/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process.mediator.daemon;

import com.google.protobuf.ByteString;
import com.intellij.execution.process.mediator.common.DaemonClientCredentials;
import com.intellij.execution.process.mediator.common.DaemonLaunchOptions;
import com.intellij.execution.process.mediator.common.rpc.Handshake;
import com.intellij.execution.process.mediator.common.util.RsaUtilKt;
import com.intellij.execution.process.mediator.daemon.DaemonProcessRuntimeClasspath;
import com.intellij.execution.process.mediator.daemon.ExitCode;
import com.intellij.execution.process.mediator.daemon.ProcessMediatorServerDaemon;
import com.intellij.execution.process.mediator.daemon.util.MachUtil;
import com.intellij.execution.process.mediator.daemon.util.UnixUtil;
import io.grpc.ServerBuilder;
import io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.EmptyCoroutineContext;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a!\u0010\u0000\u001a\u00020\u00012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004H\u0002\u00a2\u0006\u0002\u0010\u0005\u001a\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0014\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002\u001a\u001a\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u001a\u0019\u0010\u0013\u001a\u00020\u000f2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0014\u00a8\u0006\u0015"}, d2={"createDaemonProcessCommandLine", "Ljava/lang/ProcessBuilder;", "args", "", "", "([Ljava/lang/String;)Ljava/lang/ProcessBuilder;", "trampoline", "", "launchOptions", "Lcom/intellij/execution/process/mediator/common/DaemonLaunchOptions;", "openHandshakeOutputStream", "Ljava/io/OutputStream;", "handshakeOption", "Lcom/intellij/execution/process/mediator/common/DaemonLaunchOptions$HandshakeOption;", "writeHandshake", "", "outputStream", "handshake", "Lcom/intellij/execution/process/mediator/common/rpc/Handshake;", "main", "([Ljava/lang/String;)V", "intellij.execution.process.mediator.daemon"})
@SourceDebugExtension(value={"SMAP\nDaemonProcessMain.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DaemonProcessMain.kt\ncom/intellij/execution/process/mediator/daemon/DaemonProcessMainKt\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,164:1\n126#2:165\n153#2,3:166\n37#3,2:169\n37#3,2:171\n1#4:173\n*S KotlinDebug\n*F\n+ 1 DaemonProcessMain.kt\ncom/intellij/execution/process/mediator/daemon/DaemonProcessMainKt\n*L\n28#1:165\n28#1:166,3\n28#1:169,2\n38#1:171,2\n*E\n"})
public final class DaemonProcessMainKt {
    /*
     * WARNING - void declaration
     */
    private static final ProcessBuilder createDaemonProcessCommandLine(String ... args) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        SpreadBuilder spreadBuilder = new SpreadBuilder(6);
        spreadBuilder.add((Object)(System.getProperty("java.home") + File.separator + "bin" + File.separator + "java"));
        Map<String, String> map2 = DaemonProcessRuntimeClasspath.getProperties();
        Intrinsics.checkNotNullExpressionValue(map2, (String)"getProperties(...)");
        Map<String, String> map3 = map2;
        SpreadBuilder spreadBuilder2 = spreadBuilder;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object k = entry.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"component1(...)");
            String k2 = (String)k;
            Object v = entry.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"component2(...)");
            String v2 = (String)v;
            collection.add("-D" + k2 + "=" + v2);
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        spreadBuilder2.addSpread((Object)thisCollection$iv.toArray(new String[0]));
        spreadBuilder.add((Object)"-cp");
        spreadBuilder.add((Object)System.getProperty("java.class.path"));
        spreadBuilder.add((Object)DaemonProcessRuntimeClasspath.getMainClass().getName());
        spreadBuilder.addSpread((Object)args);
        String[] stringArray = (String[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()]);
        return new ProcessBuilder(stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Void trampoline(DaemonLaunchOptions launchOptions) {
        Closeable closeable = DaemonProcessMainKt.openHandshakeOutputStream(launchOptions.getHandshakeOption());
        Throwable throwable = null;
        try {
            OutputStream handshakeWriter = (OutputStream)closeable;
            boolean bl = false;
            DaemonLaunchOptions daemonOptions = DaemonLaunchOptions.copy$default((DaemonLaunchOptions)launchOptions, (boolean)false, (boolean)false, null, null, (DaemonLaunchOptions.HandshakeOption)((DaemonLaunchOptions.HandshakeOption)DaemonLaunchOptions.HandshakeOption.Stdout.INSTANCE), null, (int)46, null);
            Collection $this$toTypedArray$iv = daemonOptions.asCmdlineArgs();
            boolean $i$f$toTypedArray2 = false;
            Object thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            Process daemonProcess = DaemonProcessMainKt.createDaemonProcessCommandLine(Arrays.copyOf(stringArray, stringArray.length)).redirectOutput(ProcessBuilder.Redirect.PIPE).redirectError(ProcessBuilder.Redirect.INHERIT).start();
            System.err.println("[trampoline] Started daemon process PID " + daemonProcess.pid());
            daemonProcess.onExit().whenComplete((arg_0, arg_1) -> DaemonProcessMainKt.trampoline$lambda$0$1(DaemonProcessMainKt::trampoline$lambda$0$0, arg_0, arg_1));
            try {
                InputStream inputStream;
                Closeable $i$f$toTypedArray2 = daemonProcess.getInputStream();
                thisCollection$iv = null;
                try {
                    InputStream p0 = (InputStream)$i$f$toTypedArray2;
                    boolean bl2 = false;
                    p0 = Handshake.parseDelimitedFrom((InputStream)p0);
                    inputStream = p0;
                }
                catch (Throwable throwable2) {
                    thisCollection$iv = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)$i$f$toTypedArray2, (Throwable)thisCollection$iv);
                }
                if (inputStream == null) {
                    throw new IOException("Premature EOF while reading handshake");
                }
                InputStream handshake = inputStream;
                DaemonProcessMainKt.writeHandshake(handshakeWriter, (Handshake)handshake);
            }
            catch (Throwable e) {
                if (e instanceof IOException) {
                    System.err.println("[trampoline] Unable to relay handshake: " + e.getMessage());
                }
                Process $this$trampoline_u24lambda_u240_u242 = daemonProcess;
                boolean bl3 = false;
                $this$trampoline_u24lambda_u240_u242.waitFor(3L, TimeUnit.SECONDS);
                $this$trampoline_u24lambda_u240_u242.destroy();
                try {
                    boolean bl4 = false;
                    Object object = Result.constructor-impl((Object)$this$trampoline_u24lambda_u240_u242.waitFor(10L, TimeUnit.SECONDS));
                }
                catch (Throwable throwable3) {
                    Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable3));
                }
                $this$trampoline_u24lambda_u240_u242.destroyForcibly();
                throw e;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        System.exit(0);
        throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
    }

    private static final OutputStream openHandshakeOutputStream(DaemonLaunchOptions.HandshakeOption handshakeOption) {
        OutputStream outputStream;
        DaemonLaunchOptions.HandshakeOption handshakeOption2 = handshakeOption;
        if (handshakeOption2 == null) {
            outputStream = null;
        } else if (Intrinsics.areEqual((Object)handshakeOption2, (Object)DaemonLaunchOptions.HandshakeOption.Stdout.INSTANCE)) {
            outputStream = System.out;
        } else if (handshakeOption2 instanceof DaemonLaunchOptions.HandshakeOption.File) {
            OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.WRITE};
            outputStream = Files.newOutputStream(((DaemonLaunchOptions.HandshakeOption.File)handshakeOption).getPath(), openOptionArray);
        } else if (handshakeOption2 instanceof DaemonLaunchOptions.HandshakeOption.Port) {
            outputStream = new Socket(InetAddress.getLoopbackAddress(), ((DaemonLaunchOptions.HandshakeOption.Port)handshakeOption).getPort()).getOutputStream();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return outputStream;
    }

    private static final void writeHandshake(OutputStream outputStream, Handshake handshake) {
        OutputStream outputStream2 = outputStream;
        if (outputStream2 != null) {
            OutputStream it = outputStream2;
            boolean bl = false;
            handshake.writeDelimitedTo(it);
        } else {
            System.out.println(handshake);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void main(@NotNull String[] args) {
        ProcessHandle leaderProcessHandle;
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        DaemonLaunchOptions launchOptions = DaemonLaunchOptions.Companion.parseFromArgsOrDie("ProcessMediatorDaemonMain", args);
        Long l = launchOptions.getLeaderPid();
        if (l != null) {
            long leaderPid = ((Number)l).longValue();
            boolean bl = false;
            v1 = ProcessHandle.of(leaderPid).orElse(null);
            if (v1 == null) {
                boolean bl2 = false;
                System.err.println("Leader process with PID " + leaderPid + " not found, exiting immediately");
                System.exit(ExitCode.LEADER_EXITED.ordinal());
                throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
        } else {
            v1 = leaderProcessHandle = null;
        }
        if (launchOptions.getTrampoline()) {
            DaemonProcessMainKt.trampoline(launchOptions);
            throw new KotlinNothingValueException();
        }
        if (UnixUtil.isUnix()) {
            UnixUtil.setup(launchOptions.getDaemonize());
            if (MachUtil.isMac()) {
                MachUtil.setup(launchOptions.getMachNamespaceUid());
            }
        }
        Ref.ObjectRef daemon = new Ref.ObjectRef();
        Closeable closeable = DaemonProcessMainKt.openHandshakeOutputStream(launchOptions.getHandshakeOption());
        Throwable throwable = null;
        try {
            OutputStream handshakeWriter = (OutputStream)closeable;
            boolean bl = false;
            CoroutineScope coroutineScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)EmptyCoroutineContext.INSTANCE));
            DaemonClientCredentials credentials = DaemonClientCredentials.Companion.generate$default((DaemonClientCredentials.Companion)DaemonClientCredentials.Companion, (int)0, (int)1, null);
            NettyServerBuilder serverBuilder = NettyServerBuilder.forPort((int)0).permitKeepAliveTime(10L, TimeUnit.SECONDS).keepAliveTime(90L, TimeUnit.SECONDS).keepAliveTimeout(90L, TimeUnit.SECONDS);
            Intrinsics.checkNotNull((Object)serverBuilder);
            daemon.element = new ProcessMediatorServerDaemon(coroutineScope, (ServerBuilder)serverBuilder, credentials);
            try {
                PublicKey publicKey;
                ByteString it = credentials.getToken();
                boolean bl3 = false;
                DaemonLaunchOptions.TokenEncryptionOption tokenEncryptionOption = launchOptions.getTokenEncryptionOption();
                PublicKey publicKey2 = publicKey = tokenEncryptionOption != null ? tokenEncryptionOption.getPublicKey() : null;
                ByteString token = publicKey == null ? it : RsaUtilKt.rsaEncrypt((PublicKey)publicKey, (ByteString)it);
                Handshake handshake = Handshake.newBuilder().setPort(((ProcessMediatorServerDaemon)daemon.element).getPort()).setToken(token).setPid(ProcessHandle.current().pid()).build();
                Intrinsics.checkNotNull((Object)handshake);
                DaemonProcessMainKt.writeHandshake(handshakeWriter, handshake);
            }
            catch (Throwable e) {
                if (e instanceof IOException) {
                    System.err.println("Unable to write handshake: " + e.getMessage());
                }
                ((ProcessMediatorServerDaemon)daemon.element).requestShutdown();
                throw e;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        if (launchOptions.getDaemonize()) {
            try {
                System.in.close();
            }
            catch (IOException e) {
                System.err.println("Unable to close daemon stdin: " + e.getMessage());
            }
            System.out.close();
            System.err.close();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> DaemonProcessMainKt.main$lambda$2(daemon)));
        Object object = leaderProcessHandle;
        if (object != null && (object = object.onExit()) != null) {
            ((CompletableFuture)object).whenComplete((arg_0, arg_1) -> DaemonProcessMainKt.main$lambda$4(DaemonProcessMainKt::main$lambda$3, arg_0, arg_1));
        }
        ((ProcessMediatorServerDaemon)daemon.element).blockUntilShutdown();
    }

    private static final Unit trampoline$lambda$0$0(Process process, Throwable throwable) {
        int exitCode = process.exitValue();
        System.err.println("[trampoline] Daemon process PID " + process.pid() + " exited with code " + exitCode + " before trampoline process");
        System.exit(exitCode);
        throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
    }

    private static final void trampoline$lambda$0$1(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final void main$lambda$2(Ref.ObjectRef $daemon) {
        System.err.println("Shutting down gRPC server since JVM is shutting down");
        ((ProcessMediatorServerDaemon)$daemon.element).requestShutdown();
    }

    private static final Unit main$lambda$3(ProcessHandle handle, Throwable throwable) {
        System.err.println("Leader process with PID " + handle.pid() + " exited, shutting down");
        System.exit(ExitCode.LEADER_EXITED.ordinal());
        throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
    }

    private static final void main$lambda$4(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }
}

