/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.cron;

import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinition;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.intellij.cron.CronDefinitionExpressionProvider;
import com.intellij.cron.CronUtilsKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.HintedReferenceHost;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.boot.cron.SpringCronBundle;
import com.intellij.spring.model.values.SpringPlaceholderPropertyReference;
import com.intellij.util.text.PlaceholderTextRanges;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UAnnotationUtils;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.expressions.UInjectionHost;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u000e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0012\u0010\u0005\u001a\u00020\u00012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002\u001a\u0010\u0010\f\u001a\u00020\t2\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u001a\u0012\u0010\r\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0002\u001a\u001a\u0010\u000e\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0003H\u0000\u001a\"\u0010\u0014\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0003\u001a\u0012\u0010\u0018\u001a\u00020\u00012\b\u0010\u0019\u001a\u0004\u0018\u00010\u0012H\u0000\u001a\u0018\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u001b2\u0006\u0010\u0013\u001a\u00020\u0003H\u0000\u001a\u001b\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001e2\u0006\u0010\u0013\u001a\u00020\u0003H\u0002\u00a2\u0006\u0002\u0010\u001f\"\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u000b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"isSpringScheduledCronValue", "", "psiElement", "Lcom/intellij/psi/PsiElement;", "hasSpringLibrary", "hasNoSpELInjectionValue", "uHostElement", "Lorg/jetbrains/uast/UElement;", "SPRING53_CRON_DEFINITION", "Lcom/cronutils/model/definition/CronDefinition;", "kotlin.jvm.PlatformType", "SPRING_CRON_DEFINITION", "springCronDefinition", "isSpring53", "isSpringVersion", "springVersion", "Lcom/intellij/spring/SpringLibraryUtil$SpringVersion;", "springPropertyReferenceValue", "", "element", "getSpringCronExpression", "provider", "Lcom/intellij/cron/CronDefinitionExpressionProvider;", "cronExpr", "isSimpleValue", "value", "getInnerReferences", "", "Lcom/intellij/psi/PsiReference;", "getReferences", "", "(Lcom/intellij/psi/PsiElement;)[Lcom/intellij/psi/PsiReference;", "intellij.spring.boot.cron"})
@SourceDebugExtension(value={"SMAP\nspringCronUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 springCronUtils.kt\ncom/intellij/spring/boot/cron/SpringCronUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,105:1\n1#2:106\n808#3,11:107\n10468#4:118\n10890#4,5:119\n*S KotlinDebug\n*F\n+ 1 springCronUtils.kt\ncom/intellij/spring/boot/cron/SpringCronUtilsKt\n*L\n66#1:107,11\n87#1:118\n87#1:119,5\n*E\n"})
public final class SpringCronUtilsKt {
    private static final CronDefinition SPRING53_CRON_DEFINITION = CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.SPRING53);
    private static final CronDefinition SPRING_CRON_DEFINITION = CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.SPRING);

    public static final boolean isSpringScheduledCronValue(@NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        if (!SpringCronUtilsKt.hasSpringLibrary(psiElement)) {
            return false;
        }
        UElement uHostElement = UastContextKt.toUElement((PsiElement)psiElement);
        if (uHostElement instanceof UInjectionHost || uHostElement instanceof UReferenceExpression) {
            Pair pair = UAnnotationUtils.getContainingUAnnotationEntry((UElement)uHostElement);
            if (pair == null) {
                return false;
            }
            Pair pair2 = pair;
            UAnnotation uAnnotation = (UAnnotation)pair2.component1();
            String annotationParamName = (String)pair2.component2();
            if (Intrinsics.areEqual((Object)"cron", (Object)annotationParamName)) {
                PsiAnnotation psiAnnotation = uAnnotation.getJavaPsi();
                if (psiAnnotation == null) {
                    return false;
                }
                PsiAnnotation psiAnnotation2 = psiAnnotation;
                return !psiAnnotation2.getProject().isDefault() && Intrinsics.areEqual((Object)psiAnnotation2.getQualifiedName(), (Object)"org.springframework.scheduling.annotation.Scheduled") && SpringCronUtilsKt.hasNoSpELInjectionValue(uHostElement);
            }
        }
        return false;
    }

    public static final boolean hasSpringLibrary(@NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        return SpringLibraryUtil.hasSpringLibrary((Module)ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement));
    }

    private static final boolean hasNoSpELInjectionValue(UElement uHostElement) {
        if (!(uHostElement instanceof UExpression)) {
            return false;
        }
        String string = UastUtils.evaluateString((UExpression)((UExpression)uHostElement));
        if (string == null) {
            return false;
        }
        String value = string;
        return !StringsKt.startsWith$default((String)value, (String)"#{", (boolean)false, (int)2, null);
    }

    @NotNull
    public static final CronDefinition springCronDefinition(@Nullable PsiElement psiElement) {
        CronDefinition cronDefinition;
        if (SpringCronUtilsKt.isSpring53(psiElement)) {
            CronDefinition cronDefinition2 = SPRING53_CRON_DEFINITION;
            cronDefinition = cronDefinition2;
            Intrinsics.checkNotNullExpressionValue((Object)cronDefinition2, (String)"SPRING53_CRON_DEFINITION");
        } else {
            CronDefinition cronDefinition3 = SPRING_CRON_DEFINITION;
            cronDefinition = cronDefinition3;
            Intrinsics.checkNotNullExpressionValue((Object)cronDefinition3, (String)"SPRING_CRON_DEFINITION");
        }
        return cronDefinition;
    }

    private static final boolean isSpring53(PsiElement psiElement) {
        return SpringCronUtilsKt.isSpringVersion(psiElement, SpringLibraryUtil.SpringVersion.V_5_3);
    }

    private static final boolean isSpringVersion(PsiElement psiElement, SpringLibraryUtil.SpringVersion springVersion) {
        PsiElement psiElement2;
        block3: {
            block2: {
                psiElement2 = psiElement;
                if (psiElement2 == null) break block2;
                PsiElement it = psiElement2;
                boolean bl = false;
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement);
                psiElement2 = module;
                if (module != null) break block3;
            }
            return false;
        }
        PsiElement module = psiElement2;
        return SpringLibraryUtil.isAtLeastVersion((Module)module, (SpringLibraryUtil.SpringVersion)springVersion);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final String springPropertyReferenceValue(@NotNull PsiElement element) {
        Object object;
        block3: {
            void $this$filterIsInstanceTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Iterable<PsiReference> $this$filterIsInstance$iv = SpringCronUtilsKt.getInnerReferences(element);
            boolean $i$f$filterIsInstance = false;
            Object object2 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof SpringPlaceholderPropertyReference)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (SpringPlaceholderPropertyReference it : (Iterable)((List)destination$iv$iv)) {
                boolean bl = false;
                String string = it.getFoldingValue();
                if (string == null) {
                    string = it.getDefaultValue();
                }
                if ((object2 = string) == null) continue;
                object = object2;
                break block3;
            }
            object = null;
        }
        return object;
    }

    @Nullable
    public static final String getSpringCronExpression(@NotNull CronDefinitionExpressionProvider provider, @NotNull String cronExpr, @Nullable PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)cronExpr, (String)"cronExpr");
        if (SpringCronUtilsKt.isSpringVersion(element, SpringLibraryUtil.SpringVersion.V_5_1) && Intrinsics.areEqual((Object)cronExpr, (Object)"-")) {
            return SpringCronBundle.INSTANCE.message("spring.cron.expression.disabled", new Object[0]);
        }
        return CronUtilsKt.getCronExplanationWithDescriptor((String)cronExpr, (CronDefinition)provider.getCronDefinition(cronExpr, element));
    }

    public static final boolean isSimpleValue(@Nullable String value) {
        if (value == null) {
            return false;
        }
        Set set = PlaceholderTextRanges.getPlaceholderRanges((String)value, (String)"${", (String)"}");
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getPlaceholderRanges(...)");
        Set propertyPlaceholderRange = set;
        return propertyPlaceholderRange.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Iterable<PsiReference> getInnerReferences(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Ref.ObjectRef references = new Ref.ObjectRef();
        references.element = ArraysKt.asSequence((Object[])SpringCronUtilsKt.getReferences(element));
        if (element instanceof PsiLanguageInjectionHost) {
            void $this$flatMapTo$iv$iv;
            PsiElement[] psiElementArray = element.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
            Object[] $this$flatMap$iv = psiElementArray;
            boolean $i$f$flatMap = false;
            Object[] objectArray = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (void element$iv$iv : $this$flatMapTo$iv$iv) {
                PsiElement it = (PsiElement)element$iv$iv;
                boolean bl = false;
                PsiReference[] psiReferenceArray = it.getReferences();
                Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"getReferences(...)");
                Iterable list$iv$iv = ArraysKt.toList((Object[])psiReferenceArray);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Sequence innerReferences = CollectionsKt.asSequence((Iterable)((List)destination$iv$iv));
            references.element = SequencesKt.plus((Sequence)((Sequence)references.element), (Sequence)innerReferences);
        }
        return new Iterable<PsiReference>(references){
            final /* synthetic */ Ref.ObjectRef $references$inlined;
            {
                this.$references$inlined = objectRef;
            }

            public Iterator<PsiReference> iterator() {
                boolean bl = false;
                return ((Sequence)this.$references$inlined.element).iterator();
            }
        };
    }

    private static final PsiReference[] getReferences(PsiElement element) {
        if (element instanceof HintedReferenceHost) {
            PsiReference[] psiReferenceArray = ((HintedReferenceHost)element).getReferences(PsiReferenceService.Hints.HIGHLIGHTED_REFERENCES);
            Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"getReferences(...)");
            return psiReferenceArray;
        }
        PsiReference[] psiReferenceArray = element.getReferences();
        Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"getReferences(...)");
        return psiReferenceArray;
    }
}

