/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.database.Dbms;
import com.intellij.database.util.DdlBuilder;
import com.intellij.lang.Language;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.intentions.SqlBaseElementAtCaretIntentionAction;
import com.intellij.sql.psi.SqlPsiFacade;
import com.intellij.sql.psi.SqlStringLiteralExpression;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlStringLiteralManipulator;
import com.intellij.sql.psi.impl.SqlStringTokenElement;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqlSplitStringLiteralIntention
extends SqlBaseElementAtCaretIntentionAction
implements LowPriorityAction {
    private final boolean myIsPreview;

    public SqlSplitStringLiteralIntention(boolean isPreview) {
        this.myIsPreview = isPreview;
    }

    public SqlSplitStringLiteralIntention() {
        this(false);
    }

    @NotNull
    public String getFamilyName() {
        String string = SqlBundle.message((String)"quickfix.name.split.string.literal", (Object[])new Object[0]);
        if (string == null) {
            SqlSplitStringLiteralIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        SqlStringTokenElement string;
        if (project == null) {
            SqlSplitStringLiteralIntention.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            SqlSplitStringLiteralIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            SqlSplitStringLiteralIntention.$$$reportNull$$$0(3);
        }
        if ((string = SqlSplitStringLiteralIntention.currentStringToken(element)) == null) {
            return false;
        }
        return SqlSplitStringLiteralIntention.getContentRange(string).contains(editor.getCaretModel().getOffset());
    }

    @Nullable
    public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
        if (target == null) {
            SqlSplitStringLiteralIntention.$$$reportNull$$$0(4);
        }
        return new SqlSplitStringLiteralIntention(true);
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        SqlStringTokenElement string;
        if (project == null) {
            SqlSplitStringLiteralIntention.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            SqlSplitStringLiteralIntention.$$$reportNull$$$0(6);
        }
        if (element == null) {
            SqlSplitStringLiteralIntention.$$$reportNull$$$0(7);
        }
        if ((string = SqlSplitStringLiteralIntention.currentStringToken(element)) != null) {
            if (this.myIsPreview) {
                this.splitLiteral(string, project, editor, element);
            } else {
                CommandProcessor.getInstance().executeCommand(project, () -> this.splitLiteral(string, project, editor, element), null, (Object)editor.getDocument());
            }
        }
    }

    @NotNull
    private static TextRange getContentRange(SqlStringTokenElement string) {
        PsiElement element = Objects.requireNonNull(SqlStringLiteralManipulator.getStringElement((PsiElement)string));
        TextRange textRange = SqlStringLiteralManipulator.getStringContentRange((PsiElement)element).shiftRight(element.getTextRange().getStartOffset());
        if (textRange == null) {
            SqlSplitStringLiteralIntention.$$$reportNull$$$0(8);
        }
        return textRange;
    }

    private static SqlStringTokenElement currentStringToken(PsiElement element) {
        SqlStringTokenElement type = (SqlStringTokenElement)PsiTreeUtil.getParentOfType((PsiElement)element, SqlStringTokenElement.class, (boolean)false);
        return PsiUtilCore.getElementType((PsiElement)type) != SqlTokens.SQL_IDENT_DELIMITED ? type : null;
    }

    private int getConcatExpr(@NotNull DdlBuilder builder, @NotNull String a, @NotNull String b) {
        int res;
        Dbms id;
        if (builder == null) {
            SqlSplitStringLiteralIntention.$$$reportNull$$$0(9);
        }
        if (a == null) {
            SqlSplitStringLiteralIntention.$$$reportNull$$$0(10);
        }
        if (b == null) {
            SqlSplitStringLiteralIntention.$$$reportNull$$$0(11);
        }
        if ((id = builder.getDialect().getDbms()).isMysql()) {
            builder.keyword("CONCAT").symbol("(").literal(a).symbol(",").space();
            res = builder.length();
            builder.symbol(",").space().literal(b).symbol(")");
        } else {
            String op = id.isTransactSql() ? "+" : "||";
            builder.literal(a).space().symbol(op).space();
            res = builder.length();
            if (this.myIsPreview) {
                builder.plain("...");
            }
            builder.space().symbol(op).space().literal(b);
        }
        return res;
    }

    @NotNull
    private static TextRange findLiteralRange(@NotNull SqlStringTokenElement string) {
        if (string == null) {
            SqlSplitStringLiteralIntention.$$$reportNull$$$0(12);
        }
        if (string.getParent() instanceof SqlStringLiteralExpression) {
            TextRange textRange = string.getParent().getTextRange();
            if (textRange == null) {
                SqlSplitStringLiteralIntention.$$$reportNull$$$0(13);
            }
            return textRange;
        }
        if (string.getElementType() == SqlTokens.SQL_CUSTOM_QUOTED_STRING_TOKEN) {
            PsiElement prev = PsiTreeUtil.prevLeaf((PsiElement)string);
            PsiElement next = PsiTreeUtil.nextLeaf((PsiElement)string);
            if (PsiUtilCore.getElementType((PsiElement)prev) != SqlTokens.SQL_CUSTOM_LQUOTE) {
                prev = string;
            }
            if (PsiUtilCore.getElementType((PsiElement)next) != SqlTokens.SQL_CUSTOM_RQUOTE) {
                next = string;
            }
            TextRange textRange = TextRange.create((int)prev.getTextRange().getStartOffset(), (int)next.getTextRange().getEndOffset());
            if (textRange == null) {
                SqlSplitStringLiteralIntention.$$$reportNull$$$0(14);
            }
            return textRange;
        }
        TextRange textRange = string.getTextRange();
        if (textRange == null) {
            SqlSplitStringLiteralIntention.$$$reportNull$$$0(15);
        }
        return textRange;
    }

    private void splitLiteral(SqlStringTokenElement string, Project project, Editor editor, PsiElement element) {
        TextRange outerRange = SqlSplitStringLiteralIntention.findLiteralRange(string);
        TextRange innerRange = SqlSplitStringLiteralIntention.getContentRange(string).shiftLeft(outerRange.getStartOffset());
        int splitPosition = SqlSplitStringLiteralIntention.findSplitPosition(string, outerRange, editor);
        if (splitPosition != -1) {
            if (this.myIsPreview) {
                this.doSplitLiteral(string, project, editor, outerRange, innerRange, splitPosition);
            } else {
                WriteCommandAction.runWriteCommandAction((Project)project, (String)SqlBundle.message((String)"command.name.split.string.literal", (Object[])new Object[0]), (String)"Split string literal", () -> this.doSplitLiteral(string, project, editor, outerRange, innerRange, splitPosition), (PsiFile[])new PsiFile[]{element.getContainingFile()});
                AutoPopupController.getInstance((Project)project).scheduleAutoPopup(editor);
            }
        }
    }

    private void doSplitLiteral(SqlStringTokenElement string, Project project, Editor editor, TextRange outerRange, TextRange innerRange, int splitPosition) {
        String text = editor.getDocument().getText(outerRange);
        String bquote = text.substring(0, innerRange.getStartOffset());
        String equote = text.substring(innerRange.getEndOffset(), outerRange.getLength());
        SqlLanguageDialectEx sqlDialect = SqlImplUtil.getSqlDialectSafe((PsiElement)string);
        DdlBuilder builder = new DdlBuilder(new StringBuilder(string.getTextLength() + 20)).configureBuilder(project, (SqlLanguageDialect)sqlDialect).withDialect(sqlDialect.getDatabaseDialect());
        int cur = this.getConcatExpr(builder, text.substring(0, splitPosition) + equote, bquote + text.substring(splitPosition));
        editor.getDocument().replaceString(outerRange.getStartOffset(), outerRange.getEndOffset(), (CharSequence)builder.getStatement());
        editor.getCaretModel().moveToOffset(cur += outerRange.getStartOffset());
    }

    private static int findSplitPosition(SqlStringTokenElement string, TextRange literalRange, Editor editor) {
        PsiElement parent = string.getParent();
        int caret = editor.getCaretModel().getOffset();
        if (parent instanceof SqlStringLiteralExpression) {
            return SqlSplitStringLiteralIntention.findSplitPosition((SqlStringLiteralExpression)parent, caret);
        }
        SqlPsiFacade facade = SqlPsiFacade.getInstance((Project)editor.getProject());
        SqlStringLiteralExpression literal = (SqlStringLiteralExpression)PsiTreeUtil.findChildOfType((PsiElement)facade.createExpressionFragment((Language)SqlImplUtil.getSqlDialectSafe((PsiElement)string), null, null, editor.getDocument().getText(literalRange), false, true), SqlStringLiteralExpression.class);
        if (literal == null) {
            return -1;
        }
        return SqlSplitStringLiteralIntention.findSplitPosition(literal, caret - literalRange.getStartOffset());
    }

    private static int findSplitPosition(SqlStringLiteralExpression literal, int caret) {
        StringBuilder dummy;
        int innerCaretOffset;
        TextRange innerRange = SqlStringLiteralManipulator.getStringContentRange((PsiElement)literal);
        if (!innerRange.contains(innerCaretOffset = caret - literal.getTextRange().getStartOffset())) {
            return -1;
        }
        LiteralTextEscaper esc = literal.createLiteralTextEscaper();
        if (!esc.decode(innerRange, dummy = new StringBuilder(literal.getTextLength()))) {
            return -1;
        }
        int pos = SqlSplitStringLiteralIntention.findDecodedSplitPosition(esc, innerRange, innerCaretOffset, 0, dummy.length());
        return pos == -1 ? -1 : esc.getOffsetInHost(pos, innerRange);
    }

    private static int findDecodedSplitPosition(LiteralTextEscaper<?> esc, TextRange innerRange, int h, int s, int e) {
        if (esc.getOffsetInHost(s, innerRange) == h) {
            return s;
        }
        if (esc.getOffsetInHost(e, innerRange) == h) {
            return e;
        }
        int i = ObjectUtils.binarySearch((int)s, (int)e, m -> Integer.compare(esc.getOffsetInHost(m, innerRange), h));
        if (i < 0) {
            i = -i - 1;
        }
        return i;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 9, 10, 11, 12 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/intentions/SqlSplitStringLiteralIntention";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/intentions/SqlSplitStringLiteralIntention";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentRange";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "findLiteralRange";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFileModifierForPreview";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getConcatExpr";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findLiteralRange";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 9, 10, 11, 12 -> new IllegalArgumentException(string);
        };
    }
}

