/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.RuleFilter;
import org.languagetool.tools.StringTools;

public class UnderlineSpacesFilter
extends RuleFilter {
    @Override
    public RuleMatch acceptRuleMatch(RuleMatch match, Map<String, String> arguments, int patternTokenPos, AnalyzedTokenReadings[] patternTokens, List<Integer> tokenPositions) throws IOException {
        String underlineSpaces = this.getRequired("underlineSpaces", arguments);
        String sentence = match.getSentence().getText();
        if ((underlineSpaces.equals("before") || underlineSpaces.equals("both")) && match.getFromPos() - 1 >= 0 && StringTools.isWhitespace(sentence.substring(match.getFromPos() - 1, match.getFromPos()))) {
            match.setOffsetPosition(match.getFromPos() - 1, match.getToPos());
        }
        if ((underlineSpaces.equals("after") || underlineSpaces.equals("both")) && match.getToPos() + 1 < sentence.length() && StringTools.isWhitespace(sentence.substring(match.getToPos(), match.getToPos() + 1))) {
            match.setOffsetPosition(match.getFromPos(), match.getToPos() + 1);
        }
        return match;
    }
}

