/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.lang.html.highlighting;

import com.intellij.ide.highlighter.HtmlFileHighlighter;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.lang.javascript.highlighting.JSHighlighter;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.XmlHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.tree.IElementType;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.vuejs.lang.LangMode;
import org.jetbrains.vuejs.lang.html.lexer.VueLexer;
import org.jetbrains.vuejs.lang.html.lexer.VueTokenType;
import org.jetbrains.vuejs.lang.html.lexer.VueTokenTypes;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001d\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/vuejs/lang/html/highlighting/VueFileHighlighter;", "Lcom/intellij/ide/highlighter/HtmlFileHighlighter;", "languageLevel", "Lcom/intellij/lang/javascript/dialects/JSLanguageLevel;", "langMode", "Lorg/jetbrains/vuejs/lang/LangMode;", "project", "Lcom/intellij/openapi/project/Project;", "interpolationConfig", "Lkotlin/Pair;", "", "htmlCompatMode", "", "<init>", "(Lcom/intellij/lang/javascript/dialects/JSLanguageLevel;Lorg/jetbrains/vuejs/lang/LangMode;Lcom/intellij/openapi/project/Project;Lkotlin/Pair;Z)V", "getTokenHighlights", "", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "tokenType", "Lcom/intellij/psi/tree/IElementType;", "(Lcom/intellij/psi/tree/IElementType;)[Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "getHighlightingLexer", "Lcom/intellij/lexer/Lexer;", "Companion", "intellij.vuejs.backend"})
@SourceDebugExtension(value={"SMAP\nVueFileHighlighter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VueFileHighlighter.kt\norg/jetbrains/vuejs/lang/html/highlighting/VueFileHighlighter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,66:1\n1#2:67\n1869#3,2:68\n1869#3,2:72\n13805#4,2:70\n*S KotlinDebug\n*F\n+ 1 VueFileHighlighter.kt\norg/jetbrains/vuejs/lang/html/highlighting/VueFileHighlighter\n*L\n51#1:68,2\n61#1:72,2\n55#1:70,2\n*E\n"})
public final class VueFileHighlighter
extends HtmlFileHighlighter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JSLanguageLevel languageLevel;
    @NotNull
    private final LangMode langMode;
    @Nullable
    private final Project project;
    @Nullable
    private final kotlin.Pair<String, String> interpolationConfig;
    private final boolean htmlCompatMode;
    @NotNull
    private static final TextAttributesKey VUE_INTERPOLATION_DELIMITER;
    @NotNull
    private static final Map<IElementType, TextAttributesKey[]> keys;

    public VueFileHighlighter(@NotNull JSLanguageLevel languageLevel, @NotNull LangMode langMode, @Nullable Project project, @Nullable kotlin.Pair<String, String> interpolationConfig, boolean htmlCompatMode) {
        Intrinsics.checkNotNullParameter((Object)languageLevel, (String)"languageLevel");
        Intrinsics.checkNotNullParameter((Object)((Object)langMode), (String)"langMode");
        this.languageLevel = languageLevel;
        this.langMode = langMode;
        this.project = project;
        this.interpolationConfig = interpolationConfig;
        this.htmlCompatMode = htmlCompatMode;
    }

    @NotNull
    public TextAttributesKey[] getTokenHighlights(@NotNull IElementType tokenType) {
        Intrinsics.checkNotNullParameter((Object)tokenType, (String)"tokenType");
        TextAttributesKey[] textAttributesKeyArray = keys.get(tokenType);
        if (textAttributesKeyArray != null) {
            TextAttributesKey[] it = textAttributesKeyArray;
            boolean bl = false;
            return it;
        }
        return super.getTokenHighlights(tokenType);
    }

    @NotNull
    public Lexer getHighlightingLexer() {
        return (Lexer)new VueLexer(this.languageLevel, this.project, this.interpolationConfig, this.htmlCompatMode, true, this.langMode);
    }

    static {
        TextAttributesKey textAttributesKey = TextAttributesKey.createTextAttributesKey((String)"VUE.SCRIPT_DELIMITERS", (TextAttributesKey)DefaultLanguageHighlighterColors.SEMICOLON);
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"createTextAttributesKey(...)");
        VUE_INTERPOLATION_DELIMITER = textAttributesKey;
        keys = new LinkedHashMap();
        VueTokenType[] vueTokenTypeArray = new VueTokenType[]{VueTokenTypes.INTERPOLATION_START, VueTokenTypes.INTERPOLATION_END};
        Object $this$forEach$iv = (Object[])CollectionsKt.listOf((Object[])vueTokenTypeArray);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv = iterator.next();
            VueTokenType token = (VueTokenType)((Object)element$iv);
            boolean bl = false;
            IElementType iElementType = token;
            TextAttributesKey[] textAttributesKeyArray = new TextAttributesKey[2];
            Intrinsics.checkNotNullExpressionValue((Object)XmlHighlighterColors.HTML_CODE, (String)"HTML_CODE");
            textAttributesKeyArray[1] = VUE_INTERPOLATION_DELIMITER;
            VueFileHighlighter.Companion.put(iElementType, textAttributesKeyArray);
        }
        IElementType[] iElementTypeArray = JSKeywordSets.AS_RESERVED_WORDS.getTypes();
        Intrinsics.checkNotNullExpressionValue((Object)iElementTypeArray, (String)"getTypes(...)");
        $this$forEach$iv = iElementTypeArray;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IElementType token = (IElementType)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)token);
            TextAttributesKey[] textAttributesKeyArray = new TextAttributesKey[2];
            Intrinsics.checkNotNullExpressionValue((Object)XmlHighlighterColors.HTML_CODE, (String)"HTML_CODE");
            textAttributesKeyArray[1] = JSHighlighter.JS_KEYWORD;
            VueFileHighlighter.Companion.put(token, textAttributesKeyArray);
        }
        $this$forEach$iv = CollectionsKt.listOf((Object)Pair.pair((Object)JSTokenTypes.STRING_LITERAL_PART, (Object)JSHighlighter.JS_STRING));
        $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv = iterator2.next();
            Pair p = (Pair)element$iv;
            boolean bl = false;
            Object object = p.first;
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first");
            IElementType iElementType = (IElementType)object;
            TextAttributesKey[] textAttributesKeyArray = new TextAttributesKey[2];
            Intrinsics.checkNotNullExpressionValue((Object)XmlHighlighterColors.HTML_CODE, (String)"HTML_CODE");
            Intrinsics.checkNotNullExpressionValue((Object)p.second, (String)"second");
            VueFileHighlighter.Companion.put(iElementType, textAttributesKeyArray);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J)\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\t2\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\n\"\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010\u000fR\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/vuejs/lang/html/highlighting/VueFileHighlighter$Companion;", "", "<init>", "()V", "VUE_INTERPOLATION_DELIMITER", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "Lorg/jetbrains/annotations/NotNull;", "keys", "", "Lcom/intellij/psi/tree/IElementType;", "", "put", "", "token", "keysArr", "(Lcom/intellij/psi/tree/IElementType;[Lcom/intellij/openapi/editor/colors/TextAttributesKey;)V", "intellij.vuejs.backend"})
    public static final class Companion {
        private Companion() {
        }

        private final void put(IElementType token, TextAttributesKey ... keysArr) {
            keys.put(token, keysArr);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

