/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.actions;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.facet.Facet;
import com.intellij.icons.AllIcons;
import com.intellij.jpa.JpaMessages;
import com.intellij.jpa.facet.JpaConfigurationModel;
import com.intellij.jpa.highlighting.JpaHighlightingMessages;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.persistence.PersistenceDataKeys;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.util.UnitSettingMapConfigurable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.ui.JBColor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.xml.highlighting.DomElementAnnotationsManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AssignDataSourcesAction
extends AnAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            AssignDataSourcesAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        PersistenceFacet facet;
        if (e == null) {
            AssignDataSourcesAction.$$$reportNull$$$0(1);
        }
        boolean enabled = (facet = (PersistenceFacet)e.getData(PersistenceDataKeys.PERSISTENCE_FACET)) != null;
        e.getPresentation().setEnabledAndVisible(enabled);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        PersistenceFacet facet;
        if (e == null) {
            AssignDataSourcesAction.$$$reportNull$$$0(2);
        }
        if ((facet = (PersistenceFacet)e.getData(PersistenceDataKeys.PERSISTENCE_FACET)) == null) {
            return;
        }
        PsiDocumentManager.getInstance((Project)facet.getModule().getProject()).commitAllDocuments();
        facet = JpaConfigurationModel.createModifiablePersistenceFacet(facet);
        AssignDataSourcesAction.showUnitDataSourceMappingDialog(facet);
    }

    public static boolean showUnitDataSourceMappingDialog(@NotNull PersistenceFacet facet) {
        if (facet == null) {
            AssignDataSourcesAction.$$$reportNull$$$0(3);
        }
        return ShowSettingsUtil.getInstance().editConfigurable(facet.getModule().getProject(), (Configurable)new MyComponent(facet));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/actions/AssignDataSourcesAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/actions/AssignDataSourcesAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "showUnitDataSourceMappingDialog";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }

    private static class MyComponent
    extends UnitSettingMapConfigurable<PersistenceFacet, DasDataSource> {
        private final DbPsiFacade myManager;
        private final DasDataSource myMissingValue = MyComponent.createFakeDs(JpaMessages.message("jpa.missing.datasource", new Object[0]));

        MyComponent(PersistenceFacet facet) {
            super(facet);
            this.myManager = DbPsiFacade.getInstance((Project)this.myFacet.getModule().getProject());
            JComponent component = this.getComponent();
            List dataSources = DbPsiFacade.getInstance((Project)this.myFacet.getModule().getProject()).getDataSources();
            if (dataSources.isEmpty()) {
                JLabel messageLabel = new JLabel(JpaMessages.message("jpa.no.data.sources", new Object[0]));
                messageLabel.setIcon(AllIcons.General.Warning);
                messageLabel.setBorder((Border)JBUI.Borders.emptyBottom((int)5));
                component.add((Component)messageLabel, "North");
            }
            int headerHeight = dataSources.isEmpty() ? 75 : 50;
            component.setPreferredSize((Dimension)new JBDimension(640, this.myView.getRowHeight() * 4 + headerHeight));
        }

        @NotNull
        public JComponent createComponent() {
            JComponent jComponent = UiDataProvider.wrapComponent((JComponent)super.createComponent(), sink -> {
                DasDataSource value = (DasDataSource)this.getSelectedValue();
                sink.lazy(CommonDataKeys.PSI_ELEMENT, () -> (PsiElement)ObjectUtils.tryCast((Object)value, DbDataSource.class));
            });
            if (jComponent == null) {
                MyComponent.$$$reportNull$$$0(0);
            }
            return jComponent;
        }

        @NotNull
        private static DasDataSource createFakeDs(String name) {
            LocalDataSource ds = LocalDataSource.temporary();
            ds.setName(name);
            LocalDataSource localDataSource = ds;
            if (localDataSource == null) {
                MyComponent.$$$reportNull$$$0(1);
            }
            return localDataSource;
        }

        protected UnitSettingMapConfigurable.MyRenderer createComboBoxTableRenderer() {
            ArrayList<DasDataSource> copy = new ArrayList<DasDataSource>(DbPsiFacade.getInstance((Project)this.myFacet.getModule().getProject()).getDataSources());
            copy.sort((o1, o2) -> StringUtil.naturalCompare((String)o1.getName(), (String)o2.getName()));
            final DasDataSource nullValue = MyComponent.createFakeDs("");
            copy.add(0, nullValue);
            UnitSettingMapConfigurable.MyRenderer renderer = new UnitSettingMapConfigurable.MyRenderer(copy.toArray(new DasDataSource[0])){

                public String getTextFor(@NotNull DasDataSource value) {
                    if (value == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return value == nullValue ? JpaMessages.message("default.or.no.data.source", new Object[0]) : value.getName();
                }

                protected Icon getIconFor(@NotNull DasDataSource value) {
                    if (value == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (value == myMissingValue) {
                        return AllIcons.Ide.Statusbar_arrows;
                    }
                    return value instanceof DbDataSource ? ((DbDataSource)value).getIcon() : EmptyIcon.ICON_16;
                }

                protected void customizeComponent(DasDataSource value, JTable table, boolean isSelected) {
                    super.customizeComponent((Object)value, table, isSelected);
                    if (value == null || value.getName().isEmpty()) {
                        this.setText(JpaMessages.message("jpa.click.to.select.datasource", new Object[0]));
                        this.setIcon(AllIcons.Ide.Statusbar_arrows);
                    }
                    if (value == myMissingValue) {
                        this.setForeground((Color)JBColor.RED);
                    } else if (!isSelected && !(value instanceof DbDataSource)) {
                        this.setForeground(UIUtil.getComboBoxDisabledForeground());
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "value";
                    objectArray2[1] = "com/intellij/jpa/actions/AssignDataSourcesAction$MyComponent$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "getTextFor";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "getIconFor";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            renderer.setFont(StartupUiUtil.getLabelFont());
            return renderer;
        }

        public void apply() throws ConfigurationException {
            super.apply();
            Project project = this.myFacet.getModule().getProject();
            DomElementAnnotationsManager.getInstance((Project)project).dropAnnotationsCache();
            DaemonCodeAnalyzer.getInstance((Project)project).restart((Object)this);
        }

        @NotNull
        protected String getValueColumnName() {
            String string = DatabaseBundle.message((String)"default.datasource.name", (Object[])new Object[0]);
            if (string == null) {
                MyComponent.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Nullable
        protected DasDataSource getSettingValue(PersistencePackage unit) {
            String id = this.myFacet.getDataSourceId(unit);
            DbDataSource result = this.myManager.findDataSource(id);
            return result == null && id != null ? this.myMissingValue : result;
        }

        protected void setSettingValue(PersistencePackage unit, DasDataSource value) {
            String dataSourceId;
            String string = dataSourceId = value instanceof DbDataSource ? value.getUniqueId() : null;
            if (!(this.myFacet instanceof Facet) && dataSourceId == null) {
                return;
            }
            JpaConfigurationModel.modifyConfiguration(this.myFacet, facet -> facet.setDataSourceId(unit, dataSourceId));
        }

        @Nls
        public String getDisplayName() {
            return JpaHighlightingMessages.message("fix.edit.unit.datasource.action.name", new Object[0]);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/jpa/actions/AssignDataSourcesAction$MyComponent";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createComponent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createFakeDs";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getValueColumnName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

