/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.view.editor;

import com.intellij.facet.Facet;
import com.intellij.facet.pointers.FacetPointer;
import com.intellij.facet.pointers.FacetPointersManager;
import com.intellij.javaee.JavaeeIcons;
import com.intellij.javaee.module.components.FrameworkElementAsVirtualFileImpl;
import com.intellij.javaee.module.components.FrameworkVirtualFileSystem;
import com.intellij.jpa.JpaMessages;
import com.intellij.jpa.view.editor.ImplicitPersistencePackagePointer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.model.PersistencePackagePointer;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.ElementPresentationManager;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PersistencePackageAsVirtualFileImpl<F extends Facet<?>>
extends FrameworkElementAsVirtualFileImpl<F>
implements PersistencePackagePointer {
    @NonNls
    public static final String PERSISTENCE_UNIT_TYPE = "PersistenceModel";
    @NonNls
    private static final String ANONYMOUS_PREFIX = "noname-";

    PersistencePackageAsVirtualFileImpl(FacetPointer<F> facetPointer, String elementName) {
        super(facetPointer, PERSISTENCE_UNIT_TYPE, elementName);
    }

    @NotNull
    public Project getProject() {
        Project project = this.getFacetPointer().getProject();
        if (project == null) {
            PersistencePackageAsVirtualFileImpl.$$$reportNull$$$0(0);
        }
        return project;
    }

    @Nullable
    public PersistencePackage findElement() {
        PersistenceFacet facet = this.getPersistenceFacet();
        if (facet != null) {
            String elementName = this.getElementName();
            List units = facet.getPersistenceUnits();
            for (PersistencePackage unit : units) {
                if (!Objects.equals(PersistencePackageAsVirtualFileImpl.getElementName(unit), elementName)) continue;
                return unit;
            }
        }
        return null;
    }

    public PersistenceFacet getPersistenceFacet() {
        return (PersistenceFacet)this.getFacetPointer().getFacet();
    }

    @NotNull
    public String getPresentableName() {
        String string = JpaMessages.message("persistence.unit.type", new Object[0]) + " '" + this.getElementName() + "'";
        if (string == null) {
            PersistencePackageAsVirtualFileImpl.$$$reportNull$$$0(1);
        }
        return string;
    }

    public Icon getIcon() {
        PersistencePackage unit = this.findElement();
        Icon icon = unit == null ? null : ElementPresentationManager.getIcon((Object)unit);
        return icon == null ? JavaeeIcons.PERSISTENCE_UNIT_ICON : icon;
    }

    @Nullable
    public static PersistencePackagePointer findFile(PersistencePackage unit, PersistenceFacet facet) {
        if (!(facet instanceof Facet)) {
            return new ImplicitPersistencePackagePointer(facet, PersistencePackageAsVirtualFileImpl.getElementName(unit), facet.getModule().getName());
        }
        String path = PersistencePackageAsVirtualFileImpl.getPath(unit, (Facet)facet);
        FrameworkVirtualFileSystem instance = FrameworkVirtualFileSystem.getJ2EEInstance();
        FrameworkElementAsVirtualFileImpl file = (FrameworkElementAsVirtualFileImpl)instance.findFileByPath(path);
        return (PersistencePackageAsVirtualFileImpl)file;
    }

    private static String getPath(PersistencePackage unit, Facet<?> facet) {
        String name = PersistencePackageAsVirtualFileImpl.getElementName(unit);
        return FrameworkVirtualFileSystem.getPath((Project)facet.getModule().getProject(), (String)FacetPointersManager.constructId(facet), (String)PERSISTENCE_UNIT_TYPE, (String)name);
    }

    @NotNull
    public static String getElementName(@NotNull PersistencePackage unit) {
        if (unit == null) {
            PersistencePackageAsVirtualFileImpl.$$$reportNull$$$0(2);
        }
        Object unitName = (String)unit.getName().getValue();
        XmlTag tag = unit.getXmlTag();
        PsiFile containingFile = unit.getContainingFile();
        if (StringUtil.isEmpty((String)unitName) && tag != null && containingFile != null) {
            unitName = ANONYMOUS_PREFIX + containingFile.getName() + "@" + tag.getTextOffset();
        }
        String string = StringUtil.notNullize((String)unitName);
        if (string == null) {
            PersistencePackageAsVirtualFileImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/view/editor/PersistencePackageAsVirtualFileImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unit";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/view/editor/PersistencePackageAsVirtualFileImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getElementName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2 -> new IllegalArgumentException(string);
        };
    }
}

