/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.llm.vcs.completion.context;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0001\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007J\u0014\u0010\n\u001a\u00020\u00062\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\u0006\u0010\f\u001a\u00020\u0006J\b\u0010\r\u001a\u00020\u0006H\u0016R \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/ml/llm/vcs/completion/context/CommitHistoryCache;", "Lcom/intellij/openapi/Disposable;", "<init>", "()V", "cache", "Lcom/github/benmanes/caffeine/cache/Cache;", "", "", "Lcom/intellij/ml/llm/privacy/PSString;", "getCachedContext", "cacheContext", "value", "invalidate", "dispose", "Companion", "intellij.ml.llm.vcs.completion"})
public final class CommitHistoryCache
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Cache<Unit, List<PSString>> cache;
    private static final long CACHE_TTL = DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.MINUTES);
    private static final long CACHE_SIZE = 1L;

    public CommitHistoryCache() {
        Cache cache = Caffeine.newBuilder().maximumSize(1L).expireAfterAccess(Duration.getInWholeMinutes-impl((long)CACHE_TTL), TimeUnit.MINUTES).build();
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"build(...)");
        this.cache = cache;
    }

    @Nullable
    public final List<PSString> getCachedContext() {
        return (List)this.cache.getIfPresent((Object)Unit.INSTANCE);
    }

    public final void cacheContext(@NotNull List<? extends PSString> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.cache.put((Object)Unit.INSTANCE, value);
    }

    public final void invalidate() {
        this.cache.invalidateAll();
    }

    public void dispose() {
        this.invalidate();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u0010\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/ml/llm/vcs/completion/context/CommitHistoryCache$Companion;", "", "<init>", "()V", "CACHE_TTL", "Lkotlin/time/Duration;", "J", "CACHE_SIZE", "", "getInstance", "Lcom/intellij/ml/llm/vcs/completion/context/CommitHistoryCache;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.ml.llm.vcs.completion"})
    @SourceDebugExtension(value={"SMAP\nCommitHistoryCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommitHistoryCache.kt\ncom/intellij/ml/llm/vcs/completion/context/CommitHistoryCache$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,46:1\n30#2,2:47\n*S KotlinDebug\n*F\n+ 1 CommitHistoryCache.kt\ncom/intellij/ml/llm/vcs/completion/context/CommitHistoryCache$Companion\n*L\n44#1:47,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CommitHistoryCache getInstance(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project2;
            boolean $i$f$service = false;
            Class<CommitHistoryCache> serviceClass$iv = CommitHistoryCache.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (CommitHistoryCache)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

