/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.proj4j.proj;

import org.locationtech.proj4j.ProjCoordinate;
import org.locationtech.proj4j.proj.GaussProjection;

public class ObliqueStereographicAlternativeProjection
extends GaussProjection {
    private double sinc0;
    private double cosc0;
    private double R2;

    public ProjCoordinate OLDproject(double x, double y, ProjCoordinate out) {
        super.project(x, y, out);
        double px = out.x;
        double py = out.y;
        double sinc = Math.sin(py);
        double cosc = Math.cos(py);
        double cosl = Math.cos(px);
        double k = this.scaleFactor * this.R2 / (1.0 + this.sinc0 * sinc + this.cosc0 * cosc * cosl);
        out.x = k * cosc * Math.sin(px);
        out.y = k * (this.cosc0 * sinc - this.sinc0 * cosc * cosl);
        return out;
    }

    @Override
    public ProjCoordinate project(double lplamIn, double lpphiIn, ProjCoordinate out) {
        super.project(lplamIn, lpphiIn, out);
        double lplam = out.x;
        double lpphi = out.y;
        double sinc = Math.sin(lpphi);
        double cosc = Math.cos(lpphi);
        double cosl = Math.cos(lplam);
        double k = this.scaleFactor * this.R2 / (1.0 + this.sinc0 * sinc + this.cosc0 * cosc * cosl);
        out.x = k * cosc * Math.sin(lplam);
        out.y = k * (this.cosc0 * sinc - this.sinc0 * cosc * cosl);
        return out;
    }

    @Override
    public ProjCoordinate projectInverse(double x, double y, ProjCoordinate out) {
        double lplam;
        double lpphi;
        double xyx = x / this.scaleFactor;
        double xyy = y / this.scaleFactor;
        double rho = Math.sqrt(xyx * xyx + xyy * xyy);
        if (rho != 0.0) {
            double c2 = 2.0 * Math.atan2(rho, this.R2);
            double sinc = Math.sin(c2);
            double cosc = Math.cos(c2);
            lpphi = Math.asin(cosc * this.sinc0 + xyy * sinc * this.cosc0 / rho);
            lplam = Math.atan2(xyx * sinc, rho * this.cosc0 * cosc - xyy * this.sinc0 * sinc);
        } else {
            lpphi = this.phic0;
            lplam = 0.0;
        }
        return super.projectInverse(lplam, lpphi, out);
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.sinc0 = Math.sin(this.phic0);
        this.cosc0 = Math.cos(this.phic0);
        this.R2 = 2.0 * this.rc;
    }

    @Override
    public String toString() {
        return "Oblique Stereographic Alternative";
    }
}

