/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.jam.http;

import com.intellij.jam.JamService;
import com.intellij.micronaut.jam.http.MnClient;
import com.intellij.micronaut.jam.http.MnController;
import com.intellij.micronaut.jam.http.MnHttpMappingInfo;
import com.intellij.micronaut.jam.http.MnHttpUrlPathSpecification;
import com.intellij.micronaut.jam.http.mapping.MnErrorMethod;
import com.intellij.micronaut.jam.http.mapping.MnHttpMethodMapping;
import com.intellij.micronaut.provider.http.MnHttpUtils;
import com.intellij.microservices.jvm.cache.SourceLibSearchProvider;
import com.intellij.microservices.jvm.cache.UastCachedSearchUtils;
import com.intellij.microservices.url.UrlPath;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

public final class MnHttpModel {
    private static final SourceLibSearchProvider<List<MnHttpMappingInfo>, UserDataHolder> HTTP_MAPPINGS_CACHE_KEY = new SourceLibSearchProvider("MN_HTTP_MAPPINGS", (project, holder, scope) -> MnHttpModel.getHttpMappings(project, scope));

    @NotNull
    public static List<MnHttpMappingInfo> getHttpMethods(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            MnHttpModel.$$$reportNull$$$0(0);
        }
        List<MnHttpMappingInfo> list = MnHttpModel.getHttpMethods(JamService.getJamService((Project)psiClass.getProject()), psiClass).collect(Collectors.toList());
        if (list == null) {
            MnHttpModel.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public static List<MnController> findControllers(@NotNull Module module, @NotNull GlobalSearchScope scope) {
        if (module == null) {
            MnHttpModel.$$$reportNull$$$0(2);
        }
        if (scope == null) {
            MnHttpModel.$$$reportNull$$$0(3);
        }
        ArrayList<MnController> controllers = new ArrayList<MnController>();
        for (MnController mnController : MnHttpModel.getAllMnControllers(module, scope)) {
            PsiClass psiClass = (PsiClass)mnController.getPsiElement();
            if (psiClass.isAnnotationType()) {
                Collection<PsiClass> annotatedClasses = MnHttpModel.getAnnotatedClasses(psiClass, scope);
                controllers.addAll(ContainerUtil.mapNotNull(annotatedClasses, arg_0 -> MnController.META.getJamElement(arg_0)));
                continue;
            }
            controllers.add(mnController);
        }
        ArrayList<MnController> arrayList = controllers;
        if (arrayList == null) {
            MnHttpModel.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @NotNull
    private static List<MnController> getAllMnControllers(@NotNull Module module, @NotNull GlobalSearchScope scope) {
        if (module == null) {
            MnHttpModel.$$$reportNull$$$0(5);
        }
        if (scope == null) {
            MnHttpModel.$$$reportNull$$$0(6);
        }
        JamService jamService = JamService.getJamService((Project)module.getProject());
        List list = jamService.getJamClassElements(MnController.META, "io.micronaut.http.annotation.Controller", scope);
        if (list == null) {
            MnHttpModel.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    public static List<MnClient> findClients(@NotNull Module module, @NotNull GlobalSearchScope scope) {
        if (module == null) {
            MnHttpModel.$$$reportNull$$$0(8);
        }
        if (scope == null) {
            MnHttpModel.$$$reportNull$$$0(9);
        }
        JamService jamService = JamService.getJamService((Project)module.getProject());
        List list = jamService.getJamClassElements(MnClient.META, "io.micronaut.http.client.annotation.Client", scope);
        if (list == null) {
            MnHttpModel.$$$reportNull$$$0(10);
        }
        return list;
    }

    public static Sequence<MnHttpMappingInfo> getHttpMethodMappings(@NotNull Project project) {
        if (project == null) {
            MnHttpModel.$$$reportNull$$$0(11);
        }
        return UastCachedSearchUtils.sequenceWithCache((Project)project, HTTP_MAPPINGS_CACHE_KEY);
    }

    public static Sequence<MnHttpMappingInfo> resolveUrl(@NotNull Project project, @NotNull UrlPath resolveUrl) {
        if (project == null) {
            MnHttpModel.$$$reportNull$$$0(12);
        }
        if (resolveUrl == null) {
            MnHttpModel.$$$reportNull$$$0(13);
        }
        return SequencesKt.filter(MnHttpModel.getHttpMethodMappings(project), mapping -> {
            UrlPath resourcePath = MnHttpUrlPathSpecification.INSTANCE.parsePath(MnHttpUtils.getHttpResourcePath(mapping));
            return resourcePath.isCompatibleWith(resolveUrl);
        });
    }

    private static List<MnHttpMappingInfo> getHttpMappings(Project p, GlobalSearchScope scope) {
        JamService jamService = JamService.getJamService((Project)p);
        List controllers = jamService.getJamClassElements(MnController.META, "io.micronaut.http.annotation.Controller", scope);
        return controllers.stream().flatMap(c -> MnHttpModel.getHttpMethods(jamService, (PsiClass)c.getPsiElement())).collect(Collectors.toList());
    }

    @NotNull
    private static Stream<MnHttpMappingInfo> getHttpMethods(JamService jamService, @NotNull PsiClass psiClass) {
        if (psiClass == null) {
            MnHttpModel.$$$reportNull$$$0(14);
        }
        Stream<MnHttpMappingInfo> stream = jamService.getAnnotatedMembersList(psiClass, MnHttpMethodMapping.HTTP_METHOD_JAM_KEY, 10).stream().filter(mapping -> !(mapping instanceof MnErrorMethod)).map(mapping -> new MnHttpMappingInfo((MnHttpMethodMapping)((Object)mapping), psiClass));
        if (stream == null) {
            MnHttpModel.$$$reportNull$$$0(15);
        }
        return stream;
    }

    @NotNull
    private static Collection<PsiClass> getAnnotatedClasses(@NotNull PsiClass annoPsiClass, @NotNull GlobalSearchScope scope) {
        if (annoPsiClass == null) {
            MnHttpModel.$$$reportNull$$$0(16);
        }
        if (scope == null) {
            MnHttpModel.$$$reportNull$$$0(17);
        }
        LinkedHashSet<PsiClass> annotatedClasses = new LinkedHashSet<PsiClass>();
        CommonProcessors.CollectProcessor processor2 = new CommonProcessors.CollectProcessor(annotatedClasses);
        AnnotatedElementsSearch.searchPsiClasses((PsiClass)annoPsiClass, (SearchScope)scope).forEach((Processor)processor2);
        LinkedHashSet<PsiClass> linkedHashSet = annotatedClasses;
        if (linkedHashSet == null) {
            MnHttpModel.$$$reportNull$$$0(18);
        }
        return linkedHashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 7, 10, 15, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/micronaut/jam/http/MnHttpModel";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: 
            case 6: 
            case 9: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveUrl";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annoPsiClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/micronaut/jam/http/MnHttpModel";
                break;
            }
            case 1: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getHttpMethods";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findControllers";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllMnControllers";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findClients";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotatedClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getHttpMethods";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 15: 
            case 18: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findControllers";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAllMnControllers";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findClients";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getHttpMethodMappings";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "resolveUrl";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotatedClasses";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 7, 10, 15, 18 -> new IllegalStateException(string);
        };
    }
}

