/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.internal.parser.v0;

import java.io.IOException;
import org.openjdk.jmc.common.unit.QuantityRange;
import org.openjdk.jmc.flightrecorder.CouldNotLoadRecordingException;
import org.openjdk.jmc.flightrecorder.internal.ChunkInfo;
import org.openjdk.jmc.flightrecorder.internal.IChunkLoader;
import org.openjdk.jmc.flightrecorder.internal.parser.Chunk;
import org.openjdk.jmc.flightrecorder.internal.parser.LoaderContext;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.ChunkMetadata;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.ChunkStructure;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.EventParserManager;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.NumberReaders;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.Offset;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.ReaderFactory;
import org.openjdk.jmc.flightrecorder.parser.ByteBufferWrapper;

public class ChunkLoaderV0
implements IChunkLoader {
    private final ChunkStructure structure;
    private final ByteBufferWrapper data;
    private final LoaderContext context;
    private final ChunkMetadata metadata;

    private ChunkLoaderV0(ChunkStructure structure, ByteBufferWrapper data2, LoaderContext context2) throws CouldNotLoadRecordingException {
        this.structure = structure;
        this.data = data2;
        this.context = context2;
        this.metadata = new ChunkMetadata(data2, structure.getMetadataOffset());
        context2.addChunkRange(QuantityRange.createWithEnd(this.metadata.getStartTime(), this.metadata.getEndTime()));
    }

    @Override
    public byte[] call() throws Exception {
        this.context.incChunkCount();
        ReaderFactory readerFactory = new ReaderFactory(this.metadata, this.data, this.context, this.structure);
        EventParserManager eventParser = new EventParserManager(readerFactory, this.context, this.metadata.getProducers());
        int nextEventIndex = this.structure.getBodyStartOffset();
        while (nextEventIndex < this.structure.getMetadataOffset()) {
            Offset offset = new Offset(this.data, nextEventIndex);
            nextEventIndex = offset.getEnd();
            int eventTypeId = NumberReaders.readInt(this.data, offset);
            if (eventTypeId == 0 || eventTypeId == 1) continue;
            eventParser.loadEvent(this.data, offset, eventTypeId);
        }
        return this.data.hasArray() ? this.data.array() : new byte[]{};
    }

    public static IChunkLoader create(Chunk input, LoaderContext context2) throws IOException, CouldNotLoadRecordingException {
        ChunkStructure structure = new ChunkStructure(input);
        ByteBufferWrapper buffer = input.fill(structure.getChunkSize());
        return new ChunkLoaderV0(structure, buffer, context2);
    }

    public static ChunkInfo getInfo(Chunk input, long position) throws IOException, CouldNotLoadRecordingException {
        ChunkStructure structure = new ChunkStructure(input);
        ByteBufferWrapper buffer = input.fill(structure.getChunkSize());
        ChunkMetadata metadata = new ChunkMetadata(buffer, structure.getMetadataOffset());
        return new ChunkInfo(position, structure.getChunkSize(), QuantityRange.createWithEnd(metadata.getStartTime(), metadata.getEndTime()));
    }

    @Override
    public long getTimestamp() {
        return this.metadata.getStartTime().longValue();
    }
}

