/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.util;

import com.intellij.openapi.util.text.StringUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class Version {
    @NonNls
    private static final Pattern PATTERN = Pattern.compile("(\\d+)((\\.(\\d+))(\\.(\\d+))?)?\\.?(.*?)");
    private final int myMajor;
    private final int myMinor;
    private final int myMicro;
    private final String myRevision;

    public Version(String text) {
        Matcher matcher = PATTERN.matcher(text);
        if (matcher.matches()) {
            this.myMajor = Version.groupValue(matcher, 1);
            this.myMinor = Version.groupValue(matcher, 4);
            this.myMicro = Version.groupValue(matcher, 6);
            this.myRevision = StringUtil.notNullize((String)matcher.group(7));
        } else {
            this.myMajor = 0;
            this.myMinor = 0;
            this.myMicro = 0;
            this.myRevision = "";
        }
    }

    private static int groupValue(Matcher matcher, int groupIndex) {
        String groupText = matcher.group(groupIndex);
        return groupText == null ? 0 : Integer.parseInt(groupText);
    }

    public int getMajor() {
        return this.myMajor;
    }

    public int getMinor() {
        return this.myMinor;
    }

    public int getMicro() {
        return this.myMicro;
    }

    @NotNull
    public String getRevision() {
        String string = this.myRevision;
        if (string == null) {
            Version.$$$reportNull$$$0(0);
        }
        return string;
    }

    public int compare(int major, int minor, int micro) {
        if (this.myMajor > major) {
            return 1;
        }
        if (this.myMajor < major) {
            return -1;
        }
        if (this.myMinor > minor) {
            return 1;
        }
        if (this.myMinor < minor) {
            return -1;
        }
        return Integer.compare(this.myMicro, micro);
    }

    public String toString() {
        return super.toString() + ": `" + this.myMajor + "." + this.myMinor + "." + this.myMicro + "." + this.myRevision + "`";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/oss/util/Version", "getRevision"));
    }
}

