/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.gulp.codeInsight;

import com.intellij.lang.javascript.buildTools.JSPsiUtil;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import java.io.File;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeRequireDirCall {
    private final String myRelativeDirPath;

    public NodeRequireDirCall(@NotNull String relativeDirPath) {
        if (relativeDirPath == null) {
            NodeRequireDirCall.$$$reportNull$$$0(0);
        }
        this.myRelativeDirPath = relativeDirPath;
    }

    @Nullable
    public VirtualFile resolveRequiredDir(@NotNull VirtualFile callerFile) {
        VirtualFile baseDir;
        if (callerFile == null) {
            NodeRequireDirCall.$$$reportNull$$$0(1);
        }
        if (!(baseDir = callerFile).isDirectory()) {
            baseDir = baseDir.getParent();
        }
        if (baseDir == null) {
            return null;
        }
        File dir = VfsUtilCore.virtualToIoFile((VirtualFile)baseDir);
        if (dir.isDirectory()) {
            File requiredDir = new File(dir, this.myRelativeDirPath);
            if (requiredDir.isDirectory()) {
                return VfsUtil.findFileByIoFile((File)requiredDir, (boolean)false);
            }
            requiredDir = new File(this.myRelativeDirPath);
            if (requiredDir.isDirectory() && requiredDir.isAbsolute()) {
                return VfsUtil.findFileByIoFile((File)requiredDir, (boolean)false);
            }
        }
        return null;
    }

    @Nullable
    public static NodeRequireDirCall build(@NotNull JSCallExpression expr, @NotNull Set<String> requireDirVarNames) {
        String relativeDir;
        if (expr == null) {
            NodeRequireDirCall.$$$reportNull$$$0(2);
        }
        if (requireDirVarNames == null) {
            NodeRequireDirCall.$$$reportNull$$$0(3);
        }
        if (NodeRequireDirCall.isRequireDirCall(expr, requireDirVarNames) && (relativeDir = JSPsiUtil.getFirstArgumentAsString(expr.getArgumentList())) != null) {
            return new NodeRequireDirCall(relativeDir);
        }
        return null;
    }

    private static boolean isRequireDirCall(@NotNull JSCallExpression expr, @NotNull Set<String> requireDirVarNames) {
        JSCallExpression callExpr;
        if (expr == null) {
            NodeRequireDirCall.$$$reportNull$$$0(4);
        }
        if (requireDirVarNames == null) {
            NodeRequireDirCall.$$$reportNull$$$0(5);
        }
        if ((callExpr = (JSCallExpression)ObjectUtils.tryCast((Object)expr.getMethodExpression(), JSCallExpression.class)) != null) {
            return NodeRequireDirCall.isRequireDirRequireCall(callExpr);
        }
        JSReferenceExpression refExpr = (JSReferenceExpression)ObjectUtils.tryCast((Object)expr.getMethodExpression(), JSReferenceExpression.class);
        if (refExpr != null && refExpr.getQualifier() == null) {
            return requireDirVarNames.contains(refExpr.getReferenceName());
        }
        return false;
    }

    public static boolean isRequireDirRequireCall(@Nullable JSCallExpression expr) {
        if (expr != null && expr.isRequireCall()) {
            JSLiteralExpression argExpr = JSPsiUtil.getFirstArgumentAsStringLiteral(expr.getArgumentList());
            return argExpr != null && NodeRequireDirCall.isRequireDirLiteralValue(argExpr.getText());
        }
        return false;
    }

    public static boolean isRequireDirLiteralValue(@NotNull String value) {
        if (value == null) {
            NodeRequireDirCall.$$$reportNull$$$0(6);
        }
        return StringUtil.isQuotedString((String)value) && value.regionMatches(1, "require-dir", 0, value.length() - 2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativeDirPath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callerFile";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requireDirVarNames";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/buildTools/gulp/codeInsight/NodeRequireDirCall";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveRequiredDir";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "build";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isRequireDirCall";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isRequireDirLiteralValue";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

