/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow.lsp;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.flow.FlowJSServerService;
import com.intellij.lang.javascript.flow.FlowJSSettings;
import com.intellij.lang.javascript.flow.FlowJSSettingsManager;
import com.intellij.lang.javascript.flow.flowconfig.FlowJSConfig;
import com.intellij.lang.javascript.flow.lsp.FlowJSLspDiagnosticsSupport;
import com.intellij.lang.javascript.flow.lsp.FlowJSLspSupportProviderKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lsp.api.LspServerDescriptor;
import com.intellij.platform.lsp.api.customization.LspCallHierarchyCustomizer;
import com.intellij.platform.lsp.api.customization.LspCallHierarchyDisabled;
import com.intellij.platform.lsp.api.customization.LspCustomization;
import com.intellij.platform.lsp.api.customization.LspDiagnosticsSupport;
import com.intellij.platform.lsp.api.customization.LspDocumentHighlightsCustomizer;
import com.intellij.platform.lsp.api.customization.LspDocumentHighlightsDisabled;
import com.intellij.platform.lsp.api.customization.LspDocumentSymbolCustomizer;
import com.intellij.platform.lsp.api.customization.LspDocumentSymbolDisabled;
import com.intellij.platform.lsp.api.customization.LspFoldingRangeDisabled;
import com.intellij.platform.lsp.api.customization.LspInlayHintCustomizer;
import com.intellij.platform.lsp.api.customization.LspInlayHintDisabled;
import com.intellij.platform.lsp.api.customization.LspSelectionRangeCustomizer;
import com.intellij.platform.lsp.api.customization.LspSelectionRangeDisabled;
import com.intellij.platform.lsp.api.customization.LspSignatureHelpCustomizer;
import com.intellij.platform.lsp.api.customization.LspSignatureHelpDisabled;
import com.intellij.platform.lsp.api.customization.LspWorkspaceSymbolCustomizer;
import com.intellij.platform.lsp.api.customization.LspWorkspaceSymbolDisabled;
import com.intellij.util.text.SemVer;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/intellij/lang/javascript/flow/lsp/FlowJSLspServerDescriptor;", "Lcom/intellij/platform/lsp/api/LspServerDescriptor;", "project", "Lcom/intellij/openapi/project/Project;", "config", "Lcom/intellij/lang/javascript/flow/flowconfig/FlowJSConfig;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/lang/javascript/flow/flowconfig/FlowJSConfig;)V", "getConfig", "()Lcom/intellij/lang/javascript/flow/flowconfig/FlowJSConfig;", "isSupportedFile", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "createCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "lspCustomization", "Lcom/intellij/platform/lsp/api/customization/LspCustomization;", "getLspCustomization", "()Lcom/intellij/platform/lsp/api/customization/LspCustomization;", "intellij.javascript.backend"})
public final class FlowJSLspServerDescriptor
extends LspServerDescriptor {
    @NotNull
    private final FlowJSConfig config;
    @NotNull
    private final LspCustomization lspCustomization;

    public FlowJSLspServerDescriptor(@NotNull Project project, @NotNull FlowJSConfig config) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        String string = JavaScriptBundle.message((String)"flow.js.widget.name", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        VirtualFile[] virtualFileArray = new VirtualFile[1];
        Intrinsics.checkNotNullExpressionValue((Object)config.getConfigDirectory(), (String)"getConfigDirectory(...)");
        super(project, string, virtualFileArray);
        this.config = config;
        this.lspCustomization = new LspCustomization(this){
            private final LspDiagnosticsSupport diagnosticsCustomizer;
            private final LspFoldingRangeDisabled foldingRangeCustomizer;
            private final LspInlayHintCustomizer inlayHintCustomizer;
            private final LspWorkspaceSymbolCustomizer workspaceSymbolCustomizer;
            private final LspDocumentHighlightsCustomizer documentHighlightsCustomizer;
            private final LspDocumentSymbolCustomizer documentSymbolCustomizer;
            private final LspSignatureHelpCustomizer signatureHelpCustomizer;
            private final LspSelectionRangeCustomizer selectionRangeCustomizer;
            private final LspCallHierarchyCustomizer callHierarchyCustomizer;
            {
                this.diagnosticsCustomizer = new FlowJSLspDiagnosticsSupport($receiver.getConfig());
                this.foldingRangeCustomizer = LspFoldingRangeDisabled.INSTANCE;
                this.inlayHintCustomizer = (LspInlayHintCustomizer)LspInlayHintDisabled.INSTANCE;
                this.workspaceSymbolCustomizer = (LspWorkspaceSymbolCustomizer)LspWorkspaceSymbolDisabled.INSTANCE;
                this.documentHighlightsCustomizer = (LspDocumentHighlightsCustomizer)LspDocumentHighlightsDisabled.INSTANCE;
                this.documentSymbolCustomizer = (LspDocumentSymbolCustomizer)LspDocumentSymbolDisabled.INSTANCE;
                this.signatureHelpCustomizer = (LspSignatureHelpCustomizer)LspSignatureHelpDisabled.INSTANCE;
                this.selectionRangeCustomizer = (LspSelectionRangeCustomizer)LspSelectionRangeDisabled.INSTANCE;
                this.callHierarchyCustomizer = (LspCallHierarchyCustomizer)LspCallHierarchyDisabled.INSTANCE;
            }

            public LspDiagnosticsSupport getDiagnosticsCustomizer() {
                return this.diagnosticsCustomizer;
            }

            public LspFoldingRangeDisabled getFoldingRangeCustomizer() {
                return this.foldingRangeCustomizer;
            }

            public LspInlayHintCustomizer getInlayHintCustomizer() {
                return this.inlayHintCustomizer;
            }

            public LspWorkspaceSymbolCustomizer getWorkspaceSymbolCustomizer() {
                return this.workspaceSymbolCustomizer;
            }

            public LspDocumentHighlightsCustomizer getDocumentHighlightsCustomizer() {
                return this.documentHighlightsCustomizer;
            }

            public LspDocumentSymbolCustomizer getDocumentSymbolCustomizer() {
                return this.documentSymbolCustomizer;
            }

            public LspSignatureHelpCustomizer getSignatureHelpCustomizer() {
                return this.signatureHelpCustomizer;
            }

            public LspSelectionRangeCustomizer getSelectionRangeCustomizer() {
                return this.selectionRangeCustomizer;
            }

            public LspCallHierarchyCustomizer getCallHierarchyCustomizer() {
                return this.callHierarchyCustomizer;
            }
        };
    }

    @NotNull
    public final FlowJSConfig getConfig() {
        return this.config;
    }

    public boolean isSupportedFile(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return FlowJSLspSupportProviderKt.isFlowLanguageServiceFileType(file) && this.config.isFileIncluded(file);
    }

    @NotNull
    public GeneralCommandLine createCommandLine() {
        SemVer semVer = FlowJSServerService.getFlowVersion(this.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)semVer, (String)"getFlowVersion(...)");
        SemVer version2 = semVer;
        if (!version2.isGreaterOrEqualThan(0, 83, 0)) {
            Object[] objectArray = new Object[]{version2.getParsedVersion()};
            String string = JavaScriptBundle.message((String)"flow.js.version.not.supported", (Object[])objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String message = string;
            throw new RuntimeException(message);
        }
        FlowJSSettings.FlowJSExecutable executable = FlowJSSettingsManager.getInstance(this.getProject()).getRawSettings().getFlowExecutable();
        if (executable == null) {
            throw new ExecutionException(JavaScriptBundle.message((String)"can.t.find.flow.executable", (Object[])new Object[0]));
        }
        GeneralCommandLine generalCommandLine = executable.createCommandLine(this.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"createCommandLine(...)");
        GeneralCommandLine line = generalCommandLine;
        line.addParameter("lsp");
        line.withWorkingDirectory(Path.of(this.getRoots()[0].getPath(), new String[0]));
        return line;
    }

    @NotNull
    public LspCustomization getLspCustomization() {
        return this.lspCustomization;
    }
}

