/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.hierarchy.method;

import com.intellij.lang.javascript.index.JSTypeEvaluateManager;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.stubs.JSBaseTypesIndex;
import com.intellij.lang.javascript.psi.types.JSContext;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class JSMethodHierarchyUtil {
    JSMethodHierarchyUtil() {
    }

    static JSPsiElementBase @NotNull [] getSuperClasses(@NotNull JSPsiElementBase clazz) {
        if (clazz == null) {
            JSMethodHierarchyUtil.$$$reportNull$$$0(0);
        }
        if (clazz instanceof JSClass) {
            JSClass[] jSClassArray = ((JSClass)clazz).getSuperClasses();
            if (jSClassArray == null) {
                JSMethodHierarchyUtil.$$$reportNull$$$0(1);
            }
            return jSClassArray;
        }
        JSQualifiedName qualifiedName = JSQualifiedNameImpl.buildProvidedNamespace((JSElementBase)clazz);
        if (qualifiedName == null) {
            if (JSPsiElementBase.EMPTY_ARRAY == null) {
                JSMethodHierarchyUtil.$$$reportNull$$$0(2);
            }
            return JSPsiElementBase.EMPTY_ARRAY;
        }
        String typeString = JSBaseTypesIndex.serializeHierarchyElement(qualifiedName, JSContext.INSTANCE);
        Collection result2 = JSTypeEvaluateManager.findNearestExtendedJSTypes((JSPsiElementBase)clazz, (String)typeString);
        JSPsiElementBase[] jSPsiElementBaseArray = result2.toArray(JSPsiElementBase.EMPTY_ARRAY);
        if (jSPsiElementBaseArray == null) {
            JSMethodHierarchyUtil.$$$reportNull$$$0(3);
        }
        return jSPsiElementBaseArray;
    }

    @Nullable
    static JSFunctionItem findMethodInClass(@Nullable JSFunctionItem method, @NotNull JSPsiElementBase clazz, boolean lookInSupers) {
        if (clazz == null) {
            JSMethodHierarchyUtil.$$$reportNull$$$0(4);
        }
        return JSMethodHierarchyUtil.findMethodInClass(method, clazz, lookInSupers, null);
    }

    @Nullable
    private static JSFunctionItem findMethodInClass(@Nullable JSFunctionItem method, @NotNull JSPsiElementBase clazz, boolean lookInSupers, @Nullable Set<JSPsiElementBase> visited) {
        if (clazz == null) {
            JSMethodHierarchyUtil.$$$reportNull$$$0(5);
        }
        if (method == null || visited != null && !visited.add(clazz)) {
            return null;
        }
        if (method instanceof JSFunction && clazz instanceof JSClass) {
            return JSInheritanceUtil.findMethodInClass((JSFunction)((JSFunction)method), (JSClass)((JSClass)clazz), (boolean)lookInSupers);
        }
        JSFunctionItem methodInCurrentClass = JSInheritanceUtil.findMethodInClass((JSFunctionItem)method, (JSPsiElementBase)clazz);
        if (methodInCurrentClass != null || !lookInSupers) {
            return methodInCurrentClass;
        }
        JSPsiElementBase[] superClasses = JSMethodHierarchyUtil.getSuperClasses(clazz);
        if (visited == null) {
            visited = new HashSet<JSPsiElementBase>();
        }
        for (JSPsiElementBase superClass : superClasses) {
            JSFunctionItem methodInClass = JSMethodHierarchyUtil.findMethodInClass(method, superClass, true, visited);
            if (methodInClass == null) continue;
            return methodInClass;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/hierarchy/method/JSMethodHierarchyUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/hierarchy/method/JSMethodHierarchyUtil";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSuperClasses";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findMethodInClass";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }
}

