/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.library;

import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.library.JSBundledLibraryFolder;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesConstants;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.library.JSPredefinedLibraryProvider;
import com.intellij.lang.typescript.library.TypeScriptLibraries;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSCorePredefinedLibrariesProvider
extends JSPredefinedLibraryProvider {
    private static final Logger LOG = Logger.getInstance(JSCorePredefinedLibrariesProvider.class);
    private static final String[] ES6_LIB_FILES = new String[]{"es2019decorators.d.ts"};
    @NotNull
    private static final Map<String, String[]> ourLibMappings = Map.of("HTML", JSCorePredefinedLibrariesConstants.HTML_FILES, "react.d.ts", new String[]{"react.d.ts"}, "lib.es5.d.ts", new String[]{"lib.es5.d.ts"}, "ECMAScript 6+", ES6_LIB_FILES, "flow.utilities.d.ts", new String[]{"flow.utilities.d.ts"});
    @NotNull
    private static final ConcurrentMap<String, JSBundledLibraryFolder.FileSet> ourLibFiles = new ConcurrentHashMap<String, JSBundledLibraryFolder.FileSet>();
    private static final JSBundledLibraryFolder COMPILER_FOLDER = new JSBundledLibraryFolder("jsLanguageServicesImpl", (Function0<? extends Path>)((Function0)() -> TypeScriptUtil.getTypeScriptCompilerFolderFile().toPath()));
    private static final JSBundledLibraryFolder.FileSet ourFlowJSPredefLibFiles = COMPILER_FOLDER.registerFileSet(List.of("flow/bom.js", "flow/core.js", "flow/dom.js", "flow/indexeddb.js", "flow/intl.js", "flow/node.js", "flow/react.js", "flow/react-dom.js", "flow/serviceworkers.js", "flow/streams.js", "flow/webassembly.js"));
    private static final NotNullLazyValue<Set<VirtualFile>> ourJSPredefLibFiles = NotNullLazyValue.atomicLazy(() -> {
        HashSet<VirtualFile> result2 = new HashSet<VirtualFile>(JSCorePredefinedLibrariesProvider.getHtmlLibraryFiles());
        result2.addAll(JSCorePredefinedLibrariesProvider.getJavaScriptCorePredefinedLibraryFiles());
        result2.addAll(JSCorePredefinedLibrariesProvider.getFlowJSCorePredefinedLibraryFiles());
        result2.addAll(JSCorePredefinedLibrariesProvider.getLibFiles((Condition<? super String>)((Condition)JSCorePredefinedLibrariesProvider::isES6Lib), false));
        result2.addAll(JSCorePredefinedLibrariesProvider.getES6CorePredefinedLibraryFiles());
        return result2;
    });
    private static final NotNullLazyValue<Set<VirtualFile>> ourAllJSAndTSPredefLibFiles = NotNullLazyValue.atomicLazy(() -> {
        HashSet<VirtualFile> result2 = new HashSet<VirtualFile>(JSCorePredefinedLibrariesProvider.getJavaScriptPredefinedLibraryFiles());
        result2.addAll(JSCorePredefinedLibrariesProvider.getHtmlLibraryFiles());
        result2.addAll(JSCorePredefinedLibrariesProvider.getLibFiles((Condition<? super String>)Conditions.alwaysTrue(), false));
        result2.addAll(JSCorePredefinedLibrariesProvider.getReactPredefinedLibraryFiles());
        return result2;
    });

    @NotNull
    private static Set<VirtualFile> getFilesByLibName(@NotNull String name) {
        if (name == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(0);
        }
        JSBundledLibraryFolder.FileSet fileSet = ourLibFiles.computeIfAbsent(name, libName -> {
            String[] strings = ourLibMappings.get(libName);
            assert (strings != null);
            List<String> relativePaths = Arrays.stream(strings).map(fileName -> "external/" + fileName).toList();
            return COMPILER_FOLDER.registerFileSet(relativePaths);
        });
        Set<VirtualFile> set = fileSet.getFiles();
        if (set == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(1);
        }
        return set;
    }

    public static boolean isECMAScriptLibraryFileName(String fileName) {
        for (VirtualFile file : (Set)ourJSPredefLibFiles.getValue()) {
            if (!fileName.equals(file.getName())) continue;
            return true;
        }
        return false;
    }

    public static boolean isCoreLibraryFile(@Nullable VirtualFile libFile) {
        return libFile != null && JSCorePredefinedLibrariesProvider.getAllJSPredefinedLibraryFiles().contains(libFile) && !JSCorePredefinedLibrariesProvider.getReactPredefinedLibraryFiles().contains(libFile);
    }

    public static boolean isLibraryElement(@Nullable PsiElement element2) {
        VirtualFile file;
        PsiFile psiFile = element2 != null ? element2.getContainingFile() : null;
        psiFile = psiFile != null ? psiFile.getOriginalFile() : null;
        VirtualFile virtualFile = file = psiFile != null ? psiFile.getVirtualFile() : null;
        if (file == null && psiFile != null) {
            file = psiFile.getViewProvider().getVirtualFile();
        }
        if (file instanceof LightVirtualFile) {
            file = ((LightVirtualFile)file).getOriginalFile();
        }
        return file != null && JSCorePredefinedLibrariesProvider.isCoreLibraryFile(file);
    }

    @NotNull
    public static Set<VirtualFile> getJavaScriptPredefinedLibraryFiles() {
        Set set = (Set)ourJSPredefLibFiles.getValue();
        if (set == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    public static Set<VirtualFile> getReactPredefinedLibraryFiles() {
        return JSCorePredefinedLibrariesProvider.getFilesByLibName("react.d.ts");
    }

    @NotNull
    public static VirtualFile getReactLibraryFile() {
        VirtualFile virtualFile = JSCorePredefinedLibrariesProvider.getReactPredefinedLibraryFiles().iterator().next();
        if (virtualFile == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(3);
        }
        return virtualFile;
    }

    @NotNull
    public static Set<VirtualFile> getJavaScriptCorePredefinedLibraryFiles() {
        return JSCorePredefinedLibrariesProvider.getFilesByLibName("lib.es5.d.ts");
    }

    @NotNull
    public static Set<VirtualFile> getES6CorePredefinedLibraryFiles() {
        return JSCorePredefinedLibrariesProvider.getFilesByLibName("ECMAScript 6+");
    }

    public static Set<VirtualFile> getHtmlLibraryFiles() {
        return JSCorePredefinedLibrariesProvider.getFilesByLibName("HTML");
    }

    @NotNull
    public static Set<VirtualFile> getFlowJSCorePredefinedLibraryFiles() {
        return JSCorePredefinedLibrariesProvider.getFilesByLibName("flow.utilities.d.ts");
    }

    public static Set<VirtualFile> getFlowJSPredefinedLibraryFiles() {
        return ourFlowJSPredefLibFiles.getFiles();
    }

    @Override
    public ScriptingLibraryModel @NotNull [] getPredefinedLibraries(@NotNull Project project) {
        if (project == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(4);
        }
        ScriptingLibraryModel[] scriptingLibraryModelArray = new ScriptingLibraryModel[]{ScriptingLibraryModel.createPredefinedLibrary((String)"HTML", (VirtualFile[])VfsUtilCore.toVirtualFileArray(JSCorePredefinedLibrariesProvider.getHtmlLibraryFiles()), (boolean)true)};
        if (scriptingLibraryModelArray == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(5);
        }
        return scriptingLibraryModelArray;
    }

    @Override
    @NotNull
    public Set<VirtualFile> getRequiredLibraryFilesToIndex() {
        HashSet<VirtualFile> files = new HashSet<VirtualFile>(JSCorePredefinedLibrariesProvider.getReactPredefinedLibraryFiles());
        files.addAll(JSCorePredefinedLibrariesProvider.getFlowJSPredefinedLibraryFiles());
        HashSet<VirtualFile> hashSet = files;
        if (hashSet == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(6);
        }
        return hashSet;
    }

    @Override
    @NotNull
    public Set<VirtualFile> getRequiredLibraryFilesForResolve() {
        HashSet<VirtualFile> files = new HashSet<VirtualFile>(this.getRequiredLibraryFilesForResolveES5());
        files.addAll(JSCorePredefinedLibrariesProvider.getLibFiles((Condition<? super String>)((Condition)JSCorePredefinedLibrariesProvider::isES6Lib), false));
        files.addAll(JSCorePredefinedLibrariesProvider.getES6CorePredefinedLibraryFiles());
        HashSet<VirtualFile> hashSet = files;
        if (hashSet == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(7);
        }
        return hashSet;
    }

    @Override
    @NotNull
    public Set<VirtualFile> getRequiredLibraryFilesForResolveES5() {
        HashSet<VirtualFile> files = new HashSet<VirtualFile>();
        files.addAll(JSCorePredefinedLibrariesProvider.getJavaScriptCorePredefinedLibraryFiles());
        files.addAll(JSCorePredefinedLibrariesProvider.getFlowJSCorePredefinedLibraryFiles());
        HashSet<VirtualFile> hashSet = files;
        if (hashSet == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(8);
        }
        return hashSet;
    }

    @NotNull
    public static Set<VirtualFile> getAllJSPredefinedLibraryFiles() {
        Set set = (Set)ourAllJSAndTSPredefLibFiles.getValue();
        if (set == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(9);
        }
        return set;
    }

    private static boolean isES6Lib(@NotNull String fileName) {
        if (fileName == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(10);
        }
        if (ArrayUtil.contains((String)fileName, (String[])ES6_LIB_FILES)) {
            return true;
        }
        if (fileName.endsWith(".full.d.ts")) {
            return false;
        }
        String exactLibName = TypeScriptLibraries.getLibraryName((String)fileName);
        if (StringUtil.isEmpty((String)exactLibName) || exactLibName.length() <= 4) {
            return false;
        }
        return TypeScriptUtil.isES6LibName((String)exactLibName);
    }

    @NotNull
    public static Set<VirtualFile> getLibFiles(@NotNull Condition<? super String> includeCondition, boolean includeInvalid) {
        VirtualFile virtualFileExternalDirectory;
        if (includeCondition == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(11);
        }
        if ((virtualFileExternalDirectory = COMPILER_FOLDER.findFileByRelativePath("external")) == null) {
            Set<VirtualFile> set = Collections.emptySet();
            if (set == null) {
                JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(12);
            }
            return set;
        }
        return JSCorePredefinedLibrariesProvider.getLibDtsFilesByVFS(virtualFileExternalDirectory, includeCondition, includeInvalid);
    }

    @NotNull
    private static Set<VirtualFile> getLibDtsFilesByVFS(@NotNull VirtualFile directory, @NotNull Condition<? super String> includeCondition, boolean includeInvalid) {
        if (directory == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(13);
        }
        if (includeCondition == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(14);
        }
        VirtualFile[] children = directory.getChildren();
        HashSet<VirtualFile> result2 = new HashSet<VirtualFile>(children.length);
        for (VirtualFile child : children) {
            String name;
            if (child.isDirectory() || !child.isValid() && !includeInvalid || !JSCorePredefinedLibrariesProvider.isLibFileAcceptable(includeCondition, name = child.getName())) continue;
            result2.add(child);
        }
        HashSet<VirtualFile> hashSet = result2;
        if (hashSet == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(15);
        }
        return hashSet;
    }

    private static boolean isLibFileAcceptable(@NotNull Predicate<? super String> includeCondition, @NotNull String name) {
        if (includeCondition == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(16);
        }
        if (name == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(17);
        }
        return name.startsWith("lib.") && TypeScriptUtil.isDefinitionFile((CharSequence)name) && includeCondition.test(name);
    }

    @NotNull
    public static List<VirtualFile> getLibFilesByIO(@NotNull File libFolder, @NotNull Predicate<? super String> includeCondition, boolean includeInvalid) {
        if (libFolder == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(18);
        }
        if (includeCondition == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(19);
        }
        if (!libFolder.exists() || !libFolder.isDirectory()) {
            LOG.error("Cannot find external directory, the installation is possibly broken.");
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(20);
            }
            return list;
        }
        File[] files = libFolder.listFiles();
        if (files == null) {
            LOG.error("Cannot find files in the external directory, the installation is possibly broken.");
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(21);
            }
            return list;
        }
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>(files.length);
        for (File file : files) {
            String name;
            ProgressManager.checkCanceled();
            if (file.isDirectory() || !JSCorePredefinedLibrariesProvider.isLibFileAcceptable(includeCondition, name = file.getName())) continue;
            ContainerUtil.addIfNotNull(result2, (Object)JSLibraryUtil.findFileByIO((File)file, (boolean)includeInvalid));
        }
        ArrayList<VirtualFile> arrayList = result2;
        if (arrayList == null) {
            JSCorePredefinedLibrariesProvider.$$$reportNull$$$0(22);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 5, 6, 7, 8, 9, 12, 15, 20, 21, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 15: 
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/library/JSCorePredefinedLibrariesProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 11: 
            case 14: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "includeCondition";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libFolder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/library/JSCorePredefinedLibrariesProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesByLibName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaScriptPredefinedLibraryFiles";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getReactLibraryFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPredefinedLibraries";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredLibraryFilesToIndex";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredLibraryFilesForResolve";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequiredLibraryFilesForResolveES5";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllJSPredefinedLibraryFiles";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibFiles";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibDtsFilesByVFS";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibFilesByIO";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFilesByLibName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 15: 
            case 20: 
            case 21: 
            case 22: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPredefinedLibraries";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isES6Lib";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getLibFiles";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getLibDtsFilesByVFS";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isLibFileAcceptable";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getLibFilesByIO";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 5, 6, 7, 8, 9, 12, 15, 20, 21, 22 -> new IllegalStateException(string);
        };
    }
}

