/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.performanceTesting;

import com.intellij.lang.javascript.index.JavaScriptIndex;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.performanceTesting.VirtualFilesVisitorCommand;
import com.intellij.lang.javascript.psi.JSRecursiveWalkingElementVisitor;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSResolveReferencesCommandBase
extends VirtualFilesVisitorCommand<List<String>> {
    public JSResolveReferencesCommandBase(@NotNull String text, int line) {
        if (text == null) {
            JSResolveReferencesCommandBase.$$$reportNull$$$0(0);
        }
        super(text, line);
    }

    @Override
    protected boolean isContentOnly() {
        return true;
    }

    @Override
    protected boolean isAcceptable(@NotNull VirtualFile file) {
        if (file == null) {
            JSResolveReferencesCommandBase.$$$reportNull$$$0(1);
        }
        return JavaScriptIndex.isAcceptableFile(file) && !"coffee".equalsIgnoreCase(file.getExtension());
    }

    @Override
    protected List<String> visitFile(@NotNull VirtualFile file, final @NotNull VirtualFile root, @NotNull Project project) {
        String path2;
        if (file == null) {
            JSResolveReferencesCommandBase.$$$reportNull$$$0(2);
        }
        if (root == null) {
            JSResolveReferencesCommandBase.$$$reportNull$$$0(3);
        }
        if (project == null) {
            JSResolveReferencesCommandBase.$$$reportNull$$$0(4);
        }
        if ((path2 = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)root, (char)'/')) == null) {
            return Collections.emptyList();
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (psiFile == null) {
            return Collections.emptyList();
        }
        final Document document = FileDocumentManager.getInstance().getDocument(file);
        if (document == null) {
            return Collections.emptyList();
        }
        final ArrayList<String> result2 = new ArrayList<String>();
        new JSRecursiveWalkingElementVisitor(){

            public void visitJSReferenceExpression(@NotNull JSReferenceExpression node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!1.isAcceptableReference(node)) {
                    super.visitJSReferenceExpression(node);
                    return;
                }
                Object[] resolveResults = JSResolveReferencesCommandBase.this.getResolveResults(node);
                int offset = node.getTextRange().getStartOffset() + node.getRangeInElement().getStartOffset();
                int lineNumber = document.getLineNumber(offset);
                int offsetInLine = offset - document.getLineStartOffset(lineNumber);
                String messageBody = JSResolveResult.isTooManyCandidatesResult((ResolveResult[])resolveResults) ? "too many candidates" : (!ContainerUtil.exists((Object[])resolveResults, ResolveResult::isValidResult) ? "unresolved" : (resolveResults.length > 1 ? "several results (" + resolveResults.length + ")" : JSResolveReferencesCommandBase.formatUniqueValidResult(resolveResults[0].getElement(), root)));
                String message = String.format("jsref: %s:%d:%d %s -> %s", path2, lineNumber, offsetInLine, node.getReferenceName(), messageBody);
                result2.add(message);
                super.visitJSReferenceExpression(node);
            }

            private static boolean isAcceptableReference(JSReferenceExpression node) {
                return node.getClass().equals(JSReferenceExpressionImpl.class) && !JSResolveUtil.isSelfReference((PsiElement)node);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/javascript/performanceTesting/JSResolveReferencesCommandBase$1", "visitJSReferenceExpression"));
            }
        }.visitElement((PsiElement)psiFile);
        return result2;
    }

    @NotNull
    private static String formatUniqueValidResult(@Nullable PsiElement element2, @NotNull VirtualFile root) {
        if (root == null) {
            JSResolveReferencesCommandBase.$$$reportNull$$$0(5);
        }
        if (element2 == null) {
            return "unknown";
        }
        VirtualFile resolveFile = element2.getContainingFile().getVirtualFile();
        if (resolveFile == null) {
            return "unknown";
        }
        Document resolveDocument = FileDocumentManager.getInstance().getDocument(resolveFile);
        if (resolveDocument == null) {
            return "unknown";
        }
        int offset = element2.getTextOffset();
        if (offset == -1 || element2 instanceof FakePsiElement || element2 instanceof LightElement) {
            return "unknown";
        }
        int lineNumber = resolveDocument.getLineNumber(offset);
        int offsetInLine = offset - resolveDocument.getLineStartOffset(lineNumber);
        String relativePath = VfsUtilCore.getRelativePath((VirtualFile)resolveFile, (VirtualFile)root, (char)'/');
        if (relativePath == null && JSCorePredefinedLibrariesProvider.isCoreLibraryFile(resolveFile)) {
            relativePath = resolveFile.getName();
        }
        if (relativePath == null) {
            return "unknown";
        }
        String string = String.format("%s:%d:%d", relativePath, lineNumber, offsetInLine);
        if (string == null) {
            JSResolveReferencesCommandBase.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    protected void processResult(@NotNull VirtualFile file, @NotNull VirtualFile root, List<String> result2, @NotNull PlaybackContext context2) {
        if (file == null) {
            JSResolveReferencesCommandBase.$$$reportNull$$$0(7);
        }
        if (root == null) {
            JSResolveReferencesCommandBase.$$$reportNull$$$0(8);
        }
        if (context2 == null) {
            JSResolveReferencesCommandBase.$$$reportNull$$$0(9);
        }
        for (String message : result2) {
            context2.message(message, -1);
        }
    }

    protected abstract ResolveResult @NotNull [] getResolveResults(@NotNull JSReferenceExpression var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/performanceTesting/JSResolveReferencesCommandBase";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/performanceTesting/JSResolveReferencesCommandBase";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "formatUniqueValidResult";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptable";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "visitFile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "formatUniqueValidResult";
                break;
            }
            case 6: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processResult";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

