/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.ide.nls.NlsMessages;
import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.evaluation.JSTypeEvaluationLocationProvider;
import com.intellij.lang.javascript.integration.JSAnnotationError;
import com.intellij.lang.javascript.integration.JSAnnotationRangeError;
import com.intellij.lang.javascript.linter.LinterLanguageServiceClient;
import com.intellij.lang.javascript.service.JSLanguageServiceBase;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.JSLanguageServiceQueueImpl;
import com.intellij.lang.javascript.service.JSLanguageServiceTracerUtilKt;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceNodeStdProtocolBase;
import com.intellij.lang.javascript.service.protocol.LocalFilePath;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PluginPathManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.indexing.FileBasedIndex;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import java.io.File;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.List;
import java.util.MissingResourceException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.concurrency.Promise;

public final class JSLanguageServiceUtil {
    private static final long DEFAULT_TIMEOUT = TimeUnit.SECONDS.toMillis(20L);
    private static final long DEFAULT_SHORT_TIMEOUT = 200L;
    private static final long DEFAULT_MODERATE_TIMEOUT = 4000L;
    private static final long QUOTA_MILLS = 5L;
    public static final boolean TIMEOUT_DISABLED = StringUtil.isNotEmpty((String)System.getProperty("idea.javascript.language.service.disable.timeout"));
    private static long EXPLICIT_TIMEOUT = -1L;

    private JSLanguageServiceUtil() {
    }

    /*
     * WARNING - void declaration
     */
    @TestOnly
    public static void setTimeout(long explicitTimeout, @NotNull Disposable disposable) {
        void disposable2;
        if (disposable == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(0);
        }
        long previousTimeout = EXPLICIT_TIMEOUT;
        EXPLICIT_TIMEOUT = explicitTimeout;
        Disposer.register((Disposable)disposable2, () -> {
            EXPLICIT_TIMEOUT = previousTimeout;
        });
    }

    public static boolean isExplicitTimeoutSet() {
        return EXPLICIT_TIMEOUT >= 0L;
    }

    public static long getTimeout() {
        return JSLanguageServiceUtil.getTimeout(DEFAULT_TIMEOUT);
    }

    public static long getShortTimeout() {
        return JSLanguageServiceUtil.getTimeout(200L);
    }

    public static long getModerateTimeout() {
        return JSLanguageServiceUtil.getTimeout(4000L);
    }

    public static long getModerateTimeoutNanos() {
        return TimeUnit.MILLISECONDS.toNanos(JSLanguageServiceUtil.getTimeout(4000L));
    }

    public static long getTimeout(long defaultValue) {
        if (TIMEOUT_DISABLED) {
            return 1800000L;
        }
        if (JSLanguageServiceUtil.isExplicitTimeoutSet()) {
            return EXPLICIT_TIMEOUT;
        }
        return defaultValue;
    }

    @NlsContexts.DialogMessage
    public static String getTimeoutMessage(@NlsSafe @NotNull String fileName, long timeout) {
        if (fileName == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(1);
        }
        String formattedTimeout = NlsMessages.formatDurationApproximateNarrow((long)timeout);
        return JavaScriptBundle.message((String)"dialog.message.no.results.for.after", (Object[])new Object[]{fileName, formattedTimeout});
    }

    @Nullable
    public static <T> T awaitFuture(@Nullable Future<T> future, long timeoutMillis) {
        return JSLanguageServiceUtil.awaitFuture(future, timeoutMillis, true, null);
    }

    @Nullable
    public static <T> T awaitFuture(@Nullable Future<T> future, long timeoutMills, boolean cancelFutureIfTimeout, @Nullable Computable<Boolean> cancelCheck) {
        return JSLanguageServiceUtil.awaitFuture(future, timeoutMills, cancelFutureIfTimeout, cancelCheck, timeoutMills <= 200L);
    }

    @Nullable
    public static <T> T awaitFuture(@Nullable Future<T> future, long timeoutMills, boolean cancelFutureIfTimeout, @Nullable Computable<Boolean> cancelCheck, boolean allowEDT) {
        block12: {
            if (future == null) {
                return null;
            }
            if (ApplicationManager.getApplication().isDispatchThread() && !ApplicationManager.getApplication().isHeadlessEnvironment() && !allowEDT) {
                JSLanguageServiceQueue.Holder.LOGGER.error("Await future on EDT may cause a deadlock");
                return null;
            }
            ProgressManager.checkCanceled();
            try {
                long totalWait;
                for (totalWait = timeoutMills; !(timeoutMills >= 0L && totalWait <= 0L || cancelCheck != null && Boolean.TRUE.equals(cancelCheck.compute())); totalWait -= 5L) {
                    try {
                        return future.get(5L, TimeUnit.MILLISECONDS);
                    }
                    catch (TimeoutException timeoutException) {
                    }
                    catch (InterruptedException | CancellationException e) {
                        return null;
                    }
                    ProgressManager.checkCanceled();
                }
                if (future.isDone()) {
                    return future.get();
                }
                if (cancelFutureIfTimeout && timeoutMills >= 0L) {
                    if (ApplicationManager.getApplication().isUnitTestMode() && !JSLanguageServiceUtil.isExplicitTimeoutSet() && totalWait <= 0L) {
                        JSLanguageServiceQueue.Holder.LOGGER.error("Timeout in JSLanguageServiceUtil.awaitFuture");
                    }
                    future.cancel(false);
                }
            }
            catch (CancellationException e) {
                throw e;
            }
            catch (Exception e) {
                if (!ApplicationManager.getApplication().isUnitTestMode()) break block12;
                JSLanguageServiceQueue.Holder.LOGGER.error((Throwable)e);
            }
        }
        return null;
    }

    @Nullable
    public static <Result> Result awaitLanguageService(@Nullable Future<? extends Result> future, @NotNull LinterLanguageServiceClient languageService, @NotNull VirtualFile file) throws ExecutionException {
        if (languageService == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(2);
        }
        if (file == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(3);
        }
        return JSLanguageServiceUtil.awaitLanguageService(future, languageService, file, JSLanguageServiceUtil.getTimeout());
    }

    @Nullable
    public static <Result> Result awaitLanguageService(@Nullable Future<? extends Result> future, @NotNull LinterLanguageServiceClient languageService, @NotNull VirtualFile file, long timeout) throws ExecutionException {
        if (languageService == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(4);
        }
        if (file == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(5);
        }
        if (future == null) {
            if (JSLanguageServiceUtil.languageServiceHasError(languageService)) {
                throw new ExecutionException(JSLanguageServiceUtil.getLanguageServiceCreationError(languageService));
            }
            return null;
        }
        Result result2 = JSLanguageServiceUtil.awaitFuture(future, timeout, true, (Computable<Boolean>)((Computable)() -> languageService.getServiceCreationError() != null));
        if (future.isCancelled()) {
            if (JSLanguageServiceUtil.languageServiceHasError(languageService)) {
                throw new ExecutionException(JSLanguageServiceUtil.getLanguageServiceCreationError(languageService));
            }
            throw new ExecutionException(JSLanguageServiceUtil.getTimeoutMessage(StringUtil.notNullize((String)file.getName()), timeout));
        }
        if (result2 == null) {
            if (JSLanguageServiceUtil.languageServiceHasError(languageService)) {
                throw new ExecutionException(JSLanguageServiceUtil.getLanguageServiceCreationError(languageService));
            }
            return null;
        }
        return result2;
    }

    private static boolean languageServiceHasError(@NotNull LinterLanguageServiceClient languageService) {
        if (languageService == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(6);
        }
        return !languageService.isServiceCreated() || languageService.getServiceCreationError() != null;
    }

    @NotNull
    @InspectionMessage
    public static String getLanguageServiceCreationError(@NotNull LinterLanguageServiceClient languageService) {
        if (languageService == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(7);
        }
        String string = (String)ObjectUtils.coalesce((Object)languageService.getServiceCreationError(), (Object)JavaScriptBundle.message((String)"javascript.language.service.cannot.start", (Object[])new Object[0]));
        if (string == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Nullable
    public static PsiElementInfo getElementInfo(@Nullable PsiFile file, @NotNull Document document, @NotNull JSAnnotationError result2) {
        if (document == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(9);
        }
        if (result2 == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(10);
        }
        int endLine = result2 instanceof JSAnnotationRangeError ? ((JSAnnotationRangeError)result2).getEndLine() : -1;
        int endColumn = result2 instanceof JSAnnotationRangeError ? ((JSAnnotationRangeError)result2).getEndColumn() : -1;
        return JSLanguageServiceUtil.getElementInfo(file, document, result2.getLine(), result2.getColumn(), endLine, endColumn);
    }

    @Nullable
    public static PsiElementInfo getElementInfo(@Nullable PsiFile file, @NotNull Document document, int line, int column, int endLine, int endColumn) {
        if (document == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(11);
        }
        try {
            PsiElement element2;
            if (line < 0 || line >= document.getLineCount()) {
                return null;
            }
            int lineStartOffset = document.getLineStartOffset(line);
            int errorStartOffset = Math.min(lineStartOffset + column, document.getLineEndOffset(line));
            TextRange range = null;
            if (endLine < 0 && file != null) {
                element2 = file.findElementAt(errorStartOffset);
                if (element2 == null && lineStartOffset < errorStartOffset) {
                    element2 = file.findElementAt(errorStartOffset - 1);
                }
            } else {
                if (endLine < 0 || endLine >= document.getLineCount()) {
                    return null;
                }
                int errorEndOffset = Math.min(document.getLineStartOffset(endLine) + endColumn, document.getLineEndOffset(endLine));
                if (errorEndOffset < errorStartOffset) {
                    return null;
                }
                range = TextRange.create((int)errorStartOffset, (int)errorEndOffset);
                element2 = file != null ? TypeScriptPsiUtil.getPsiElementByRange((PsiFile)file, (TextRange)range) : null;
            }
            return new PsiElementInfo(element2, range);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            JSLanguageServiceQueue.Holder.LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Nullable
    public static NodeJsInterpreter getInterpreterIfValid(@Nullable NodeJsInterpreter interpreter2) {
        return interpreter2 != null && interpreter2.validate(null) == null ? interpreter2 : null;
    }

    @Nullable
    public static String normalizePathDoNotFollowSymlinks(@Nullable VirtualFile virtualFile) {
        if (virtualFile == null || !virtualFile.isInLocalFileSystem()) {
            return null;
        }
        VirtualFileSystem fileSystem = virtualFile.getFileSystem();
        Path nioPath = fileSystem.getNioPath(virtualFile);
        if (nioPath == null) {
            return null;
        }
        return FileUtil.toSystemDependentName((String)LocalFilePath.asLocalFilePath(nioPath));
    }

    @Nullable
    public static String normalizeNameAndPath(@NotNull VirtualFile file) {
        if (file == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(12);
        }
        return JSLanguageServiceUtil.normalizePathDoNotFollowSymlinks(file);
    }

    @Contract(value="!null -> !null")
    public static String normalizeNameAndPath(@Nullable String path2) {
        if (null == path2) {
            return null;
        }
        return FileUtil.toSystemDependentName((String)path2);
    }

    @NotNull
    public static CharSequence convertLineSeparatorsToFileOriginal(@NotNull Project project, @NotNull CharSequence fileContent, @NotNull VirtualFile file) {
        String lineSeparator;
        if (project == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(13);
        }
        if (fileContent == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(14);
        }
        if (file == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(15);
        }
        if ((lineSeparator = FileDocumentManager.getInstance().getLineSeparator(file, project)).equals("\n")) {
            CharSequence charSequence = fileContent;
            if (charSequence == null) {
                JSLanguageServiceUtil.$$$reportNull$$$0(16);
            }
            return charSequence;
        }
        CharSequence charSequence = StringUtilRt.convertLineSeparators((CharSequence)fileContent, (String)lineSeparator);
        if (charSequence == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(17);
        }
        return charSequence;
    }

    @NotNull
    public static CharSequence convertLineSeparatorsToFileOriginal(@NotNull Project project, @NotNull CharSequence fileContent, @NotNull VirtualFile file, int @Nullable [] offsetsToKeep) {
        String lineSeparator;
        if (project == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(18);
        }
        if (fileContent == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(19);
        }
        if (file == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(20);
        }
        if ((lineSeparator = FileDocumentManager.getInstance().getLineSeparator(file, project)).equals("\n")) {
            CharSequence charSequence = fileContent;
            if (charSequence == null) {
                JSLanguageServiceUtil.$$$reportNull$$$0(21);
            }
            return charSequence;
        }
        String string = StringUtilRt.convertLineSeparators((String)fileContent.toString(), (String)lineSeparator, (int[])offsetsToKeep);
        if (string == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(22);
        }
        return string;
    }

    public static void assertServiceRequestAllowed() {
        if (FileBasedIndex.getInstance().getFileBeingCurrentlyIndexed() != null) {
            JSLanguageServiceQueue.Holder.LOGGER.error("Service cannot be used during indexing");
        }
        if (JSTypeEvaluationLocationProvider.isCalculatingGists()) {
            JSLanguageServiceQueue.Holder.LOGGER.error("Service cannot be used during gist building");
        }
    }

    @NotNull
    public static File getPluginStarterDirectory() {
        File file = TypeScriptUtil.getTypeScriptCompilerFolderFile();
        if (file == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(23);
        }
        return file;
    }

    @NotNull
    public static Gson createGson(@NotNull NodeTargetRun targetRun) {
        if (targetRun == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(24);
        }
        return JSLanguageServiceUtil.createGson((Function<? super String, String>)((Function)localPath -> {
            try {
                Promise<String> targetPathPromise = targetRun.convertLocalPathToTarget((String)localPath);
                return (String)targetPathPromise.blockingGet(1000, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                ExceptionUtil.rethrowUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
        }), (Function<? super String, String>)((Function)targetPath -> {
            try {
                Promise<String> localPathPromise = targetRun.convertTargetPathToLocal((String)targetPath);
                return (String)localPathPromise.blockingGet(1000, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                ExceptionUtil.rethrowUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
        }));
    }

    @NotNull
    static Gson createGson(final @NotNull Function<? super String, String> localPathToRemotePathConverter, final @NotNull Function<? super String, String> remotePathToLocalPathConverter) {
        if (localPathToRemotePathConverter == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(25);
        }
        if (remotePathToLocalPathConverter == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(26);
        }
        Gson gson = new GsonBuilder().registerTypeAdapter(LocalFilePath.class, (Object)new JsonSerializer<LocalFilePath>(){

            public JsonElement serialize(LocalFilePath src, Type typeOfSrc, JsonSerializationContext context2) {
                if (src == null) {
                    return context2.serialize(null);
                }
                try {
                    String targetPath = (String)localPathToRemotePathConverter.fun((Object)src.getPath());
                    return context2.serialize((Object)targetPath);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Cannot convert local path (" + src.getPath() + ") to remote", e);
                }
            }
        }).registerTypeAdapter(LocalFilePath.class, (Object)new JsonDeserializer<LocalFilePath>(){

            public LocalFilePath deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context2) throws JsonParseException {
                String targetPath = (String)context2.deserialize(json, String.class);
                if (targetPath == null) {
                    return null;
                }
                try {
                    String localPath = (String)remotePathToLocalPathConverter.fun((Object)targetPath);
                    return LocalFilePath.create(localPath);
                }
                catch (Exception e) {
                    throw new IllegalStateException("Cannot convert remote path (" + targetPath + ") to local", e);
                }
            }
        }).create();
        if (gson == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(27);
        }
        return gson;
    }

    @NotNull
    public static Gson getGson(@NotNull JSLanguageServiceBase serviceBase) {
        JSLanguageServiceNodeStdProtocolBase protocolBase;
        JSLanguageServiceQueue queue;
        if (serviceBase == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(28);
        }
        if ((queue = serviceBase.getProcessIfCreated()) != null && queue instanceof JSLanguageServiceQueueImpl && (protocolBase = (JSLanguageServiceNodeStdProtocolBase)ObjectUtils.tryCast((Object)((JSLanguageServiceQueueImpl)queue).getProtocol(), JSLanguageServiceNodeStdProtocolBase.class)) != null) {
            Gson gson = protocolBase.getGson();
            if (gson == null) {
                JSLanguageServiceUtil.$$$reportNull$$$0(29);
            }
            return gson;
        }
        Gson gson = JSLanguageServiceQueue.SharedGson.GSON;
        if (gson == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(30);
        }
        return gson;
    }

    public static void addNodePathFromRegistry(@NotNull TargetedCommandLineBuilder commandLineBuilder, @NotNull Supplier<String> getRegistryValue) {
        if (commandLineBuilder == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(31);
        }
        if (getRegistryValue == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(32);
        }
        String nodePath = null;
        try {
            nodePath = getRegistryValue.get();
        }
        catch (MissingResourceException e) {
            JSLanguageServiceQueue.Holder.LOGGER.debug(e.getMessage(), (Throwable)e);
        }
        if (!StringUtil.isEmptyOrSpaces((String)nodePath)) {
            commandLineBuilder.addEnvironmentVariable("NODE_PATH", nodePath);
        }
    }

    public static void addNodeProcessArgumentsFromRegistry(@NotNull TargetedCommandLineBuilder commandLineBuilder, @NotNull String serviceName, @NotNull Supplier<String> getRegistryValue) {
        if (commandLineBuilder == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(33);
        }
        if (serviceName == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(34);
        }
        if (getRegistryValue == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(35);
        }
        String value = null;
        try {
            value = getRegistryValue.get();
        }
        catch (MissingResourceException e) {
            JSLanguageServiceQueue.Holder.LOGGER.info(e.getMessage(), (Throwable)e);
        }
        JSLanguageServiceUtil.addNodeProcessArguments(commandLineBuilder, serviceName, value);
    }

    @Nullable
    public static File getPluginDirectory(@NotNull Class<?> pluginClass, @NotNull String resourceName) {
        if (pluginClass == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(36);
        }
        if (resourceName == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(37);
        }
        return PluginPathManager.getPluginResource(pluginClass, (String)resourceName);
    }

    public static void addNodeProcessArguments(@NotNull TargetedCommandLineBuilder commandLineBuilder, @NotNull String serviceName, @Nullable String value) {
        if (commandLineBuilder == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(38);
        }
        if (serviceName == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(39);
        }
        if (!StringUtil.isEmptyOrSpaces((String)value)) {
            List params = ParametersListUtil.parse((String)value);
            params.forEach(arg_0 -> ((TargetedCommandLineBuilder)commandLineBuilder).addParameter(arg_0));
            JSLanguageServiceQueue.Holder.LOGGER.info(String.format("Language service %s will start with arguments '%s'", serviceName, value));
        }
    }

    public static <T> T nonBlockingReadActionWithTimeout(Supplier<T> computation) {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            return (T)ReadAction.compute(() -> computation.get());
        }
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            return computation.get();
        }
        Context context2 = Context.current();
        long startNs = System.nanoTime();
        long timeoutNs = JSLanguageServiceUtil.getModerateTimeoutNanos();
        Ref waitingSpan = new Ref((Object)JSLanguageServiceTracerUtilKt.serviceTraceSpanBuilder(JSLanguageServiceUtil.class, "waiting for ReadAction").startSpan());
        return (T)ReadAction.nonBlocking(() -> {
            ((Span)waitingSpan.get()).end();
            waitingSpan.set((Object)JSLanguageServiceTracerUtilKt.serviceTraceSpanBuilder(JSLanguageServiceUtil.class, "waiting for ReadAction").startSpan());
            try (Scope ignored = context2.makeCurrent();){
                Object t = computation.get();
                return t;
            }
        }).expireWhen(() -> System.nanoTime() - startNs > timeoutNs).executeSynchronously();
    }

    public static void showServiceStoppedOrRestartedNotification(@NotNull Project project, @NlsContexts.NotificationTitle @NotNull String title, @NlsContexts.NotificationContent @NotNull String content) {
        if (project == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(40);
        }
        if (title == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(41);
        }
        if (content == null) {
            JSLanguageServiceUtil.$$$reportNull$$$0(42);
        }
        NotificationGroupManager.getInstance().getNotificationGroup("language.service.stopped.or.restarted").createNotification(title, content, NotificationType.INFORMATION).notify(project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 16, 17, 21, 22, 23, 27, 29, 30 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageService";
                break;
            }
            case 3: 
            case 5: 
            case 12: 
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 27: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/service/JSLanguageServiceUtil";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 13: 
            case 18: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileContent";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetRun";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPathToRemotePathConverter";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remotePathToLocalPathConverter";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceBase";
                break;
            }
            case 31: 
            case 33: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLineBuilder";
                break;
            }
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getRegistryValue";
                break;
            }
            case 34: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceName";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginClass";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceName";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/service/JSLanguageServiceUtil";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageServiceCreationError";
                break;
            }
            case 16: 
            case 17: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "convertLineSeparatorsToFileOriginal";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginStarterDirectory";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createGson";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getGson";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setTimeout";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getTimeoutMessage";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "awaitLanguageService";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "languageServiceHasError";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageServiceCreationError";
                break;
            }
            case 8: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 27: 
            case 29: 
            case 30: {
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getElementInfo";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "normalizeNameAndPath";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "convertLineSeparatorsToFileOriginal";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createGson";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getGson";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "addNodePathFromRegistry";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "addNodeProcessArgumentsFromRegistry";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getPluginDirectory";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "addNodeProcessArguments";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "showServiceStoppedOrRestartedNotification";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 16, 17, 21, 22, 23, 27, 29, 30 -> new IllegalStateException(string);
        };
    }

    public static class PsiElementInfo {
        @Nullable
        private final PsiElement myElement;
        @Nullable
        private final TextRange myRange;

        public PsiElementInfo(@Nullable PsiElement element2, @Nullable TextRange range) {
            this.myElement = element2;
            this.myRange = range;
        }

        @Nullable
        public PsiElement getElement() {
            return this.myElement;
        }

        @Nullable
        public TextRange getRange() {
            return this.myRange;
        }
    }
}

