/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.zmq.protocol;

import java.io.Closeable;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty1;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.jupyter.protocol.RawMessageImpl;
import org.jetbrains.kotlinx.jupyter.protocol.RawMessageImplKt;
import org.jetbrains.kotlinx.jupyter.protocol.api.JsonExtensionsKt;
import org.jetbrains.kotlinx.jupyter.protocol.api.KernelLoggerFactory;
import org.jetbrains.kotlinx.jupyter.protocol.api.KernelLoggerFactoryKt;
import org.jetbrains.kotlinx.jupyter.protocol.api.RawMessage;
import org.jetbrains.kotlinx.jupyter.zmq.protocol.HMAC;
import org.jetbrains.kotlinx.jupyter.zmq.protocol.JupyterZmqSocket;
import org.jetbrains.kotlinx.jupyter.zmq.protocol.JupyterZmqSocketImplKt;
import org.jetbrains.kotlinx.jupyter.zmq.protocol.ZmqSocketData;
import org.jetbrains.kotlinx.jupyter.zmq.protocol.ZmqSocketWithCancellationImpl;
import org.jetbrains.kotlinx.jupyter.zmq.protocol.ZmqString;
import org.slf4j.Logger;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0016\u0010\u0015\u001a\u00020\u00102\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0016J\u001c\u0010\u0019\u001a\u00020\u00102\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00100\u001bH\u0016J\"\u0010\u001c\u001a\u00020\u00102\u0018\u0010\u001a\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u0017\u0012\u0004\u0012\u00020\u00100\u001bH\u0016J\u0018\u0010\u001d\u001a\u0004\u0018\u00010\u00142\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0016J\b\u0010\u001f\u001a\u00020\u0010H\u0016J\u0010\u0010 \u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlinx/jupyter/zmq/protocol/JupyterZmqSocketImpl;", "Ljava/io/Closeable;", "Lorg/jetbrains/kotlinx/jupyter/zmq/protocol/JupyterZmqSocket;", "loggerFactory", "Lorg/jetbrains/kotlinx/jupyter/protocol/api/KernelLoggerFactory;", "socketData", "Lorg/jetbrains/kotlinx/jupyter/zmq/protocol/ZmqSocketData;", "hmac", "Lorg/jetbrains/kotlinx/jupyter/zmq/protocol/HMAC;", "<init>", "(Lorg/jetbrains/kotlinx/jupyter/protocol/api/KernelLoggerFactory;Lorg/jetbrains/kotlinx/jupyter/zmq/protocol/ZmqSocketData;Lorg/jetbrains/kotlinx/jupyter/zmq/protocol/HMAC;)V", "logger", "Lorg/slf4j/Logger;", "zmqSocket", "Lorg/jetbrains/kotlinx/jupyter/zmq/protocol/ZmqSocketWithCancellationImpl;", "bind", "", "connect", "sendRawMessage", "msg", "Lorg/jetbrains/kotlinx/jupyter/protocol/api/RawMessage;", "sendBytes", "message", "", "", "onRawMessage", "callback", "Lkotlin/Function1;", "onBytesReceived", "convertToRawMessage", "zmqMessage", "close", "doSendRawMessage", "zmq-protocol"})
@SourceDebugExtension(value={"SMAP\nJupyterZmqSocketImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterZmqSocketImpl.kt\norg/jetbrains/kotlinx/jupyter/zmq/protocol/JupyterZmqSocketImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,176:1\n1563#2:177\n1634#2,3:178\n1563#2:181\n1634#2,3:182\n1563#2:185\n1634#2,2:186\n1636#2:190\n1#3:188\n205#4:189\n222#4:191\n*S KotlinDebug\n*F\n+ 1 JupyterZmqSocketImpl.kt\norg/jetbrains/kotlinx/jupyter/zmq/protocol/JupyterZmqSocketImpl\n*L\n87#1:177\n87#1:178,3\n104#1:181\n104#1:182,3\n127#1:185\n127#1:186,2\n127#1:190\n130#1:189\n95#1:191\n*E\n"})
public final class JupyterZmqSocketImpl
implements Closeable,
JupyterZmqSocket {
    @NotNull
    private final HMAC hmac;
    @NotNull
    private final Logger logger;
    @NotNull
    private final ZmqSocketWithCancellationImpl zmqSocket;

    public JupyterZmqSocketImpl(@NotNull KernelLoggerFactory loggerFactory, @NotNull ZmqSocketData socketData, @NotNull HMAC hmac) {
        Intrinsics.checkNotNullParameter((Object)loggerFactory, (String)"loggerFactory");
        Intrinsics.checkNotNullParameter((Object)socketData, (String)"socketData");
        Intrinsics.checkNotNullParameter((Object)hmac, (String)"hmac");
        this.hmac = hmac;
        this.logger = KernelLoggerFactoryKt.getLogger(loggerFactory, Reflection.getOrCreateKotlinClass(this.getClass()), socketData.getName());
        this.zmqSocket = new ZmqSocketWithCancellationImpl(loggerFactory, socketData);
    }

    @Override
    public void bind() {
        this.zmqSocket.bind();
    }

    @Override
    public void connect() {
        this.zmqSocket.connect();
    }

    @Override
    public void sendRawMessage(@NotNull RawMessage msg) {
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        this.doSendRawMessage(msg);
        this.logger.debug("snd>: {}", (Object)msg);
    }

    @Override
    public void sendBytes(@NotNull List<byte[]> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        this.zmqSocket.sendMultipart(message);
        this.logger.debug("snd bytes>: {} frames", (Object)message.size());
    }

    @Override
    public void onRawMessage(@NotNull Function1<? super RawMessage, Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.onBytesReceived((Function1<? super List<byte[]>, Unit>)((Function1)arg_0 -> JupyterZmqSocketImpl.onRawMessage$lambda$0(this, callback, arg_0)));
    }

    @Override
    public void onBytesReceived(@NotNull Function1<? super List<byte[]>, Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.zmqSocket.onReceive(callback);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public RawMessage convertToRawMessage(@NotNull List<byte[]> zmqMessage) {
        void $this$mapTo$iv$iv;
        Collection collection;
        List $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter(zmqMessage, (String)"zmqMessage");
        Iterator<byte[]> iter = zmqMessage.iterator();
        List zmqIdentities = SequencesKt.toList((Sequence)SequencesKt.takeWhile((Sequence)SequencesKt.generateSequence(() -> JupyterZmqSocketImpl.convertToRawMessage$lambda$0(iter)), JupyterZmqSocketImpl::convertToRawMessage$lambda$1));
        if (!iter.hasNext()) {
            return null;
        }
        String string = ZmqString.INSTANCE.getString(iter.next()).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String sig = string;
        Iterable $this$map$iv = JupyterZmqSocketImplKt.access$getMessagePartProperties$p();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            KProperty1 kProperty1 = (KProperty1)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(iter.next());
        }
        List blocks = (List)destination$iv$iv;
        String calculatedSig = this.hmac.invoke(blocks);
        if (!Intrinsics.areEqual((Object)sig, (Object)calculatedSig)) {
            throw new SignatureException("Invalid signature: expected " + calculatedSig + ", received " + sig + " for message " + zmqIdentities);
        }
        List $this$convertToRawMessage_u24lambda_u243 = $this$mapTo$iv$iv2 = CollectionsKt.createListBuilder();
        boolean bl = false;
        iter.forEachRemaining(arg_0 -> JupyterZmqSocketImpl.convertToRawMessage$lambda$3$1(arg_0 -> JupyterZmqSocketImpl.convertToRawMessage$lambda$3$0($this$convertToRawMessage_u24lambda_u243, arg_0), arg_0));
        List buffers = CollectionsKt.build((List)$this$mapTo$iv$iv2);
        Iterable $this$map$iv2 = blocks;
        boolean $i$f$map2 = false;
        Iterable iterable2 = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            byte[] byArray = (byte[])item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            JsonElement jsonElement = JupyterZmqSocketImpl.convertToRawMessage$parseJson((byte[])it);
            collection.add(jsonElement != null ? JsonElementKt.getJsonObject((JsonElement)jsonElement) : null);
        }
        List blockJsons = (List)destination$iv$iv2;
        JsonObject jsonObject = (JsonObject)blockJsons.get(0);
        if (jsonObject == null) {
            throw new IllegalStateException(("There is no header in the message. Data was read: " + blockJsons).toString());
        }
        JsonObject jsonObject2 = (JsonObject)blockJsons.get(1);
        JsonObject jsonObject3 = (JsonObject)blockJsons.get(2);
        JsonObject jsonObject4 = (JsonObject)blockJsons.get(3);
        if (jsonObject4 == null) {
            jsonObject4 = JsonExtensionsKt.getEMPTY((Json)Json.Default);
        }
        return new RawMessageImpl(zmqIdentities, jsonObject, jsonObject2, jsonObject3, (JsonElement)jsonObject4, buffers);
    }

    @Override
    public void close() {
        this.zmqSocket.close();
    }

    /*
     * Unable to fully structure code
     */
    private final void doSendRawMessage(RawMessage msg) {
        var3_3 = var2_2 = CollectionsKt.createListBuilder();
        var23_4 = this.zmqSocket;
        $i$a$-buildList-JupyterZmqSocketImpl$doSendRawMessage$1 = false;
        $this$doSendRawMessage_u24lambda_u240.addAll((Collection)msg.getZmqIdentities());
        $this$doSendRawMessage_u24lambda_u240.add(JupyterZmqSocketImplKt.access$getMESSAGE_DELIMITER$p());
        $this$map$iv = JupyterZmqSocketImplKt.access$getMessagePartProperties$p();
        $i$f$map = false;
        var7_8 = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            var12_13 = (KProperty1)item$iv$iv;
            var13_14 = destination$iv$iv;
            $i$a$-map-JupyterZmqSocketImpl$doSendRawMessage$1$signableMessage$1 = false;
            var15_16 = (JsonElement)prop.get((Object)msg);
            if (var15_16 == null) ** GOTO lbl-1000
            it = var15_16;
            $i$a$-let-JupyterZmqSocketImpl$doSendRawMessage$1$signableMessage$1$1 = false;
            var18_19 = RawMessageImplKt.getMessageFormat();
            value$iv = it;
            $i$f$encodeToString = false;
            this_$iv.getSerializersModule();
            var18_19 = this_$iv.encodeToString((SerializationStrategy)JsonElement.Companion.serializer(), (Object)value$iv);
            Intrinsics.checkNotNullExpressionValue((Object)var18_19.getBytes(Charsets.UTF_8), (String)"getBytes(...)");
            if (var21_22 != null) {
                v0 = var21_22;
            } else lbl-1000:
            // 2 sources

            {
                v0 = JupyterZmqSocketImplKt.access$getEmptyJsonObjectStringBytes$p();
            }
            var13_14.add(v0);
        }
        signableMessage = (List)destination$iv$iv;
        $this$doSendRawMessage_u24lambda_u240.add(ZmqString.INSTANCE.getBytes(this.hmac.invoke(signableMessage)));
        $this$doSendRawMessage_u24lambda_u240.addAll(signableMessage);
        $this$doSendRawMessage_u24lambda_u240.addAll((Collection)msg.getBuffers());
        var23_4.sendMultipart(CollectionsKt.build((List)var2_2));
    }

    private static final Unit onRawMessage$lambda$0(JupyterZmqSocketImpl this$0, Function1 $callback, List bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        RawMessage rawMessage = this$0.convertToRawMessage(bytes);
        if (rawMessage != null) {
            this$0.logger.debug(">rcv: {}", (Object)rawMessage);
            $callback.invoke((Object)rawMessage);
        }
        return Unit.INSTANCE;
    }

    private static final byte[] convertToRawMessage$lambda$0(Iterator $iter) {
        return $iter.hasNext() ? (byte[])$iter.next() : null;
    }

    private static final boolean convertToRawMessage$lambda$1(byte[] it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !Arrays.equals(it, JupyterZmqSocketImplKt.access$getMESSAGE_DELIMITER$p());
    }

    /*
     * WARNING - void declaration
     */
    private static final JsonElement convertToRawMessage$parseJson(byte[] $this$convertToRawMessage_u24parseJson) {
        void this_$iv;
        Json json = (Json)Json.Default;
        String string$iv = new String($this$convertToRawMessage_u24parseJson, Charsets.UTF_8);
        boolean $i$f$decodeFromString = false;
        this_$iv.getSerializersModule();
        JsonElement json2 = (JsonElement)this_$iv.decodeFromString((DeserializationStrategy)JsonElement.Companion.serializer(), string$iv);
        return json2 instanceof JsonObject && ((JsonObject)json2).isEmpty() ? null : json2;
    }

    private static final Unit convertToRawMessage$lambda$3$0(List $this_buildList, byte[] it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this_buildList.add(it);
        return Unit.INSTANCE;
    }

    private static final void convertToRawMessage$lambda$3$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

