/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import com.intellij.rt.jasper2.CompilerNotifier;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Map;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.ErrorDispatcher;
import org.apache.jasper.compiler.Node;
import org.apache.jasper.compiler.PageInfo;
import org.apache.jasper.servlet.JspServletWrapper;

public class CompilerWrapper
extends Compiler {
    private final Compiler myCompiler;
    private PageInfo myPageInfo;

    public CompilerWrapper(Compiler delegate) {
        this.myCompiler = delegate;
    }

    public void setPageInfo(PageInfo pageInfo) {
        if (pageInfo != null) {
            this.myPageInfo = pageInfo;
        }
    }

    public void setErrorDispatcher(ErrorDispatcher errorDispatcher) {
        this.myCompiler.errDispatcher = errorDispatcher;
    }

    public void init(JspCompilationContext ctxt, JspServletWrapper jsw) {
        this.myCompiler.init(ctxt, jsw);
    }

    public Node.Nodes getPageNodes() {
        return this.myCompiler.getPageNodes();
    }

    public String[] generateJava() throws Exception {
        return this.myCompiler.generateJava();
    }

    public void generateClass(String[] smap) throws Exception {
        this.myCompiler.generateClass(smap);
    }

    public void compile(boolean compileClass, boolean jspcMode) throws Exception {
        String jspFile = this.getCompilationContext().getJspFile();
        CompilerNotifier compilerNotifier = CompilerNotifier.getInstance();
        compilerNotifier.beforeCompile(jspFile);
        compilerNotifier.setCompilingFile(jspFile);
        int errorsBefore = compilerNotifier.getErrorCount();
        this.myCompiler.compile(compileClass, jspcMode);
        int errorsAfter = compilerNotifier.getErrorCount();
        if (errorsAfter == errorsBefore) {
            String classFilePath = this.getCompilationContext().getClassFileName();
            compilerNotifier.compiledOk(jspFile, classFilePath, CompilerWrapper.getPathsToIncludedFiles(this.myPageInfo));
        }
    }

    private static String[] getPathsToIncludedFiles(PageInfo pageInfo) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (pageInfo == null) {
            return new String[0];
        }
        Object dependants = pageInfo.getClass().getMethod("getDependants", new Class[0]).invoke((Object)pageInfo, new Object[0]);
        if (dependants instanceof Collection) {
            return ((Collection)dependants).toArray(new String[0]);
        }
        if (dependants instanceof Map) {
            return ((Map)dependants).keySet().toArray(new String[0]);
        }
        return new String[0];
    }

    public boolean isOutDated() {
        return true;
    }

    public boolean isOutDated(boolean checkClass) {
        return true;
    }

    public ErrorDispatcher getErrorDispatcher() {
        return this.myCompiler.getErrorDispatcher();
    }

    public PageInfo getPageInfo() {
        return this.myCompiler.getPageInfo();
    }

    public JspCompilationContext getCompilationContext() {
        return this.myCompiler.getCompilationContext();
    }

    public void removeGeneratedFiles() {
        this.myCompiler.removeGeneratedFiles();
    }

    public void removeGeneratedClassFiles() {
        this.myCompiler.removeGeneratedClassFiles();
    }
}

