/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.kryo5.serializers;

import com.esotericsoftware.kryo.kryo5.Kryo;
import com.esotericsoftware.kryo.kryo5.KryoException;
import com.esotericsoftware.kryo.kryo5.Serializer;
import com.esotericsoftware.kryo.kryo5.io.Input;
import com.esotericsoftware.kryo.kryo5.io.Output;
import com.esotericsoftware.kryo.kryo5.util.ObjectMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;

public class JavaSerializer
extends Serializer {
    public void write(Kryo kryo, Output output, Object object) {
        try {
            ObjectMap graphContext = kryo.getGraphContext();
            ObjectOutputStream objectStream = (ObjectOutputStream)graphContext.get(this);
            if (objectStream == null) {
                objectStream = new ObjectOutputStream(output);
                graphContext.put(this, objectStream);
            }
            objectStream.writeObject(object);
            objectStream.flush();
        }
        catch (Exception ex) {
            throw new KryoException("Error during Java serialization.", ex);
        }
    }

    public Object read(Kryo kryo, Input input, Class type) {
        try {
            ObjectMap graphContext = kryo.getGraphContext();
            ObjectInputStream objectStream = (ObjectInputStream)graphContext.get(this);
            if (objectStream == null) {
                objectStream = new ObjectInputStreamWithKryoClassLoader(input, kryo);
                graphContext.put(this, objectStream);
            }
            return objectStream.readObject();
        }
        catch (Exception ex) {
            throw new KryoException("Error during Java deserialization.", ex);
        }
    }

    private static class ObjectInputStreamWithKryoClassLoader
    extends ObjectInputStream {
        private final Kryo kryo;

        ObjectInputStreamWithKryoClassLoader(InputStream in, Kryo kryo) throws IOException {
            super(in);
            this.kryo = kryo;
        }

        protected Class resolveClass(ObjectStreamClass type) {
            try {
                return Class.forName(type.getName(), false, this.kryo.getClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {
                try {
                    return super.resolveClass(type);
                }
                catch (ClassNotFoundException ex) {
                    throw new KryoException("Class not found: " + type.getName(), ex);
                }
                catch (IOException ex) {
                    throw new KryoException("Could not load class: " + type.getName(), ex);
                }
            }
        }
    }
}

