/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.structureView;

import com.intellij.icons.AllIcons;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.swagger.core.SwaggerCoreIcons;
import com.intellij.swagger.core.meta.SwElementProvider;
import com.intellij.swagger.core.model.api.SwDefinition;
import com.intellij.swagger.core.model.api.SwHttpOperation;
import com.intellij.swagger.core.model.api.SwModelElement;
import com.intellij.swagger.core.model.api.SwSyntheticContainer;
import com.intellij.swagger.core.model.api.SwUrl;
import com.intellij.swagger.core.model.specification.SpecificationParameter;
import com.intellij.swagger.core.model.specification.SwSpecificationFile;
import com.intellij.swagger.core.model.specification.openapi.v3.Openapi3Callback;
import com.intellij.swagger.core.model.specification.openapi.v3.Openapi3Example;
import com.intellij.swagger.core.model.specification.openapi.v3.Openapi3Header;
import com.intellij.swagger.core.model.specification.openapi.v3.Openapi3Link;
import com.intellij.swagger.core.model.specification.openapi.v3.Openapi3RequestBody;
import com.intellij.swagger.core.model.specification.openapi.v3.Openapi3SecuritySchema;
import com.intellij.swagger.core.structureView.OpenapiStructureViewKt;
import com.intellij.swagger.core.traverser.SpecificationTraverser;
import java.util.Collection;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0013\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00010\rH\u0016\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\b\u0010\u0013\u001a\u00020\u0005H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0017H\u0016J\b\u0010\u0019\u001a\u00020\u0017H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lcom/intellij/swagger/core/structureView/OpenapiStructureViewElement;", "Lcom/intellij/ide/structureView/StructureViewTreeElement;", "modelElement", "Lcom/intellij/swagger/core/model/api/SwModelElement;", "sourcePsi", "Lcom/intellij/psi/PsiElement;", "<init>", "(Lcom/intellij/swagger/core/model/api/SwModelElement;Lcom/intellij/psi/PsiElement;)V", "getModelElement", "()Lcom/intellij/swagger/core/model/api/SwModelElement;", "getSourcePsi", "()Lcom/intellij/psi/PsiElement;", "getChildren", "", "()[Lcom/intellij/ide/structureView/StructureViewTreeElement;", "getPresentation", "Lcom/intellij/navigation/ItemPresentation;", "getTextAttributesFor", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "getValue", "navigate", "", "requestFocus", "", "canNavigate", "canNavigateToSource", "intellij.swagger.core"})
@SourceDebugExtension(value={"SMAP\nOpenapiStructureView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenapiStructureView.kt\ncom/intellij/swagger/core/structureView/OpenapiStructureViewElement\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,178:1\n37#2,2:179\n*S KotlinDebug\n*F\n+ 1 OpenapiStructureView.kt\ncom/intellij/swagger/core/structureView/OpenapiStructureViewElement\n*L\n80#1:179,2\n*E\n"})
final class OpenapiStructureViewElement
implements StructureViewTreeElement {
    @NotNull
    private final SwModelElement modelElement;
    @NotNull
    private final PsiElement sourcePsi;

    public OpenapiStructureViewElement(@NotNull SwModelElement modelElement, @NotNull PsiElement sourcePsi) {
        Intrinsics.checkNotNullParameter((Object)modelElement, (String)"modelElement");
        Intrinsics.checkNotNullParameter((Object)sourcePsi, (String)"sourcePsi");
        this.modelElement = modelElement;
        this.sourcePsi = sourcePsi;
    }

    @NotNull
    public final SwModelElement getModelElement() {
        return this.modelElement;
    }

    @NotNull
    public final PsiElement getSourcePsi() {
        return this.sourcePsi;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public StructureViewTreeElement[] getChildren() {
        StructureViewTreeElement[] structureViewTreeElementArray;
        SpecificationTraverser $this$getChildren_u24lambda_u240 = OpenapiStructureViewKt.access$traverser(this);
        boolean bl = false;
        PsiElement psiElement = this.sourcePsi;
        PsiElement psiElement2 = psiElement instanceof PsiFile ? $this$getChildren_u24lambda_u240.getTopLevelValueOf((PsiFile)this.sourcePsi) : (psiElement instanceof PsiNamedElement ? $this$getChildren_u24lambda_u240.getValueIfKeyValue(this.sourcePsi) : null);
        if (psiElement2 == null) {
            structureViewTreeElementArray = new StructureViewTreeElement[]{};
        } else {
            void $this$toTypedArray$iv;
            PsiElement substitutedElement = psiElement2;
            Collection collection = SequencesKt.toList((Sequence)SequencesKt.mapNotNull($this$getChildren_u24lambda_u240.findByPathAndExpand(substitutedElement, new String[0]), OpenapiStructureViewElement::getChildren$lambda$0$0));
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            structureViewTreeElementArray = thisCollection$iv.toArray(new StructureViewTreeElement[0]);
        }
        return structureViewTreeElementArray;
    }

    @NotNull
    public ItemPresentation getPresentation() {
        ItemPresentation itemPresentation;
        SwModelElement swModelElement = this.modelElement;
        if (swModelElement instanceof SwSpecificationFile) {
            PsiFile psiFile = ((SwSpecificationFile)this.modelElement).getSourcePsi();
            itemPresentation = OpenapiStructureViewKt.createItemPresentation$default(((SwSpecificationFile)this.modelElement).getSpecificationType().getPresentableName(), psiFile != null ? psiFile.getName() : null, ((SwSpecificationFile)this.modelElement).getSpecificationType().getIcon(), null, 8, null);
        } else if (swModelElement instanceof SwUrl) {
            itemPresentation = OpenapiStructureViewKt.createItemPresentation$default(((SwUrl)this.modelElement).getUrlString(), null, AllIcons.Nodes.PpWeb, null, 8, null);
        } else if (swModelElement instanceof SwHttpOperation) {
            String string = ((SwHttpOperation)this.modelElement).getHttpMethod().getValue();
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string2 = string.toUpperCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
            itemPresentation = OpenapiStructureViewKt.access$createItemPresentation(string2, ((SwHttpOperation)this.modelElement).getDescription().getValue(), SwaggerCoreIcons.Endpoint, this.getTextAttributesFor(this.modelElement));
        } else {
            itemPresentation = swModelElement instanceof SpecificationParameter ? OpenapiStructureViewKt.createItemPresentation$default(((SpecificationParameter)this.modelElement).getParameterName().getValue(), ((SpecificationParameter)this.modelElement).getDescription().getValue(), SwaggerCoreIcons.Entity, null, 8, null) : (swModelElement instanceof Openapi3RequestBody ? OpenapiStructureViewKt.createItemPresentation$default(((Openapi3RequestBody)this.modelElement).getName().getValue(), ((Openapi3RequestBody)this.modelElement).getDescription().getValue(), SwaggerCoreIcons.Entity, null, 8, null) : (swModelElement instanceof Openapi3Callback ? OpenapiStructureViewKt.createItemPresentation$default(((Openapi3Callback)this.modelElement).getName().getValue(), null, SwaggerCoreIcons.Entity, null, 8, null) : (swModelElement instanceof Openapi3Example ? OpenapiStructureViewKt.createItemPresentation$default(((Openapi3Example)this.modelElement).getName().getValue(), ((Openapi3Example)this.modelElement).getDescription().getValue(), SwaggerCoreIcons.Entity, null, 8, null) : (swModelElement instanceof Openapi3Header ? OpenapiStructureViewKt.createItemPresentation$default(((Openapi3Header)this.modelElement).getName().getValue(), ((Openapi3Header)this.modelElement).getDescription().getValue(), SwaggerCoreIcons.Entity, null, 8, null) : (swModelElement instanceof Openapi3Link ? OpenapiStructureViewKt.createItemPresentation$default(((Openapi3Link)this.modelElement).getName().getValue(), ((Openapi3Link)this.modelElement).getDescription().getValue(), SwaggerCoreIcons.Entity, null, 8, null) : (swModelElement instanceof Openapi3SecuritySchema ? OpenapiStructureViewKt.createItemPresentation$default(((Openapi3SecuritySchema)this.modelElement).getName().getValue(), ((Openapi3SecuritySchema)this.modelElement).getType().getValue(), AllIcons.Nodes.SecurityRole, null, 8, null) : (swModelElement instanceof SwDefinition ? OpenapiStructureViewKt.createItemPresentation$default(((SwDefinition)this.modelElement).getName().getValue(), ((SwDefinition)this.modelElement).getDescription().getValue(), SwaggerCoreIcons.Entity, null, 8, null) : (swModelElement instanceof SwSyntheticContainer ? OpenapiStructureViewKt.access$createCategoryPresentation((SwSyntheticContainer)this.modelElement) : OpenapiStructureViewKt.createItemPresentation$default(this.sourcePsi.toString(), null, null, null, 14, null)))))))));
        }
        return itemPresentation;
    }

    private final TextAttributesKey getTextAttributesFor(SwModelElement modelElement) {
        return modelElement instanceof SwHttpOperation && ((SwHttpOperation)modelElement).isDeprecated().getValue() != false ? CodeInsightColors.DEPRECATED_ATTRIBUTES : null;
    }

    @NotNull
    public PsiElement getValue() {
        return this.sourcePsi;
    }

    public void navigate(boolean requestFocus) {
        block0: {
            PsiElement psiElement = this.sourcePsi;
            Navigatable navigatable = psiElement instanceof Navigatable ? (Navigatable)psiElement : null;
            if (navigatable == null) break block0;
            navigatable.navigate(requestFocus);
        }
    }

    public boolean canNavigate() {
        PsiElement psiElement = this.sourcePsi;
        Navigatable navigatable = psiElement instanceof Navigatable ? (Navigatable)psiElement : null;
        return navigatable != null ? navigatable.canNavigate() : false;
    }

    public boolean canNavigateToSource() {
        PsiElement psiElement = this.sourcePsi;
        Navigatable navigatable = psiElement instanceof Navigatable ? (Navigatable)psiElement : null;
        return navigatable != null ? navigatable.canNavigateToSource() : false;
    }

    private static final OpenapiStructureViewElement getChildren$lambda$0$0(PsiElement childPsiElement) {
        Intrinsics.checkNotNullParameter((Object)childPsiElement, (String)"childPsiElement");
        SwModelElement childModelElement = SwElementProvider.INSTANCE.getModelElement(childPsiElement);
        return childModelElement != null && OpenapiStructureViewKt.access$needShowElementInStructure(childModelElement) ? new OpenapiStructureViewElement(childModelElement, childPsiElement) : null;
    }
}

