/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.handler;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiUtil;
import de.plushnikov.intellij.plugin.util.LombokProcessorUtil;
import de.plushnikov.intellij.plugin.util.PsiAnnotationSearchUtil;
import de.plushnikov.intellij.plugin.util.PsiAnnotationUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseLombokHandler
implements CodeInsightActionHandler {
    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        PsiClass psiClass;
        if (project == null) {
            BaseLombokHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            BaseLombokHandler.$$$reportNull$$$0(1);
        }
        if (psiFile == null) {
            BaseLombokHandler.$$$reportNull$$$0(2);
        }
        if (psiFile.isWritable() && null != (psiClass = OverrideImplementUtil.getContextClass((Project)project, (Editor)editor, (PsiFile)psiFile, (boolean)false))) {
            this.processClass(psiClass);
            UndoUtil.markPsiFileForUndo((PsiFile)psiFile);
        }
    }

    protected abstract void processClass(@NotNull PsiClass var1);

    protected static void processIntern(@NotNull Map<PsiField, PsiMethod> fieldMethodMap, @NotNull PsiClass psiClass, String annotationClassName) {
        boolean useAnnotationOnClass;
        if (fieldMethodMap == null) {
            BaseLombokHandler.$$$reportNull$$$0(3);
        }
        if (psiClass == null) {
            BaseLombokHandler.$$$reportNull$$$0(4);
        }
        if (fieldMethodMap.isEmpty()) {
            return;
        }
        PsiMethod firstPropertyMethod = fieldMethodMap.values().iterator().next();
        boolean bl = useAnnotationOnClass = BaseLombokHandler.haveAllMethodsSameAccessLevel(fieldMethodMap.values()) && BaseLombokHandler.isNotAnnotatedWithOrSameAccessLevelAs(psiClass, firstPropertyMethod, annotationClassName);
        if (useAnnotationOnClass) {
            BaseLombokHandler.addAnnotation((PsiModifierListOwner)psiClass, (PsiModifierListOwner)firstPropertyMethod, annotationClassName);
        }
        for (Map.Entry<PsiField, PsiMethod> fieldMethodEntry : fieldMethodMap.entrySet()) {
            PsiField propertyField = fieldMethodEntry.getKey();
            PsiMethod propertyMethod = fieldMethodEntry.getValue();
            if (null == propertyField) continue;
            boolean isStatic = propertyField.hasModifierProperty("static");
            if (isStatic || !useAnnotationOnClass) {
                BaseLombokHandler.addAnnotation((PsiModifierListOwner)propertyField, (PsiModifierListOwner)propertyMethod, annotationClassName);
            }
            for (PsiAnnotation psiMethodAnnotation : propertyMethod.getModifierList().getAnnotations()) {
                psiClass.addBefore((PsiElement)psiMethodAnnotation, (PsiElement)propertyField);
            }
            propertyMethod.delete();
        }
    }

    private static boolean isNotAnnotatedWithOrSameAccessLevelAs(PsiClass psiClass, PsiMethod firstPropertyMethod, String annotationClassName) {
        PsiAnnotation presentAnnotation = PsiAnnotationSearchUtil.findAnnotation((PsiModifierListOwner)psiClass, annotationClassName);
        if (null != presentAnnotation) {
            String presentAccessModifier = LombokProcessorUtil.getMethodModifier(presentAnnotation);
            String currentAccessModifier = PsiUtil.getAccessModifier((int)PsiUtil.getAccessLevel((PsiModifierList)firstPropertyMethod.getModifierList()));
            return presentAccessModifier != null && presentAccessModifier.equals(currentAccessModifier);
        }
        return true;
    }

    private static boolean haveAllMethodsSameAccessLevel(Collection<PsiMethod> psiMethods) {
        HashSet<Integer> accessLevelSet = new HashSet<Integer>();
        for (PsiMethod psiMethod : psiMethods) {
            accessLevelSet.add(PsiUtil.getAccessLevel((PsiModifierList)psiMethod.getModifierList()));
        }
        return accessLevelSet.size() <= 1;
    }

    private static void addAnnotation(@NotNull PsiModifierListOwner targetElement, @NotNull PsiModifierListOwner sourceElement, String annotationClassName) {
        if (targetElement == null) {
            BaseLombokHandler.$$$reportNull$$$0(5);
        }
        if (sourceElement == null) {
            BaseLombokHandler.$$$reportNull$$$0(6);
        }
        PsiAnnotation newPsiAnnotation = LombokProcessorUtil.createAnnotationWithAccessLevel(sourceElement, annotationClassName);
        BaseLombokHandler.addAnnotation(targetElement, newPsiAnnotation, annotationClassName);
    }

    protected static void addAnnotation(@NotNull PsiClass targetElement, String annotationClassName) {
        if (targetElement == null) {
            BaseLombokHandler.$$$reportNull$$$0(7);
        }
        PsiAnnotation newPsiAnnotation = PsiAnnotationUtil.createPsiAnnotation((PsiModifierListOwner)targetElement, annotationClassName);
        BaseLombokHandler.addAnnotation((PsiModifierListOwner)targetElement, newPsiAnnotation, annotationClassName);
    }

    private static void addAnnotation(@NotNull PsiModifierListOwner targetElement, @NotNull PsiAnnotation newPsiAnnotation, String annotationClassName) {
        if (targetElement == null) {
            BaseLombokHandler.$$$reportNull$$$0(8);
        }
        if (newPsiAnnotation == null) {
            BaseLombokHandler.$$$reportNull$$$0(9);
        }
        PsiAnnotation presentAnnotation = PsiAnnotationSearchUtil.findAnnotation(targetElement, annotationClassName);
        Project project = targetElement.getProject();
        JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
        javaCodeStyleManager.shortenClassReferences((PsiElement)newPsiAnnotation);
        if (null == presentAnnotation) {
            PsiModifierList modifierList = targetElement.getModifierList();
            if (null != modifierList) {
                modifierList.addAfter((PsiElement)newPsiAnnotation, null);
            }
        } else {
            presentAnnotation.setDeclaredAttributeValue("value", newPsiAnnotation.findDeclaredAttributeValue("value"));
        }
    }

    protected void removeDefaultAnnotation(@NotNull PsiModifierListOwner targetElement, String annotationClassName) {
        PsiAnnotation psiAnnotation;
        if (targetElement == null) {
            BaseLombokHandler.$$$reportNull$$$0(10);
        }
        if (null != (psiAnnotation = PsiAnnotationSearchUtil.findAnnotation(targetElement, annotationClassName))) {
            boolean hasOnlyDefaultValues = true;
            PsiAnnotationParameterList psiAnnotationParameterList = psiAnnotation.getParameterList();
            for (PsiNameValuePair nameValuePair : psiAnnotationParameterList.getAttributes()) {
                if (null == psiAnnotation.findDeclaredAttributeValue(nameValuePair.getName())) continue;
                hasOnlyDefaultValues = false;
                break;
            }
            if (hasOnlyDefaultValues) {
                psiAnnotation.delete();
            }
        }
    }

    @Nullable
    protected PsiMethod findPublicNonStaticMethod(@NotNull PsiClass psiClass, @NotNull String methodName, @NotNull PsiType returnType, PsiType ... params) {
        PsiMethod[] toStringMethods;
        if (psiClass == null) {
            BaseLombokHandler.$$$reportNull$$$0(11);
        }
        if (methodName == null) {
            BaseLombokHandler.$$$reportNull$$$0(12);
        }
        if (returnType == null) {
            BaseLombokHandler.$$$reportNull$$$0(13);
        }
        for (PsiMethod method : toStringMethods = psiClass.findMethodsByName(methodName, false)) {
            int paramsCount;
            PsiParameterList parameterList;
            PsiParameter[] psiParameters;
            if (!method.hasModifierProperty("public") || method.hasModifierProperty("static") || !returnType.equals(method.getReturnType()) || (psiParameters = (parameterList = method.getParameterList()).getParameters()).length != (paramsCount = params.length)) continue;
            boolean allParametersFound = true;
            for (int i = 0; i < paramsCount; ++i) {
                if (psiParameters[i].getType().equals(params[i])) continue;
                allParametersFound = false;
                break;
            }
            if (!allParametersFound) continue;
            return method;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldMethodMap";
                break;
            }
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newPsiAnnotation";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnType";
                break;
            }
        }
        objectArray2[1] = "de/plushnikov/intellij/plugin/handler/BaseLombokHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "processIntern";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "addAnnotation";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "removeDefaultAnnotation";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "findPublicNonStaticMethod";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

