/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.processor;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import de.plushnikov.intellij.plugin.problem.LombokProblem;
import de.plushnikov.intellij.plugin.problem.ProblemSink;
import de.plushnikov.intellij.plugin.problem.ProblemValidationSink;
import de.plushnikov.intellij.plugin.processor.AbstractProcessor;
import de.plushnikov.intellij.plugin.quickfix.PsiQuickFixFactory;
import de.plushnikov.intellij.plugin.util.PsiAnnotationUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class SynchronizedProcessor
extends AbstractProcessor {
    public SynchronizedProcessor() {
        super(PsiElement.class, "lombok.Synchronized");
    }

    @Override
    @NotNull
    public Collection<PsiAnnotation> collectProcessedAnnotations(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            SynchronizedProcessor.$$$reportNull$$$0(0);
        }
        List<PsiAnnotation> list = Collections.emptyList();
        if (list == null) {
            SynchronizedProcessor.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    @NotNull
    public Collection<LombokProblem> verifyAnnotation(@NotNull PsiAnnotation psiAnnotation) {
        PsiClass containingClass;
        if (psiAnnotation == null) {
            SynchronizedProcessor.$$$reportNull$$$0(2);
        }
        ProblemValidationSink problemBuilder = new ProblemValidationSink();
        PsiMethod psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)psiAnnotation, PsiMethod.class);
        if (null != psiMethod && null != (containingClass = psiMethod.getContainingClass())) {
            if (containingClass.isAnnotationType() || containingClass.isInterface() || containingClass.isRecord()) {
                problemBuilder.addErrorMessage("inspection.message.synchronized.legal.only.on.methods.in.classes.enums", new Object[0]);
            } else if (psiMethod.hasModifierProperty("abstract")) {
                problemBuilder.addErrorMessage("inspection.message.synchronized.legal.only.on.concrete.methods", new Object[0]).withLocalQuickFixes(() -> PsiQuickFixFactory.createModifierListFix((PsiModifierListOwner)psiMethod, "abstract", false, false));
            } else {
                SynchronizedProcessor.validateReferencedField(problemBuilder, psiAnnotation, psiMethod, containingClass);
            }
        }
        Set<LombokProblem> set = problemBuilder.getProblems();
        if (set == null) {
            SynchronizedProcessor.$$$reportNull$$$0(3);
        }
        return set;
    }

    private static void validateReferencedField(@NotNull ProblemSink problemNewBuilder, @NotNull PsiAnnotation psiAnnotation, @NotNull PsiMethod psiMethod, @NotNull PsiClass containingClass) {
        String lockFieldName;
        if (problemNewBuilder == null) {
            SynchronizedProcessor.$$$reportNull$$$0(4);
        }
        if (psiAnnotation == null) {
            SynchronizedProcessor.$$$reportNull$$$0(5);
        }
        if (psiMethod == null) {
            SynchronizedProcessor.$$$reportNull$$$0(6);
        }
        if (containingClass == null) {
            SynchronizedProcessor.$$$reportNull$$$0(7);
        }
        if (StringUtil.isNotEmpty((String)(lockFieldName = PsiAnnotationUtil.getStringAnnotationValue(psiAnnotation, "value", "")))) {
            boolean isStatic = psiMethod.hasModifierProperty("static");
            PsiField lockField = containingClass.findFieldByName(lockFieldName, true);
            if (null != lockField) {
                if (isStatic && !lockField.hasModifierProperty("static")) {
                    problemNewBuilder.addErrorMessage("inspection.message.synchronized.field.is.not.static", lockFieldName).withLocalQuickFixes(() -> PsiQuickFixFactory.createModifierListFix((PsiModifierListOwner)lockField, "static", true, false));
                }
            } else {
                PsiClassType javaLangObjectType = PsiType.getJavaLangObject((PsiManager)containingClass.getManager(), (GlobalSearchScope)containingClass.getResolveScope());
                String[] modifiers = isStatic ? new String[]{"private", "final", "static"} : new String[]{"private", "final"};
                problemNewBuilder.addErrorMessage("inspection.message.field.s.does.not.exist", lockFieldName).withLocalQuickFixes(() -> PsiQuickFixFactory.createNewFieldFix(containingClass, lockFieldName, (PsiType)javaLangObjectType, "new Object()", modifiers));
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/processor/SynchronizedProcessor";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemNewBuilder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/processor/SynchronizedProcessor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "collectProcessedAnnotations";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "verifyAnnotation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectProcessedAnnotations";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "verifyAnnotation";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "validateReferencedField";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3 -> new IllegalStateException(string);
        };
    }
}

