/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.xslt.validation;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.SmartList;
import java.util.List;
import org.intellij.lang.xpath.XPathFile;
import org.intellij.lang.xpath.xslt.XsltSupport;
import org.intellij.plugins.xpathView.XPathBundle;
import org.jetbrains.annotations.NotNull;

public class XsltXmlAnnotator
extends XmlElementVisitor
implements Annotator,
DumbAware {
    private AnnotationHolder myHolder;

    public void annotate(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        if (psiElement == null) {
            XsltXmlAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            XsltXmlAnnotator.$$$reportNull$$$0(1);
        }
        try {
            this.myHolder = holder;
            psiElement.accept((PsiElementVisitor)this);
        }
        finally {
            this.myHolder = null;
        }
    }

    public void visitXmlAttributeValue(@NotNull XmlAttributeValue value) {
        PsiElement parent;
        if (value == null) {
            XsltXmlAnnotator.$$$reportNull$$$0(2);
        }
        if ((parent = value.getParent()) instanceof XmlAttribute) {
            List<Integer> singleBraces;
            if (!XsltSupport.isXsltFile(parent.getContainingFile())) {
                return;
            }
            String s = value.getValue();
            if (s.isEmpty()) {
                if (XsltSupport.isXPathAttribute((XmlAttribute)parent)) {
                    InjectedLanguageManager.getInstance((Project)value.getProject()).enumerate((PsiElement)value, (injectedPsi, places) -> {
                        if (injectedPsi instanceof XPathFile && injectedPsi.getTextLength() == 0) {
                            this.myHolder.newAnnotation(HighlightSeverity.ERROR, XPathBundle.message("annotator.error.empty.xpath.expression", new Object[0])).range((PsiElement)value).create();
                        }
                    });
                }
            } else if (XsltSupport.mayBeAVT((XmlAttribute)parent) && (singleBraces = XsltXmlAnnotator.collectClosingBraceOffsets(s)) != null) {
                InjectedLanguageManager.getInstance((Project)value.getProject()).enumerate((PsiElement)value, (injectedPsi, places) -> {
                    if (injectedPsi instanceof XPathFile) {
                        for (PsiLanguageInjectionHost.Shred place : places) {
                            TextRange range = place.getRangeInsideHost();
                            singleBraces.removeIf(arg_0 -> ((TextRange)range).contains(arg_0));
                        }
                    }
                });
                String message = XPathBundle.message("annotator.error.invalid.single.closing.brace.escape.as.double.closing.brace", new Object[0]);
                for (Integer brace : singleBraces) {
                    this.myHolder.newAnnotation(HighlightSeverity.ERROR, message).range(TextRange.from((int)(value.getTextOffset() + brace), (int)1)).create();
                }
            }
        }
        super.visitXmlAttributeValue(value);
    }

    private static List<Integer> collectClosingBraceOffsets(String s) {
        SmartList singleBraces = null;
        int i = -1;
        while ((i = XsltXmlAnnotator.getAVTEndOffset(s, i)) != -1) {
            if (singleBraces == null) {
                singleBraces = new SmartList();
            }
            if (i != 0 && s.charAt(i - 1) == '{') continue;
            singleBraces.add(i);
        }
        return singleBraces;
    }

    private static int getAVTEndOffset(String value, int i) {
        while ((i = value.indexOf(125, i + 1)) != -1 && i == value.indexOf("}}", i)) {
            i += 2;
        }
        return i;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        objectArray2[1] = "org/intellij/lang/xpath/xslt/validation/XsltXmlAnnotator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "annotate";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitXmlAttributeValue";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

