/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xpathView.ui;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.ui.EditorTextField;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import org.intellij.plugins.xpathView.ui.Expression;
import org.jetbrains.annotations.NotNull;

public class ExpressionCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private final Project project;
    private Document myDocument;
    private Expression myExpression;

    public ExpressionCellEditor(Project project) {
        this.project = project;
    }

    @Override
    public Component getTableCellEditorComponent(JTable ttable, Object value, boolean isSelected, int row, int col) {
        this.myExpression = (Expression)value;
        this.myDocument = PsiDocumentManager.getInstance((Project)this.project).getDocument(this.myExpression.getFile());
        return new EditorTextField(this.myDocument, this.project, (FileType)this.myExpression.getFileType()){

            protected boolean shouldHaveBorder() {
                return false;
            }

            protected void onEditorAdded(@NotNull Editor editor) {
                if (editor == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.onEditorAdded(editor);
                Runnable runnable = () -> {
                    Editor e = this.getEditor();
                    if (e != null) {
                        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)e.getContentComponent(), true));
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "org/intellij/plugins/xpathView/ui/ExpressionCellEditor$1", "onEditorAdded"));
            }
        };
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        if (eventObject instanceof MouseEvent) {
            return ((MouseEvent)eventObject).getClickCount() >= 2;
        }
        return super.isCellEditable(eventObject);
    }

    @Override
    public Expression getCellEditorValue() {
        return this.myExpression;
    }

    @Override
    public boolean stopCellEditing() {
        super.stopCellEditing();
        PsiDocumentManager.getInstance((Project)this.project).commitDocument(this.myDocument);
        return true;
    }
}

