/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.highlighting;

import com.intellij.cdi.beans.AbstractCdiBeanDescriptor;
import com.intellij.cdi.beans.CdiBeanDescriptor;
import com.intellij.cdi.beans.CdiCustomizationManager;
import com.intellij.cdi.beans.InjectionPointDescriptor;
import com.intellij.cdi.highlighting.CdiInjectionGeneratorHelperKt;
import com.intellij.cdi.manager.CdiDescriptorsFactory;
import com.intellij.cdi.manager.CdiManager;
import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.cdi.utils.CdiInjectionUtils;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.java.ultimate.icons.JavaUltimateIcons;
import com.intellij.javaee.constants.CdiAnnoConstants;
import com.intellij.javaee.utils.JavaeeClass;
import com.intellij.javaee.utils.JavaeeType;
import com.intellij.lang.jvm.JvmAnnotation;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.lang.jvm.actions.AnnotationAttributeRequest;
import com.intellij.lang.jvm.actions.AnnotationRequest;
import com.intellij.lang.jvm.actions.AnnotationRequestsKt;
import com.intellij.microservices.jvm.inject.FieldInjectionGenerator;
import com.intellij.microservices.jvm.inject.InjectionConstructorHandler;
import com.intellij.microservices.jvm.inject.InjectionDescriptor;
import com.intellij.microservices.jvm.inject.InjectionGenerator;
import com.intellij.microservices.jvm.inject.InjectionGeneratorContext;
import com.intellij.microservices.jvm.inject.InjectionGeneratorHelper;
import com.intellij.microservices.jvm.inject.InjectionType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedMembersSearch;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b \u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u000245B-\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0002H\u0014J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0011\u001a\u00020\u0002H\u0014J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0011\u001a\u00020\u0002H\u0014J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0011\u001a\u00020\u0002H\u0014J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\u0016\u0010\u001a\u001a\u0004\u0018\u00010\u00072\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u001cH\u0002J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001e\u001a\u00020\u0005H\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u0011\u001a\u00020\u0002H\u0014J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0014J\u0010\u0010%\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0014J\u0016\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00020'2\u0006\u0010(\u001a\u00020\u0007H\u0014J\b\u0010)\u001a\u00020*H\u0002J\u0016\u0010+\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001c2\u0006\u0010,\u001a\u00020-H\u0002J\u001a\u0010.\u001a\b\u0012\u0004\u0012\u00020/0'2\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u001cH\u0002J\u001a\u00100\u001a\u0004\u0018\u0001012\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\b\u00102\u001a\u000203H\u0014R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/intellij/cdi/highlighting/CdiInjectionGeneratorHelper;", "Lcom/intellij/microservices/jvm/inject/InjectionGeneratorHelper;", "Lcom/intellij/cdi/highlighting/CdiInjectionGeneratorHelper$CidBeanDescriptorWrapper;", "elementPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lcom/intellij/psi/PsiElement;", "name", "", "context", "Lcom/intellij/microservices/jvm/inject/InjectionGeneratorContext;", "module", "Lcom/intellij/openapi/module/Module;", "<init>", "(Lcom/intellij/psi/SmartPsiElementPointer;Ljava/lang/String;Lcom/intellij/microservices/jvm/inject/InjectionGeneratorContext;Lcom/intellij/openapi/module/Module;)V", "javaeeType", "Lcom/intellij/javaee/utils/JavaeeType;", "getBeanName", "bean", "getBeanLocation", "getBeanIdentifyingPsiElement", "getBeanType", "Lcom/intellij/psi/PsiType;", "injectionGenerator", "Lcom/intellij/microservices/jvm/inject/InjectionGenerator;", "type", "Lcom/intellij/microservices/jvm/inject/InjectionType;", "getAlias", "descriptor", "Lcom/intellij/cdi/beans/AbstractCdiBeanDescriptor;", "getElementName", "psiElement", "getBeanIcon", "Ljavax/swing/Icon;", "hasFieldInjection", "", "uClass", "Lorg/jetbrains/uast/UClass;", "hasSetterInjection", "findMatchingBeans", "", "prefix", "checkType", "", "getDescriptor", "member", "Lcom/intellij/psi/PsiMember;", "getQualifiers", "Lcom/intellij/lang/jvm/actions/AnnotationRequest;", "getBeanDescriptor", "Lcom/intellij/microservices/jvm/inject/InjectionDescriptor;", "getConstructorHandler", "Lcom/intellij/microservices/jvm/inject/InjectionConstructorHandler;", "CidBeanDescriptorWrapper", "CdiConstructorHandler", "intellij.javaee.cdi"})
@SourceDebugExtension(value={"SMAP\nCdiInjectionGeneratorHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CdiInjectionGeneratorHelper.kt\ncom/intellij/cdi/highlighting/CdiInjectionGeneratorHelper\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,245:1\n126#2:246\n153#2,3:247\n126#2:250\n153#2,3:251\n1563#3:254\n1634#3,3:255\n1617#3,9:258\n1869#3:267\n1870#3:269\n1626#3:270\n1#4:268\n*S KotlinDebug\n*F\n+ 1 CdiInjectionGeneratorHelper.kt\ncom/intellij/cdi/highlighting/CdiInjectionGeneratorHelper\n*L\n161#1:246\n161#1:247,3\n168#1:250\n168#1:251,3\n181#1:254\n181#1:255,3\n199#1:258,9\n199#1:267\n199#1:269\n199#1:270\n199#1:268\n*E\n"})
public abstract class CdiInjectionGeneratorHelper
extends InjectionGeneratorHelper<CidBeanDescriptorWrapper> {
    @NotNull
    private final Module module;
    @NotNull
    private JavaeeType javaeeType;

    public CdiInjectionGeneratorHelper(@NotNull SmartPsiElementPointer<PsiElement> elementPointer, @NotNull String name, @NotNull InjectionGeneratorContext context, @NotNull Module module) {
        Intrinsics.checkNotNullParameter(elementPointer, (String)"elementPointer");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        super(elementPointer, name, context);
        this.module = module;
        this.javaeeType = JavaeeType.JAKARTA;
    }

    @NotNull
    protected String getBeanName(@NotNull CidBeanDescriptorWrapper bean) {
        Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
        return bean.getName();
    }

    @Nullable
    protected String getBeanLocation(@NotNull CidBeanDescriptorWrapper bean) {
        Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
        return bean.getLocation();
    }

    @Nullable
    protected PsiElement getBeanIdentifyingPsiElement(@NotNull CidBeanDescriptorWrapper bean) {
        Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
        return bean.getDescriptor().getIdentifyingElement();
    }

    @Nullable
    protected PsiType getBeanType(@NotNull CidBeanDescriptorWrapper bean) {
        Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
        return bean.getDescriptor().getType();
    }

    @Nullable
    protected InjectionGenerator injectionGenerator(@NotNull InjectionType type) {
        InjectionGenerator injectionGenerator;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        if (type == InjectionType.FIELD) {
            JvmModifier jvmModifier = CdiCustomizationManager.getFieldInjectionAccessModifier(this.module);
            Intrinsics.checkNotNullExpressionValue((Object)jvmModifier, (String)"getFieldInjectionAccessModifier(...)");
            injectionGenerator = (InjectionGenerator)new FieldInjectionGenerator(jvmModifier);
        } else {
            injectionGenerator = super.injectionGenerator(type);
        }
        return injectionGenerator;
    }

    private final String getAlias(AbstractCdiBeanDescriptor<?> descriptor) {
        UAnnotated uAnnotated = (UAnnotated)UastContextKt.toUElement((PsiElement)((PsiElement)descriptor.getAnnotatedItem()), UAnnotated.class);
        if (uAnnotated == null) {
            return null;
        }
        UAnnotated uAnnotated2 = uAnnotated;
        for (UAnnotation uAnnotation : uAnnotated2.getUAnnotations()) {
            PsiAnnotation psiAnnotation;
            if (uAnnotation.getJavaPsi() == null || !CdiAnnoConstants.NAMED_ANNOTATION.isFqn(psiAnnotation.getQualifiedName())) continue;
            PsiAnnotationMemberValue value = psiAnnotation.findDeclaredAttributeValue("value");
            if (value == null) {
                Object obj = descriptor.getAnnotatedItem();
                Intrinsics.checkNotNullExpressionValue(obj, (String)"getAnnotatedItem(...)");
                return this.getElementName((PsiElement)obj);
            }
            return AnnotationUtil.getStringAttributeValue((PsiAnnotationMemberValue)value);
        }
        return null;
    }

    private final String getElementName(PsiElement psiElement) {
        UClass uClass = (UClass)UastContextKt.toUElement((PsiElement)psiElement, UClass.class);
        if (uClass != null) {
            return uClass.getJavaPsi().getName();
        }
        UMethod uMethod = (UMethod)UastContextKt.toUElement((PsiElement)psiElement, UMethod.class);
        if (uMethod != null) {
            return uMethod.getName();
        }
        UField uField = (UField)UastContextKt.toUElement((PsiElement)psiElement, UField.class);
        if (uField != null) {
            return uField.getName();
        }
        return null;
    }

    @NotNull
    protected Icon getBeanIcon(@NotNull CidBeanDescriptorWrapper bean) {
        Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
        Icon icon = JavaUltimateIcons.Cdi.Bean;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Bean");
        return icon;
    }

    protected boolean hasFieldInjection(@NotNull UClass uClass) {
        Intrinsics.checkNotNullParameter((Object)uClass, (String)"uClass");
        for (InjectionPointDescriptor ip : CdiInjectionUtils.getInjectionPoints(uClass.getJavaPsi())) {
            if (!(UastContextKt.toUElement((PsiElement)((PsiElement)ip.getOwner())) instanceof UField)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasSetterInjection(@NotNull UClass uClass) {
        Intrinsics.checkNotNullParameter((Object)uClass, (String)"uClass");
        for (InjectionPointDescriptor ip : CdiInjectionUtils.getInjectionPoints(uClass.getJavaPsi())) {
            UParameter uParameter;
            UElement uElement = UastContextKt.toUElement((PsiElement)((PsiElement)ip.getOwner()));
            if ((uElement instanceof UParameter ? (UParameter)uElement : null) == null) continue;
            uParameter = uParameter;
            UMethod uMethod = UastUtils.getContainingUMethod((UElement)((UElement)uParameter));
            boolean bl = uMethod != null ? !uMethod.isConstructor() : false;
            if (!bl) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected List<CidBeanDescriptorWrapper> findMatchingBeans(@NotNull String prefix) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        this.checkType();
        CamelHumpMatcher matcher = new CamelHumpMatcher(prefix, true);
        HashMap candidates = new HashMap();
        Processor processor = arg_0 -> CdiInjectionGeneratorHelper.findMatchingBeans$lambda$0(this, prefix, candidates, matcher, arg_0);
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)this.module.getProject());
        PsiElement psiElement = this.getElementPointer().getElement();
        if (psiElement == null || (psiElement = psiElement.getResolveScope()) == null) {
            return CollectionsKt.emptyList();
        }
        PsiElement searchScope = psiElement;
        Set<String> set = CdiCommonUtils.getBeanDefiningAnnotations(this.module);
        Intrinsics.checkNotNullExpressionValue(set, (String)"getBeanDefiningAnnotations(...)");
        List<String> list = CdiCustomizationManager.getCustomBeanAnnotations(this.module);
        Intrinsics.checkNotNullExpressionValue(list, (String)"getCustomBeanAnnotations(...)");
        for (Object anno : SetsKt.plus((Set)SetsKt.plus(set, (Iterable)list), (Object)CdiAnnoConstants.PRODUCES_ANNOTATION.fqn(this.module))) {
            PsiClass annoClass;
            if (javaPsiFacade.findClass((String)anno, (GlobalSearchScope)searchScope) == null) continue;
            Collection psiMembers = AnnotatedMembersSearch.search((PsiClass)annoClass, (SearchScope)((SearchScope)searchScope)).findAll();
            for (Map member2 : psiMembers) {
                void $this$mapTo$iv$iv2;
                if (processor.process((Object)member2)) continue;
                Map $this$map$iv = candidates;
                boolean $i$f$map = false;
                Map map = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.size());
                boolean $i$f$mapTo2 = false;
                Iterator iterator = $this$mapTo$iv$iv2.entrySet().iterator();
                while (iterator.hasNext()) {
                    void it;
                    Map.Entry item$iv$iv;
                    Map.Entry entry = item$iv$iv = iterator.next();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(new CidBeanDescriptorWrapper((CdiBeanDescriptor)it.getKey(), (String)((Pair)it.getValue()).getFirst(), this.getQualifiers((AbstractCdiBeanDescriptor)it.getKey())));
                }
                return (List)destination$iv$iv;
            }
        }
        Collection<PsiMember> implicit = CdiManager.collectImplicitProduces(this.module);
        for (PsiMember member : implicit) {
            void $this$mapTo$iv$iv3;
            Map member2;
            if (processor.process((Object)member)) continue;
            Map $this$map$iv = candidates;
            boolean $i$f$map2 = false;
            member2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator $this$mapTo$iv$iv2 = $this$mapTo$iv$iv3.entrySet().iterator();
            while ($this$mapTo$iv$iv2.hasNext()) {
                void it;
                Map.Entry item$iv$iv2;
                Map.Entry $i$f$mapTo2 = item$iv$iv2 = $this$mapTo$iv$iv2.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new CidBeanDescriptorWrapper((CdiBeanDescriptor)it.getKey(), (String)((Pair)it.getValue()).getFirst(), this.getQualifiers((AbstractCdiBeanDescriptor)it.getKey())));
            }
            return (List)destination$iv$iv;
        }
        ArrayList result = new ArrayList(candidates.entrySet());
        CollectionsKt.sortWith((List)result, (arg_0, arg_1) -> CdiInjectionGeneratorHelper.findMatchingBeans$lambda$4(CdiInjectionGeneratorHelper::findMatchingBeans$lambda$3, arg_0, arg_1));
        Iterable $this$map$iv = result;
        boolean $i$f$map = false;
        Iterable $i$f$map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Map.Entry item$iv$iv2 = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object k = it.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"<get-key>(...)");
            CdiBeanDescriptor cdiBeanDescriptor = (CdiBeanDescriptor)k;
            String string = (String)((Pair)it.getValue()).getFirst();
            Object k2 = it.getKey();
            Intrinsics.checkNotNullExpressionValue(k2, (String)"<get-key>(...)");
            collection.add(new CidBeanDescriptorWrapper(cdiBeanDescriptor, string, this.getQualifiers((AbstractCdiBeanDescriptor)k2)));
        }
        return (List)destination$iv$iv;
    }

    private final void checkType() {
        JavaeeType javaeeType = JavaeeType.discover((Module)this.module, (JavaeeClass)CdiAnnoConstants.INJECT_ANNOTATION);
        Intrinsics.checkNotNullExpressionValue((Object)javaeeType, (String)"discover(...)");
        this.javaeeType = javaeeType;
    }

    private final AbstractCdiBeanDescriptor<?> getDescriptor(PsiMember member) {
        return member instanceof PsiClass ? (AbstractCdiBeanDescriptor)CdiDescriptorsFactory.createCdiBeanDescriptor((PsiClass)member) : (AbstractCdiBeanDescriptor)CdiDescriptorsFactory.createProducerCdiBeanDescriptor(member);
    }

    /*
     * WARNING - void declaration
     */
    private final List<AnnotationRequest> getQualifiers(AbstractCdiBeanDescriptor<?> descriptor) {
        void $this$mapNotNullTo$iv$iv;
        UAnnotated uAnnotated = (UAnnotated)UastContextKt.toUElement((PsiElement)((PsiElement)descriptor.getAnnotatedItem()), UAnnotated.class);
        if (uAnnotated == null) {
            return CollectionsKt.emptyList();
        }
        UAnnotated uAnnotated2 = uAnnotated;
        Iterable $this$mapNotNull$iv = uAnnotated2.getUAnnotations();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            AnnotationRequest it$iv$iv;
            PsiAnnotation psiAnnotation;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            UAnnotation it = (UAnnotation)element$iv$iv;
            boolean bl2 = false;
            if ((it.getJavaPsi() == null ? null : (!CdiAnnoConstants.NAMED_ANNOTATION.isFqn(psiAnnotation.getQualifiedName()) ? null : AnnotationRequestsKt.annotationRequest((JvmAnnotation)((JvmAnnotation)psiAnnotation)))) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    protected InjectionDescriptor getBeanDescriptor(@NotNull CidBeanDescriptorWrapper bean, @NotNull InjectionType type) {
        Intrinsics.checkNotNullParameter((Object)bean, (String)"bean");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        String name = PsiNameHelper.getInstance((Project)this.getContext().getProject()).isIdentifier(bean.getName()) ? bean.getName() : CdiInjectionGeneratorHelperKt.access$getBeanName(bean.getDescriptor());
        PsiClass psiClass = PsiTypesUtil.getPsiClass((PsiType)bean.getDescriptor().getType());
        if (psiClass == null) {
            return null;
        }
        PsiClass psiClass2 = psiClass;
        SmartList annotationRequests = new SmartList();
        if (type != InjectionType.CONSTRUCTOR) {
            String string = CdiAnnoConstants.INJECT_ANNOTATION.fqn(this.javaeeType);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"fqn(...)");
            annotationRequests.add((Object)AnnotationRequestsKt.annotationRequest((String)string, (AnnotationAttributeRequest[])new AnnotationAttributeRequest[0]));
        }
        annotationRequests.addAll((Collection)bean.getQualifiers());
        PsiClassType psiClassType = PsiTypesUtil.getClassType((PsiClass)psiClass2);
        Intrinsics.checkNotNullExpressionValue((Object)psiClassType, (String)"getClassType(...)");
        return new InjectionDescriptor(name, (PsiType)psiClassType, (List)annotationRequests);
    }

    @NotNull
    protected InjectionConstructorHandler getConstructorHandler() {
        return new CdiConstructorHandler(this.javaeeType);
    }

    private static final boolean findMatchingBeans$lambda$0(CdiInjectionGeneratorHelper this$0, String $prefix, HashMap $candidates, CamelHumpMatcher $matcher, PsiMember it) {
        String name;
        Intrinsics.checkNotNull((Object)it);
        AbstractCdiBeanDescriptor<?> abstractCdiBeanDescriptor = this$0.getDescriptor(it);
        if (abstractCdiBeanDescriptor == null) {
            return true;
        }
        AbstractCdiBeanDescriptor<?> descriptor = abstractCdiBeanDescriptor;
        String typeName = CdiInjectionGeneratorHelperKt.access$getBeanName(descriptor);
        if (Intrinsics.areEqual((Object)typeName, (Object)$prefix)) {
            $candidates.clear();
            ((Map)$candidates).put(descriptor, new Pair((Object)typeName, (Object)1));
            return false;
        }
        String alias = this$0.getAlias(descriptor);
        if (Intrinsics.areEqual((Object)alias, (Object)$prefix)) {
            $candidates.clear();
            ((Map)$candidates).put(descriptor, new Pair((Object)alias, (Object)1));
            return false;
        }
        String string = alias;
        if (string == null) {
            string = name = typeName;
        }
        if (alias != null && $matcher.prefixMatches(alias)) {
            ((Map)$candidates).put(descriptor, new Pair((Object)name, (Object)$matcher.matchingDegree(alias)));
        } else if ($matcher.prefixMatches(typeName)) {
            ((Map)$candidates).put(descriptor, new Pair((Object)name, (Object)$matcher.matchingDegree(typeName)));
        }
        return true;
    }

    private static final int findMatchingBeans$lambda$3(Map.Entry t1, Map.Entry t2) {
        int matchingDegree = ((Number)((Pair)t2.getValue()).getSecond()).intValue() - ((Number)((Pair)t1.getValue()).getSecond()).intValue();
        if (matchingDegree == 0) {
            return StringUtil.compare((String)((String)((Pair)t1.getValue()).getFirst()), (String)((String)((Pair)t2.getValue()).getFirst()), (boolean)false);
        }
        return matchingDegree;
    }

    private static final int findMatchingBeans$lambda$4(Function2 $tmp0, Object p0, Object p1) {
        return ((Number)$tmp0.invoke(p0, p1)).intValue();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/cdi/highlighting/CdiInjectionGeneratorHelper$CdiConstructorHandler;", "Lcom/intellij/microservices/jvm/inject/InjectionConstructorHandler;", "javaeeType", "Lcom/intellij/javaee/utils/JavaeeType;", "<init>", "(Lcom/intellij/javaee/utils/JavaeeType;)V", "findConstructor", "Lorg/jetbrains/uast/UMethod;", "uClass", "Lorg/jetbrains/uast/UClass;", "getAnnotationRequests", "", "Lcom/intellij/lang/jvm/actions/AnnotationRequest;", "intellij.javaee.cdi"})
    @SourceDebugExtension(value={"SMAP\nCdiInjectionGeneratorHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CdiInjectionGeneratorHelper.kt\ncom/intellij/cdi/highlighting/CdiInjectionGeneratorHelper$CdiConstructorHandler\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,245:1\n3919#2:246\n4434#2,2:247\n*S KotlinDebug\n*F\n+ 1 CdiInjectionGeneratorHelper.kt\ncom/intellij/cdi/highlighting/CdiInjectionGeneratorHelper$CdiConstructorHandler\n*L\n229#1:246\n229#1:247,2\n*E\n"})
    private static final class CdiConstructorHandler
    implements InjectionConstructorHandler {
        @NotNull
        private final JavaeeType javaeeType;

        public CdiConstructorHandler(@NotNull JavaeeType javaeeType) {
            Intrinsics.checkNotNullParameter((Object)javaeeType, (String)"javaeeType");
            this.javaeeType = javaeeType;
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public UMethod findConstructor(@NotNull UClass uClass) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)uClass, (String)"uClass");
            UMethod[] $this$filter$iv = uClass.getMethods();
            boolean $i$f$filter = false;
            UMethod[] uMethodArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            int n = ((void)$this$filterTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void element$iv$iv;
                void it = element$iv$iv = $this$filterTo$iv$iv[i];
                boolean bl = false;
                if (!it.isConstructor()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List constructors = (List)destination$iv$iv;
            if (constructors.size() == 1) {
                return (UMethod)CollectionsKt.first((List)constructors);
            }
            for (UMethod constructor : constructors) {
                if (!CdiAnnoConstants.INJECT_ANNOTATION.isAnnotated((PsiModifierListOwner)constructor.getJavaPsi(), 0)) continue;
                return constructor;
            }
            return null;
        }

        @NotNull
        public List<AnnotationRequest> getAnnotationRequests(@NotNull UClass uClass) {
            Intrinsics.checkNotNullParameter((Object)uClass, (String)"uClass");
            String string = CdiAnnoConstants.INJECT_ANNOTATION.fqn(this.javaeeType);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"fqn(...)");
            return CollectionsKt.listOf((Object)AnnotationRequestsKt.annotationRequest((String)string, (AnnotationAttributeRequest[])new AnnotationAttributeRequest[0]));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B)\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\r\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J1\u0010\u0016\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0005H\u00d6\u0001R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lcom/intellij/cdi/highlighting/CdiInjectionGeneratorHelper$CidBeanDescriptorWrapper;", "", "descriptor", "Lcom/intellij/cdi/beans/CdiBeanDescriptor;", "name", "", "qualifiers", "", "Lcom/intellij/lang/jvm/actions/AnnotationRequest;", "<init>", "(Lcom/intellij/cdi/beans/CdiBeanDescriptor;Ljava/lang/String;Ljava/util/List;)V", "getDescriptor", "()Lcom/intellij/cdi/beans/CdiBeanDescriptor;", "getName", "()Ljava/lang/String;", "getQualifiers", "()Ljava/util/List;", "location", "getLocation", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.javaee.cdi"})
    public static final class CidBeanDescriptorWrapper {
        @NotNull
        private final CdiBeanDescriptor<?> descriptor;
        @NotNull
        private final String name;
        @NotNull
        private final List<AnnotationRequest> qualifiers;
        @Nullable
        private final String location;

        public CidBeanDescriptorWrapper(@NotNull CdiBeanDescriptor<?> descriptor, @NotNull String name, @NotNull List<? extends AnnotationRequest> qualifiers) {
            Intrinsics.checkNotNullParameter(descriptor, (String)"descriptor");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(qualifiers, (String)"qualifiers");
            this.descriptor = descriptor;
            this.name = name;
            this.qualifiers = qualifiers;
            this.location = CdiInjectionGeneratorHelperKt.access$getBeanLocation(this.descriptor, this.name);
        }

        @NotNull
        public final CdiBeanDescriptor<?> getDescriptor() {
            return this.descriptor;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final List<AnnotationRequest> getQualifiers() {
            return this.qualifiers;
        }

        @Nullable
        public final String getLocation() {
            return this.location;
        }

        @NotNull
        public final CdiBeanDescriptor<?> component1() {
            return this.descriptor;
        }

        @NotNull
        public final String component2() {
            return this.name;
        }

        @NotNull
        public final List<AnnotationRequest> component3() {
            return this.qualifiers;
        }

        @NotNull
        public final CidBeanDescriptorWrapper copy(@NotNull CdiBeanDescriptor<?> descriptor, @NotNull String name, @NotNull List<? extends AnnotationRequest> qualifiers) {
            Intrinsics.checkNotNullParameter(descriptor, (String)"descriptor");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(qualifiers, (String)"qualifiers");
            return new CidBeanDescriptorWrapper(descriptor, name, qualifiers);
        }

        public static /* synthetic */ CidBeanDescriptorWrapper copy$default(CidBeanDescriptorWrapper cidBeanDescriptorWrapper, CdiBeanDescriptor cdiBeanDescriptor, String string, List list, int n, Object object) {
            if ((n & 1) != 0) {
                cdiBeanDescriptor = cidBeanDescriptorWrapper.descriptor;
            }
            if ((n & 2) != 0) {
                string = cidBeanDescriptorWrapper.name;
            }
            if ((n & 4) != 0) {
                list = cidBeanDescriptorWrapper.qualifiers;
            }
            return cidBeanDescriptorWrapper.copy(cdiBeanDescriptor, string, list);
        }

        @NotNull
        public String toString() {
            return "CidBeanDescriptorWrapper(descriptor=" + this.descriptor + ", name=" + this.name + ", qualifiers=" + this.qualifiers + ")";
        }

        public int hashCode() {
            int result = this.descriptor.hashCode();
            result = result * 31 + this.name.hashCode();
            result = result * 31 + ((Object)this.qualifiers).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CidBeanDescriptorWrapper)) {
                return false;
            }
            CidBeanDescriptorWrapper cidBeanDescriptorWrapper = (CidBeanDescriptorWrapper)other;
            if (!Intrinsics.areEqual(this.descriptor, cidBeanDescriptorWrapper.descriptor)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.name, (Object)cidBeanDescriptorWrapper.name)) {
                return false;
            }
            return Intrinsics.areEqual(this.qualifiers, cidBeanDescriptorWrapper.qualifiers);
        }
    }
}

