/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.blocking;

import com.intellij.codeInspection.blockingCallsDetection.BlockingMethodChecker;
import com.intellij.codeInspection.blockingCallsDetection.MethodContext;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.spring.SpringLibraryUtil;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/spring/data/blocking/SpringJdbcTemplateBlockingMethodChecker;", "Lcom/intellij/codeInspection/blockingCallsDetection/BlockingMethodChecker;", "<init>", "()V", "JDBC_OPERATIONS_METHOD_NAMES", "", "", "isApplicable", "", "file", "Lcom/intellij/psi/PsiFile;", "isMethodBlocking", "context", "Lcom/intellij/codeInspection/blockingCallsDetection/MethodContext;", "intellij.spring.data"})
public final class SpringJdbcTemplateBlockingMethodChecker
implements BlockingMethodChecker {
    @NotNull
    private final Set<String> JDBC_OPERATIONS_METHOD_NAMES;

    public SpringJdbcTemplateBlockingMethodChecker() {
        Object[] objectArray = new String[]{"batchUpdate", "call", "execute", "query", "queryForInt", "queryForList", "queryForLong", "queryForMap", "queryForObject", "queryForRowSet", "queryForStream", "update"};
        this.JDBC_OPERATIONS_METHOD_NAMES = SetsKt.hashSetOf((Object[])objectArray);
    }

    public boolean isApplicable(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!SpringLibraryUtil.hasSpringLibrary((Project)file.getProject())) {
            return false;
        }
        JavaPsiFacade javaPsi = JavaPsiFacade.getInstance((Project)file.getProject());
        return javaPsi.findClass("org.springframework.jdbc.core.JdbcOperations", file.getResolveScope()) != null;
    }

    public boolean isMethodBlocking(@NotNull MethodContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!this.JDBC_OPERATIONS_METHOD_NAMES.contains(context.getElement().getName())) {
            return false;
        }
        PsiClass psiClass = context.getElement().getContainingClass();
        String qualifiedClassName = psiClass != null ? psiClass.getQualifiedName() : null;
        return Intrinsics.areEqual((Object)qualifiedClassName, (Object)"org.springframework.jdbc.core.JdbcOperations") || Intrinsics.areEqual((Object)qualifiedClassName, (Object)"org.springframework.jdbc.core.JdbcTemplate");
    }
}

