/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.InheritanceImplUtil;
import com.intellij.psi.impl.PsiSubstitutorImpl;
import com.intellij.psi.impl.ScopedClassHierarchy;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceBound;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.JavaClassSupers;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.UnmodifiableHashMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaClassSupersImpl
extends JavaClassSupers {
    private static final Logger LOG = Logger.getInstance(JavaClassSupersImpl.class);
    private static final Set<String> ourReportedInconsistencies = ConcurrentHashMap.newKeySet();

    @Override
    @Nullable
    public PsiSubstitutor getSuperClassSubstitutor(@NotNull PsiClass superClass, @NotNull PsiClass derivedClass, @NotNull GlobalSearchScope scope, @NotNull PsiSubstitutor derivedSubstitutor) {
        PsiType lowerBound;
        if (superClass == null) {
            JavaClassSupersImpl.$$$reportNull$$$0(0);
        }
        if (derivedClass == null) {
            JavaClassSupersImpl.$$$reportNull$$$0(1);
        }
        if (scope == null) {
            JavaClassSupersImpl.$$$reportNull$$$0(2);
        }
        if (derivedSubstitutor == null) {
            JavaClassSupersImpl.$$$reportNull$$$0(3);
        }
        if (InheritanceImplUtil.hasObjectQualifiedName(superClass)) {
            return PsiSubstitutor.EMPTY;
        }
        List<PsiType> bounds = null;
        if (superClass instanceof InferenceVariable) {
            bounds = ((InferenceVariable)superClass).getBounds(InferenceBound.LOWER);
        } else if (superClass instanceof PsiTypeParameter && (lowerBound = TypeConversionUtil.getInferredLowerBoundForSynthetic((PsiTypeParameter)superClass)) != null) {
            bounds = Collections.singletonList(lowerBound);
        }
        if (bounds != null) {
            for (PsiType lowerBound2 : bounds) {
                PsiSubstitutor substitutor;
                if (lowerBound2 == null || (substitutor = JavaClassSupersImpl.processLowerBound(lowerBound2, derivedClass, scope, derivedSubstitutor)) == null) continue;
                return substitutor;
            }
        }
        return derivedClass instanceof PsiTypeParameter ? JavaClassSupersImpl.processTypeParameter((PsiTypeParameter)derivedClass, scope, superClass, new HashSet(), derivedSubstitutor) : JavaClassSupersImpl.getSuperSubstitutorWithCaching(superClass, derivedClass, scope, derivedSubstitutor);
    }

    private static PsiSubstitutor processLowerBound(@NotNull PsiType lowerBound, @NotNull PsiClass derivedClass, @NotNull GlobalSearchScope scope, @NotNull PsiSubstitutor derivedSubstitutor) {
        if (lowerBound == null) {
            JavaClassSupersImpl.$$$reportNull$$$0(4);
        }
        if (derivedClass == null) {
            JavaClassSupersImpl.$$$reportNull$$$0(5);
        }
        if (scope == null) {
            JavaClassSupersImpl.$$$reportNull$$$0(6);
        }
        if (derivedSubstitutor == null) {
            JavaClassSupersImpl.$$$reportNull$$$0(7);
        }
        if (lowerBound instanceof PsiClassType) {
            PsiClassType.ClassResolveResult result = ((PsiClassType)lowerBound).resolveGenerics();
            PsiClass boundClass = result.getElement();
            if (boundClass != null) {
                if (boundClass.equals(derivedClass)) {
                    return derivedSubstitutor;
                }
                PsiSubstitutor substitutor = JavaClassSupersImpl.getSuperSubstitutorWithCaching(boundClass, derivedClass, scope, result.getSubstitutor());
                if (substitutor != null) {
                    return JavaClassSupersImpl.composeSubstitutors(derivedSubstitutor, substitutor, boundClass);
                }
            }
        } else if (lowerBound instanceof PsiIntersectionType) {
            for (PsiType bound : ((PsiIntersectionType)lowerBound).getConjuncts()) {
                PsiSubstitutor substitutor = JavaClassSupersImpl.processLowerBound(bound, derivedClass, scope, derivedSubstitutor);
                if (substitutor == null) continue;
                return substitutor;
            }
        } else if (lowerBound instanceof PsiCapturedWildcardType) {
            return JavaClassSupersImpl.processLowerBound(((PsiCapturedWildcardType)lowerBound).getUpperBound(), derivedClass, scope, derivedSubstitutor);
        }
        return null;
    }

    @Nullable
    private static PsiSubstitutor getSuperSubstitutorWithCaching(@NotNull PsiClass superClass, @NotNull PsiClass derivedClass, @NotNull GlobalSearchScope resolveScope, @NotNull PsiSubstitutor derivedSubstitutor) {
        PsiSubstitutor substitutor;
        if (superClass == null) {
            JavaClassSupersImpl.$$$reportNull$$$0(8);
        }
        if (derivedClass == null) {
            JavaClassSupersImpl.$$$reportNull$$$0(9);
        }
        if (resolveScope == null) {
            JavaClassSupersImpl.$$$reportNull$$$0(10);
        }
        if (derivedSubstitutor == null) {
            JavaClassSupersImpl.$$$reportNull$$$0(11);
        }
        if ((substitutor = ScopedClassHierarchy.getSuperClassSubstitutor(derivedClass, resolveScope, superClass)) == null) {
            return null;
        }
        if (PsiUtil.isRawSubstitutor(derivedClass, derivedSubstitutor)) {
            return JavaClassSupersImpl.createRawSubstitutor(superClass);
        }
        return JavaClassSupersImpl.composeSubstitutors(derivedSubstitutor, substitutor, superClass);
    }

    @NotNull
    static PsiSubstitutor createRawSubstitutor(@NotNull PsiClass superClass) {
        if (superClass == null) {
            JavaClassSupersImpl.$$$reportNull$$$0(12);
        }
        PsiSubstitutor psiSubstitutor = JavaPsiFacade.getElementFactory(superClass.getProject()).createRawSubstitutor(superClass);
        if (psiSubstitutor == null) {
            JavaClassSupersImpl.$$$reportNull$$$0(13);
        }
        return psiSubstitutor;
    }

    @NotNull
    private static PsiSubstitutor composeSubstitutors(PsiSubstitutor outer, PsiSubstitutor inner, PsiClass onClass) {
        UnmodifiableHashMap answer = UnmodifiableHashMap.empty(PsiSubstitutorImpl.PSI_EQUIVALENCE);
        Map<PsiTypeParameter, PsiType> outerMap = outer.getSubstitutionMap();
        Map<PsiTypeParameter, PsiType> innerMap = inner.getSubstitutionMap();
        for (PsiTypeParameter parameter : PsiUtil.typeParametersIterable(onClass)) {
            PsiType targetType;
            PsiClass paramCandidate;
            if (!outerMap.containsKey(parameter) && !innerMap.containsKey(parameter)) continue;
            PsiType innerType = inner.substitute(parameter);
            PsiClass psiClass = paramCandidate = PsiCapturedWildcardType.isCapture() ? PsiUtil.resolveClassInClassTypeOnly(innerType) : null;
            if (paramCandidate instanceof PsiTypeParameter && paramCandidate != parameter) {
                targetType = outer.substituteWithBoundsPromotion((PsiTypeParameter)paramCandidate);
                if (targetType != null && innerType.hasAnnotations()) {
                    PsiAnnotation[] typeAnnotations = targetType.getAnnotations();
                    targetType = targetType.annotate(() -> (PsiAnnotation[])ArrayUtil.mergeArrays((Object[])innerType.getAnnotations(), (Object[])typeAnnotations));
                }
            } else {
                targetType = outer.substitute(innerType);
            }
            answer = answer.with((Object)parameter, (Object)targetType);
        }
        PsiSubstitutor psiSubstitutor = PsiSubstitutor.EMPTY.putAll((Map<? extends PsiTypeParameter, ? extends PsiType>)answer);
        if (psiSubstitutor == null) {
            JavaClassSupersImpl.$$$reportNull$$$0(14);
        }
        return psiSubstitutor;
    }

    @Nullable
    private static PsiSubstitutor processTypeParameter(PsiTypeParameter parameter, GlobalSearchScope scope, PsiClass superClass, Set<? super PsiTypeParameter> visited, PsiSubstitutor derivedSubstitutor) {
        if (parameter.getManager().areElementsEquivalent((PsiElement)parameter, (PsiElement)superClass)) {
            return PsiSubstitutor.EMPTY;
        }
        if (!visited.add(parameter)) {
            return null;
        }
        for (PsiClassType type : parameter.getExtendsListTypes()) {
            PsiSubstitutor answer;
            PsiClassType.ClassResolveResult result = type.resolveGenerics();
            PsiClass psiClass = result.getElement();
            if (psiClass == null) continue;
            if (psiClass instanceof PsiTypeParameter) {
                answer = JavaClassSupersImpl.processTypeParameter((PsiTypeParameter)psiClass, scope, superClass, visited, derivedSubstitutor);
                if (answer == null) continue;
                return answer;
            }
            answer = JavaClassSupersImpl.getSuperSubstitutorWithCaching(superClass, psiClass, scope, result.getSubstitutor());
            if (answer == null) continue;
            return JavaClassSupersImpl.composeSubstitutors(derivedSubstitutor, answer, superClass);
        }
        return null;
    }

    @Override
    public void reportHierarchyInconsistency(@NotNull PsiClass superClass, @NotNull PsiClass derivedClass) {
        if (superClass == null) {
            JavaClassSupersImpl.$$$reportNull$$$0(15);
        }
        if (derivedClass == null) {
            JavaClassSupersImpl.$$$reportNull$$$0(16);
        }
        if (!ourReportedInconsistencies.add(derivedClass.getQualifiedName() + "/" + superClass.getQualifiedName()) && !ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        final StringBuilder msg = new StringBuilder("superClassSubstitutor requested when derived doesn't extend super:\nSuper: " + JavaClassSupersImpl.classInfo(superClass) + "Derived: " + JavaClassSupersImpl.classInfo(derivedClass) + "isInheritor: via util=" + InheritanceUtil.isInheritorOrSelf(derivedClass, superClass, true) + ", directly=" + derivedClass.isInheritor(superClass, true) + "\nSuper in derived's scope: " + PsiSearchScopeUtil.isInScope((GlobalSearchScope)derivedClass.getResolveScope(), (PsiElement)superClass) + "\n" + (InheritanceUtil.processSupers(derivedClass, false, (Processor<? super PsiClass>)((Processor)s -> s != superClass)) ? "" : "Plain derived's supers contain Super\n") + "Hierarchy:\n");
        new ScopedClassHierarchy(derivedClass, derivedClass.getResolveScope()){

            @Override
            void visitType(@NotNull PsiClassType type, Map<PsiClass, PsiClassType.ClassResolveResult> map2) {
                if (type == null) {
                    1.$$$reportNull$$$0(0);
                }
                PsiClass eachClass = type.resolve();
                msg.append("  each: ");
                msg.append(eachClass == null ? "unresolved " + type : JavaClassSupersImpl.classInfo(eachClass));
                super.visitType(type, map2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/JavaClassSupersImpl$1", "visitType"));
            }
        }.visitType(JavaPsiFacade.getElementFactory(derivedClass.getProject()).createType(derivedClass, PsiSubstitutor.EMPTY), new HashMap<PsiClass, PsiClassType.ClassResolveResult>());
        LOG.error(msg.toString());
    }

    @NotNull
    private static String classInfo(@NotNull PsiClass aClass) {
        if (aClass == null) {
            JavaClassSupersImpl.$$$reportNull$$$0(17);
        }
        String s = aClass.getQualifiedName() + "(" + aClass.getClass().getName() + "; " + PsiUtilCore.getVirtualFile((PsiElement)aClass) + ");\n";
        s = s + "    extends: ";
        for (PsiClassType type : aClass.getExtendsListTypes()) {
            s = s + "    " + type + " (" + type.getClass().getName() + "; " + type.resolve() + ") ";
        }
        s = s + "\n    implements: ";
        for (PsiClassType type : aClass.getImplementsListTypes()) {
            s = s + "    " + type + " (" + type.getClass().getName() + "; " + type.resolve() + ") ";
        }
        String string = s + "\n";
        if (string == null) {
            JavaClassSupersImpl.$$$reportNull$$$0(18);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: 
            case 14: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: 
            case 14: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClass";
                break;
            }
            case 1: 
            case 5: 
            case 9: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "derivedClass";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 3: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "derivedSubstitutor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lowerBound";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveScope";
                break;
            }
            case 13: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/JavaClassSupersImpl";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/JavaClassSupersImpl";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createRawSubstitutor";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "composeSubstitutors";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "classInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSuperClassSubstitutor";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processLowerBound";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSuperSubstitutorWithCaching";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createRawSubstitutor";
                break;
            }
            case 13: 
            case 14: 
            case 18: {
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "reportHierarchyInconsistency";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "classInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: 
            case 14: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

