/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.provider;

import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.augment.PsiAugmentProvider;
import com.intellij.psi.augment.PsiExtensionMethod;
import com.intellij.psi.impl.source.PsiExtensibleClass;
import com.siyeh.ig.psiutils.InitializationUtils;
import de.plushnikov.intellij.plugin.processor.LombokProcessorManager;
import de.plushnikov.intellij.plugin.processor.Processor;
import de.plushnikov.intellij.plugin.processor.ValProcessor;
import de.plushnikov.intellij.plugin.processor.lombok.LombokAnnotationProcessor;
import de.plushnikov.intellij.plugin.processor.method.ExtensionMethodsHelper;
import de.plushnikov.intellij.plugin.processor.modifier.ModifierProcessor;
import de.plushnikov.intellij.plugin.util.DumbIncompleteModeUtil;
import de.plushnikov.intellij.plugin.util.LombokLibraryUtil;
import de.plushnikov.intellij.plugin.util.PsiAnnotationSearchUtil;
import de.plushnikov.intellij.plugin.util.PsiAnnotationUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LombokAugmentProvider
extends PsiAugmentProvider
implements PossiblyDumbAware {
    public boolean isDumbAware() {
        return Registry.is((String)"lombok.dumb.mode.enabled", (boolean)false);
    }

    @NotNull
    protected Set<String> transformModifiers(@NotNull PsiModifierList modifierList, @NotNull Set<String> modifiers) {
        if (modifierList == null) {
            LombokAugmentProvider.$$$reportNull$$$0(0);
        }
        if (modifiers == null) {
            LombokAugmentProvider.$$$reportNull$$$0(1);
        }
        if (!LombokLibraryUtil.hasLombokLibrary(modifierList.getProject()) && !DumbIncompleteModeUtil.isIncompleteModeWithLombokAnnotation((PsiElement)modifierList)) {
            Set<String> set = modifiers;
            if (set == null) {
                LombokAugmentProvider.$$$reportNull$$$0(2);
            }
            return set;
        }
        HashSet<String> result = new HashSet<String>(modifiers);
        DumbService dumbService = DumbService.getInstance((Project)modifierList.getProject());
        Runnable runnable = () -> {
            for (ModifierProcessor processor : Holder.modifierProcessors) {
                if (!processor.isSupported(modifierList)) continue;
                processor.transformModifiers(modifierList, result);
            }
        };
        if (dumbService.isDumb() && !dumbService.isAlternativeResolveEnabled()) {
            dumbService.runWithAlternativeResolveEnabled(() -> runnable.run());
        } else {
            runnable.run();
        }
        HashSet<String> hashSet = result;
        if (hashSet == null) {
            LombokAugmentProvider.$$$reportNull$$$0(3);
        }
        return hashSet;
    }

    public boolean canInferType(@NotNull PsiTypeElement typeElement) {
        if (typeElement == null) {
            LombokAugmentProvider.$$$reportNull$$$0(4);
        }
        if (DumbService.isDumb((Project)typeElement.getProject())) {
            return false;
        }
        return LombokLibraryUtil.hasLombokLibrary(typeElement.getProject()) && ValProcessor.canInferType(typeElement);
    }

    protected boolean fieldInitializerMightBeChanged(@NotNull PsiField field) {
        PsiField referencedField;
        PsiClass containingClass;
        PsiReferenceExpression qualifierReferenceExpression;
        PsiElement referencedElement;
        PsiMethodCallExpression methodCallExpression;
        PsiExpression qualifierExpression;
        PsiExpression fieldInitializer;
        boolean isLazyGetter;
        if (field == null) {
            LombokAugmentProvider.$$$reportNull$$$0(5);
        }
        if (DumbService.isDumb((Project)field.getProject())) {
            return false;
        }
        if (PsiAnnotationSearchUtil.isAnnotatedWith((PsiModifierListOwner)field, "lombok.Builder.Default")) {
            return true;
        }
        PsiAnnotation getterAnnotation = PsiAnnotationSearchUtil.findAnnotation((PsiModifierListOwner)field, "lombok.Getter");
        boolean bl = isLazyGetter = null != getterAnnotation && PsiAnnotationUtil.getBooleanAnnotationValue(getterAnnotation, "lazy", false);
        if (isLazyGetter && (fieldInitializer = field.getInitializer()) instanceof PsiMethodCallExpression && (qualifierExpression = (methodCallExpression = (PsiMethodCallExpression)fieldInitializer).getMethodExpression().getQualifierExpression()) instanceof PsiReferenceExpression && (referencedElement = (qualifierReferenceExpression = (PsiReferenceExpression)qualifierExpression).resolve()) instanceof PsiField && (containingClass = (referencedField = (PsiField)referencedElement).getContainingClass()) != null) {
            return InitializationUtils.isInitializedInConstructors((PsiField)referencedField, (PsiClass)containingClass);
        }
        return isLazyGetter;
    }

    @Nullable
    protected PsiType inferType(@NotNull PsiTypeElement typeElement) {
        if (typeElement == null) {
            LombokAugmentProvider.$$$reportNull$$$0(6);
        }
        if (DumbService.isDumb((Project)typeElement.getProject())) {
            return null;
        }
        return LombokLibraryUtil.hasLombokLibrary(typeElement.getProject()) ? ValProcessor.inferType(typeElement) : null;
    }

    @NotNull
    public <Psi extends PsiElement> List<Psi> getAugments(@NotNull PsiElement element, @NotNull Class<Psi> type) {
        if (element == null) {
            LombokAugmentProvider.$$$reportNull$$$0(7);
        }
        if (type == null) {
            LombokAugmentProvider.$$$reportNull$$$0(8);
        }
        List<Psi> list = this.getAugments(element, type, null);
        if (list == null) {
            LombokAugmentProvider.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    public <Psi extends PsiElement> List<Psi> getAugments(@NotNull PsiElement element, @NotNull Class<Psi> type, @Nullable String nameHint) {
        if (element == null) {
            LombokAugmentProvider.$$$reportNull$$$0(10);
        }
        if (type == null) {
            LombokAugmentProvider.$$$reportNull$$$0(11);
        }
        List emptyResult = Collections.emptyList();
        if (type != PsiClass.class && type != PsiField.class && type != PsiMethod.class || !(element instanceof PsiExtensibleClass)) {
            List list = emptyResult;
            if (list == null) {
                LombokAugmentProvider.$$$reportNull$$$0(12);
            }
            return list;
        }
        PsiExtensibleClass psiClass = (PsiExtensibleClass)element;
        if (!psiClass.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE)) {
            List list = emptyResult;
            if (list == null) {
                LombokAugmentProvider.$$$reportNull$$$0(13);
            }
            return list;
        }
        if (!LombokLibraryUtil.hasLombokLibrary(element.getProject()) && !DumbIncompleteModeUtil.isIncompleteModeWithLombokAnnotation((PsiElement)psiClass)) {
            List list = emptyResult;
            if (list == null) {
                LombokAugmentProvider.$$$reportNull$$$0(14);
            }
            return list;
        }
        if (psiClass.isAnnotationType() && type == PsiMethod.class) {
            List<PsiMethod> result;
            List<PsiMethod> list = result = LombokAnnotationProcessor.process((PsiClass)psiClass, nameHint);
            if (list == null) {
                LombokAugmentProvider.$$$reportNull$$$0(15);
            }
            return list;
        }
        if (psiClass.isAnnotationType() || psiClass.isInterface()) {
            List list = emptyResult;
            if (list == null) {
                LombokAugmentProvider.$$$reportNull$$$0(16);
            }
            return list;
        }
        if (element instanceof PsiCompiledElement) {
            List list = emptyResult;
            if (list == null) {
                LombokAugmentProvider.$$$reportNull$$$0(17);
            }
            return list;
        }
        DumbService dumbService = DumbService.getInstance((Project)psiClass.getProject());
        if (DumbService.isDumb((Project)psiClass.getProject()) && !dumbService.isAlternativeResolveEnabled()) {
            List list = (List)dumbService.computeWithAlternativeResolveEnabled(() -> LombokAugmentProvider.getPsis((PsiClass)psiClass, type, nameHint));
            if (list == null) {
                LombokAugmentProvider.$$$reportNull$$$0(18);
            }
            return list;
        }
        return LombokAugmentProvider.getPsis((PsiClass)psiClass, type, nameHint);
    }

    @NotNull
    private static <Psi extends PsiElement> List<Psi> getPsis(PsiClass psiClass, Class<Psi> type, String nameHint) {
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        for (Processor processor : LombokProcessorManager.getProcessors(type)) {
            List<? super PsiElement> generatedElements = processor.process(psiClass, nameHint);
            Iterator<? super PsiElement> iterator = generatedElements.iterator();
            while (iterator.hasNext()) {
                PsiElement psiElement;
                PsiElement element = psiElement = iterator.next();
                result.add(element);
            }
        }
        ArrayList<PsiElement> arrayList = result;
        if (arrayList == null) {
            LombokAugmentProvider.$$$reportNull$$$0(19);
        }
        return arrayList;
    }

    protected List<PsiExtensionMethod> getExtensionMethods(@NotNull PsiClass aClass, @NotNull String nameHint, @NotNull PsiElement context) {
        if (aClass == null) {
            LombokAugmentProvider.$$$reportNull$$$0(20);
        }
        if (nameHint == null) {
            LombokAugmentProvider.$$$reportNull$$$0(21);
        }
        if (context == null) {
            LombokAugmentProvider.$$$reportNull$$$0(22);
        }
        if (DumbService.isDumb((Project)aClass.getProject())) {
            return Collections.emptyList();
        }
        if (!LombokLibraryUtil.hasLombokLibrary(context.getProject())) {
            return Collections.emptyList();
        }
        return ExtensionMethodsHelper.getExtensionMethods(aClass, nameHint, context);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 9, 12, 13, 14, 15, 16, 17, 18, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierList";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiers";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/provider/LombokAugmentProvider";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameHint";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/provider/LombokAugmentProvider";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "transformModifiers";
                break;
            }
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getAugments";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsis";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "transformModifiers";
                break;
            }
            case 2: 
            case 3: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "canInferType";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "fieldInitializerMightBeChanged";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "inferType";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getAugments";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getExtensionMethods";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 9, 12, 13, 14, 15, 16, 17, 18, 19 -> new IllegalStateException(string);
        };
    }

    private static final class Holder {
        static final Collection<ModifierProcessor> modifierProcessors = LombokProcessorManager.getLombokModifierProcessors();

        private Holder() {
        }
    }
}

