/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.appServers.run.configuration;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.execution.ui.DefaultJreSelector;
import com.intellij.javaee.appServers.run.configuration.CommonModel;
import com.intellij.javaee.appServers.run.configuration.ServerModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.util.CloudConfigurationUtil;
import java.util.UUID;
import java.util.function.Consumer;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ServerModelBase
implements ServerModel {
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void readExternal(Element element) throws InvalidDataException {
        this.read(element, false);
    }

    public void readPersistent(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            ServerModelBase.$$$reportNull$$$0(0);
        }
        this.read(element, true);
        if (!this.isTemplate()) {
            this.readPasswords();
        }
    }

    protected abstract void read(@NotNull Element var1, boolean var2) throws InvalidDataException;

    protected void readPasswords() {
        this.readPassword("", this::setPassword);
    }

    protected void readPassword(@NotNull String suffix, @NotNull Consumer<? super String> passwordSetter) {
        if (suffix == null) {
            ServerModelBase.$$$reportNull$$$0(1);
        }
        if (passwordSetter == null) {
            ServerModelBase.$$$reportNull$$$0(2);
        }
        CloudConfigurationUtil.doGetSafeValue((CredentialAttributes)this.createCredentialAttributes(suffix)).ifPresent(passwordSetter);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        this.write(element, false);
    }

    public void writePersistent(@NotNull Element element) throws WriteExternalException {
        if (element == null) {
            ServerModelBase.$$$reportNull$$$0(3);
        }
        if (!this.isTemplate() && this.isCredentialAliasRequired()) {
            this.setCredentialAlias(UUID.randomUUID().toString());
        }
        this.write(element, true);
    }

    protected abstract void write(@NotNull Element var1, boolean var2) throws InvalidDataException;

    protected void writePasswords() {
        this.writePassword("", this.getPassword());
    }

    protected void writePassword(@NotNull String suffix, @Nullable String password) {
        if (suffix == null) {
            ServerModelBase.$$$reportNull$$$0(4);
        }
        CloudConfigurationUtil.doSetSafeValue((CredentialAttributes)this.createCredentialAttributes(suffix), (String)this.getCredentialAlias(), (String)password);
    }

    public abstract boolean isTemplate();

    @Nullable
    public abstract String getPassword();

    public abstract void setPassword(@NotNull String var1);

    public void savePassword() {
        this.writePasswords();
    }

    private boolean isCredentialAliasRequired() {
        return !this.isDefaultPasswords() && StringUtil.isEmpty((String)this.getCredentialAlias());
    }

    protected abstract boolean isDefaultPasswords();

    @Nullable
    protected abstract String getCredentialAlias();

    protected abstract void setCredentialAlias(@Nullable String var1);

    @Nullable
    private CredentialAttributes createCredentialAttributes(@NotNull String suffix) {
        String credentialAlias;
        if (suffix == null) {
            ServerModelBase.$$$reportNull$$$0(5);
        }
        return StringUtil.isEmpty((String)(credentialAlias = this.getCredentialAlias())) ? null : new CredentialAttributes(CredentialAttributesKt.generateServiceName((String)(this.getCommonModel().getIntegration().getPresentableName() + suffix), (String)credentialAlias), credentialAlias);
    }

    protected abstract CommonModel getCommonModel();

    public boolean needsToBeMigrated() {
        return this.isCredentialAliasRequired() || this.isTemplate() && !this.isEmptyPasswords();
    }

    protected boolean isEmptyPasswords() {
        return StringUtil.isEmpty((String)this.getPassword());
    }

    public void onConfigurationCopied() {
        this.setCredentialAlias(null);
    }

    public DefaultJreSelector getDefaultJreSelector(Project project) {
        return DefaultJreSelector.projectSdk((Project)project);
    }

    @Nullable
    public String getServerHome() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "passwordSetter";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javaee/appServers/run/configuration/ServerModelBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "readPersistent";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "readPassword";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "writePersistent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "writePassword";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createCredentialAttributes";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

