/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.process;

import com.intellij.javaee.process.JavaeeProcessObject;
import com.intellij.javaee.process.common.DocumentWriter;
import com.intellij.javaee.process.common.JavaeeProcessUtilException;
import com.intellij.javaee.process.common.MethodParamSaver;
import com.intellij.util.io.socketConnection.AbstractRequest;
import java.io.IOException;
import org.w3c.dom.Document;

public class JavaeeProcessRequest
implements AbstractRequest {
    private static int ourLastId = 0;
    private final int myId = JavaeeProcessRequest.getNextId();
    private final String myClassName;
    private final String myObjectId;
    private final String myMethodName;
    private final MethodParamSaver myMethodSaver;

    private static int getNextId() {
        return ourLastId++;
    }

    public JavaeeProcessRequest(Class<? extends JavaeeProcessObject> targetClass, String objectId, String methodName, String ... paramValues) throws JavaeeProcessUtilException {
        this.myClassName = targetClass.getName();
        this.myObjectId = objectId;
        this.myMethodName = methodName;
        this.myMethodSaver = new MethodParamSaver(targetClass, methodName, paramValues);
    }

    public int getId() {
        return this.myId;
    }

    public void save(Document document) throws IOException {
        DocumentWriter requestWriter = new DocumentWriter(document, "request");
        requestWriter.createTopElement("requestId", String.valueOf(this.getId()));
        requestWriter.createTopElement("targetClassName", this.myClassName);
        requestWriter.createTopElement("targetObjectId", this.myObjectId);
        requestWriter.createTopElement("targetMethodName", this.myMethodName);
        this.myMethodSaver.save(requestWriter);
    }
}

