/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsp.javaee.web.el;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.javaee.el.ELElementVisitor;
import com.intellij.javaee.el.impl.ElBundle;
import com.intellij.javaee.el.psi.ELExpression;
import com.intellij.javaee.el.psi.ELFunctionCallExpression;
import com.intellij.javaee.el.psi.ELMethodCallExpression;
import com.intellij.javaee.el.psi.ELParameterList;
import com.intellij.javaee.el.psi.ELVariable;
import com.intellij.jsp.impl.FunctionDescriptor;
import com.intellij.jsp.javaee.web.el.impl.references.FunctionELReference;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.NotNull;

public final class FunctionELReferenceInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            FunctionELReferenceInspection.$$$reportNull$$$0(0);
        }
        return new ELElementVisitor(this){

            public void visitELFunctionCallExpression(@NotNull ELFunctionCallExpression o) {
                if (o == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitELFunctionCallExpression(o);
                FunctionELReferenceInspection.validateELFunctionCall(o, holder);
            }

            public void visitELMethodCallExpression(@NotNull ELMethodCallExpression methodCallExpression) {
                if (methodCallExpression == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.visitELMethodCallExpression(methodCallExpression);
                FunctionELReferenceInspection.validateMethodCallExpression(methodCallExpression, holder);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "o";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "methodCallExpression";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/jsp/javaee/web/el/FunctionELReferenceInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitELFunctionCallExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitELMethodCallExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static void validateELFunctionCall(ELFunctionCallExpression callExpression, @NotNull ProblemsHolder holder) {
        PsiElement element;
        ELVariable method;
        if (holder == null) {
            FunctionELReferenceInspection.$$$reportNull$$$0(1);
        }
        PsiReference reference = (method = callExpression.getMethod()) != null ? method.getReference() : null;
        PsiElement psiElement = element = reference != null ? reference.resolve() : null;
        if (element instanceof XmlTag) {
            FunctionDescriptor data = (FunctionDescriptor)element.getUserData(FunctionELReference.EL_FUNCTION_DESCRIPTOR);
            ELParameterList parameterList = callExpression.getParameterList();
            if (parameterList != null && data != null && parameterList.getParameters().length != data.getParameterCount()) {
                holder.registerProblem((PsiElement)parameterList, ElBundle.message((String)"el.mismatched.parameters.count", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
            }
        }
    }

    private static void validateMethodCallExpression(@NotNull ELMethodCallExpression methodCallExpression, @NotNull ProblemsHolder holder) {
        ELVariable elVariable;
        if (methodCallExpression == null) {
            FunctionELReferenceInspection.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            FunctionELReferenceInspection.$$$reportNull$$$0(3);
        }
        if ((elVariable = methodCallExpression.getMethod()) == null) {
            return;
        }
        PsiReference[] references = elVariable.getReferences();
        if (references.length == 0) {
            return;
        }
        PsiElement element = references[0].resolve();
        if (element instanceof PsiMethod) {
            boolean vararg;
            PsiParameter[] psiParameters = ((PsiMethod)element).getParameterList().getParameters();
            ELParameterList parameterList = methodCallExpression.getParameterList();
            ELExpression[] parameters = parameterList != null ? parameterList.getParameters() : null;
            boolean bl = vararg = psiParameters.length > 0 && psiParameters[psiParameters.length - 1].isVarArgs();
            if (parameters != null && (!vararg && parameters.length != psiParameters.length || vararg && parameters.length < psiParameters.length - 1)) {
                holder.registerProblem((PsiElement)parameterList, ElBundle.message((String)"el.mismatched.parameters.count", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCallExpression";
                break;
            }
        }
        objectArray2[1] = "com/intellij/jsp/javaee/web/el/FunctionELReferenceInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "validateELFunctionCall";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "validateMethodCallExpression";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

