/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsp.javaee.web.tld;

import com.intellij.jsp.javaee.web.tld.TaglibUriXmlBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.text.CharSequenceReader;
import com.intellij.util.xml.NanoXmlUtil;
import java.io.Reader;
import net.n3.nanoxml.IXMLBuilder;
import org.jetbrains.annotations.Nullable;

public class TaglibUriCacheProvider
implements CachedValueProvider<String> {
    private static final Key<CachedValue<String>> TLD_URI_KEY = new Key("tld uri key");
    private final XmlFile myTldFile;

    public TaglibUriCacheProvider(XmlFile tldFile) {
        this.myTldFile = tldFile;
    }

    public CachedValueProvider.Result<String> compute() {
        TaglibUriXmlBuilder builder = new TaglibUriXmlBuilder();
        CharSequenceReader reader = new CharSequenceReader(this.myTldFile.getViewProvider().getContents());
        NanoXmlUtil.parse((Reader)reader, (IXMLBuilder)builder);
        String uri = !builder.isUriFound() || !builder.isTagLib() ? null : builder.getUri();
        return new CachedValueProvider.Result((Object)uri, new Object[]{this.myTldFile});
    }

    @Nullable
    public static String getUri(XmlFile tldFile) {
        CachedValue cachedValue = (CachedValue)tldFile.getUserData(TLD_URI_KEY);
        if (cachedValue == null) {
            TaglibUriCacheProvider provider = new TaglibUriCacheProvider(tldFile);
            cachedValue = CachedValuesManager.getManager((Project)tldFile.getProject()).createCachedValue((CachedValueProvider)provider, false);
            tldFile.putUserData(TLD_URI_KEY, (Object)cachedValue);
        }
        return (String)cachedValue.getValue();
    }

    public static boolean isUpToDate(XmlFile tldFile) {
        CachedValue cachedValue = (CachedValue)tldFile.getUserData(TLD_URI_KEY);
        return cachedValue == null || cachedValue.hasUpToDateValue();
    }
}

