/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n23#3:393\n23#3:394\n23#3:395\n23#3:396\n23#3:397\n23#3:398\n23#3:399\n23#3:400\n23#3:401\n23#3:402\n23#3:403\n23#3:404\n23#3:405\n23#3:406\n23#3:407\n23#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l = 57282413827667L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(435021330 - 7199, 435021330 - 7269, (int)l));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(435021330 - 7200, 435021330 - 18954, (int)l));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l;
            block2: {
                l = 101403528900106L;
                thread = Thread.currentThread();
                int[] nArray = SshAgentIpcService.h();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (nArray == null) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(-648927570 + -13574, 648927570 + 15229, (int)l) + string + WindowsNamedPipeAgentIpc.b(-648927570 + -13573, -648927570 + -23563, (int)l) + thread3 + WindowsNamedPipeAgentIpc.b(-648927570 + -13568, 648927570 + 24977, (int)l) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        long l;
        block14: {
            block15: {
                int[] nArray;
                l = 60100355502924L;
                Object object = this.lock;
                synchronized (object) {
                    boolean bl;
                    nArray = SshAgentIpcService.h();
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string = WindowsNamedPipeAgentIpc.b(878169000 - 24255, 878169000 - (char)-21090, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(878169000 - 24254, -878169000 - -((char)-26432), (int)l) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(878169000 - 24253, 878169000 - 32490, (int)l));
                        this.hPipe = hANDLE;
                        windowsNamedPipeAgentIpc = this;
                        if (nArray == null) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.b(878169000 - 24260, -878169000 - -((char)-15079), (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(878169000 - 24259, 878169000 - 27817, (int)l) + ErrorToolsKt.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(878169000 - 24258, 878169000 - 24565, (int)l));
            logger.info(WindowsNamedPipeAgentIpc.b(878169000 - 24260, -878169000 - -((char)-15079), (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(878169000 - 24257, 878169000 - (char)-18219, (int)l));
            if (ActionTimestamp.h() == null) {
                SshAgentIpcService.h(new int[2]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                int[] nArray;
                block6: {
                    long l = 46396728592403L;
                    nArray = SshAgentIpcService.h();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (nArray == null) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (nArray == null) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        Object object;
        Object object2;
        int[] nArray;
        long l;
        block27: {
            block28: {
                l = 85180111954870L;
                int[] nArray2 = SshAgentIpcService.h();
                this.assertConnectionThread();
                Object object3 = this.lock;
                nArray = nArray2;
                synchronized (object3) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block25: {
                        block26: {
                            boolean bl2 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (nArray == null) break block25;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block26;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1974438480 - -((char)-31126), -1974438480 - -27621, (int)l));
                            logger.info(WindowsNamedPipeAgentIpc.b(-1974438480 - -((char)-31122), 1974438480 - 8389, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1974438480 - -((char)-31125), 1974438480 - 21219, (int)l) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-1974438480 - -((char)-31122), 1974438480 - 8389, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1974438480 - -((char)-31128), 1974438480 - 7990, (int)l) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1974438480 - -((char)-31126), -1974438480 - -27621, (int)l));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1974438480 - -((char)-31122), 1974438480 - 8389, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1974438480 - -((char)-31127), -1974438480 - -17493, (int)l));
                    object2 = Kernel32.INSTANCE;
                    if (nArray == null) break block27;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block28;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n2 = Kernel32.INSTANCE.GetLastError();
                if (n2 == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl5 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1974438480 - -((char)-31126), -1974438480 - -27621, (int)l));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1974438480 - -((char)-31122), 1974438480 - 8389, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1974438480 - -((char)-31146), -1974438480 - -21168, (int)l));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(-1974438480 - -((char)-31122), 1974438480 - 8389, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1974438480 - -((char)-31145), -1974438480 - -4476, (int)l) + ErrorToolsKt.prettyHRESULT((int)n2)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block29: {
                block30: {
                    boolean bl6 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (nArray == null) break block29;
                    try {
                        block31: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block30;
                            break block31;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl) {
                boolean bl7 = false;
                String string = WindowsNamedPipeAgentIpc.b(-1974438480 - -((char)-31122), 1974438480 - 8389, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1974438480 - -((char)-31128), 1974438480 - 7990, (int)l) + this.state;
                throw new IllegalArgumentException(string.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1974438480 - -((char)-31126), -1974438480 - -27621, (int)l));
        logger.info(WindowsNamedPipeAgentIpc.b(-1974438480 - -((char)-31122), 1974438480 - 8389, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1974438480 - -((char)-31148), -1974438480 - -4115, (int)l));
        long l2 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l2);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        try {
            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                final /* synthetic */ PipeReadableByteChannel $read;
                final /* synthetic */ PipeWritableByteChannel $write;
                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                private static final String[] a;
                private static final String[] b;
                {
                    this.$read = $read;
                    this.$write = $write;
                    this.this$0 = $receiver;
                }

                public InputStream getInputStream() {
                    long l = 40026471165087L;
                    InputStream inputStream = Channels.newInputStream(this.$read);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(1670880360 + (char)-15176, -1670880360 + -((char)-8551), (int)l));
                    return inputStream;
                }

                public OutputStream getOutputStream() {
                    long l = 16836581886251L;
                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(310111620 - 26863, 310111620 - 847, (int)l));
                    return outputStream;
                }

                public void close() {
                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block13: {
                        var5 = new String[2];
                        var3_1 = 0;
                        var2_2 = "1\u00c7J;\u0019\u0016W\u0094\u00b3\u00a4~\u00ac\u00f3\u0093GMS/\u000f\u0014\u007f\u00dc\u0083^;xn\u00dc\u0016\u00ab\u000f\u0099\u001f\u00cc\u001b-5\u00e5\u00c4\u001f";
                        var4_3 = "1\u00c7J;\u0019\u0016W\u0094\u00b3\u00a4~\u00ac\u00f3\u0093GMS/\u000f\u0014\u007f\u00dc\u0083^;xn\u00dc\u0016\u00ab\u000f\u0099\u001f\u00cc\u001b-5\u00e5\u00c4\u001f".length();
                        var1_4 = 19;
                        var0_5 = -1;
lbl7:
                        // 2 sources

                        while (true) {
                            continue;
                            break;
                        }
lbl9:
                        // 1 sources

                        while (true) {
                            var5[var3_1++] = new String(v0).intern();
                            if ((var0_5 += var1_4) < var4_3) {
                                var1_4 = var2_2.charAt(var0_5);
                                ** continue;
                            }
                            break block13;
                            break;
                        }
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                        v3 = v2.length;
                        var6_6 = 0;
                        v4 = 84;
                        v5 = v2;
                        v6 = v3;
                        if (v3 > 1) ** GOTO lbl67
                        do {
                            v7 = v4;
                            v5 = v5;
                            v8 = v5;
                            v9 = v4;
                            v10 = var6_6;
                            while (true) {
                                switch (var6_6 % 7) {
                                    case 0: {
                                        v11 = 33;
                                        break;
                                    }
                                    case 1: {
                                        v11 = 68;
                                        break;
                                    }
                                    case 2: {
                                        v11 = 66;
                                        break;
                                    }
                                    case 3: {
                                        v11 = 21;
                                        break;
                                    }
                                    case 4: {
                                        v11 = 49;
                                        break;
                                    }
                                    case 5: {
                                        v11 = 29;
                                        break;
                                    }
                                    default: {
                                        v11 = 90;
                                    }
                                }
                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                ++var6_6;
                                v4 = v7;
                                if (v7 != 0) break;
                                v7 = v4;
                                v5 = v5;
                                v10 = v4;
                                v8 = v5;
                                v9 = v4;
                            }
lbl67:
                            // 2 sources

                            v0 = v5;
                            v6 = v6;
                        } while (v6 > var6_6);
                        ** while (true)
                    }
                    accept.3.a = var5;
                    accept.3.b = new String[2];
                }

                private static String a(int n2, int n3, int n4) {
                    int n5 = (n2 ^ n4 ^ 0xDBF) & 0xFFFF;
                    if (b[n5] == null) {
                        int n6;
                        char[] cArray = a[n5].toCharArray();
                        int n7 = switch (cArray[0] & 0xFF) {
                            case 0 -> 165;
                            case 1 -> 116;
                            case 2 -> 115;
                            case 3 -> 37;
                            case 4 -> 228;
                            case 5 -> 147;
                            case 6 -> 202;
                            case 7 -> 237;
                            case 8 -> 225;
                            case 9 -> 218;
                            case 10 -> 186;
                            case 11 -> 55;
                            case 12 -> 104;
                            case 13 -> 240;
                            case 14 -> 83;
                            case 15 -> 166;
                            case 16 -> 82;
                            case 17 -> 66;
                            case 18 -> 173;
                            case 19 -> 160;
                            case 20 -> 188;
                            case 21 -> 75;
                            case 22 -> 97;
                            case 23 -> 114;
                            case 24 -> 35;
                            case 25 -> 113;
                            case 26 -> 205;
                            case 27 -> 5;
                            case 28 -> 143;
                            case 29 -> 11;
                            case 30 -> 60;
                            case 31 -> 251;
                            case 32 -> 103;
                            case 33 -> 196;
                            case 34 -> 88;
                            case 35 -> 109;
                            case 36 -> 3;
                            case 37 -> 185;
                            case 38 -> 204;
                            case 39 -> 41;
                            case 40 -> 172;
                            case 41 -> 157;
                            case 42 -> 8;
                            case 43 -> 174;
                            case 44 -> 194;
                            case 45 -> 210;
                            case 46 -> 245;
                            case 47 -> 12;
                            case 48 -> 184;
                            case 49 -> 126;
                            case 50 -> 23;
                            case 51 -> 152;
                            case 52 -> 192;
                            case 53 -> 90;
                            case 54 -> 254;
                            case 55 -> 27;
                            case 56 -> 42;
                            case 57 -> 137;
                            case 58 -> 84;
                            case 59 -> 61;
                            case 60 -> 135;
                            case 61 -> 87;
                            case 62 -> 151;
                            case 63 -> 18;
                            case 64 -> 168;
                            case 65 -> 101;
                            case 66 -> 4;
                            case 67 -> 246;
                            case 68 -> 54;
                            case 69 -> 253;
                            case 70 -> 47;
                            case 71 -> 57;
                            case 72 -> 14;
                            case 73 -> 69;
                            case 74 -> 74;
                            case 75 -> 189;
                            case 76 -> 247;
                            case 77 -> 178;
                            case 78 -> 123;
                            case 79 -> 49;
                            case 80 -> 110;
                            case 81 -> 138;
                            case 82 -> 250;
                            case 83 -> 108;
                            case 84 -> 216;
                            case 85 -> 224;
                            case 86 -> 238;
                            case 87 -> 105;
                            case 88 -> 249;
                            case 89 -> 221;
                            case 90 -> 170;
                            case 91 -> 179;
                            case 92 -> 64;
                            case 93 -> 106;
                            case 94 -> 190;
                            case 95 -> 28;
                            case 96 -> 131;
                            case 97 -> 169;
                            case 98 -> 39;
                            case 99 -> 244;
                            case 100 -> 255;
                            case 101 -> 139;
                            case 102 -> 129;
                            case 103 -> 85;
                            case 104 -> 45;
                            case 105 -> 21;
                            case 106 -> 207;
                            case 107 -> 208;
                            case 108 -> 159;
                            case 109 -> 191;
                            case 110 -> 232;
                            case 111 -> 226;
                            case 112 -> 153;
                            case 113 -> 163;
                            case 114 -> 6;
                            case 115 -> 20;
                            case 116 -> 0;
                            case 117 -> 117;
                            case 118 -> 242;
                            case 119 -> 119;
                            case 120 -> 77;
                            case 121 -> 50;
                            case 122 -> 127;
                            case 123 -> 86;
                            case 124 -> 214;
                            case 125 -> 212;
                            case 126 -> 99;
                            case 127 -> 213;
                            case 128 -> 48;
                            case 129 -> 171;
                            case 130 -> 182;
                            case 131 -> 203;
                            case 132 -> 17;
                            case 133 -> 70;
                            case 134 -> 219;
                            case 135 -> 24;
                            case 136 -> 80;
                            case 137 -> 95;
                            case 138 -> 198;
                            case 139 -> 2;
                            case 140 -> 130;
                            case 141 -> 144;
                            case 142 -> 10;
                            case 143 -> 53;
                            case 144 -> 124;
                            case 145 -> 175;
                            case 146 -> 100;
                            case 147 -> 58;
                            case 148 -> 19;
                            case 149 -> 248;
                            case 150 -> 98;
                            case 151 -> 149;
                            case 152 -> 220;
                            case 153 -> 68;
                            case 154 -> 223;
                            case 155 -> 164;
                            case 156 -> 142;
                            case 157 -> 62;
                            case 158 -> 236;
                            case 159 -> 29;
                            case 160 -> 26;
                            case 161 -> 63;
                            case 162 -> 199;
                            case 163 -> 59;
                            case 164 -> 181;
                            case 165 -> 31;
                            case 166 -> 34;
                            case 167 -> 133;
                            case 168 -> 93;
                            case 169 -> 145;
                            case 170 -> 233;
                            case 171 -> 67;
                            case 172 -> 81;
                            case 173 -> 158;
                            case 174 -> 118;
                            case 175 -> 30;
                            case 176 -> 155;
                            case 177 -> 161;
                            case 178 -> 73;
                            case 179 -> 43;
                            case 180 -> 128;
                            case 181 -> 36;
                            case 182 -> 167;
                            case 183 -> 234;
                            case 184 -> 56;
                            case 185 -> 125;
                            case 186 -> 52;
                            case 187 -> 15;
                            case 188 -> 122;
                            case 189 -> 7;
                            case 190 -> 241;
                            case 191 -> 13;
                            case 192 -> 94;
                            case 193 -> 79;
                            case 194 -> 154;
                            case 195 -> 215;
                            case 196 -> 9;
                            case 197 -> 193;
                            case 198 -> 150;
                            case 199 -> 16;
                            case 200 -> 78;
                            case 201 -> 227;
                            case 202 -> 201;
                            case 203 -> 111;
                            case 204 -> 91;
                            case 205 -> 231;
                            case 206 -> 206;
                            case 207 -> 176;
                            case 208 -> 132;
                            case 209 -> 140;
                            case 210 -> 162;
                            case 211 -> 134;
                            case 212 -> 89;
                            case 213 -> 252;
                            case 214 -> 102;
                            case 215 -> 239;
                            case 216 -> 217;
                            case 217 -> 65;
                            case 218 -> 112;
                            case 219 -> 148;
                            case 220 -> 33;
                            case 221 -> 222;
                            case 222 -> 51;
                            case 223 -> 235;
                            case 224 -> 136;
                            case 225 -> 107;
                            case 226 -> 156;
                            case 227 -> 121;
                            case 228 -> 44;
                            case 229 -> 229;
                            case 230 -> 25;
                            case 231 -> 38;
                            case 232 -> 230;
                            case 233 -> 211;
                            case 234 -> 92;
                            case 235 -> 76;
                            case 236 -> 72;
                            case 237 -> 71;
                            case 238 -> 120;
                            case 239 -> 183;
                            case 240 -> 187;
                            case 241 -> 141;
                            case 242 -> 180;
                            case 243 -> 1;
                            case 244 -> 40;
                            case 245 -> 32;
                            case 246 -> 46;
                            case 247 -> 195;
                            case 248 -> 146;
                            case 249 -> 209;
                            case 250 -> 243;
                            case 251 -> 96;
                            case 252 -> 177;
                            case 253 -> 22;
                            case 254 -> 200;
                            default -> 197;
                        };
                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                        if (n8 < 0) {
                            n8 += 256;
                        }
                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                            n6 += 256;
                        }
                        int n9 = 0;
                        while (n9 < cArray.length) {
                            int n10 = n9 % 2;
                            int n11 = n9;
                            char[] cArray2 = cArray;
                            char c2 = cArray[n11];
                            if (n10 == 0) {
                                cArray2[n11] = (char)(c2 ^ n8);
                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                            } else {
                                cArray2[n11] = (char)(c2 ^ n6);
                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                            }
                            ++n9;
                        }
                        accept.3.b[n5] = new String(cArray).intern();
                    }
                    return b[n5];
                }
            };
            if (nArray == null) {
                ActionTimestamp.h(new int[2]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l2;
            block2: {
                block3: {
                    l2 = 22387854393632L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    int[] nArray = SshAgentIpcService.h();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (nArray == null) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1810076700 + -((char)-12968), -1810076700 + -((char)-5919), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1810076700 + -((char)-12964), 1810076700 + 30465, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1810076700 + -((char)-12975), -1810076700 + -((char)-32392), (int)l2) + uLONG);
                    l = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n3 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1810076700 + -((char)-12968), -1810076700 + -((char)-5919), (int)l2));
            logger.warn(WindowsNamedPipeAgentIpc.b(-1810076700 + -((char)-12964), 1810076700 + 30465, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1810076700 + -((char)-12976), -1810076700 + -((char)-24524), (int)l2) + ErrorToolsKt.prettyHRESULT((int)n3));
            l = -1L;
        }
        long l3 = l;
        return l3;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    int[] nArray;
                    block13: {
                        long l = 111872249222190L;
                        int[] nArray2 = SshAgentIpcService.h();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(1235990100 + (char)-10937, 1236121170 - (char)-5215, (int)l));
                        nArray = nArray2;
                        try {
                            try {
                                try {
                                    try {
                                        if (nArray == null || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (nArray == null) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(1235990100 + (char)-10940, 1236121170 - (char)-9895, (int)l);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (nArray == null) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        int[] nArray;
        long l;
        block25: {
            block26: {
                l = 30938871616547L;
                int[] nArray2 = SshAgentIpcService.h();
                this.assertConnectionThread();
                nArray = nArray2;
                Object object2 = this.lock;
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (nArray == null) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (nArray == null) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-2072740980 + -((char)-4099), -2072740980 + -((char)-6772), (int)l));
                            logger.info(WindowsNamedPipeAgentIpc.b(-2072740980 + -((char)-4095), 2072740980 + (char)-26198, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-2072740980 + -((char)-4104), -2072740980 + -32722, (int)l));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-2072740980 + -((char)-4095), 2072740980 + (char)-26198, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-2072740980 + -((char)-4097), 2072740980 + (char)-26597, (int)l) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-2072740980 + -((char)-4099), -2072740980 + -((char)-6772), (int)l));
                    logger.info(WindowsNamedPipeAgentIpc.b(-2072740980 + -((char)-4095), 2072740980 + (char)-26198, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-2072740980 + -((char)-4111), -2072740980 + -((char)-1278), (int)l));
                    object = Kernel32.INSTANCE;
                    if (nArray == null) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-2072740980 + -((char)-4099), -2072740980 + -((char)-6772), (int)l));
                logger.warn(WindowsNamedPipeAgentIpc.b(-2072740980 + -((char)-4095), 2072740980 + (char)-26198, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-2072740980 + -((char)-4110), 2072740980 + (char)-30808, (int)l) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (nArray == null) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-2072740980 + -((char)-4099), -2072740980 + -((char)-6772), (int)l));
        logger.info(WindowsNamedPipeAgentIpc.b(-2072740980 + -((char)-4095), 2072740980 + (char)-26198, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-2072740980 + -((char)-4109), 2072740980 + (char)-13353, (int)l));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l;
            block15: {
                int[] nArray;
                block16: {
                    l = 66617147287216L;
                    Object object = this.lock;
                    nArray = SshAgentIpcService.h();
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (nArray == null) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-2090435430 + -17278, -2090435430 + -22535, (int)l));
                                logger.info(WindowsNamedPipeAgentIpc.b(-2090435430 + -17282, 2090435430 + 10535, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-2090435430 + -17295, -2090435430 + -5600, (int)l) + this.state + WindowsNamedPipeAgentIpc.b(-2090435430 + -17294, -2090435430 + -992, (int)l));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-2090435430 + -17278, -2090435430 + -22535, (int)l));
                            logger.info(WindowsNamedPipeAgentIpc.b(-2090435430 + -17282, 2090435430 + 10535, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-2090435430 + -17293, 2090435430 + 27006, (int)l));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (nArray == null) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (nArray == null) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n3 = n2;
                    if (n3 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-2090435430 + -17278, -2090435430 + -22535, (int)l));
                        logger.info(WindowsNamedPipeAgentIpc.b(-2090435430 + -17282, 2090435430 + 10535, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-2090435430 + -17292, 2090435430 + 24133, (int)l) + ErrorToolsKt.prettyHRESULT((int)n3));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-2090435430 + -17278, -2090435430 + -22535, (int)l));
                    logger.info(WindowsNamedPipeAgentIpc.b(-2090435430 + -17282, 2090435430 + 10535, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-2090435430 + -17291, -2090435430 + -15221, (int)l));
                    if (nArray == null) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-2090435430 + -17278, -2090435430 + -22535, (int)l));
                logger.warn(WindowsNamedPipeAgentIpc.b(-2090435430 + -17282, 2090435430 + 10535, (int)l) + this.pipePath + WindowsNamedPipeAgentIpc.b(-2090435430 + -17258, 2090435430 + 25726, (int)l) + ErrorToolsKt.kernel32LastError());
            }
            WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-2090435430 + -17257, 2090435430 + 30513, (int)l));
            this.hPipe = hANDLE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[34];
                var3_1 = 0;
                var2_2 = "\u00a7@\u00f9\u009c\u000f\u008a\u00e8\u0095\u0014\u00b4\u00ff\u00a3\u008c\u00ba\u0000\u00f1\u00de\u0003-\u00da\u0096!|_\u008d\u001d\u00d4\u0081\u00ab\u0006\u0096\u009f\u00dfg\u00a1\u00b4\u0018QV\u007f\u0089\u00a3e\u00d0\u00b2\u00ef\u00ddH\u00f8\u0015N\u008bI.%\u00c9\b\u00a3\u008aS\u00a6\t\u0002\u00e4\u008bnV\u0006v\u0096\u0007\u0005\u0005\u0018\u00ad\u0097\u00f5\b\u00ec\u00b3\u0090\u0093pM\u0001\u008f\u00148\u009bJ\u009b\u00ea\u00ea\u00ce\u0014\u008a\u00a9@\u00b28[\u00c7\u0084\u001c&X\u00b7\u0005\u0002{M\u00fb\u00e9\u001e\u009dR\u00ab\u00ba\u00a8\u00c7\u0013\u009c2\f\u00b8EG\u00d9c\u00df\u00d2f\u0084\u0094\u00a66\u00ff\u00fc\u0012\tlU\"\u00ac\u0010d\u0010p7\u0084D`\u0015!\u008fW\u00c8\u00bc=\u00b3\u00dc\tJ\u00c9T\u00da\u00fe\u00b7E?\u008f\u0010\u0001\u00fd\u00dc\u008a\u0011\u00f3\u00d2\u00e3wQ\u009d\u0013\u00e5F\u0098\u00b3? \u00fe\u0014/R|\u00c9\u0087\u0018\u00be\u00b8\u00e8\u00f8\u009a\u00a9\u008eN)j\u00b8\u00f5\u00e1\u00ee` r'\u008e|\u0081\u000b\u00d3\u00dd\u0094\u00d4\u0013\u00b1\u008a\u00f0l \u0001/\u00dc\u0087\r\"\u00c7\u00c1\u0082\u00c6}\u0007\u00ce\u00ec\u00ae\u00a6\u00f4\u0087W`s\u00ec\b\u00d1\u00c87\u00fc\u0084\u00a0\u009f2\f\u009d&\u00ae:\u00aa\u001a\u00b4b\u0092)s\u0018F\u00faTBt7\u00d3\u0007[\u00e4\u0002\u00b7\u00b9\u008f\u00b8X\u00ec\u008c\u00022r\u00ec\u00ea\u00ce3\u00123\u0092\u00adu\u00cc\u0010F\u0082\u0090\u00fd\u00b2N\u00f3\u00a4\u00879i\u0087*LV\u000f\u00d1\u0083\u00b8\u00e8\u0090-\u00e5\u00bf\u00d0SO\u00af\u009cVcvg_K\u00c7\u00f6c\u00d8\u001f\u008bpi\u00fe\u00f0O\u0018\u008dS.\u0094\u0001\u00c2L\u00d8\u00dc\u00de\u00eexO\u00f2\u00cd\u00a2(\u00d8C\"\u00d0\u00f6\u00edb\u000b5\u0081\u00bb\u00ce\b\u0084\u00e0\u00b1\u0018_(\u0015d\u0000\u0091\u00fdJ\u008aD\r\u00b2(\u00b5\nX\u0081\u00963\u00ec\u0087\u00e3\u001b\u00b7)\u00b96/68V\u0001\u00aepJ\u00f0\u008dJ\u00d7W\u00aap\u00a8v \u00c3XB\u0082\u00ab_\u009b+\u00eef\u00e3-\u0002X\u008b&\u009e|5\u00df\u00a8\u0007X\u00c4\u0019r\u00da\u0083\u00c6\u0007\u0086H\u00a6\u008f\u00ca\u00d3\u00d2(\u008c@\u00c5\u00d9\u00d5\u00c1J{i'\u00f9\u0016H%Uw7\u00be0\u00a1jV\u0018\u0088p\u00a2V\u00ef`\u009e\u00e9+\u00b8\u00f3B\u00fe\u001d\u001a\u00d6\u00e0\u000f\u0097e\u00e8T\u0098\u001cF\u0003\u009d\u00a5\u00c6\u0017\u000fQ#\"\u00b0.\u000e5\u001c6\u0085\u00a2\u00e0\u00cb\u00e2\u00bd\u000b\u00dd\u001b%\u0012p\u00b0y\u00f1s\u00a4\u00b7\u00e4\u00ad\u00bf\u00abNDUn\u00fa\u00c3\u000e\u00b5\u0094\u00acj\u0010\u00dbW\u00fb\u00bf\u00ba\u0082\u00f4\u008b'\u001b\u00cd\u00c6\u00a4%\u00ea\u0087\u009d,\u00b1\u00c7\u00ceZR\u00c4\u0016\u0010\u001b|,dY\u00e4\u00c2\u00e3cJ\u001a\n\u0014s[\u0094\u0001U3\\\u00cf\u00ab\u0018\u008f\u00c0\u00ec\u00e8\u00e2\u0082\u00bd\u00d2\u00ab\u00d1O\u0007\u00db<\u00db.\u00d5\u00ba\"\u00c5\u00e0\u009b\u00ae_)\u001e\u00af\u00db\u0005\u00a60\u00d2b\n\u00d3\u00bf\u00be\u00a7\u00b8u<J\u000f\u00ee\u0011\u00ean.HS\u0094\u0019\u00be\u00ed\u00888a\\\u000f\u0095X\u0083\u0097\u0096\u00a2\u00dc\t^5\u00d6[\u00a4HX\u009b\u0091";
                var4_3 = "\u00a7@\u00f9\u009c\u000f\u008a\u00e8\u0095\u0014\u00b4\u00ff\u00a3\u008c\u00ba\u0000\u00f1\u00de\u0003-\u00da\u0096!|_\u008d\u001d\u00d4\u0081\u00ab\u0006\u0096\u009f\u00dfg\u00a1\u00b4\u0018QV\u007f\u0089\u00a3e\u00d0\u00b2\u00ef\u00ddH\u00f8\u0015N\u008bI.%\u00c9\b\u00a3\u008aS\u00a6\t\u0002\u00e4\u008bnV\u0006v\u0096\u0007\u0005\u0005\u0018\u00ad\u0097\u00f5\b\u00ec\u00b3\u0090\u0093pM\u0001\u008f\u00148\u009bJ\u009b\u00ea\u00ea\u00ce\u0014\u008a\u00a9@\u00b28[\u00c7\u0084\u001c&X\u00b7\u0005\u0002{M\u00fb\u00e9\u001e\u009dR\u00ab\u00ba\u00a8\u00c7\u0013\u009c2\f\u00b8EG\u00d9c\u00df\u00d2f\u0084\u0094\u00a66\u00ff\u00fc\u0012\tlU\"\u00ac\u0010d\u0010p7\u0084D`\u0015!\u008fW\u00c8\u00bc=\u00b3\u00dc\tJ\u00c9T\u00da\u00fe\u00b7E?\u008f\u0010\u0001\u00fd\u00dc\u008a\u0011\u00f3\u00d2\u00e3wQ\u009d\u0013\u00e5F\u0098\u00b3? \u00fe\u0014/R|\u00c9\u0087\u0018\u00be\u00b8\u00e8\u00f8\u009a\u00a9\u008eN)j\u00b8\u00f5\u00e1\u00ee` r'\u008e|\u0081\u000b\u00d3\u00dd\u0094\u00d4\u0013\u00b1\u008a\u00f0l \u0001/\u00dc\u0087\r\"\u00c7\u00c1\u0082\u00c6}\u0007\u00ce\u00ec\u00ae\u00a6\u00f4\u0087W`s\u00ec\b\u00d1\u00c87\u00fc\u0084\u00a0\u009f2\f\u009d&\u00ae:\u00aa\u001a\u00b4b\u0092)s\u0018F\u00faTBt7\u00d3\u0007[\u00e4\u0002\u00b7\u00b9\u008f\u00b8X\u00ec\u008c\u00022r\u00ec\u00ea\u00ce3\u00123\u0092\u00adu\u00cc\u0010F\u0082\u0090\u00fd\u00b2N\u00f3\u00a4\u00879i\u0087*LV\u000f\u00d1\u0083\u00b8\u00e8\u0090-\u00e5\u00bf\u00d0SO\u00af\u009cVcvg_K\u00c7\u00f6c\u00d8\u001f\u008bpi\u00fe\u00f0O\u0018\u008dS.\u0094\u0001\u00c2L\u00d8\u00dc\u00de\u00eexO\u00f2\u00cd\u00a2(\u00d8C\"\u00d0\u00f6\u00edb\u000b5\u0081\u00bb\u00ce\b\u0084\u00e0\u00b1\u0018_(\u0015d\u0000\u0091\u00fdJ\u008aD\r\u00b2(\u00b5\nX\u0081\u00963\u00ec\u0087\u00e3\u001b\u00b7)\u00b96/68V\u0001\u00aepJ\u00f0\u008dJ\u00d7W\u00aap\u00a8v \u00c3XB\u0082\u00ab_\u009b+\u00eef\u00e3-\u0002X\u008b&\u009e|5\u00df\u00a8\u0007X\u00c4\u0019r\u00da\u0083\u00c6\u0007\u0086H\u00a6\u008f\u00ca\u00d3\u00d2(\u008c@\u00c5\u00d9\u00d5\u00c1J{i'\u00f9\u0016H%Uw7\u00be0\u00a1jV\u0018\u0088p\u00a2V\u00ef`\u009e\u00e9+\u00b8\u00f3B\u00fe\u001d\u001a\u00d6\u00e0\u000f\u0097e\u00e8T\u0098\u001cF\u0003\u009d\u00a5\u00c6\u0017\u000fQ#\"\u00b0.\u000e5\u001c6\u0085\u00a2\u00e0\u00cb\u00e2\u00bd\u000b\u00dd\u001b%\u0012p\u00b0y\u00f1s\u00a4\u00b7\u00e4\u00ad\u00bf\u00abNDUn\u00fa\u00c3\u000e\u00b5\u0094\u00acj\u0010\u00dbW\u00fb\u00bf\u00ba\u0082\u00f4\u008b'\u001b\u00cd\u00c6\u00a4%\u00ea\u0087\u009d,\u00b1\u00c7\u00ceZR\u00c4\u0016\u0010\u001b|,dY\u00e4\u00c2\u00e3cJ\u001a\n\u0014s[\u0094\u0001U3\\\u00cf\u00ab\u0018\u008f\u00c0\u00ec\u00e8\u00e2\u0082\u00bd\u00d2\u00ab\u00d1O\u0007\u00db<\u00db.\u00d5\u00ba\"\u00c5\u00e0\u009b\u00ae_)\u001e\u00af\u00db\u0005\u00a60\u00d2b\n\u00d3\u00bf\u00be\u00a7\u00b8u<J\u000f\u00ee\u0011\u00ean.HS\u0094\u0019\u00be\u00ed\u00888a\\\u000f\u0095X\u0083\u0097\u0096\u00a2\u00dc\t^5\u00d6[\u00a4HX\u009b\u0091".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 18;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u0087\u00df\u0003\u00e0Vg'c_\u0018\u00fe,d\u0001\u00e6\u00e0\u00d3sf\u00f1E\u00a6\u00c3d\u00ae\u00e6\u00dc^.\u0014\u0086+\u000e\u00fd\u00e4\u00c5\u00d1\u008d\u00ec\u00ac\u00ccM\b\u00ec\u0091t/\u0000,\u00da";
                    var4_3 = "\u0087\u00df\u0003\u00e0Vg'c_\u0018\u00fe,d\u0001\u00e6\u00e0\u00d3sf\u00f1E\u00a6\u00c3d\u00ae\u00e6\u00dc^.\u0014\u0086+\u000e\u00fd\u00e4\u00c5\u00d1\u008d\u00ec\u00ac\u00ccM\b\u00ec\u0091t/\u0000,\u00da".length();
                    var1_4 = 29;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 60;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 25;
                            break;
                        }
                        case 1: {
                            v15 = 6;
                            break;
                        }
                        case 2: {
                            v15 = 112;
                            break;
                        }
                        case 3: {
                            v15 = 37;
                            break;
                        }
                        case 4: {
                            v15 = 64;
                            break;
                        }
                        case 5: {
                            v15 = 69;
                            break;
                        }
                        default: {
                            v15 = 127;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[34];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0x5FA0) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 53;
                case 1 -> 155;
                case 2 -> 71;
                case 3 -> 123;
                case 4 -> 244;
                case 5 -> 69;
                case 6 -> 12;
                case 7 -> 25;
                case 8 -> 199;
                case 9 -> 196;
                case 10 -> 182;
                case 11 -> 191;
                case 12 -> 174;
                case 13 -> 51;
                case 14 -> 200;
                case 15 -> 28;
                case 16 -> 100;
                case 17 -> 48;
                case 18 -> 6;
                case 19 -> 87;
                case 20 -> 142;
                case 21 -> 236;
                case 22 -> 176;
                case 23 -> 168;
                case 24 -> 128;
                case 25 -> 212;
                case 26 -> 169;
                case 27 -> 230;
                case 28 -> 232;
                case 29 -> 91;
                case 30 -> 226;
                case 31 -> 215;
                case 32 -> 183;
                case 33 -> 148;
                case 34 -> 193;
                case 35 -> 116;
                case 36 -> 131;
                case 37 -> 121;
                case 38 -> 154;
                case 39 -> 9;
                case 40 -> 237;
                case 41 -> 163;
                case 42 -> 120;
                case 43 -> 202;
                case 44 -> 209;
                case 45 -> 115;
                case 46 -> 234;
                case 47 -> 132;
                case 48 -> 181;
                case 49 -> 243;
                case 50 -> 0;
                case 51 -> 130;
                case 52 -> 198;
                case 53 -> 146;
                case 54 -> 233;
                case 55 -> 246;
                case 56 -> 250;
                case 57 -> 40;
                case 58 -> 255;
                case 59 -> 33;
                case 60 -> 45;
                case 61 -> 29;
                case 62 -> 113;
                case 63 -> 96;
                case 64 -> 19;
                case 65 -> 36;
                case 66 -> 239;
                case 67 -> 24;
                case 68 -> 43;
                case 69 -> 221;
                case 70 -> 139;
                case 71 -> 86;
                case 72 -> 21;
                case 73 -> 54;
                case 74 -> 118;
                case 75 -> 67;
                case 76 -> 52;
                case 77 -> 44;
                case 78 -> 75;
                case 79 -> 60;
                case 80 -> 158;
                case 81 -> 126;
                case 82 -> 171;
                case 83 -> 124;
                case 84 -> 46;
                case 85 -> 38;
                case 86 -> 162;
                case 87 -> 94;
                case 88 -> 81;
                case 89 -> 167;
                case 90 -> 47;
                case 91 -> 205;
                case 92 -> 227;
                case 93 -> 184;
                case 94 -> 127;
                case 95 -> 133;
                case 96 -> 214;
                case 97 -> 186;
                case 98 -> 149;
                case 99 -> 117;
                case 100 -> 109;
                case 101 -> 15;
                case 102 -> 104;
                case 103 -> 141;
                case 104 -> 207;
                case 105 -> 77;
                case 106 -> 197;
                case 107 -> 59;
                case 108 -> 222;
                case 109 -> 31;
                case 110 -> 135;
                case 111 -> 247;
                case 112 -> 187;
                case 113 -> 138;
                case 114 -> 90;
                case 115 -> 35;
                case 116 -> 173;
                case 117 -> 213;
                case 118 -> 201;
                case 119 -> 165;
                case 120 -> 92;
                case 121 -> 2;
                case 122 -> 114;
                case 123 -> 218;
                case 124 -> 62;
                case 125 -> 84;
                case 126 -> 231;
                case 127 -> 23;
                case 128 -> 224;
                case 129 -> 220;
                case 130 -> 211;
                case 131 -> 72;
                case 132 -> 150;
                case 133 -> 245;
                case 134 -> 1;
                case 135 -> 242;
                case 136 -> 99;
                case 137 -> 102;
                case 138 -> 249;
                case 139 -> 178;
                case 140 -> 65;
                case 141 -> 217;
                case 142 -> 32;
                case 143 -> 189;
                case 144 -> 177;
                case 145 -> 22;
                case 146 -> 210;
                case 147 -> 159;
                case 148 -> 172;
                case 149 -> 110;
                case 150 -> 7;
                case 151 -> 140;
                case 152 -> 156;
                case 153 -> 26;
                case 154 -> 50;
                case 155 -> 203;
                case 156 -> 3;
                case 157 -> 216;
                case 158 -> 66;
                case 159 -> 143;
                case 160 -> 166;
                case 161 -> 97;
                case 162 -> 188;
                case 163 -> 61;
                case 164 -> 179;
                case 165 -> 20;
                case 166 -> 112;
                case 167 -> 229;
                case 168 -> 105;
                case 169 -> 39;
                case 170 -> 76;
                case 171 -> 134;
                case 172 -> 34;
                case 173 -> 63;
                case 174 -> 161;
                case 175 -> 16;
                case 176 -> 37;
                case 177 -> 253;
                case 178 -> 8;
                case 179 -> 160;
                case 180 -> 78;
                case 181 -> 144;
                case 182 -> 137;
                case 183 -> 195;
                case 184 -> 27;
                case 185 -> 98;
                case 186 -> 82;
                case 187 -> 190;
                case 188 -> 240;
                case 189 -> 93;
                case 190 -> 228;
                case 191 -> 101;
                case 192 -> 225;
                case 193 -> 107;
                case 194 -> 235;
                case 195 -> 68;
                case 196 -> 208;
                case 197 -> 164;
                case 198 -> 14;
                case 199 -> 79;
                case 200 -> 57;
                case 201 -> 83;
                case 202 -> 129;
                case 203 -> 58;
                case 204 -> 136;
                case 205 -> 125;
                case 206 -> 108;
                case 207 -> 238;
                case 208 -> 194;
                case 209 -> 219;
                case 210 -> 145;
                case 211 -> 157;
                case 212 -> 111;
                case 213 -> 223;
                case 214 -> 89;
                case 215 -> 151;
                case 216 -> 30;
                case 217 -> 153;
                case 218 -> 204;
                case 219 -> 103;
                case 220 -> 80;
                case 221 -> 251;
                case 222 -> 122;
                case 223 -> 85;
                case 224 -> 180;
                case 225 -> 88;
                case 226 -> 106;
                case 227 -> 13;
                case 228 -> 241;
                case 229 -> 41;
                case 230 -> 175;
                case 231 -> 119;
                case 232 -> 55;
                case 233 -> 147;
                case 234 -> 254;
                case 235 -> 74;
                case 236 -> 185;
                case 237 -> 170;
                case 238 -> 192;
                case 239 -> 56;
                case 240 -> 49;
                case 241 -> 11;
                case 242 -> 73;
                case 243 -> 70;
                case 244 -> 248;
                case 245 -> 152;
                case 246 -> 10;
                case 247 -> 42;
                case 248 -> 18;
                case 249 -> 5;
                case 250 -> 4;
                case 251 -> 206;
                case 252 -> 252;
                case 253 -> 64;
                case 254 -> 95;
                default -> 17;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l = 32632869884006L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(291630750 - 2481, 291630750 - 27063, (int)l));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        int[] nArray;
                        block4: {
                            l = 94068937734678L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            nArray = SshAgentIpcService.h();
                            try {
                                hANDLE2 = hANDLE;
                                if (nArray == null) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (nArray == null) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-563994210 + -21250, 563994210 + 18058, (int)l));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-563994210 + -21247, -563994210 + -((char)-31523), (int)l) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-563994210 + -21248, 563994210 + 27996, (int)l));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "Fv\u0092/\\\u00ff\u00cc\u00b4\u0010Ph\u00a1M\u0080\b\u00ae\u0013\u00f2\u0018X\u0004^\u00ea`,";
                    var4_3 = "Fv\u0092/\\\u00ff\u00cc\u00b4\u0010Ph\u00a1M\u0080\b\u00ae\u0013\u00f2\u0018X\u0004^\u00ea`,".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 76;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u00fe\u0000\u001f{\u000758\u00c3\u00d0o,\u00ef\u00b9\u00de\u00fd\u0080\u00b1M\u000e\u00b3\u00f5\u0017\u0016<R\u0012:$+A\u0016]g\u0095\u00f1B\u00a6\u00030\u00ab\u00b9\u00a0I\u001bD\u0091\u009fEZ,\u00b1\u0017\u00b2\u008f\u00b3h\u000b\u00c8\u0014";
                        var4_3 = "\u00fe\u0000\u001f{\u000758\u00c3\u00d0o,\u00ef\u00b9\u00de\u00fd\u0080\u00b1M\u000e\u00b3\u00f5\u0017\u0016<R\u0012:$+A\u0016]g\u0095\u00f1B\u00a6\u00030\u00ab\u00b9\u00a0I\u001bD\u0091\u009fEZ,\u00b1\u0017\u00b2\u008f\u00b3h\u000b\u00c8\u0014".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 113;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 108;
                                break;
                            }
                            case 1: {
                                v15 = 122;
                                break;
                            }
                            case 2: {
                                v15 = 28;
                                break;
                            }
                            case 3: {
                                v15 = 74;
                                break;
                            }
                            case 4: {
                                v15 = 102;
                                break;
                            }
                            case 5: {
                                v15 = 62;
                                break;
                            }
                            default: {
                                v15 = 96;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFF48B) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 71;
                    case 1 -> 102;
                    case 2 -> 136;
                    case 3 -> 69;
                    case 4 -> 249;
                    case 5 -> 157;
                    case 6 -> 95;
                    case 7 -> 83;
                    case 8 -> 159;
                    case 9 -> 48;
                    case 10 -> 163;
                    case 11 -> 141;
                    case 12 -> 133;
                    case 13 -> 172;
                    case 14 -> 86;
                    case 15 -> 138;
                    case 16 -> 204;
                    case 17 -> 233;
                    case 18 -> 0;
                    case 19 -> 212;
                    case 20 -> 248;
                    case 21 -> 160;
                    case 22 -> 242;
                    case 23 -> 165;
                    case 24 -> 168;
                    case 25 -> 64;
                    case 26 -> 244;
                    case 27 -> 6;
                    case 28 -> 34;
                    case 29 -> 191;
                    case 30 -> 106;
                    case 31 -> 228;
                    case 32 -> 116;
                    case 33 -> 221;
                    case 34 -> 127;
                    case 35 -> 125;
                    case 36 -> 16;
                    case 37 -> 137;
                    case 38 -> 198;
                    case 39 -> 50;
                    case 40 -> 13;
                    case 41 -> 49;
                    case 42 -> 200;
                    case 43 -> 142;
                    case 44 -> 239;
                    case 45 -> 190;
                    case 46 -> 185;
                    case 47 -> 78;
                    case 48 -> 143;
                    case 49 -> 18;
                    case 50 -> 56;
                    case 51 -> 186;
                    case 52 -> 171;
                    case 53 -> 74;
                    case 54 -> 224;
                    case 55 -> 121;
                    case 56 -> 149;
                    case 57 -> 58;
                    case 58 -> 196;
                    case 59 -> 42;
                    case 60 -> 240;
                    case 61 -> 205;
                    case 62 -> 23;
                    case 63 -> 111;
                    case 64 -> 129;
                    case 65 -> 87;
                    case 66 -> 79;
                    case 67 -> 232;
                    case 68 -> 220;
                    case 69 -> 152;
                    case 70 -> 25;
                    case 71 -> 218;
                    case 72 -> 144;
                    case 73 -> 166;
                    case 74 -> 61;
                    case 75 -> 148;
                    case 76 -> 35;
                    case 77 -> 5;
                    case 78 -> 93;
                    case 79 -> 4;
                    case 80 -> 215;
                    case 81 -> 65;
                    case 82 -> 223;
                    case 83 -> 10;
                    case 84 -> 154;
                    case 85 -> 108;
                    case 86 -> 96;
                    case 87 -> 250;
                    case 88 -> 120;
                    case 89 -> 94;
                    case 90 -> 90;
                    case 91 -> 206;
                    case 92 -> 167;
                    case 93 -> 57;
                    case 94 -> 207;
                    case 95 -> 201;
                    case 96 -> 39;
                    case 97 -> 181;
                    case 98 -> 46;
                    case 99 -> 36;
                    case 100 -> 146;
                    case 101 -> 97;
                    case 102 -> 107;
                    case 103 -> 11;
                    case 104 -> 44;
                    case 105 -> 153;
                    case 106 -> 75;
                    case 107 -> 80;
                    case 108 -> 193;
                    case 109 -> 91;
                    case 110 -> 234;
                    case 111 -> 45;
                    case 112 -> 227;
                    case 113 -> 103;
                    case 114 -> 28;
                    case 115 -> 63;
                    case 116 -> 24;
                    case 117 -> 140;
                    case 118 -> 59;
                    case 119 -> 27;
                    case 120 -> 118;
                    case 121 -> 70;
                    case 122 -> 62;
                    case 123 -> 21;
                    case 124 -> 101;
                    case 125 -> 98;
                    case 126 -> 89;
                    case 127 -> 31;
                    case 128 -> 211;
                    case 129 -> 15;
                    case 130 -> 112;
                    case 131 -> 110;
                    case 132 -> 12;
                    case 133 -> 241;
                    case 134 -> 208;
                    case 135 -> 30;
                    case 136 -> 230;
                    case 137 -> 40;
                    case 138 -> 53;
                    case 139 -> 119;
                    case 140 -> 114;
                    case 141 -> 246;
                    case 142 -> 189;
                    case 143 -> 100;
                    case 144 -> 226;
                    case 145 -> 238;
                    case 146 -> 175;
                    case 147 -> 104;
                    case 148 -> 124;
                    case 149 -> 237;
                    case 150 -> 122;
                    case 151 -> 216;
                    case 152 -> 219;
                    case 153 -> 20;
                    case 154 -> 247;
                    case 155 -> 32;
                    case 156 -> 38;
                    case 157 -> 177;
                    case 158 -> 169;
                    case 159 -> 52;
                    case 160 -> 213;
                    case 161 -> 255;
                    case 162 -> 183;
                    case 163 -> 1;
                    case 164 -> 81;
                    case 165 -> 187;
                    case 166 -> 134;
                    case 167 -> 229;
                    case 168 -> 43;
                    case 169 -> 130;
                    case 170 -> 88;
                    case 171 -> 60;
                    case 172 -> 252;
                    case 173 -> 9;
                    case 174 -> 188;
                    case 175 -> 99;
                    case 176 -> 195;
                    case 177 -> 66;
                    case 178 -> 22;
                    case 179 -> 253;
                    case 180 -> 209;
                    case 181 -> 156;
                    case 182 -> 178;
                    case 183 -> 77;
                    case 184 -> 222;
                    case 185 -> 8;
                    case 186 -> 192;
                    case 187 -> 150;
                    case 188 -> 76;
                    case 189 -> 115;
                    case 190 -> 92;
                    case 191 -> 174;
                    case 192 -> 26;
                    case 193 -> 29;
                    case 194 -> 162;
                    case 195 -> 135;
                    case 196 -> 113;
                    case 197 -> 84;
                    case 198 -> 117;
                    case 199 -> 199;
                    case 200 -> 231;
                    case 201 -> 41;
                    case 202 -> 243;
                    case 203 -> 2;
                    case 204 -> 164;
                    case 205 -> 19;
                    case 206 -> 217;
                    case 207 -> 55;
                    case 208 -> 17;
                    case 209 -> 161;
                    case 210 -> 54;
                    case 211 -> 155;
                    case 212 -> 37;
                    case 213 -> 210;
                    case 214 -> 145;
                    case 215 -> 105;
                    case 216 -> 132;
                    case 217 -> 176;
                    case 218 -> 194;
                    case 219 -> 151;
                    case 220 -> 147;
                    case 221 -> 47;
                    case 222 -> 180;
                    case 223 -> 123;
                    case 224 -> 158;
                    case 225 -> 131;
                    case 226 -> 14;
                    case 227 -> 68;
                    case 228 -> 72;
                    case 229 -> 245;
                    case 230 -> 184;
                    case 231 -> 67;
                    case 232 -> 33;
                    case 233 -> 202;
                    case 234 -> 170;
                    case 235 -> 73;
                    case 236 -> 128;
                    case 237 -> 251;
                    case 238 -> 109;
                    case 239 -> 139;
                    case 240 -> 82;
                    case 241 -> 51;
                    case 242 -> 236;
                    case 243 -> 173;
                    case 244 -> 203;
                    case 245 -> 197;
                    case 246 -> 179;
                    case 247 -> 254;
                    case 248 -> 7;
                    case 249 -> 3;
                    case 250 -> 182;
                    case 251 -> 235;
                    case 252 -> 225;
                    case 253 -> 214;
                    case 254 -> 85;
                    default -> 126;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 93529914497770L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "Mh2eTol\u0014\tJb!o\u0019-q\b$";
                    var5_4 = "Mh2eTol\u0014\tJb!o\u0019-q\b$".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 15;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 41;
                                    break;
                                }
                                case 1: {
                                    v11 = 2;
                                    break;
                                }
                                case 2: {
                                    v11 = 79;
                                    break;
                                }
                                case 3: {
                                    v11 = 4;
                                    break;
                                }
                                case 4: {
                                    v11 = 62;
                                    break;
                                }
                                case 5: {
                                    v11 = 12;
                                    break;
                                }
                                default: {
                                    v11 = 80;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 129260811312152L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "\u00024\u0001\u0001l\fN\u0004\u0004*\r\u001b\n\b5\u0006\u001b`\u000eV\"4\u000f\t\b5\u0006\u001b`\u000eV.>\r\u000f3\u001b\u0016j\u0003L.9\u001c\u001ck\n";
                    var5_4 = "\u00024\u0001\u0001l\fN\u0004\u0004*\r\u001b\n\b5\u0006\u001b`\u000eV\"4\u000f\t\b5\u0006\u001b`\u000eV.>\r\u000f3\u001b\u0016j\u0003L.9\u001c\u001ck\n".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 125;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "\u001e \u0011\u0010z\u0015S\u0006\u001e \u0011\u0010v\u001f";
                        var5_4 = "\u001e \u0011\u0010z\u0015S\u0006\u001e \u0011\u0010v\u001f".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 107;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 54;
                                break;
                            }
                            case 1: {
                                v15 = 39;
                                break;
                            }
                            case 2: {
                                v15 = 21;
                                break;
                            }
                            case 3: {
                                v15 = 8;
                                break;
                            }
                            case 4: {
                                v15 = 120;
                                break;
                            }
                            case 5: {
                                v15 = 16;
                                break;
                            }
                            default: {
                                v15 = 95;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n23#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l = 69581169111474L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(1596039390 + 12564, -1596039390 + -9621, (int)l));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l = 94594029242399L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "\u00fe\u00d6\u00c2\u00ce\u008a\u0003KN\u00c0\u0005\u0005X\u009b\u00dbB\ru\u00ea\u00a3\u00c7\u00b0R\u00e7\u00b8\u0007\u00884\u0014\u00ab\u0010C\u001f\u00a2\u0092\u00afm/b\u00d7W\u00cd\u00a2rZ8/\u0005\u00f7\u009e\u00c5\u0003\u00893kdG+\u00c6\u001e2\u0018\t\u00e5\u009d\u00dd\u00be\u00e4\u008d\u00e7\u00d2\u0092h\u00c3$_\u0001]3\u0094.\u0004!Kx\u00d4\u00ff\u00f3^\u0087\u00c0Fn\u00e5Co\u0097\u00d4\u0082\u00d1oy\u007f\u00c1\u00ed";
                    var4_3 = "\u00fe\u00d6\u00c2\u00ce\u008a\u0003KN\u00c0\u0005\u0005X\u009b\u00dbB\ru\u00ea\u00a3\u00c7\u00b0R\u00e7\u00b8\u0007\u00884\u0014\u00ab\u0010C\u001f\u00a2\u0092\u00afm/b\u00d7W\u00cd\u00a2rZ8/\u0005\u00f7\u009e\u00c5\u0003\u00893kdG+\u00c6\u001e2\u0018\t\u00e5\u009d\u00dd\u00be\u00e4\u008d\u00e7\u00d2\u0092h\u00c3$_\u0001]3\u0094.\u0004!Kx\u00d4\u00ff\u00f3^\u0087\u00c0Fn\u00e5Co\u0097\u00d4\u0082\u00d1oy\u007f\u00c1\u00ed".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 106;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "R\u008c\u00da\u00ba\u00fa2\u00df\u00d3\u0093;\u001fur\u00fabaL\u00d1\u00a8]\u00f4 3\u00ea\u009d\u00bcaV\u0087U*\u0015\u0002\u009e\u00a5D\u0089\u0093(\u0087K\u009a\u00e7d\u00f6\u00c8\u0006\u00f0H\u00a4\u00d4\u001e%\u00a0\u0096\u0002\u00c3\u00a2\f>\u009f\u00f8<\u00b1\u00a6\fT1z\u00c8\u00dc-n\u0092}\u00a2A\u00db\u000eC\u00b7\u00c9=\u00f1r\u00cbo\u0090z\u00c1\u0095\u00a2\u0018";
                        var4_3 = "R\u008c\u00da\u00ba\u00fa2\u00df\u00d3\u0093;\u001fur\u00fabaL\u00d1\u00a8]\u00f4 3\u00ea\u009d\u00bcaV\u0087U*\u0015\u0002\u009e\u00a5D\u0089\u0093(\u0087K\u009a\u00e7d\u00f6\u00c8\u0006\u00f0H\u00a4\u00d4\u001e%\u00a0\u0096\u0002\u00c3\u00a2\f>\u009f\u00f8<\u00b1\u00a6\fT1z\u00c8\u00dc-n\u0092}\u00a2A\u00db\u000eC\u00b7\u00c9=\u00f1r\u00cbo\u0090z\u00c1\u0095\u00a2\u0018".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 58;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 24;
                                break;
                            }
                            case 1: {
                                v15 = 109;
                                break;
                            }
                            case 2: {
                                v15 = 17;
                                break;
                            }
                            case 3: {
                                v15 = 123;
                                break;
                            }
                            case 4: {
                                v15 = 106;
                                break;
                            }
                            case 5: {
                                v15 = 100;
                                break;
                            }
                            default: {
                                v15 = 103;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFE040) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 9;
                    case 1 -> 23;
                    case 2 -> 1;
                    case 3 -> 189;
                    case 4 -> 141;
                    case 5 -> 190;
                    case 6 -> 231;
                    case 7 -> 248;
                    case 8 -> 254;
                    case 9 -> 183;
                    case 10 -> 65;
                    case 11 -> 110;
                    case 12 -> 67;
                    case 13 -> 207;
                    case 14 -> 180;
                    case 15 -> 105;
                    case 16 -> 89;
                    case 17 -> 148;
                    case 18 -> 246;
                    case 19 -> 50;
                    case 20 -> 223;
                    case 21 -> 218;
                    case 22 -> 99;
                    case 23 -> 106;
                    case 24 -> 142;
                    case 25 -> 156;
                    case 26 -> 239;
                    case 27 -> 139;
                    case 28 -> 88;
                    case 29 -> 96;
                    case 30 -> 2;
                    case 31 -> 111;
                    case 32 -> 166;
                    case 33 -> 97;
                    case 34 -> 188;
                    case 35 -> 193;
                    case 36 -> 32;
                    case 37 -> 117;
                    case 38 -> 225;
                    case 39 -> 74;
                    case 40 -> 59;
                    case 41 -> 121;
                    case 42 -> 242;
                    case 43 -> 167;
                    case 44 -> 36;
                    case 45 -> 22;
                    case 46 -> 18;
                    case 47 -> 198;
                    case 48 -> 93;
                    case 49 -> 132;
                    case 50 -> 185;
                    case 51 -> 200;
                    case 52 -> 63;
                    case 53 -> 90;
                    case 54 -> 94;
                    case 55 -> 58;
                    case 56 -> 211;
                    case 57 -> 78;
                    case 58 -> 7;
                    case 59 -> 143;
                    case 60 -> 206;
                    case 61 -> 15;
                    case 62 -> 236;
                    case 63 -> 134;
                    case 64 -> 199;
                    case 65 -> 95;
                    case 66 -> 191;
                    case 67 -> 181;
                    case 68 -> 21;
                    case 69 -> 245;
                    case 70 -> 44;
                    case 71 -> 56;
                    case 72 -> 213;
                    case 73 -> 30;
                    case 74 -> 5;
                    case 75 -> 62;
                    case 76 -> 20;
                    case 77 -> 127;
                    case 78 -> 73;
                    case 79 -> 75;
                    case 80 -> 13;
                    case 81 -> 37;
                    case 82 -> 241;
                    case 83 -> 136;
                    case 84 -> 220;
                    case 85 -> 243;
                    case 86 -> 112;
                    case 87 -> 238;
                    case 88 -> 14;
                    case 89 -> 31;
                    case 90 -> 10;
                    case 91 -> 60;
                    case 92 -> 126;
                    case 93 -> 116;
                    case 94 -> 45;
                    case 95 -> 39;
                    case 96 -> 195;
                    case 97 -> 113;
                    case 98 -> 221;
                    case 99 -> 122;
                    case 100 -> 184;
                    case 101 -> 19;
                    case 102 -> 81;
                    case 103 -> 34;
                    case 104 -> 79;
                    case 105 -> 76;
                    case 106 -> 4;
                    case 107 -> 168;
                    case 108 -> 149;
                    case 109 -> 42;
                    case 110 -> 214;
                    case 111 -> 118;
                    case 112 -> 244;
                    case 113 -> 229;
                    case 114 -> 124;
                    case 115 -> 107;
                    case 116 -> 176;
                    case 117 -> 40;
                    case 118 -> 17;
                    case 119 -> 204;
                    case 120 -> 86;
                    case 121 -> 186;
                    case 122 -> 64;
                    case 123 -> 253;
                    case 124 -> 102;
                    case 125 -> 178;
                    case 126 -> 120;
                    case 127 -> 247;
                    case 128 -> 170;
                    case 129 -> 54;
                    case 130 -> 169;
                    case 131 -> 228;
                    case 132 -> 137;
                    case 133 -> 192;
                    case 134 -> 53;
                    case 135 -> 159;
                    case 136 -> 234;
                    case 137 -> 0;
                    case 138 -> 222;
                    case 139 -> 162;
                    case 140 -> 82;
                    case 141 -> 154;
                    case 142 -> 24;
                    case 143 -> 161;
                    case 144 -> 250;
                    case 145 -> 123;
                    case 146 -> 115;
                    case 147 -> 29;
                    case 148 -> 47;
                    case 149 -> 35;
                    case 150 -> 160;
                    case 151 -> 57;
                    case 152 -> 103;
                    case 153 -> 80;
                    case 154 -> 68;
                    case 155 -> 157;
                    case 156 -> 255;
                    case 157 -> 46;
                    case 158 -> 172;
                    case 159 -> 219;
                    case 160 -> 85;
                    case 161 -> 153;
                    case 162 -> 197;
                    case 163 -> 109;
                    case 164 -> 48;
                    case 165 -> 158;
                    case 166 -> 165;
                    case 167 -> 174;
                    case 168 -> 175;
                    case 169 -> 72;
                    case 170 -> 130;
                    case 171 -> 205;
                    case 172 -> 226;
                    case 173 -> 101;
                    case 174 -> 240;
                    case 175 -> 163;
                    case 176 -> 84;
                    case 177 -> 55;
                    case 178 -> 51;
                    case 179 -> 129;
                    case 180 -> 202;
                    case 181 -> 232;
                    case 182 -> 237;
                    case 183 -> 12;
                    case 184 -> 144;
                    case 185 -> 179;
                    case 186 -> 38;
                    case 187 -> 87;
                    case 188 -> 187;
                    case 189 -> 216;
                    case 190 -> 249;
                    case 191 -> 201;
                    case 192 -> 196;
                    case 193 -> 152;
                    case 194 -> 212;
                    case 195 -> 210;
                    case 196 -> 125;
                    case 197 -> 100;
                    case 198 -> 173;
                    case 199 -> 217;
                    case 200 -> 43;
                    case 201 -> 164;
                    case 202 -> 98;
                    case 203 -> 49;
                    case 204 -> 194;
                    case 205 -> 16;
                    case 206 -> 233;
                    case 207 -> 104;
                    case 208 -> 150;
                    case 209 -> 6;
                    case 210 -> 33;
                    case 211 -> 215;
                    case 212 -> 66;
                    case 213 -> 251;
                    case 214 -> 135;
                    case 215 -> 208;
                    case 216 -> 61;
                    case 217 -> 235;
                    case 218 -> 114;
                    case 219 -> 155;
                    case 220 -> 25;
                    case 221 -> 131;
                    case 222 -> 133;
                    case 223 -> 91;
                    case 224 -> 140;
                    case 225 -> 3;
                    case 226 -> 26;
                    case 227 -> 83;
                    case 228 -> 27;
                    case 229 -> 92;
                    case 230 -> 146;
                    case 231 -> 69;
                    case 232 -> 182;
                    case 233 -> 108;
                    case 234 -> 52;
                    case 235 -> 227;
                    case 236 -> 203;
                    case 237 -> 224;
                    case 238 -> 11;
                    case 239 -> 138;
                    case 240 -> 128;
                    case 241 -> 70;
                    case 242 -> 28;
                    case 243 -> 252;
                    case 244 -> 77;
                    case 245 -> 230;
                    case 246 -> 151;
                    case 247 -> 119;
                    case 248 -> 171;
                    case 249 -> 209;
                    case 250 -> 145;
                    case 251 -> 71;
                    case 252 -> 177;
                    case 253 -> 41;
                    case 254 -> 147;
                    default -> 8;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l = 19506582483129L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(1159052010 - (char)-1627, 1159052010 - (char)-5580, (int)l));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l = 118247681846332L;
                    int[] nArray = SshAgentIpcService.h();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(1357754130 + 11951, 1357754130 + 10705, (int)l));
                    int[] nArray2 = nArray;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (nArray2 == null) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l = 98590090024624L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "u\u00c1\u00e9\u009b#\u0003K\u00bcx";
                var4_3 = "u\u00c1\u00e9\u009b#\u0003K\u00bcx".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 124;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 109;
                                break;
                            }
                            case 1: {
                                v11 = 76;
                                break;
                            }
                            case 2: {
                                v11 = 49;
                                break;
                            }
                            case 3: {
                                v11 = 60;
                                break;
                            }
                            case 4: {
                                v11 = 118;
                                break;
                            }
                            case 5: {
                                v11 = 77;
                                break;
                            }
                            default: {
                                v11 = 62;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFB1FC) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 199;
                    case 1 -> 247;
                    case 2 -> 204;
                    case 3 -> 218;
                    case 4 -> 16;
                    case 5 -> 149;
                    case 6 -> 42;
                    case 7 -> 119;
                    case 8 -> 142;
                    case 9 -> 236;
                    case 10 -> 176;
                    case 11 -> 104;
                    case 12 -> 181;
                    case 13 -> 189;
                    case 14 -> 120;
                    case 15 -> 55;
                    case 16 -> 196;
                    case 17 -> 186;
                    case 18 -> 70;
                    case 19 -> 132;
                    case 20 -> 75;
                    case 21 -> 130;
                    case 22 -> 74;
                    case 23 -> 112;
                    case 24 -> 234;
                    case 25 -> 180;
                    case 26 -> 31;
                    case 27 -> 53;
                    case 28 -> 211;
                    case 29 -> 106;
                    case 30 -> 3;
                    case 31 -> 6;
                    case 32 -> 30;
                    case 33 -> 225;
                    case 34 -> 187;
                    case 35 -> 248;
                    case 36 -> 123;
                    case 37 -> 52;
                    case 38 -> 129;
                    case 39 -> 41;
                    case 40 -> 24;
                    case 41 -> 54;
                    case 42 -> 20;
                    case 43 -> 79;
                    case 44 -> 11;
                    case 45 -> 84;
                    case 46 -> 25;
                    case 47 -> 89;
                    case 48 -> 241;
                    case 49 -> 60;
                    case 50 -> 81;
                    case 51 -> 28;
                    case 52 -> 208;
                    case 53 -> 118;
                    case 54 -> 105;
                    case 55 -> 49;
                    case 56 -> 38;
                    case 57 -> 115;
                    case 58 -> 14;
                    case 59 -> 4;
                    case 60 -> 137;
                    case 61 -> 185;
                    case 62 -> 212;
                    case 63 -> 71;
                    case 64 -> 39;
                    case 65 -> 87;
                    case 66 -> 223;
                    case 67 -> 86;
                    case 68 -> 7;
                    case 69 -> 202;
                    case 70 -> 237;
                    case 71 -> 47;
                    case 72 -> 21;
                    case 73 -> 235;
                    case 74 -> 114;
                    case 75 -> 64;
                    case 76 -> 242;
                    case 77 -> 165;
                    case 78 -> 198;
                    case 79 -> 113;
                    case 80 -> 146;
                    case 81 -> 210;
                    case 82 -> 195;
                    case 83 -> 109;
                    case 84 -> 126;
                    case 85 -> 34;
                    case 86 -> 0;
                    case 87 -> 167;
                    case 88 -> 122;
                    case 89 -> 169;
                    case 90 -> 182;
                    case 91 -> 164;
                    case 92 -> 125;
                    case 93 -> 143;
                    case 94 -> 29;
                    case 95 -> 250;
                    case 96 -> 140;
                    case 97 -> 221;
                    case 98 -> 170;
                    case 99 -> 32;
                    case 100 -> 10;
                    case 101 -> 192;
                    case 102 -> 43;
                    case 103 -> 216;
                    case 104 -> 230;
                    case 105 -> 253;
                    case 106 -> 188;
                    case 107 -> 72;
                    case 108 -> 175;
                    case 109 -> 151;
                    case 110 -> 117;
                    case 111 -> 18;
                    case 112 -> 103;
                    case 113 -> 77;
                    case 114 -> 238;
                    case 115 -> 90;
                    case 116 -> 80;
                    case 117 -> 206;
                    case 118 -> 145;
                    case 119 -> 61;
                    case 120 -> 152;
                    case 121 -> 249;
                    case 122 -> 232;
                    case 123 -> 148;
                    case 124 -> 220;
                    case 125 -> 174;
                    case 126 -> 73;
                    case 127 -> 82;
                    case 128 -> 194;
                    case 129 -> 108;
                    case 130 -> 244;
                    case 131 -> 139;
                    case 132 -> 13;
                    case 133 -> 226;
                    case 134 -> 159;
                    case 135 -> 2;
                    case 136 -> 44;
                    case 137 -> 48;
                    case 138 -> 19;
                    case 139 -> 33;
                    case 140 -> 155;
                    case 141 -> 138;
                    case 142 -> 45;
                    case 143 -> 68;
                    case 144 -> 197;
                    case 145 -> 57;
                    case 146 -> 9;
                    case 147 -> 245;
                    case 148 -> 156;
                    case 149 -> 5;
                    case 150 -> 173;
                    case 151 -> 59;
                    case 152 -> 110;
                    case 153 -> 224;
                    case 154 -> 166;
                    case 155 -> 85;
                    case 156 -> 134;
                    case 157 -> 160;
                    case 158 -> 107;
                    case 159 -> 162;
                    case 160 -> 243;
                    case 161 -> 171;
                    case 162 -> 209;
                    case 163 -> 141;
                    case 164 -> 239;
                    case 165 -> 88;
                    case 166 -> 36;
                    case 167 -> 229;
                    case 168 -> 50;
                    case 169 -> 8;
                    case 170 -> 190;
                    case 171 -> 191;
                    case 172 -> 157;
                    case 173 -> 227;
                    case 174 -> 233;
                    case 175 -> 240;
                    case 176 -> 121;
                    case 177 -> 203;
                    case 178 -> 168;
                    case 179 -> 100;
                    case 180 -> 1;
                    case 181 -> 201;
                    case 182 -> 22;
                    case 183 -> 96;
                    case 184 -> 222;
                    case 185 -> 76;
                    case 186 -> 46;
                    case 187 -> 111;
                    case 188 -> 97;
                    case 189 -> 183;
                    case 190 -> 254;
                    case 191 -> 128;
                    case 192 -> 66;
                    case 193 -> 231;
                    case 194 -> 69;
                    case 195 -> 178;
                    case 196 -> 62;
                    case 197 -> 27;
                    case 198 -> 215;
                    case 199 -> 147;
                    case 200 -> 136;
                    case 201 -> 35;
                    case 202 -> 246;
                    case 203 -> 95;
                    case 204 -> 98;
                    case 205 -> 179;
                    case 206 -> 116;
                    case 207 -> 78;
                    case 208 -> 172;
                    case 209 -> 23;
                    case 210 -> 144;
                    case 211 -> 99;
                    case 212 -> 83;
                    case 213 -> 12;
                    case 214 -> 207;
                    case 215 -> 40;
                    case 216 -> 135;
                    case 217 -> 158;
                    case 218 -> 153;
                    case 219 -> 15;
                    case 220 -> 94;
                    case 221 -> 26;
                    case 222 -> 177;
                    case 223 -> 92;
                    case 224 -> 161;
                    case 225 -> 133;
                    case 226 -> 193;
                    case 227 -> 102;
                    case 228 -> 255;
                    case 229 -> 228;
                    case 230 -> 150;
                    case 231 -> 219;
                    case 232 -> 214;
                    case 233 -> 67;
                    case 234 -> 131;
                    case 235 -> 91;
                    case 236 -> 51;
                    case 237 -> 17;
                    case 238 -> 213;
                    case 239 -> 93;
                    case 240 -> 251;
                    case 241 -> 205;
                    case 242 -> 101;
                    case 243 -> 154;
                    case 244 -> 58;
                    case 245 -> 65;
                    case 246 -> 124;
                    case 247 -> 184;
                    case 248 -> 37;
                    case 249 -> 217;
                    case 250 -> 200;
                    case 251 -> 127;
                    case 252 -> 252;
                    case 253 -> 56;
                    case 254 -> 63;
                    default -> 163;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

