/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.DatabaseConnectionConfig;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.SchemaControl;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.util.GetSetMap;
import com.intellij.util.ObjectUtils;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DatabaseConnectionPoint
extends RawConnectionConfig {
    @NotNull
    public LocalDataSource getDataSource();

    @NotNull
    public DatabaseConnectionConfig getMutableConfig();

    public DatabaseDriver getDatabaseDriver();

    @NotNull
    public Properties getConnectionProperties();

    public boolean isReadOnly();

    public boolean isAutoCommit();

    public int getTxIsolation();

    @NotNull
    public Dbms getDbms();

    @NotNull
    public SchemaControl getSchemaControl();

    @NotNull
    public String getAuthProviderId();

    @Nullable
    public String getInitScript();

    @Nullable
    public String getAdditionalProperty(@NotNull String var1);

    @NotNull
    public Set<String> getAdditionalPropertiesNames();

    @Deprecated
    @NotNull
    default public Map<String, String> getAdditionalProperties() {
        return new GetSetMap<String, String>(){

            @Override
            public String get(Object key) {
                return key instanceof String ? DatabaseConnectionPoint.this.getAdditionalProperty((String)key) : null;
            }

            @Override
            @Nullable
            public String put(String key, String value) {
                String prev = DatabaseConnectionPoint.this.getAdditionalProperty(key);
                DatabaseConnectionConfig config = (DatabaseConnectionConfig)ObjectUtils.tryCast((Object)DatabaseConnectionPoint.this, DatabaseConnectionConfig.class);
                if (config != null) {
                    config.setAdditionalProperty(key, value);
                }
                return prev;
            }

            @Override
            @NotNull
            public Set<String> keySet() {
                Set<String> set = DatabaseConnectionPoint.this.getAdditionalPropertiesNames();
                if (set == null) {
                    1.$$$reportNull$$$0(0);
                }
                return set;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseConnectionPoint$1", "keySet"));
            }
        };
    }

    public static class Adapter
    implements DatabaseConnectionPoint {
        private final DatabaseConnectionPoint myDelegate;

        public Adapter(DatabaseConnectionPoint delegate) {
            this.myDelegate = delegate;
        }

        @Override
        @NotNull
        public String getAuthProviderId() {
            String string = this.myDelegate.getAuthProviderId();
            if (string == null) {
                Adapter.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @Nullable
        public String getInitScript() {
            return this.myDelegate.getInitScript();
        }

        @Override
        @NotNull
        public Properties getConnectionProperties() {
            Properties properties = this.myDelegate.getConnectionProperties();
            if (properties == null) {
                Adapter.$$$reportNull$$$0(1);
            }
            return properties;
        }

        @Override
        @NotNull
        public SchemaControl getSchemaControl() {
            SchemaControl schemaControl = this.myDelegate.getSchemaControl();
            if (schemaControl == null) {
                Adapter.$$$reportNull$$$0(2);
            }
            return schemaControl;
        }

        @Override
        @NotNull
        public Dbms getDbms() {
            Dbms dbms = this.myDelegate.getDbms();
            if (dbms == null) {
                Adapter.$$$reportNull$$$0(3);
            }
            return dbms;
        }

        @Override
        public boolean isReadOnly() {
            return this.myDelegate.isReadOnly();
        }

        @Override
        public int getTxIsolation() {
            return this.myDelegate.getTxIsolation();
        }

        @Override
        public boolean isAutoCommit() {
            return this.myDelegate.isAutoCommit();
        }

        @Override
        @NotNull
        public LocalDataSource getDataSource() {
            LocalDataSource localDataSource = this.myDelegate.getDataSource();
            if (localDataSource == null) {
                Adapter.$$$reportNull$$$0(4);
            }
            return localDataSource;
        }

        @Override
        @NotNull
        public DatabaseConnectionConfig getMutableConfig() {
            DatabaseConnectionConfig databaseConnectionConfig = this.myDelegate.getMutableConfig();
            if (databaseConnectionConfig == null) {
                Adapter.$$$reportNull$$$0(5);
            }
            return databaseConnectionConfig;
        }

        @Override
        @Nullable
        public String getAdditionalProperty(@NotNull String name) {
            if (name == null) {
                Adapter.$$$reportNull$$$0(6);
            }
            return this.myDelegate.getAdditionalProperty(name);
        }

        @Override
        @NotNull
        public Set<String> getAdditionalPropertiesNames() {
            Set<String> set = this.myDelegate.getAdditionalPropertiesNames();
            if (set == null) {
                Adapter.$$$reportNull$$$0(7);
            }
            return set;
        }

        @Override
        public DatabaseDriver getDatabaseDriver() {
            return this.myDelegate.getDatabaseDriver();
        }

        public String getName() {
            return this.myDelegate.getName();
        }

        public String getDriverClass() {
            return this.myDelegate.getDriverClass();
        }

        public String getUrl() {
            return this.myDelegate.getUrl();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 6 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dataSource/DatabaseConnectionPoint$Adapter";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAuthProviderId";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConnectionProperties";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSchemaControl";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDbms";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDataSource";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMutableConfig";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dataSource/DatabaseConnectionPoint$Adapter";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAdditionalPropertiesNames";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getAdditionalProperty";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 6 -> new IllegalArgumentException(string);
            };
        }
    }
}

