/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.connection.statements;

import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.connection.DGDepartment;
import com.intellij.database.dataSource.connection.DatabaseDepartment;
import com.intellij.database.dataSource.connection.statements.BatchInsertsStatement;
import com.intellij.database.dataSource.connection.statements.SmartStatementMark;
import com.intellij.database.dataSource.connection.statements.SmartStatementSource;
import com.intellij.database.remote.dbimport.BatchRecords;
import com.intellij.database.remote.dbimport.ErrorRecord;
import com.intellij.database.remote.jdbc.RemoteBatchPreparedStatement;
import com.intellij.database.remote.jdbc.RemoteStatement;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000K\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000*\u0001\n\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/database/dataSource/connection/statements/BatchInsertsStatement;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "statement", "Lcom/intellij/database/remote/jdbc/RemoteBatchPreparedStatement;", "connection", "Lcom/intellij/database/dataSource/DatabaseConnectionCore;", "<init>", "(Lcom/intellij/database/remote/jdbc/RemoteBatchPreparedStatement;Lcom/intellij/database/dataSource/DatabaseConnectionCore;)V", "mark", "com/intellij/database/dataSource/connection/statements/BatchInsertsStatement$mark$1", "Lcom/intellij/database/dataSource/connection/statements/BatchInsertsStatement$mark$1;", "cancelled", "", "addBatch", "", "Lcom/intellij/database/remote/dbimport/ErrorRecord;", "records", "Lcom/intellij/database/remote/dbimport/BatchRecords;", "sql", "", "getInsertedLinesCount", "", "close", "", "intellij.database.core.impl"})
public final class BatchInsertsStatement
implements AutoCloseable {
    @NotNull
    private final RemoteBatchPreparedStatement statement;
    @NotNull
    private final DatabaseConnectionCore connection;
    @NotNull
    private final mark.1 mark;
    private volatile boolean cancelled;

    public BatchInsertsStatement(@NotNull RemoteBatchPreparedStatement statement, @NotNull DatabaseConnectionCore connection) {
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        this.statement = statement;
        this.connection = connection;
        this.mark = new SmartStatementMark.RunnableMark(this){
            final /* synthetic */ BatchInsertsStatement this$0;
            {
                this.this$0 = $receiver;
            }

            public DatabaseDepartment getDepartment() {
                return DGDepartment.DATA_IMPORT;
            }

            public SmartStatementSource getSource() {
                return SmartStatementSource.SYSTEM;
            }

            public boolean cancel() {
                BatchInsertsStatement.access$setCancelled$p(this.this$0, true);
                return true;
            }
        };
        this.connection.getAuditService().statementOpened((RemoteStatement)this.statement, this.mark);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<ErrorRecord> addBatch(@NotNull BatchRecords records, @NotNull String sql) throws RemoteException, SQLException {
        Intrinsics.checkNotNullParameter((Object)records, (String)"records");
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
        if (this.cancelled) {
            throw new ProcessCanceledException();
        }
        try {
            this.connection.getAuditService().beforeSimpleStatement(sql, this.mark);
            List batch = (List)this.mark.run(() -> BatchInsertsStatement.addBatch$lambda$0(this, records, sql));
            int updateCount2 = records.getLinesCount() - batch.size();
            if (updateCount2 > 0) {
                this.connection.getAuditService().updateCount(updateCount2, this.mark);
            }
            Intrinsics.checkNotNull((Object)batch);
            List list = batch;
            return list;
        }
        finally {
            this.connection.getAuditService().afterStatement(this.mark);
            this.connection.getAuditService().resultsProcessed(this.mark);
        }
    }

    public final long getInsertedLinesCount() throws RemoteException {
        return this.statement.getInsertedLinesCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            this.connection.getAuditService().beforeStatementClosing((RemoteStatement)this.statement, this.mark);
        }
        finally {
            JdbcNativeUtil.closeRemoteStatementSafe((RemoteStatement)((RemoteStatement)this.statement));
        }
    }

    private static final List addBatch$lambda$0(BatchInsertsStatement this$0, BatchRecords $records, String $sql) {
        return this$0.statement.addBatch($records, $sql);
    }

    public static final /* synthetic */ void access$setCancelled$p(BatchInsertsStatement $this, boolean bl) {
        $this.cancelled = bl;
    }
}

