/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.model;

import com.intellij.gradle.toolingExtension.util.GradleVersionSpecificsUtil;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.gradle.tooling.internal.gradle.DefaultProjectIdentifier;
import org.gradle.tooling.model.ProjectIdentifier;
import org.gradle.tooling.model.gradle.BasicGradleProject;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.plugins.gradle.model.DefaultGradleLightBuild;
import org.jetbrains.plugins.gradle.model.GradleLightBuild;
import org.jetbrains.plugins.gradle.model.GradleLightProject;

@ApiStatus.Internal
public final class DefaultGradleLightProject
implements GradleLightProject,
Serializable {
    @NotNull
    private final DefaultGradleLightBuild myBuildModel;
    @NotNull
    private final String myName;
    @NotNull
    private final String myPath;
    @Nullable
    private final String myIdentityPath;
    @NotNull
    private final File myProjectDirectory;
    @NotNull
    private final DefaultProjectIdentifier myProjectIdentifier;
    @NotNull
    private final List<DefaultGradleLightProject> myChildren;

    public DefaultGradleLightProject(@NotNull DefaultGradleLightBuild buildModel, @NotNull BasicGradleProject gradleProject, @NotNull GradleVersion gradleVersion) {
        if (buildModel == null) {
            DefaultGradleLightProject.$$$reportNull$$$0(0);
        }
        if (gradleProject == null) {
            DefaultGradleLightProject.$$$reportNull$$$0(1);
        }
        if (gradleVersion == null) {
            DefaultGradleLightProject.$$$reportNull$$$0(2);
        }
        this.myChildren = new ArrayList<DefaultGradleLightProject>();
        this.myBuildModel = buildModel;
        this.myName = gradleProject.getName();
        this.myPath = gradleProject.getPath();
        this.myIdentityPath = GradleVersionSpecificsUtil.isBuildTreePathAvailable((GradleVersion)gradleVersion) ? gradleProject.getBuildTreePath() : null;
        this.myProjectDirectory = gradleProject.getProjectDirectory();
        this.myProjectIdentifier = new DefaultProjectIdentifier(gradleProject.getProjectIdentifier().getBuildIdentifier().getRootDir(), gradleProject.getProjectIdentifier().getProjectPath());
    }

    @NotNull
    public GradleLightBuild getBuild() {
        DefaultGradleLightBuild defaultGradleLightBuild = this.myBuildModel;
        if (defaultGradleLightBuild == null) {
            DefaultGradleLightProject.$$$reportNull$$$0(3);
        }
        return defaultGradleLightBuild;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            DefaultGradleLightProject.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getPath() {
        String string = this.myPath;
        if (string == null) {
            DefaultGradleLightProject.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String getIdentityPath() {
        if (this.myIdentityPath != null) {
            String string = this.myIdentityPath;
            if (string == null) {
                DefaultGradleLightProject.$$$reportNull$$$0(6);
            }
            return string;
        }
        return DefaultGradleLightProject.getProjectIdentityPath(this);
    }

    @VisibleForTesting
    @NotNull
    public static String getProjectIdentityPath(@NotNull GradleLightProject project) {
        String buildIdentityPath;
        if (project == null) {
            DefaultGradleLightProject.$$$reportNull$$$0(7);
        }
        if ((buildIdentityPath = DefaultGradleLightProject.getBuildIdentityPath(project.getBuild())).equals(":")) {
            String string = project.getPath();
            if (string == null) {
                DefaultGradleLightProject.$$$reportNull$$$0(8);
            }
            return string;
        }
        if (project.getPath().equals(":")) {
            String string = buildIdentityPath;
            if (string == null) {
                DefaultGradleLightProject.$$$reportNull$$$0(9);
            }
            return string;
        }
        String string = buildIdentityPath + project.getPath();
        if (string == null) {
            DefaultGradleLightProject.$$$reportNull$$$0(10);
        }
        return string;
    }

    private static String getBuildIdentityPath(@NotNull GradleLightBuild build) {
        GradleLightBuild parentBuild;
        if (build == null) {
            DefaultGradleLightProject.$$$reportNull$$$0(11);
        }
        if ((parentBuild = build.getParentBuild()) == null) {
            return ":";
        }
        String parentIdentityPath = DefaultGradleLightProject.getBuildIdentityPath(parentBuild);
        if (parentIdentityPath.equals(":")) {
            return ":" + build.getName();
        }
        return parentIdentityPath + ":" + build.getName();
    }

    @NotNull
    public File getProjectDirectory() {
        File file = this.myProjectDirectory;
        if (file == null) {
            DefaultGradleLightProject.$$$reportNull$$$0(12);
        }
        return file;
    }

    @NotNull
    public ProjectIdentifier getProjectIdentifier() {
        DefaultProjectIdentifier defaultProjectIdentifier = this.myProjectIdentifier;
        if (defaultProjectIdentifier == null) {
            DefaultGradleLightProject.$$$reportNull$$$0(13);
        }
        return defaultProjectIdentifier;
    }

    @NotNull
    public List<DefaultGradleLightProject> getChildProjects() {
        List<DefaultGradleLightProject> list = this.myChildren;
        if (list == null) {
            DefaultGradleLightProject.$$$reportNull$$$0(14);
        }
        return list;
    }

    public void addChildProject(@NotNull DefaultGradleLightProject childProject) {
        if (childProject == null) {
            DefaultGradleLightProject.$$$reportNull$$$0(15);
        }
        this.myChildren.add(childProject);
    }

    public String toString() {
        return "ProjectModel{name='" + this.myName + '\'' + ", id=" + this.myProjectIdentifier + '}';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildModel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleProject";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gradleVersion";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/model/DefaultGradleLightProject";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "build";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/model/DefaultGradleLightProject";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuild";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getIdentityPath";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectIdentityPath";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectDirectory";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectIdentifier";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildProjects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getProjectIdentityPath";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getBuildIdentityPath";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addChildProject";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

