/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.hprof.visitors;

import com.intellij.diagnostic.hprof.classstore.ClassDefinition;
import com.intellij.diagnostic.hprof.parser.ConstantPoolEntry;
import com.intellij.diagnostic.hprof.parser.HProfVisitor;
import com.intellij.diagnostic.hprof.parser.HeapDumpRecordType;
import com.intellij.diagnostic.hprof.parser.InstanceFieldEntry;
import com.intellij.diagnostic.hprof.parser.RecordType;
import com.intellij.diagnostic.hprof.parser.StaticFieldEntry;
import com.intellij.diagnostic.hprof.parser.Type;
import com.intellij.profiler.ultimate.hprof.impl.HprofClass;
import com.intellij.profiler.ultimate.hprof.impl.HprofDump;
import com.intellij.profiler.ultimate.hprof.visitors.ClassVisitorKt;
import it.unimi.dsi.fastutil.longs.Long2LongOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010)\u001a\u0004\u0018\u00010\u00042\u0006\u0010*\u001a\u00020\u0014J\u0010\u0010+\u001a\u0004\u0018\u00010\u00042\u0006\u0010,\u001a\u00020\u0014J\u0010\u0010-\u001a\u0004\u0018\u00010\u00042\u0006\u0010,\u001a\u00020\u0014J\u0013\u0010.\u001a\u0004\u0018\u00010\u000f2\u0006\u0010,\u001a\u00020\u0014H\u0086\u0002J\u0016\u0010/\u001a\u0002002\u0006\u0010,\u001a\u00020\u00142\u0006\u00101\u001a\u000200J\u0016\u00102\u001a\u0002002\u0006\u0010,\u001a\u00020\u00142\u0006\u00103\u001a\u00020\u0014J\u0014\u00104\u001a\b\u0012\u0004\u0012\u000206052\u0006\u0010,\u001a\u00020\u0014J\u0014\u00107\u001a\b\u0012\u0004\u0012\u00020\u000f052\u0006\u0010,\u001a\u00020\u0014J \u00108\u001a\u0002092\u0018\u0010:\u001a\u0014\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u0002090;J\b\u0010<\u001a\u000209H\u0016J\u0018\u0010=\u001a\u0002092\u0006\u0010>\u001a\u00020\u00142\u0006\u0010?\u001a\u00020\u0004H\u0016J(\u0010@\u001a\u0002092\u0006\u0010A\u001a\u00020\u00142\u0006\u0010B\u001a\u00020\u00142\u0006\u0010C\u001a\u00020\u00142\u0006\u0010D\u001a\u00020\u0014H\u0016J_\u0010E\u001a\u0002092\u0006\u0010,\u001a\u00020\u00142\u0006\u0010F\u001a\u00020\u00142\u0006\u00103\u001a\u00020\u00142\u0006\u0010G\u001a\u00020\u00142\u0006\u0010H\u001a\u00020\u00142\f\u0010I\u001a\b\u0012\u0004\u0012\u00020K0J2\f\u0010L\u001a\b\u0012\u0004\u0012\u00020M0J2\f\u0010N\u001a\b\u0012\u0004\u0012\u0002060JH\u0016\u00a2\u0006\u0002\u0010OJ\b\u0010P\u001a\u000209H\u0016J\u000e\u0010Q\u001a\u00020\u00142\u0006\u0010R\u001a\u00020&R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u00020\u00140\u0013j\b\u0012\u0004\u0012\u00020\u0014`\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0014@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001e\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0014@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0019R\u001e\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0014@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0019R\u001e\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0014@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0019R\u001e\u0010 \u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0014@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0019R\u001e\u0010\"\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0014@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0019R\u001a\u0010$\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020\u00140%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006S"}, d2={"Lcom/intellij/profiler/ultimate/hprof/visitors/ClassVisitor;", "Lcom/intellij/diagnostic/hprof/parser/HProfVisitor;", "stringIdMap", "Lit/unimi/dsi/fastutil/longs/Long2ObjectMap;", "", "dump", "Lcom/intellij/profiler/ultimate/hprof/impl/HprofDump;", "<init>", "(Lit/unimi/dsi/fastutil/longs/Long2ObjectMap;Lcom/intellij/profiler/ultimate/hprof/impl/HprofDump;)V", "getDump", "()Lcom/intellij/profiler/ultimate/hprof/impl/HprofDump;", "classIdToStringIdMap", "Lit/unimi/dsi/fastutil/longs/Long2LongOpenHashMap;", "classes", "Lit/unimi/dsi/fastutil/longs/Long2ObjectOpenHashMap;", "Lcom/intellij/profiler/ultimate/hprof/impl/HprofClass;", "getClasses", "()Lit/unimi/dsi/fastutil/longs/Long2ObjectOpenHashMap;", "referenceClasses", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "value", "idOfStringClass", "getIdOfStringClass", "()J", "idOfThreadClass", "getIdOfThreadClass", "idOfClassClass", "getIdOfClassClass", "idOfObjectClass", "getIdOfObjectClass", "idOfClassLoaderClass", "getIdOfClassLoaderClass", "idOfPropertiesClass", "getIdOfPropertiesClass", "primitiveArrayToClass", "", "Lcom/intellij/diagnostic/hprof/parser/Type;", "classLoaderToClasses", "Lit/unimi/dsi/fastutil/longs/LongSet;", "getObjectString", "objectId", "getClassString", "classId", "getPrettyName", "get", "isReferenceClass", "", "includeSubtypes", "isSubclassOf", "superClassId", "collectInstanceFields", "", "Lcom/intellij/diagnostic/hprof/parser/InstanceFieldEntry;", "getClassHierarchy", "forEachClass", "", "consumer", "Lkotlin/Function2;", "preVisit", "visitStringInUTF8", "id", "s", "visitLoadClass", "classSerialNumber", "classObjectId", "stackSerialNumber", "classNameStringId", "visitClassDump", "stackTraceSerialNumber", "classloaderClassId", "instanceSize", "constants", "", "Lcom/intellij/diagnostic/hprof/parser/ConstantPoolEntry;", "staticFields", "Lcom/intellij/diagnostic/hprof/parser/StaticFieldEntry;", "instanceFields", "(JJJJJ[Lcom/intellij/diagnostic/hprof/parser/ConstantPoolEntry;[Lcom/intellij/diagnostic/hprof/parser/StaticFieldEntry;[Lcom/intellij/diagnostic/hprof/parser/InstanceFieldEntry;)V", "postVisit", "getClassForType", "type", "intellij.profiler.ultimate"})
@SourceDebugExtension(value={"SMAP\nClassVisitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassVisitor.kt\ncom/intellij/profiler/ultimate/hprof/visitors/ClassVisitor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,200:1\n1#2:201\n13805#3,2:202\n*S KotlinDebug\n*F\n+ 1 ClassVisitor.kt\ncom/intellij/profiler/ultimate/hprof/visitors/ClassVisitor\n*L\n78#1:202,2\n*E\n"})
public final class ClassVisitor
extends HProfVisitor {
    @NotNull
    private final Long2ObjectMap<String> stringIdMap;
    @NotNull
    private final HprofDump dump;
    @NotNull
    private final Long2LongOpenHashMap classIdToStringIdMap;
    @NotNull
    private final Long2ObjectOpenHashMap<HprofClass> classes;
    @NotNull
    private final HashSet<Long> referenceClasses;
    private long idOfStringClass;
    private long idOfThreadClass;
    private long idOfClassClass;
    private long idOfObjectClass;
    private long idOfClassLoaderClass;
    private long idOfPropertiesClass;
    @NotNull
    private final Map<Type, Long> primitiveArrayToClass;
    @NotNull
    private final Long2ObjectOpenHashMap<LongSet> classLoaderToClasses;

    public ClassVisitor(@NotNull Long2ObjectMap<String> stringIdMap, @NotNull HprofDump dump) {
        Intrinsics.checkNotNullParameter(stringIdMap, (String)"stringIdMap");
        Intrinsics.checkNotNullParameter((Object)dump, (String)"dump");
        this.stringIdMap = stringIdMap;
        this.dump = dump;
        this.classIdToStringIdMap = new Long2LongOpenHashMap();
        this.classes = new Long2ObjectOpenHashMap();
        this.referenceClasses = new HashSet();
        this.idOfStringClass = -1L;
        this.idOfThreadClass = -1L;
        this.idOfClassClass = -1L;
        this.idOfObjectClass = -1L;
        this.idOfClassLoaderClass = -1L;
        this.idOfPropertiesClass = -1L;
        this.primitiveArrayToClass = new LinkedHashMap();
        this.classLoaderToClasses = new Long2ObjectOpenHashMap();
    }

    @NotNull
    public final HprofDump getDump() {
        return this.dump;
    }

    @NotNull
    public final Long2ObjectOpenHashMap<HprofClass> getClasses() {
        return this.classes;
    }

    public final long getIdOfStringClass() {
        return this.idOfStringClass;
    }

    public final long getIdOfThreadClass() {
        return this.idOfThreadClass;
    }

    public final long getIdOfClassClass() {
        return this.idOfClassClass;
    }

    public final long getIdOfObjectClass() {
        return this.idOfObjectClass;
    }

    public final long getIdOfClassLoaderClass() {
        return this.idOfClassLoaderClass;
    }

    public final long getIdOfPropertiesClass() {
        return this.idOfPropertiesClass;
    }

    @Nullable
    public final String getObjectString(long objectId) {
        return (String)this.stringIdMap.get(objectId);
    }

    @Nullable
    public final String getClassString(long classId) {
        long index = this.classIdToStringIdMap.get(classId);
        return index >= 0L ? this.getObjectString(index) : null;
    }

    @Nullable
    public final String getPrettyName(long classId) {
        String string;
        String string2 = this.getClassString(classId);
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            string = ClassDefinition.Companion.computePrettyName(StringsKt.replace$default((String)it, (char)'/', (char)'.', (boolean)false, (int)4, null));
        } else {
            string = null;
        }
        return string;
    }

    @Nullable
    public final HprofClass get(long classId) {
        return (HprofClass)this.classes.get(classId);
    }

    public final boolean isReferenceClass(long classId, boolean includeSubtypes) {
        if (includeSubtypes) {
            return this.referenceClasses.contains(classId);
        }
        return CollectionsKt.contains((Iterable)ClassVisitorKt.access$getSPECIAL_REFS$p(), (Object)this.getClassString(classId));
    }

    public final boolean isSubclassOf(long classId, long superClassId) {
        HprofClass info = (HprofClass)this.classes.get(classId);
        while (info != null) {
            if (info.getSuperClassId() == superClassId) {
                return true;
            }
            info = (HprofClass)this.classes.get(info.getSuperClassId());
        }
        return false;
    }

    @NotNull
    public final List<InstanceFieldEntry> collectInstanceFields(long classId) {
        ArrayList<InstanceFieldEntry> fields = new ArrayList<InstanceFieldEntry>(20);
        HprofClass info = (HprofClass)this.classes.get(classId);
        while (info != null) {
            InstanceFieldEntry[] $this$forEach$iv = info.getInstanceFields();
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                InstanceFieldEntry element$iv;
                InstanceFieldEntry it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                fields.add(it);
            }
            info = (HprofClass)this.classes.get(info.getSuperClassId());
        }
        return fields;
    }

    @NotNull
    public final List<HprofClass> getClassHierarchy(long classId) {
        HprofClass info;
        HprofClass hprofClass = info = (HprofClass)this.classes.get(classId);
        boolean bl = hprofClass != null ? hprofClass.getClassId() == this.idOfClassClass : false;
        if (bl) {
            return CollectionsKt.listOf((Object)info);
        }
        ArrayList<HprofClass> classes = new ArrayList<HprofClass>(10);
        while (info != null) {
            classes.add(info);
            info = (HprofClass)this.classes.get(info.getSuperClassId());
        }
        return classes;
    }

    public final void forEachClass(@NotNull Function2<? super Long, ? super HprofClass, Unit> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        ObjectIterator objectIterator = Long2ObjectMaps.fastIterable((Long2ObjectMap)((Long2ObjectMap)this.classes)).iterator();
        Intrinsics.checkNotNullExpressionValue((Object)objectIterator, (String)"iterator(...)");
        ObjectIterator objectIterator2 = objectIterator;
        while (objectIterator2.hasNext()) {
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)objectIterator2.next();
            Long l = entry.getLongKey();
            Object object = entry.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-value>(...)");
            consumer.invoke((Object)l, object);
        }
    }

    public void preVisit() {
        this.disableAll();
        this.enable(RecordType.StringInUTF8);
        this.enable(RecordType.LoadClass);
        this.enable(RecordType.HeapDumpSegment);
        this.enable(HeapDumpRecordType.ClassDump);
    }

    public void visitStringInUTF8(long id, @NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        this.stringIdMap.put(id, (Object)s);
    }

    public void visitLoadClass(long classSerialNumber, long classObjectId, long stackSerialNumber, long classNameStringId) {
        this.classIdToStringIdMap.put(classObjectId, classNameStringId);
    }

    public void visitClassDump(long classId, long stackTraceSerialNumber, long superClassId, long classloaderClassId, long instanceSize, @NotNull ConstantPoolEntry[] constants, @NotNull StaticFieldEntry[] staticFields, @NotNull InstanceFieldEntry[] instanceFields) {
        String name;
        Intrinsics.checkNotNullParameter((Object)constants, (String)"constants");
        Intrinsics.checkNotNullParameter((Object)staticFields, (String)"staticFields");
        Intrinsics.checkNotNullParameter((Object)instanceFields, (String)"instanceFields");
        this.classes.put(classId, (Object)new HprofClass(classId, stackTraceSerialNumber, superClassId, classloaderClassId, instanceSize, constants, staticFields, instanceFields, 0L, null, this.dump, 768, null));
        ((LongSet)this.classLoaderToClasses.computeIfAbsent(classloaderClassId, ClassVisitor::visitClassDump$lambda$0)).add(classId);
        String string = this.getClassString(classId);
        Intrinsics.checkNotNull((Object)string);
        switch (name = string) {
            case "java/lang/String": 
            case "java.lang.String": {
                this.idOfStringClass = classId;
                break;
            }
            case "java.lang.Thread": 
            case "java/lang/Thread": {
                this.idOfThreadClass = classId;
                break;
            }
            case "java.lang.Class": 
            case "java/lang/Class": {
                this.idOfClassClass = classId;
                break;
            }
            case "java/lang/Object": 
            case "java.lang.Object": {
                this.idOfObjectClass = classId;
                break;
            }
            case "java.lang.ClassLoader": 
            case "java/lang/ClassLoader": {
                this.idOfClassLoaderClass = classId;
                break;
            }
            case "java/util/Properties": 
            case "java.lang.Properties": {
                this.idOfPropertiesClass = classId;
            }
        }
        if (name.length() == 2 && name.charAt(0) == '[' && name.charAt(1) != '[' && name.charAt(1) != 'L') {
            String string2 = name.substring(0, 2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            this.primitiveArrayToClass.put(Type.Companion.getType(string2), classId);
        }
    }

    public void postVisit() {
        HprofClass hprofClass = this.get(this.idOfClassClass);
        Intrinsics.checkNotNull((Object)hprofClass);
        HprofClass classInfo = hprofClass;
        this.forEachClass((Function2<? super Long, ? super HprofClass, Unit>)((Function2)(arg_0, arg_1) -> ClassVisitor.postVisit$lambda$0(classInfo, this, arg_0, arg_1)));
    }

    public final long getClassForType(@NotNull Type type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Long l = this.primitiveArrayToClass.get(type);
        if (l == null) {
            throw new AssertionError((Object)"Should contains any type");
        }
        return l;
    }

    private static final LongOpenHashSet visitClassDump$lambda$0(long it) {
        return new LongOpenHashSet();
    }

    private static final Unit postVisit$lambda$0(HprofClass $classInfo, ClassVisitor this$0, long l, HprofClass info) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        long l2 = $classInfo.getSoftRefCount();
        $classInfo.setSoftRefCount(l2 + 1L);
        HprofClass cur = info;
        while (cur != null) {
            String fqn = this$0.getClassString(cur.getClassId());
            if (Intrinsics.areEqual((Object)fqn, (Object)"java/lang/ClassLoader") || Intrinsics.areEqual((Object)fqn, (Object)"java.lang.Classloader")) {
                this$0.classLoaderToClasses.computeIfAbsent(info.getClassId(), ClassVisitor::postVisit$lambda$0$0);
                break;
            }
            if (CollectionsKt.contains((Iterable)ClassVisitorKt.access$getSPECIAL_REFS$p(), (Object)fqn)) {
                this$0.referenceClasses.add(info.getClassId());
                break;
            }
            cur = (HprofClass)this$0.classes.get(cur.getSuperClassId());
        }
        return Unit.INSTANCE;
    }

    private static final LongOpenHashSet postVisit$lambda$0$0(long it) {
        return new LongOpenHashSet();
    }
}

