/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.internal.parser.v0.factories;

import org.openjdk.jmc.common.IMCType;
import org.openjdk.jmc.common.unit.ContentType;
import org.openjdk.jmc.common.unit.UnitLookup;
import org.openjdk.jmc.common.util.MethodToolkit;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.factories.IPoolFactory;
import org.openjdk.jmc.flightrecorder.internal.parser.v0.model.ValueDescriptor;
import org.openjdk.jmc.flightrecorder.internal.util.CanonicalConstantMap;

final class TypeFactory
implements IPoolFactory<IMCType> {
    private final int m_nameIndex;
    private final CanonicalConstantMap<IMCType> typeMap;

    public TypeFactory(ValueDescriptor[] descriptors, CanonicalConstantMap<IMCType> typeMap) {
        this.typeMap = typeMap;
        this.m_nameIndex = ValueDescriptor.getIndex(descriptors, "name");
    }

    @Override
    public IMCType createObject(long identifier, Object s) {
        String refType;
        Object[] o = (Object[])s;
        if (identifier == 0L && s == null) {
            return null;
        }
        if (this.m_nameIndex != -1 && o != null && (refType = (String)o[this.m_nameIndex]) != null) {
            return this.typeMap.canonicalize(MethodToolkit.typeFromReference(refType));
        }
        return null;
    }

    @Override
    public ContentType<IMCType> getContentType() {
        return UnitLookup.CLASS;
    }
}

