/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor.markdown;

import com.intellij.jupyter.core.jupyter.editor.markdown.JupyterMarkdownFlagKt;
import com.intellij.jupyter.core.jupyter.editor.markdown.MarkdownEditorCellViewComponent;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.notebooks.jupyter.core.jupyter.CellType;
import com.intellij.notebooks.visualization.EditorCellInputFactory;
import com.intellij.notebooks.visualization.ui.EditorCell;
import com.intellij.notebooks.visualization.ui.EditorCellViewComponent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.util.registry.Registry;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/markdown/JupyterMarkdownInputFactory;", "Lcom/intellij/notebooks/visualization/EditorCellInputFactory;", "<init>", "()V", "createComponent", "Lcom/intellij/notebooks/visualization/ui/EditorCellViewComponent;", "cell", "Lcom/intellij/notebooks/visualization/ui/EditorCell;", "supports", "", "intellij.jupyter.core"})
public final class JupyterMarkdownInputFactory
implements EditorCellInputFactory {
    @NotNull
    public EditorCellViewComponent createComponent(@NotNull EditorCell cell) {
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        boolean foldingEnabled = cell.getEditor().getEditorKind() != EditorKind.DIFF && Registry.Companion.is("jupyter.editor.folding.heading");
        return new MarkdownEditorCellViewComponent(cell, foldingEnabled);
    }

    public boolean supports(@NotNull EditorCell cell) {
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        return JupyterEditorExtensionsKt.isJupyter((Editor)cell.getEditor()) && JupyterMarkdownFlagKt.getJupyterMarkdownEnabled() && cell.getEditor().getEditorKind() != EditorKind.DIFF && cell.getType() == CellType.MARKDOWN;
    }
}

