/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.web.module.view.web.viewlets;

import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.impl.ui.FacetEditorContextBase;
import com.intellij.facet.ui.FacetEditorContext;
import com.intellij.javaee.facet.JavaeeFacetConfiguration;
import com.intellij.javaee.web.WebRoot;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class WebResourceDirectoriesInfo {
    private static final Key<WebResourceDirectoriesInfo> DIRECTORIES_INFO_KEY = Key.create((String)"web_resource_directories");
    private final Map<String, FacetConfiguration> myUsedUrls = new HashMap<String, FacetConfiguration>();

    public static WebResourceDirectoriesInfo getDirectoriesInfo(FacetEditorContext context) {
        UserDataHolder moduleData = ((FacetEditorContextBase)context).getSharedModuleData();
        WebResourceDirectoriesInfo info = (WebResourceDirectoriesInfo)moduleData.getUserData(DIRECTORIES_INFO_KEY);
        if (info == null) {
            info = new WebResourceDirectoriesInfo();
            Module module = context.getModule();
            Collection webFacets = context.getFacetsProvider().getFacetsByType(module, WebFacet.ID);
            for (WebFacet webFacet : webFacets) {
                for (WebRoot webRoot : webFacet.getWebRoots()) {
                    info.put(webRoot.getDirectoryUrl(), webFacet.getConfiguration());
                }
            }
            moduleData.putUserData(DIRECTORIES_INFO_KEY, (Object)info);
        }
        return info;
    }

    public void put(String directoryUrl, FacetConfiguration configuration) {
        this.myUsedUrls.put(directoryUrl, configuration);
    }

    public boolean isAvailable(String url, JavaeeFacetConfiguration configuration) {
        return this.myUsedUrls.get(url) == null || this.myUsedUrls.get(url) == configuration;
    }

    public String suggestUrl(String baseUrl, JavaeeFacetConfiguration configuration) {
        Object url = baseUrl;
        int i = 2;
        while (!this.isAvailable((String)url, configuration)) {
            url = baseUrl + i;
            ++i;
        }
        this.put((String)url, (FacetConfiguration)configuration);
        return url;
    }
}

