/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.RepoStateException;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.util.io.FileUtil;
import git4idea.repo.GitRepositoryFiles;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lgit4idea/repo/GitSequencerTodoReader;", "", "<init>", "()V", "REVERT_COMMAND", "", "CHERRY_PICK_COMMAND", "charsToRead", "", "getTodoBasedState", "Lcom/intellij/dvcs/repo/Repository$State;", "gitFiles", "Lgit4idea/repo/GitRepositoryFiles;", "intellij.vcs.git"})
public final class GitSequencerTodoReader {
    @NotNull
    public static final GitSequencerTodoReader INSTANCE = new GitSequencerTodoReader();
    @NotNull
    private static final String REVERT_COMMAND = "revert";
    @NotNull
    private static final String CHERRY_PICK_COMMAND = "pick";
    private static final int charsToRead = Math.max(6, 4);

    private GitSequencerTodoReader() {
    }

    @Nullable
    public final Repository.State getTodoBasedState(@NotNull GitRepositoryFiles gitFiles) {
        Repository.State state;
        Intrinsics.checkNotNullParameter((Object)gitFiles, (String)"gitFiles");
        File file = gitFiles.getSequencerTodoFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getSequencerTodoFile(...)");
        File sequencerTodoFile = file;
        if (!sequencerTodoFile.exists()) {
            return null;
        }
        try {
            state = (Repository.State)DvcsUtil.tryOrThrow(() -> GitSequencerTodoReader.getTodoBasedState$lambda$0(sequencerTodoFile), (Object)sequencerTodoFile);
        }
        catch (RepoStateException repoStateException) {
            state = null;
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Repository.State getTodoBasedState$lambda$0(File $sequencerTodoFile) {
        Repository.State state;
        Object object = $sequencerTodoFile;
        Object object2 = Charsets.UTF_8;
        object = new InputStreamReader((InputStream)new FileInputStream((File)object), (Charset)object2);
        object2 = null;
        try {
            InputStreamReader reader = (InputStreamReader)object;
            boolean bl = false;
            char[] cArray = FileUtil.loadText((Reader)reader, (int)charsToRead);
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"loadText(...)");
            char[] cArray2 = cArray;
            String firstChars = new String(cArray2);
            state = StringsKt.startsWith$default((String)firstChars, (String)CHERRY_PICK_COMMAND, (boolean)false, (int)2, null) ? Repository.State.GRAFTING : (StringsKt.startsWith$default((String)firstChars, (String)REVERT_COMMAND, (boolean)false, (int)2, null) ? Repository.State.REVERTING : null);
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
        return state;
    }
}

