/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger;

import com.intellij.javascript.debugger.ChromeEvaluator;
import com.intellij.javascript.debugger.JSDebuggerSupportUtils;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.JavaScriptDebuggerViewSupportKt;
import com.intellij.javascript.debugger.MemberFilterVisitor;
import com.intellij.javascript.debugger.NavigatableVariable;
import com.intellij.javascript.debugger.NavigatableVariableBackedPsiElement;
import com.intellij.javascript.debugger.scripts.VmScriptFile;
import com.intellij.javascript.debugger.scripts.VmScriptFileSystemKt;
import com.intellij.javascript.debugger.settings.JavaScriptDebuggerSettings;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.impl.JSUseScopeProvider;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.css.impl.util.CssHighlighter;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.Url;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XInlineDebuggerDataCallback;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XNavigatable;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Obsolescent;
import org.jetbrains.concurrency.ObsolescentConsumer;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.BasicDebuggerViewSupport;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.DebugEventListener;
import org.jetbrains.debugger.DebuggerSupportUtils;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.EvaluateResult;
import org.jetbrains.debugger.MemberFilter;
import org.jetbrains.debugger.PresentationProvider;
import org.jetbrains.debugger.RejectErrorReporter;
import org.jetbrains.debugger.Scope;
import org.jetbrains.debugger.ScopeType;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.SourceInfo;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.VariableContext;
import org.jetbrains.debugger.VariableImpl;
import org.jetbrains.debugger.VariableView;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.frame.CallFrameView;
import org.jetbrains.debugger.values.ObjectValue;
import org.jetbrains.debugger.values.PrimitiveValue;
import org.jetbrains.debugger.values.Value;
import org.jetbrains.debugger.values.ValueType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00c2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0013\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J(\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$H\u0016J\u001c\u0010%\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010&\u001a\u00020'H\u0016J,\u0010%\u001a\u0004\u0018\u00010\u00172\b\u0010(\u001a\u0004\u0018\u00010 2\u0006\u0010)\u001a\u00020 2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020+H\u0016J,\u0010%\u001a\u0004\u0018\u00010\u00172\b\u0010(\u001a\u0004\u0018\u00010 2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020+H\u0016J\u0010\u0010-\u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\"H\u0016J0\u0010.\u001a\u00020/2\u0006\u00100\u001a\u0002012\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0016J>\u00106\u001a\u00020\u000e2\u0006\u00107\u001a\u0002012\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u0002052\f\u00108\u001a\b\u0012\u0004\u0012\u00020 09H\u0014J0\u0010:\u001a\u00020/2\u0006\u00100\u001a\u00020;2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0016J\u0010\u0010<\u001a\u00020=2\u0006\u0010&\u001a\u00020>H\u0016J\u001e\u0010?\u001a\u0004\u0018\u00010;2\b\u00100\u001a\u0004\u0018\u00010;2\b\u0010@\u001a\u0004\u0018\u00010 H\u0016J\u0018\u0010A\u001a\u00020\u000e2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J2\u0010B\u001a\u00020/2\u0006\u0010\u001f\u001a\u00020 2\b\u00100\u001a\u0004\u0018\u00010;2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010C\u001a\u00020DH\u0016J\u001a\u0010E\u001a\u0004\u0018\u00010F2\u0006\u0010G\u001a\u00020 2\u0006\u0010\u001b\u001a\u00020\u001cH\u0003J\u0010\u0010H\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\u001c\u0010I\u001a\b\u0012\u0004\u0012\u00020J0\u000b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010K\u001a\u00020\u000eJ$\u0010L\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010M\u001a\u00020'2\u0006\u00102\u001a\u00020NH\u0016J&\u0010O\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000b2\u0006\u0010M\u001a\u00020'2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u00102\u001a\u00020NH\u0002R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006P"}, d2={"Lcom/intellij/javascript/debugger/JavaScriptDebuggerViewSupport;", "Lorg/jetbrains/debugger/BasicDebuggerViewSupport;", "debugProcess", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "<init>", "(Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;)V", "getDebugProcess", "()Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "scopeToMemberFilter", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/jetbrains/debugger/Scope;", "Lorg/jetbrains/concurrency/Promise;", "Lorg/jetbrains/debugger/MemberFilter;", "showGetterAndSetterFunctions", "", "getShowGetterAndSetterFunctions", "()Z", "vm", "Lorg/jetbrains/debugger/Vm;", "getVm", "()Lorg/jetbrains/debugger/Vm;", "isInLibraryContent", "sourceInfo", "Lorg/jetbrains/debugger/SourceInfo;", "script", "Lorg/jetbrains/debugger/Script;", "getMemberFilter", "context", "Lorg/jetbrains/debugger/VariableContext;", "computeInlineDebuggerData", "Lcom/intellij/util/ThreeState;", "name", "", "variable", "Lorg/jetbrains/debugger/Variable;", "callback", "Lcom/intellij/xdebugger/frame/XInlineDebuggerDataCallback;", "getSourceInfo", "frame", "Lorg/jetbrains/debugger/CallFrame;", "functionName", "scriptUrl", "line", "", "column", "isMemberVisible", "computeObjectPresentation", "", "value", "Lorg/jetbrains/debugger/values/ObjectValue;", "node", "Lcom/intellij/xdebugger/frame/XValueNode;", "icon", "Ljavax/swing/Icon;", "computeObjectSpecificPresentation", "objectValue", "propertiesToShow", "", "computeArrayPresentation", "Lorg/jetbrains/debugger/values/Value;", "createFrameEvaluator", "Lcom/intellij/javascript/debugger/ChromeEvaluator;", "Lorg/jetbrains/debugger/frame/CallFrameView;", "transformErrorOnGetUsedReferenceValue", "error", "canNavigateToSource", "computeSourcePosition", "navigatable", "Lcom/intellij/xdebugger/frame/XNavigatable;", "getVariable", "Lcom/intellij/lang/javascript/psi/JSVariable;", "variableSourceName", "rawNameToSource", "getFileByUrlOrVmSource", "Lcom/intellij/openapi/vfs/VirtualFile;", "tryToResolveByUrl", "computeReceiverVariable", "callFrame", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "computeReceiverVariableUsingEvaluate", "intellij.javascript.debugger.backend"})
@SourceDebugExtension(value={"SMAP\nJavaScriptDebuggerViewSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaScriptDebuggerViewSupport.kt\ncom/intellij/javascript/debugger/JavaScriptDebuggerViewSupport\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 promise.kt\norg/jetbrains/concurrency/Promises__PromiseKt\n*L\n1#1,382:1\n1#2:383\n110#3,3:384\n110#3,3:387\n148#3,3:390\n*S KotlinDebug\n*F\n+ 1 JavaScriptDebuggerViewSupport.kt\ncom/intellij/javascript/debugger/JavaScriptDebuggerViewSupport\n*L\n219#1:384,3\n344#1:387,3\n347#1:390,3\n*E\n"})
public class JavaScriptDebuggerViewSupport
extends BasicDebuggerViewSupport {
    @NotNull
    private final JavaScriptDebugProcess<?> debugProcess;
    @NotNull
    private final ConcurrentHashMap<Scope, Promise<MemberFilter>> scopeToMemberFilter;

    public JavaScriptDebuggerViewSupport(@NotNull JavaScriptDebugProcess<?> debugProcess) {
        Intrinsics.checkNotNullParameter(debugProcess, (String)"debugProcess");
        this.debugProcess = debugProcess;
        this.scopeToMemberFilter = new ConcurrentHashMap();
        this.debugProcess.getConnection().addDebugListener(new DebugEventListener(){

            public void resumed(Vm vm) {
                Intrinsics.checkNotNullParameter((Object)vm, (String)"vm");
                this.clear();
            }

            public void navigated(String newUrl) {
                Intrinsics.checkNotNullParameter((Object)newUrl, (String)"newUrl");
                this.clear();
            }

            private final void clear() {
                scopeToMemberFilter.clear();
            }
        });
    }

    @NotNull
    public final JavaScriptDebugProcess<?> getDebugProcess() {
        return this.debugProcess;
    }

    public boolean getShowGetterAndSetterFunctions() {
        return JavaScriptDebuggerSettings.getInstance().getShowGetterAndSetterFunctions();
    }

    @Nullable
    public Vm getVm() {
        return this.debugProcess.getMainVm();
    }

    public boolean isInLibraryContent(@NotNull SourceInfo sourceInfo, @Nullable Script script) {
        Intrinsics.checkNotNullParameter((Object)sourceInfo, (String)"sourceInfo");
        return this.debugProcess.isLibraryFile(script, sourceInfo);
    }

    @NotNull
    public Promise<MemberFilter> getMemberFilter(@NotNull VariableContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Scope scope = context.getScope();
        if (scope == null || scope.getType() != ScopeType.LOCAL || !(context.getParent() instanceof CallFrameView)) {
            return this.getDefaultMemberFilterPromise();
        }
        VariableContext variableContext = context.getParent();
        Intrinsics.checkNotNull((Object)variableContext, (String)"null cannot be cast to non-null type org.jetbrains.debugger.frame.CallFrameView");
        CallFrameView callFrameView = (CallFrameView)variableContext;
        SourceInfo sourceInfo = callFrameView.getSourcePosition();
        if (sourceInfo == null) {
            return this.getDefaultMemberFilterPromise();
        }
        SourceInfo position = sourceInfo;
        Promise<MemberFilter> result = this.scopeToMemberFilter.get(scope);
        if (result != null) {
            return result;
        }
        result = new MemberFilterVisitor(this, callFrameView).compute((XSourcePosition)position, (Promise<MemberFilter>)this.getDefaultMemberFilterPromise());
        Promise<MemberFilter> promise = this.scopeToMemberFilter.putIfAbsent(scope, result);
        if (promise == null) {
            promise = result;
        }
        return promise;
    }

    @NotNull
    public ThreeState computeInlineDebuggerData(@NotNull String name, @NotNull Variable variable, @NotNull VariableContext context, @NotNull XInlineDebuggerDataCallback callback2) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
        Value value = variable.getValue();
        if (value == null) {
            return ThreeState.NO;
        }
        Value value2 = value;
        ValueType valueType = value2.getType();
        if (value2 instanceof ObjectValue && ((charSequence = (CharSequence)((ObjectValue)value2).getClassName()) == null || charSequence.length() == 0) && ((charSequence = (CharSequence)value2.getValueString()) == null || charSequence.length() == 0) && JavaScriptDebuggerViewSupportKt.access$getPropertiesToShow().isEmpty()) {
            return ThreeState.NO;
        }
        if (!(variable instanceof NavigatableVariable) && valueType == ValueType.FUNCTION) {
            return ThreeState.NO;
        }
        BuildersKt.launch$default((CoroutineScope)this.debugProcess.getSessionScope(), (CoroutineContext)((CoroutineContext)new CoroutineName("computeInlineDebuggerData[" + name + "]")), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(variable, this, name, context, callback2, null){
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ Variable $variable;
            final /* synthetic */ JavaScriptDebuggerViewSupport this$0;
            final /* synthetic */ String $name;
            final /* synthetic */ VariableContext $context;
            final /* synthetic */ XInlineDebuggerDataCallback $callback;
            {
                this.$variable = $variable;
                this.this$0 = $receiver;
                this.$name = $name;
                this.$context = $context;
                this.$callback = $callback;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        xDebuggerUtil = XDebuggerUtil.getInstance();
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)xDebuggerUtil);
                        this.label = 1;
                        v0 = CoroutinesKt.readAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$0(org.jetbrains.debugger.Variable com.intellij.xdebugger.XDebuggerUtil com.intellij.javascript.debugger.JavaScriptDebuggerViewSupport java.lang.String org.jetbrains.debugger.VariableContext ), ()Ljava/util/List;)((Variable)this.$variable, (XDebuggerUtil)xDebuggerUtil, (JavaScriptDebuggerViewSupport)this.this$0, (String)this.$name, (VariableContext)this.$context), (Continuation)((Continuation)this));
                        if (v0 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl16
                    }
                    case 1: {
                        xDebuggerUtil = (XDebuggerUtil)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl16:
                        // 2 sources

                        positions = (List)v0;
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)xDebuggerUtil);
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)positions);
                        this.label = 2;
                        v1 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((List<? extends XSourcePosition>)positions, this.$callback, null){
                            int label;
                            final /* synthetic */ List<XSourcePosition> $positions;
                            final /* synthetic */ XInlineDebuggerDataCallback $callback;
                            {
                                this.$positions = $positions;
                                this.$callback = $callback;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             */
                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        void $this$forEach$iv;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Iterable iterable = CollectionsKt.filterNotNull((Iterable)this.$positions);
                                        XInlineDebuggerDataCallback xInlineDebuggerDataCallback = this.$callback;
                                        boolean $i$f$forEach = false;
                                        for (T element$iv : $this$forEach$iv) {
                                            XSourcePosition it = (XSourcePosition)element$iv;
                                            boolean bl = false;
                                            xInlineDebuggerDataCallback.computed(it);
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (v1 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl29
                    }
                    case 2: {
                        positions = (List)this.L$1;
                        xDebuggerUtil = (XDebuggerUtil)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl29:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            /*
             * WARNING - void declaration
             */
            private static final List invokeSuspend$lambda$0(Variable $variable, XDebuggerUtil $xDebuggerUtil, JavaScriptDebuggerViewSupport this$0, String $name, VariableContext $context) {
                XSourcePosition xSourcePosition;
                if ($variable instanceof NavigatableVariable) {
                    void $this$mapNotNullTo$iv$iv;
                    void $this$mapNotNull$iv;
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv;
                    PsiElement declarationElement;
                    Iterable position;
                    HashSet<Integer> lines = new HashSet<Integer>();
                    NavigatableVariableBackedPsiElement navigatableVariable = (NavigatableVariableBackedPsiElement)$variable;
                    PsiElement psiElement = navigatableVariable.getElementPointer().getElement();
                    if (psiElement instanceof JSReferenceExpression && (position = $xDebuggerUtil.createPositionByElement(declarationElement = JSDebuggerSupportUtils.resolve((PsiPolyVariantReference)psiElement))) != null && lines.add(position.getLine())) {
                        return CollectionsKt.listOf((Object)position);
                    }
                    position = navigatableVariable.getInlineReferences();
                    boolean $i$f$filter = false;
                    void var11_16 = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        SmartPsiElementPointer ref = (SmartPsiElementPointer)element$iv$iv;
                        boolean bl = false;
                        if (!(ref.getPsiRange() != null)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filter$iv = (List)destination$iv$iv;
                    boolean $i$f$mapNotNull = false;
                    $this$filterTo$iv$iv = $this$mapNotNull$iv;
                    destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        XSourcePosition it$iv$iv;
                        T element$iv$iv$iv;
                        T element$iv$iv = element$iv$iv$iv = iterator.next();
                        boolean bl = false;
                        SmartPsiElementPointer ref = (SmartPsiElementPointer)element$iv$iv;
                        boolean bl2 = false;
                        VirtualFile virtualFile = ref.getVirtualFile();
                        Segment segment = ref.getPsiRange();
                        Intrinsics.checkNotNull((Object)segment);
                        if ($xDebuggerUtil.createPositionByOffset(virtualFile, segment.getStartOffset()) == null) continue;
                        boolean bl3 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    List positions = (List)destination$iv$iv;
                    XSourcePosition currentPosition = this$0.getDebugProcess().getSession().getCurrentPosition();
                    if (currentPosition != null && positions.size() > 1) {
                        int debugLine = currentPosition.getLine();
                        int nearestLine = Integer.MAX_VALUE;
                        XSourcePosition bestPos = (XSourcePosition)positions.get(0);
                        for (XSourcePosition pos : positions) {
                            int distance = Math.abs(debugLine - pos.getLine());
                            if (distance >= nearestLine) continue;
                            nearestLine = distance;
                            bestPos = pos;
                        }
                        if (lines.add(bestPos.getLine())) {
                            return CollectionsKt.listOf((Object)bestPos);
                        }
                    } else {
                        List list;
                        List $this$invokeSuspend_u24lambda_u240_u242 = list = CollectionsKt.createListBuilder();
                        boolean bl = false;
                        for (XSourcePosition pos : positions) {
                            if (!lines.add(pos.getLine())) continue;
                            $this$invokeSuspend_u24lambda_u240_u242.add(pos);
                        }
                        return CollectionsKt.build((List)list);
                    }
                    return CollectionsKt.emptyList();
                }
                JSVariable jSVariable = JavaScriptDebuggerViewSupport.access$getVariable(this$0, $name, $context);
                if (jSVariable == null) {
                    return CollectionsKt.emptyList();
                }
                JSVariable variable = jSVariable;
                PsiElement navigationElement = variable.getNavigationElement();
                VirtualFile virtualFile = navigationElement.getContainingFile().getVirtualFile();
                if (virtualFile == null) {
                    return CollectionsKt.emptyList();
                }
                VirtualFile file = virtualFile;
                Document document = FileDocumentManager.getInstance().getDocument(file);
                if (document != null) {
                    Document it = document;
                    boolean bl = false;
                    xSourcePosition = $xDebuggerUtil.createPositionByOffset(file, navigationElement.getTextOffset());
                } else {
                    xSourcePosition = null;
                }
                XSourcePosition position = xSourcePosition;
                return CollectionsKt.listOf(position);
            }
        }), (int)2, null);
        return ThreeState.YES;
    }

    @Nullable
    public SourceInfo getSourceInfo(@Nullable Script script, @NotNull CallFrame frame) {
        SourceInfo sourceInfo;
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        Script script2 = script;
        if (script2 != null) {
            Script it = script2;
            boolean bl = false;
            sourceInfo = this.getSourceInfo(frame.getFunctionName(), it, frame.getLine(), frame.getColumn());
        } else {
            sourceInfo = null;
        }
        return sourceInfo;
    }

    @Nullable
    public SourceInfo getSourceInfo(@Nullable String functionName, @NotNull String scriptUrl, int line, int column) {
        SourceInfo sourceInfo;
        Intrinsics.checkNotNullParameter((Object)scriptUrl, (String)"scriptUrl");
        Vm vm = this.getVm();
        if (vm != null && (vm = vm.getScriptManager()) != null && (vm = vm.findScriptByUrl(scriptUrl)) != null) {
            Vm it = vm;
            boolean bl = false;
            sourceInfo = this.getSourceInfo(functionName, (Script)it, line, column);
        } else {
            sourceInfo = null;
        }
        return sourceInfo;
    }

    @Nullable
    public SourceInfo getSourceInfo(@Nullable String functionName, @NotNull Script script, int line, int column) {
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        return this.debugProcess.getSourceInfo(functionName, script, line, column);
    }

    public boolean isMemberVisible(@NotNull Variable variable) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        return super.isMemberVisible(variable) && JavaScriptDebuggerViewSupportKt.isVariableVisible(variable);
    }

    /*
     * WARNING - void declaration
     */
    public void computeObjectPresentation(@NotNull ObjectValue value, @NotNull Variable variable, @NotNull VariableContext context, @NotNull XValueNode node, @NotNull Icon icon) {
        void $this$onSuccess$iv;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        if (value instanceof PresentationProvider && ((PresentationProvider)value).computePresentation(node, icon)) {
            return;
        }
        if (value.getType() == ValueType.NODE) {
            String string = value.getValueString();
            Intrinsics.checkNotNull((Object)string);
            String string2 = string;
            node.setPresentation(icon, new XValuePresentation(string2){
                final /* synthetic */ String $string;
                {
                    this.$string = $string;
                }

                public void renderValue(XValuePresentation.XValueTextRenderer renderer) {
                    Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
                    int index = StringsKt.indexOf$default((CharSequence)this.$string, (char)'#', (int)0, (boolean)false, (int)6, null);
                    if (index > 0) {
                        String string = this.$string.substring(0, index);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        renderer.renderComment(string);
                        String string2 = this.$string.substring(index);
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                        renderer.renderValue(string2, CssHighlighter.CSS_IDENT);
                    } else {
                        renderer.renderComment(this.$string);
                    }
                }
            }, true);
            return;
        }
        if (!Intrinsics.areEqual((Object)value.getClassName(), (Object)value.getValueString())) {
            VariableView.Companion.setObjectPresentation(value, icon, node);
            return;
        }
        List propertiesToShow = JavaScriptDebuggerViewSupportKt.access$getPropertiesToShow();
        if (this.computeObjectSpecificPresentation(value, variable, context, node, icon, propertiesToShow)) {
            return;
        }
        if (propertiesToShow.isEmpty() || value.hasProperties() == ThreeState.NO) {
            VariableView.Companion.setObjectPresentation(value, icon, node);
            return;
        }
        Promise promise = value.getProperties(propertiesToShow, context.getEvaluateContext(), (Obsolescent)node);
        Obsolescent node$iv = (Obsolescent)node;
        boolean $i$f$onSuccess = false;
        Promise promise2 = $this$onSuccess$iv.onSuccess((Consumer)new ObsolescentConsumer<List<? extends Variable>>(node$iv, node, value, icon){
            final /* synthetic */ XValueNode $node$inlined;
            final /* synthetic */ ObjectValue $value$inlined;
            final /* synthetic */ Icon $icon$inlined;
            {
                this.$node$inlined = xValueNode;
                this.$value$inlined = objectValue;
                this.$icon$inlined = icon;
                super($node);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public void accept(Object param) {
                List it = (List)param;
                boolean bl = false;
                JavaScriptDebuggerViewSupportKt.doSetObjectPresentation(this.$node$inlined, it, this.$value$inlined, this.$icon$inlined);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)promise2, (String)"onSuccess(...)");
        XDebugSession xDebugSession = this.debugProcess.getSession();
        Intrinsics.checkNotNullExpressionValue((Object)xDebugSession, (String)"getSession(...)");
        promise2.onError((Consumer)new RejectErrorReporter(xDebugSession, null, 2, null));
    }

    protected boolean computeObjectSpecificPresentation(@NotNull ObjectValue objectValue, @NotNull Variable variable, @NotNull VariableContext context, @NotNull XValueNode node, @NotNull Icon icon, @NotNull List<String> propertiesToShow) {
        Intrinsics.checkNotNullParameter((Object)objectValue, (String)"objectValue");
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        Intrinsics.checkNotNullParameter(propertiesToShow, (String)"propertiesToShow");
        return false;
    }

    public void computeArrayPresentation(@NotNull Value value, @NotNull Variable variable, @NotNull VariableContext context, @NotNull XValueNode node, @NotNull Icon icon) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        VariableView.Companion.setArrayPresentation(value, context, icon, node);
    }

    @NotNull
    public ChromeEvaluator createFrameEvaluator(@NotNull CallFrameView frame) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        return new ChromeEvaluator((VariableContext)frame);
    }

    @Nullable
    public Value transformErrorOnGetUsedReferenceValue(@Nullable Value value, @Nullable String error) {
        return value instanceof ObjectValue && (Intrinsics.areEqual((Object)((ObjectValue)value).getClassName(), (Object)"TypeError") || Intrinsics.areEqual((Object)((ObjectValue)value).getClassName(), (Object)"ReferenceError")) ? (Value)PrimitiveValue.UNDEFINED : super.transformErrorOnGetUsedReferenceValue(value, error);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canNavigateToSource(@NotNull Variable variable, @NotNull VariableContext context) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (variable instanceof NavigatableVariable) {
            return (Boolean)ActionsKt.runReadAction(() -> JavaScriptDebuggerViewSupport.canNavigateToSource$lambda$0(variable));
        }
        Scope scope = context.getScope();
        if (scope == null) return false;
        if (scope.getType() != ScopeType.LOCAL && scope.getType() != ScopeType.CLOSURE) {
            if (scope.getType() != ScopeType.CATCH) return false;
        }
        if (!(context.getParent() instanceof CallFrameView)) return false;
        VariableContext variableContext = context.getParent();
        Intrinsics.checkNotNull((Object)variableContext, (String)"null cannot be cast to non-null type org.jetbrains.debugger.frame.CallFrameView");
        if (((CallFrameView)variableContext).getSourcePosition() == null) return false;
        return true;
    }

    public void computeSourcePosition(@NotNull String name, @Nullable Value value, @NotNull Variable variable, @NotNull VariableContext context, @NotNull XNavigatable navigatable) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)navigatable, (String)"navigatable");
            if (variable instanceof NavigatableVariable) {
                navigatable.setSourcePosition(((NavigatableVariable)variable).getSourcePosition());
                return;
            }
            JSVariable jSVariable = this.getVariable(name, context);
            if (jSVariable == null) break block1;
            JSVariable it = jSVariable;
            boolean bl = false;
            navigatable.setSourcePosition(DebuggerSupportUtils.calcSourcePosition((PsiElement)((PsiElement)it)));
        }
    }

    @RequiresReadLock
    private final JSVariable getVariable(String variableSourceName, VariableContext context) {
        PsiElement psiElement;
        VariableContext variableContext = context.getParent();
        CallFrameView callFrameView = variableContext instanceof CallFrameView ? (CallFrameView)variableContext : null;
        if (callFrameView == null || (callFrameView = callFrameView.getSourcePosition()) == null) {
            return null;
        }
        CallFrameView sourcePosition2 = callFrameView;
        VirtualFile virtualFile = sourcePosition2.getFile();
        int n = sourcePosition2.getOffset();
        Project project = this.debugProcess.getSession().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        PsiElement psiElement2 = JavaScriptDebuggerViewSupportKt.getContextElement(virtualFile, n, project);
        if (psiElement2 == null) {
            return null;
        }
        PsiElement contextElement = psiElement2;
        JSFunction jSFunction = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)contextElement, JSFunction.class);
        if (jSFunction != null) {
            psiElement = (PsiElement)jSFunction;
        } else {
            PsiFile psiFile = contextElement.getContainingFile();
            if (psiFile != null) {
                psiElement = (PsiElement)psiFile;
            } else {
                return null;
            }
        }
        PsiElement host = psiElement;
        Ref.ObjectRef result = new Ref.ObjectRef();
        host.accept((PsiElementVisitor)new JSElementVisitor((Ref.ObjectRef<JSVariable>)result, variableSourceName){
            final /* synthetic */ Ref.ObjectRef<JSVariable> $result;
            final /* synthetic */ String $variableSourceName;
            {
                this.$result = $result;
                this.$variableSourceName = $variableSourceName;
            }

            public void visitElement(PsiElement node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (this.$result.element == null) {
                    node.acceptChildren((PsiElementVisitor)this);
                }
            }

            public void visitJSParameter(JSParameter node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (Intrinsics.areEqual((Object)this.$variableSourceName, (Object)node.getName())) {
                    this.$result.element = node;
                } else {
                    super.visitJSParameter(node);
                }
            }

            public void visitJSVariable(JSVariable node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (Intrinsics.areEqual((Object)this.$variableSourceName, (Object)node.getName())) {
                    this.$result.element = node;
                } else {
                    super.visitJSVariable(node);
                }
            }
        });
        return (JSVariable)result.element;
    }

    @NotNull
    public String rawNameToSource(@NotNull Variable variable) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        String string = variable.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return this.debugProcess.normalizeMemberName(string);
    }

    @NotNull
    public final Promise<VirtualFile> getFileByUrlOrVmSource(@NotNull Script script, boolean tryToResolveByUrl) {
        VirtualFile virtualFile;
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        VmScriptFile vmScriptFile = (VmScriptFile)((Object)script.getUserData(VmScriptFileSystemKt.getVM_SCRIPT_FILE_KEY()));
        if (vmScriptFile != null && (virtualFile = vmScriptFile.ensureDownloaded()) != null) {
            VirtualFile it = virtualFile;
            boolean bl = false;
            return it;
        }
        Url url = script.getUrl();
        if (tryToResolveByUrl) {
            String string = url.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            if (!StringsKt.endsWith$default((String)string, (String)"!transpiled", (boolean)false, (int)2, null)) {
                JavaScriptDebugProcess<?> $this$getFileByUrlOrVmSource_u24lambda_u241 = this.debugProcess;
                boolean bl = false;
                virtualFile = $this$getFileByUrlOrVmSource_u24lambda_u241.findFile(script);
                if (virtualFile != null) {
                    VirtualFile it = virtualFile;
                    boolean bl2 = false;
                    return Promises.resolvedPromise((Object)it);
                }
            }
        }
        Promise promise = VmScriptFileSystemKt.getVmFile(script).ensureDownloaded().onSuccess(arg_0 -> JavaScriptDebuggerViewSupport.getFileByUrlOrVmSource$lambda$4(arg_0 -> JavaScriptDebuggerViewSupport.getFileByUrlOrVmSource$lambda$3(this, url, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"onSuccess(...)");
        return promise;
    }

    @NotNull
    public Promise<?> computeReceiverVariable(@NotNull VariableContext context, @NotNull CallFrame callFrame, @NotNull XCompositeNode node) {
        Promise<?> promise;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)callFrame, (String)"callFrame");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (!Registry.Companion.is("js.debugger.use.vm.receiver", false) && (promise = this.computeReceiverVariableUsingEvaluate(callFrame, context, node)) != null) {
            Promise<?> it = promise;
            boolean bl = false;
            return it;
        }
        return super.computeReceiverVariable(context, callFrame, node);
    }

    private final Promise<?> computeReceiverVariableUsingEvaluate(CallFrame callFrame, VariableContext context, XCompositeNode node) {
        VariableContext parent;
        for (parent = context; parent != null && !(parent instanceof CallFrameView); parent = parent.getParent()) {
        }
        VariableContext variableContext = parent;
        CallFrameView callFrameView = variableContext instanceof CallFrameView ? (CallFrameView)variableContext : null;
        if (callFrameView == null || (callFrameView = callFrameView.getSourcePosition()) == null || (callFrameView = callFrameView.getFile()) == null) {
            return null;
        }
        CallFrameView file = callFrameView;
        return (Promise)ActionsKt.runReadAction(() -> JavaScriptDebuggerViewSupport.computeReceiverVariableUsingEvaluate$lambda$0(this, (VirtualFile)file, callFrame, node, context));
    }

    private static final boolean canNavigateToSource$lambda$0(Variable $variable) {
        return ((NavigatableVariable)$variable).hasSourcePosition();
    }

    private static final Unit getFileByUrlOrVmSource$lambda$3(JavaScriptDebuggerViewSupport this$0, Url $url, VirtualFile it) {
        JavaScriptDebugProcess<?> javaScriptDebugProcess = this$0.debugProcess;
        Intrinsics.checkNotNull((Object)it);
        javaScriptDebugProcess.saveResolvedFile($url, it);
        return Unit.INSTANCE;
    }

    private static final void getFileByUrlOrVmSource$lambda$4(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    /*
     * WARNING - void declaration
     */
    private static final Promise computeReceiverVariableUsingEvaluate$lambda$0(JavaScriptDebuggerViewSupport this$0, VirtualFile $file, CallFrame $callFrame, XCompositeNode $node, VariableContext $context) {
        Project project = this$0.debugProcess.getSession().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        PsiFile psiFile = PsiManager.getInstance((Project)project2).findFile($file);
        if (psiFile == null) {
            return null;
        }
        PsiFile psiFile2 = psiFile;
        try {
            Document document;
            Document document2 = document = PsiDocumentManager.getInstance((Project)project2).getDocument(psiFile2);
            Intrinsics.checkNotNull((Object)document2);
            int offset = document2.getLineStartOffset($callFrame.getLine()) + $callFrame.getColumn();
            PsiElement psiElement = psiFile2.findElementAt(offset);
            if (psiElement == null) {
                return null;
            }
            PsiElement elementAtOffset = psiElement;
            PsiElement executionScope = JSUseScopeProvider.getLexicalScopeOrFile((PsiElement)elementAtOffset);
            if (executionScope instanceof JSFunctionExpression && ((JSFunctionExpression)executionScope).isArrowFunction()) {
                void $this$onError$iv;
                Promise $this$onSuccess$iv;
                Promise promise = EvaluateContext.evaluate$default((EvaluateContext)$callFrame.getEvaluateContext(), (String)"this", null, (boolean)false, null, (int)14, null);
                Obsolescent node$iv = (Obsolescent)$node;
                boolean $i$f$onSuccess = false;
                Promise promise2 = $this$onSuccess$iv.onSuccess((Consumer)new ObsolescentConsumer<EvaluateResult>(node$iv, $node, $context){
                    final /* synthetic */ XCompositeNode $node$inlined;
                    final /* synthetic */ VariableContext $context$inlined;
                    {
                        this.$node$inlined = xCompositeNode;
                        this.$context$inlined = variableContext;
                        super($node);
                    }

                    /*
                     * Ignored method signature, as it can't be verified against descriptor
                     */
                    public void accept(Object param) {
                        EvaluateResult it = (EvaluateResult)param;
                        boolean bl = false;
                        this.$node$inlined.addChildren(XValueChildrenList.singleton((XNamedValue)((XNamedValue)new VariableView((Variable)new VariableImpl("this", it.getValue()), this.$context$inlined))), true);
                    }
                });
                Intrinsics.checkNotNullExpressionValue((Object)promise2, (String)"onSuccess(...)");
                $this$onSuccess$iv = promise2;
                node$iv = (Obsolescent)$node;
                boolean $i$f$onError = false;
                Promise promise3 = $this$onError$iv.onError((Consumer)new ObsolescentConsumer<Throwable>(node$iv, $node){
                    final /* synthetic */ XCompositeNode $node$inlined;
                    {
                        this.$node$inlined = xCompositeNode;
                        super($node);
                    }

                    public void accept(Throwable param) {
                        Intrinsics.checkNotNullParameter((Object)param, (String)"param");
                        Throwable it = param;
                        boolean bl = false;
                        this.$node$inlined.addChildren(XValueChildrenList.EMPTY, true);
                    }
                });
                Intrinsics.checkNotNullExpressionValue((Object)promise3, (String)"onError(...)");
                return promise3;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static final /* synthetic */ JSVariable access$getVariable(JavaScriptDebuggerViewSupport $this, String variableSourceName, VariableContext context) {
        return $this.getVariable(variableSourceName, context);
    }
}

