/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.execution;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.browsers.BrowserFamily;
import com.intellij.ide.browsers.StartBrowserSettings;
import com.intellij.ide.browsers.WebBrowserXmlService;
import com.intellij.ide.browsers.impl.WebBrowserServiceImpl;
import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.execution.BrowserSelectorProxy;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.BrowseFolderDescriptor;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.layout.ComponentPredicateKt;
import com.intellij.util.Url;
import com.intellij.util.io.URLUtil;
import com.intellij.util.text.StringKt;
import java.util.Arrays;
import javax.swing.AbstractButton;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0006\u0010\u0014\u001a\u00020\u0015J\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lcom/intellij/javascript/debugger/execution/RemoteStartBrowserPanel;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "browserSelector", "Lcom/intellij/javascript/debugger/execution/BrowserSelectorProxy;", "urlField", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "startBrowserCheckBox", "Lcom/intellij/ui/components/JBCheckBox;", "component", "Lcom/intellij/openapi/ui/DialogPanel;", "getComponent", "()Lcom/intellij/openapi/ui/DialogPanel;", "virtualFileToUrl", "Lcom/intellij/util/Url;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "createSettings", "Lcom/intellij/ide/browsers/StartBrowserSettings;", "getNormalizedUrl", "", "setFromSettings", "", "settings", "intellij.javascript.debugger.backend"})
@SourceDebugExtension(value={"SMAP\nRemoteStartBrowserPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteStartBrowserPanel.kt\ncom/intellij/javascript/debugger/execution/RemoteStartBrowserPanel\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,99:1\n106#2:100\n78#2,22:101\n*S KotlinDebug\n*F\n+ 1 RemoteStartBrowserPanel.kt\ncom/intellij/javascript/debugger/execution/RemoteStartBrowserPanel\n*L\n86#1:100\n86#1:101,22\n*E\n"})
public final class RemoteStartBrowserPanel {
    @NotNull
    private final Project project;
    @NotNull
    private final BrowserSelectorProxy browserSelector;
    private TextFieldWithBrowseButton urlField;
    private JBCheckBox startBrowserCheckBox;
    @NotNull
    private final DialogPanel component;

    public RemoteStartBrowserPanel(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.browserSelector = BrowserSelectorProxy.Companion.create$default(BrowserSelectorProxy.Companion, this.project, BrowserFamily.CHROME, null, 4, null);
        this.component = BuilderKt.panel(arg_0 -> RemoteStartBrowserPanel.component$lambda$0(this, arg_0));
    }

    @NotNull
    public final DialogPanel getComponent() {
        return this.component;
    }

    private final Url virtualFileToUrl(VirtualFile file) {
        PsiFile psiFile = (PsiFile)ActionsKt.runReadAction(() -> RemoteStartBrowserPanel.virtualFileToUrl$lambda$0(this, file));
        return WebBrowserServiceImpl.Companion.getDebuggableUrl((PsiElement)psiFile);
    }

    @NotNull
    public final StartBrowserSettings createSettings() {
        StartBrowserSettings browserSettings = new StartBrowserSettings();
        JBCheckBox jBCheckBox = this.startBrowserCheckBox;
        if (jBCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"startBrowserCheckBox");
            jBCheckBox = null;
        }
        browserSettings.setSelected(jBCheckBox.isSelected());
        browserSettings.setBrowserReference(this.browserSelector.getSelectedBrowserId());
        browserSettings.setStartJavaScriptDebugger(true);
        browserSettings.setUrl(this.getNormalizedUrl());
        return browserSettings;
    }

    @Nullable
    public final String getNormalizedUrl() {
        String url;
        TextFieldWithBrowseButton textFieldWithBrowseButton = this.urlField;
        if (textFieldWithBrowseButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"urlField");
            textFieldWithBrowseButton = null;
        }
        if ((url = StringKt.nullize((String)textFieldWithBrowseButton.getText(), (boolean)true)) != null) {
            String $this$trim$iv = url;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            if (!URLUtil.containsScheme((String)(url = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()))) {
                return VirtualFileManager.constructUrl((String)"http", (String)url);
            }
        }
        return url;
    }

    public final void setFromSettings(@NotNull StartBrowserSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        JBCheckBox jBCheckBox = this.startBrowserCheckBox;
        if (jBCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"startBrowserCheckBox");
            jBCheckBox = null;
        }
        jBCheckBox.setSelected(settings.isSelected());
        TextFieldWithBrowseButton textFieldWithBrowseButton = this.urlField;
        if (textFieldWithBrowseButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"urlField");
            textFieldWithBrowseButton = null;
        }
        textFieldWithBrowseButton.setText(settings.getUrl());
        this.browserSelector.setSelectedBrowserId(settings.getBrowserReference());
    }

    private static final Unit component$lambda$0(RemoteStartBrowserPanel this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.group$default((Panel)$this$panel, (String)IdeBundle.message((String)"start.browser.border.label.open.browser", (Object[])new Object[0]), (boolean)false, arg_0 -> RemoteStartBrowserPanel.component$lambda$0$0(this$0, arg_0), (int)2, null);
        return Unit.INSTANCE;
    }

    private static final Unit component$lambda$0$0(RemoteStartBrowserPanel this$0, Panel $this$group) {
        Intrinsics.checkNotNullParameter((Object)$this$group, (String)"$this$group");
        Panel.row$default((Panel)$this$group, null, arg_0 -> RemoteStartBrowserPanel.component$lambda$0$0$0(this$0, arg_0), (int)1, null);
        String string = JSDebuggerBundle.message("label.text.browser", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Row row = $this$group.row(string, arg_0 -> RemoteStartBrowserPanel.component$lambda$0$0$1(this$0, arg_0));
        JBCheckBox jBCheckBox = this$0.startBrowserCheckBox;
        if (jBCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"startBrowserCheckBox");
            jBCheckBox = null;
        }
        row.enabledIf(ComponentPredicateKt.getSelected((AbstractButton)((AbstractButton)jBCheckBox)));
        String string2 = IdeBundle.message((String)"start.browser.panel.url.label", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        Row row2 = $this$group.row(string2, arg_0 -> RemoteStartBrowserPanel.component$lambda$0$0$2(this$0, arg_0));
        JBCheckBox jBCheckBox2 = this$0.startBrowserCheckBox;
        if (jBCheckBox2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"startBrowserCheckBox");
            jBCheckBox2 = null;
        }
        row2.enabledIf(ComponentPredicateKt.getSelected((AbstractButton)((AbstractButton)jBCheckBox2)));
        return Unit.INSTANCE;
    }

    private static final Unit component$lambda$0$0$0(RemoteStartBrowserPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = JSDebuggerBundle.message("start.debug.in.browser.checkbox.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.checkBox(string).applyToComponent(arg_0 -> RemoteStartBrowserPanel.component$lambda$0$0$0$0(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final Unit component$lambda$0$0$0$0(RemoteStartBrowserPanel this$0, JBCheckBox $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        this$0.startBrowserCheckBox = $this$applyToComponent;
        return Unit.INSTANCE;
    }

    private static final Unit component$lambda$0$0$1(RemoteStartBrowserPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.cell(this$0.browserSelector.getMainComponent()).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final Unit component$lambda$0$0$2(RemoteStartBrowserPanel this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        VirtualFile[] virtualFileArray = ProjectRootManager.getInstance((Project)this$0.project).getContentRoots();
        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.singleFileOrDir().withTitle(IdeBundle.message((String)"javascript.debugger.settings.choose.file.title", (Object[])new Object[0])).withDescription(IdeBundle.message((String)"javascript.debugger.settings.choose.file.subtitle", (Object[])new Object[0])).withRoots(Arrays.copyOf(virtualFileArray, virtualFileArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)fileChooserDescriptor, (String)"withRoots(...)");
        FileChooserDescriptor fileChooserDescriptor2 = BrowseFolderDescriptor.Companion.withFileToTextConvertor(fileChooserDescriptor, arg_0 -> RemoteStartBrowserPanel.component$lambda$0$0$2$0(this$0, arg_0)).withFileFilter(arg_0 -> RemoteStartBrowserPanel.component$lambda$0$0$2$2(arg_0 -> RemoteStartBrowserPanel.component$lambda$0$0$2$1(this$0, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)fileChooserDescriptor2, (String)"withFileFilter(...)");
        FileChooserDescriptor descriptor = fileChooserDescriptor2;
        Row.textFieldWithBrowseButton$default((Row)$this$row, (FileChooserDescriptor)descriptor, (Project)this$0.project, null, (int)4, null).applyToComponent(arg_0 -> RemoteStartBrowserPanel.component$lambda$0$0$2$3(this$0, arg_0)).align((Align)AlignX.FILL.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final String component$lambda$0$0$2$0(RemoteStartBrowserPanel this$0, VirtualFile it) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it.isDirectory()) {
            String string = it.getPresentableUrl();
            Intrinsics.checkNotNull((Object)string);
            object = string;
        } else {
            object = this$0.virtualFileToUrl(it);
            if (object == null || (object = object.toDecodedForm()) == null) {
                String string = it.getUrl();
                object = string;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
            }
        }
        return object;
    }

    private static final boolean component$lambda$0$0$2$1(RemoteStartBrowserPanel this$0, VirtualFile it) {
        WebBrowserXmlService webBrowserXmlService = WebBrowserXmlService.Companion.getInstance();
        Intrinsics.checkNotNull((Object)it);
        return webBrowserXmlService.isHtmlFile(it) || this$0.virtualFileToUrl(it) != null;
    }

    private static final boolean component$lambda$0$0$2$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit component$lambda$0$0$2$3(RemoteStartBrowserPanel this$0, TextFieldWithBrowseButton $this$applyToComponent) {
        Intrinsics.checkNotNullParameter((Object)$this$applyToComponent, (String)"$this$applyToComponent");
        this$0.urlField = $this$applyToComponent;
        return Unit.INSTANCE;
    }

    private static final PsiFile virtualFileToUrl$lambda$0(RemoteStartBrowserPanel this$0, VirtualFile $file) {
        return PsiManager.getInstance((Project)this$0.project).findFile($file);
    }
}

