/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.commons.interval;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.interval.NumSpan;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0000J\u0011\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0003H\u0086\u0002J\u0011\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0000H\u0086\u0002J\u000e\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0000J\u0013\u0010\u0014\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0015H\u0096\u0002J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0003J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0000J\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u001cJ\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0000R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "Lorg/jetbrains/letsPlot/commons/interval/NumSpan;", "lower", "", "upper", "(DD)V", "length", "getLength", "()D", "lowerEnd", "getLowerEnd", "()Ljava/lang/Double;", "upperEnd", "getUpperEnd", "connected", "", "other", "contains", "v", "encloses", "equals", "", "expanded", "expand", "hashCode", "", "intersection", "toPair", "Lkotlin/Pair;", "union", "Companion", "commons"})
public final class DoubleSpan
extends NumSpan {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double lowerEnd;
    private final double upperEnd;
    private final double length;

    public DoubleSpan(double lower2, double upper2) {
        this.lowerEnd = Math.min(lower2, upper2);
        this.upperEnd = Math.max(lower2, upper2);
        this.length = this.getUpperEnd() - this.getLowerEnd();
        double d = lower2;
        if (!(!Double.isInfinite(d) && !Double.isNaN(d) && !Double.isInfinite(d = upper2) && !Double.isNaN(d))) {
            boolean bl = false;
            String string = "Ends must be finite: lower=" + lower2 + " upper=" + upper2;
            throw new IllegalStateException(string.toString());
        }
    }

    @Override
    @NotNull
    public Double getLowerEnd() {
        return this.lowerEnd;
    }

    @Override
    @NotNull
    public Double getUpperEnd() {
        return this.upperEnd;
    }

    public final double getLength() {
        return this.length;
    }

    public final boolean contains(double v) {
        return v >= this.getLowerEnd() && v <= this.getUpperEnd();
    }

    public final boolean contains(@NotNull DoubleSpan other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.getLowerEnd() <= other.getLowerEnd() && this.getUpperEnd() >= other.getUpperEnd();
    }

    public final boolean encloses(@NotNull DoubleSpan other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.getLowerEnd() <= other.getLowerEnd() && this.getUpperEnd() >= other.getUpperEnd();
    }

    public final boolean connected(@NotNull DoubleSpan other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return !(this.getLowerEnd() > other.getUpperEnd()) && !(this.getUpperEnd() < other.getLowerEnd());
    }

    @NotNull
    public final DoubleSpan union(@NotNull DoubleSpan other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (this.encloses(other)) {
            return this;
        }
        return other.encloses(this) ? other : new DoubleSpan(Math.min(this.getLowerEnd(), other.getLowerEnd()), Math.max(this.getUpperEnd(), other.getUpperEnd()));
    }

    @NotNull
    public final DoubleSpan intersection(@NotNull DoubleSpan other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (!this.connected(other)) {
            throw new IllegalArgumentException("Ranges are not connected: this=" + this + " other=" + other);
        }
        if (this.encloses(other)) {
            return other;
        }
        return other.encloses(this) ? this : new DoubleSpan(Math.max(this.getLowerEnd(), other.getLowerEnd()), Math.min(this.getUpperEnd(), other.getUpperEnd()));
    }

    @NotNull
    public final DoubleSpan expanded(double expand) {
        double expand2 = expand >= 0.0 ? expand : -Math.min(this.length / (double)2, Math.abs(expand));
        return new DoubleSpan(this.getLowerEnd() - expand2, this.getUpperEnd() + expand2);
    }

    @NotNull
    public final Pair<Double, Double> toPair() {
        return TuplesKt.to((Object)this.getLowerEnd(), (Object)this.getUpperEnd());
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        DoubleSpan cfr_ignored_0 = (DoubleSpan)other;
        if (!(this.getLowerEnd().doubleValue() == ((DoubleSpan)other).getLowerEnd().doubleValue())) {
            return false;
        }
        return this.getUpperEnd().doubleValue() == ((DoubleSpan)other).getUpperEnd().doubleValue();
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + Double.hashCode(this.getLowerEnd());
        result2 = 31 * result2 + Double.hashCode(this.getUpperEnd());
        return result2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0010\u0006\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006J\u0018\u0010\b\u001a\u0004\u0018\u00010\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006J\u000e\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0007J\u0016\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0007J\u0016\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0007\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan$Companion;", "", "()V", "encloseAll", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "values", "", "", "encloseAllQ", "singleton", "v", "withLowerEnd", "lowerEnd", "length", "withUpperEnd", "upperEnd", "commons"})
    @SourceDebugExtension(value={"SMAP\nDoubleSpan.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DoubleSpan.kt\norg/jetbrains/letsPlot/commons/interval/DoubleSpan$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,123:1\n766#2:124\n857#2,2:125\n*S KotlinDebug\n*F\n+ 1 DoubleSpan.kt\norg/jetbrains/letsPlot/commons/interval/DoubleSpan$Companion\n*L\n108#1:124\n108#1:125,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DoubleSpan withLowerEnd(double lowerEnd, double length) {
            return new DoubleSpan(lowerEnd, lowerEnd + length);
        }

        @NotNull
        public final DoubleSpan withUpperEnd(double upperEnd, double length) {
            return new DoubleSpan(upperEnd - length, upperEnd);
        }

        @NotNull
        public final DoubleSpan singleton(double v) {
            return new DoubleSpan(v, v);
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final DoubleSpan encloseAllQ(@NotNull Iterable<Double> values2) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter(values2, (String)"values");
            Iterable $this$filter$iv = CollectionsKt.filterNotNull(values2);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                double it = ((Number)element$iv$iv).doubleValue();
                boolean bl = false;
                double d = it;
                boolean bl2 = !Double.isInfinite(d) && !Double.isNaN(d);
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List it = (List)destination$iv$iv;
            boolean bl = false;
            Pair pair2 = new Pair((Object)CollectionsKt.minOrNull((Iterable)it), (Object)CollectionsKt.maxOrNull((Iterable)it));
            Double min = (Double)pair2.component1();
            Double max = (Double)pair2.component2();
            return min == null || max == null ? null : new DoubleSpan(min, max);
        }

        @NotNull
        public final DoubleSpan encloseAll(@NotNull Iterable<Double> values2) {
            Intrinsics.checkNotNullParameter(values2, (String)"values");
            DoubleSpan doubleSpan = this.encloseAllQ(CollectionsKt.toList(values2));
            if (doubleSpan == null) {
                throw new NoSuchElementException("Can't create DoubleSpan: the input is empty or contains NULLs.");
            }
            return doubleSpan;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

