/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.geom;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleSegment;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.Aesthetics;
import org.jetbrains.letsPlot.core.plot.base.CoordinateSystem;
import org.jetbrains.letsPlot.core.plot.base.DataPointAesthetics;
import org.jetbrains.letsPlot.core.plot.base.GeomContext;
import org.jetbrains.letsPlot.core.plot.base.GeomKind;
import org.jetbrains.letsPlot.core.plot.base.PositionAdjustment;
import org.jetbrains.letsPlot.core.plot.base.geom.BandGeom;
import org.jetbrains.letsPlot.core.plot.base.geom.GeomBase;
import org.jetbrains.letsPlot.core.plot.base.geom.util.GeomHelper;
import org.jetbrains.letsPlot.core.plot.base.geom.util.HintColorUtil;
import org.jetbrains.letsPlot.core.plot.base.geom.util.HintsCollection;
import org.jetbrains.letsPlot.core.plot.base.render.SvgRoot;
import org.jetbrains.letsPlot.core.plot.base.tooltip.GeomTargetCollector;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgNode;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J0\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/BandGeom;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/GeomBase;", "isVertical", "", "(Z)V", "yMaxAes", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "", "yMinAes", "buildIntern", "", "root", "Lorg/jetbrains/letsPlot/core/plot/base/render/SvgRoot;", "aesthetics", "Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;", "pos", "Lorg/jetbrains/letsPlot/core/plot/base/PositionAdjustment;", "coord", "Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;", "Companion", "plot-base"})
public final class BandGeom
extends GeomBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isVertical;
    @NotNull
    private final Aes<Double> yMinAes;
    @NotNull
    private final Aes<Double> yMaxAes;
    public static final boolean HANDLES_GROUPS = false;

    public BandGeom(boolean isVertical) {
        this.isVertical = isVertical;
        this.yMinAes = this.isVertical ? Aes.Companion.getYMIN() : Aes.Companion.getXMIN();
        this.yMaxAes = this.isVertical ? Aes.Companion.getYMAX() : Aes.Companion.getXMAX();
    }

    @Override
    protected void buildIntern(@NotNull SvgRoot root, @NotNull Aesthetics aesthetics2, @NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx2) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)aesthetics2, (String)"aesthetics");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
        GeomHelper geomHelper = new GeomHelper(pos, coord, ctx2);
        GeomHelper.SvgElementHelper svgHelper2 = new GeomHelper(pos, coord, ctx2).createSvgElementHelper().setResamplingEnabled(!coord.isLinear());
        DoubleRectangle viewPort = GeomBase.Companion.overallAesBounds(ctx2).flipIf(!this.isVertical);
        for (DataPointAesthetics p : aesthetics2.dataPoints()) {
            DoubleRectangle r;
            Double d = p.finiteOrNull(this.yMinAes);
            if (d == null) {
                continue;
            }
            double yMin = d;
            Double d2 = p.finiteOrNull(this.yMaxAes);
            if (d2 == null) {
                continue;
            }
            double yMax = d2;
            if (yMin > yMax) continue;
            DoubleRectangle rect2 = DoubleRectangle.Companion.hvRange(viewPort.xRange(), new DoubleSpan(yMin, yMax));
            List list2 = CollectionsKt.toList(rect2.getParts());
            DoubleSegment topSide = (DoubleSegment)list2.get(0);
            DoubleSegment bottomSide = (DoubleSegment)list2.get(3);
            Pair<SvgNode, List<DoubleVector>> pair2 = svgHelper2.createRectangle(rect2.flipIf(!this.isVertical), p, (Function1<? super DataPointAesthetics, Double>)((Function1)buildIntern.1.INSTANCE));
            if (pair2 == null) continue;
            SvgNode rectSvg = (SvgNode)pair2.component1();
            Pair pair3 = GeomHelper.SvgElementHelper.createLine$default(svgHelper2, topSide.flipIf(!this.isVertical), p, null, 4, null);
            if (pair3 == null) continue;
            SvgNode topSvg = (SvgNode)pair3.component1();
            Pair pair4 = GeomHelper.SvgElementHelper.createLine$default(svgHelper2, bottomSide.flipIf(!this.isVertical), p, null, 4, null);
            if (pair4 == null) continue;
            SvgNode bottomSvg = (SvgNode)pair4.component1();
            root.add(rectSvg);
            root.add(topSvg);
            root.add(bottomSvg);
            GeomTargetCollector.TooltipParams tooltipParams = new GeomTargetCollector.TooltipParams(new HintsCollection(p, geomHelper).getHints(), null, null, (List)HintColorUtil.INSTANCE.createColorMarkerMapper(GeomKind.BAND, ctx2).invoke((Object)p), 6, null);
            if (geomHelper.toClient(rect2.flipIf(!this.isVertical), p) == null) continue;
            boolean bl = false;
            GeomTargetCollector.DefaultImpls.addPolygon$default(ctx2.getTargetCollector(), r.getPoints(), p.index(), tooltipParams, null, 8, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/BandGeom$Companion;", "", "()V", "HANDLES_GROUPS", "", "plot-base"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

