/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.extractors.FormatterCreator;
import com.intellij.database.extractors.ObjectFormatterConfig;
import com.intellij.database.run.ui.grid.editors.CompositeFormatter;
import com.intellij.database.run.ui.grid.editors.Formatter;
import com.intellij.database.run.ui.grid.editors.NumberFormatter;
import com.intellij.database.settings.DataGridSettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.Pair;
import java.text.SimpleDateFormat;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import kotlin.Triple;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FormatsCache {
    public static final FormatProvider<String, SimpleDateFormat> SIMPLE_TIMESTAMP_FORMAT_PROVIDER = new BaseFormatProvider<String, SimpleDateFormat>("SIMPLE_TIMESTAMP", FormatterCreator.SIMPLE_TIMESTAMP_FORMATTER_KEY);
    public static final FormatProvider<String, SimpleDateFormat> SHORT_TIMESTAMP_FORMAT_PROVIDER = new BaseFormatProvider<String, SimpleDateFormat>("SHORT_TIMESTAMP", FormatterCreator.SHORT_TIMESTAMP_FORMATTER_KEY);
    public static final FormatProvider<String, SimpleDateFormat> TIMESTAMP_WITH_MILLI_FORMAT_PROVIDER = new BaseFormatProvider<String, SimpleDateFormat>("TIMESTAMP_WITH_MILLI", FormatterCreator.TIMESTAMP_WITH_MILLI_FORMATTER_KEY);
    public static final FormatProvider<String, SimpleDateFormat> SIMPLE_DATE_FORMAT_PROVIDER = new BaseFormatProvider<String, SimpleDateFormat>("SIMPLE_DATE", FormatterCreator.SIMPLE_DATE_FORMATTER_KEY);
    public static final FormatProvider<String, DateTimeFormatter> LOCAL_DATE_WITH_MILLI_FORMAT_PROVIDER = new BaseFormatProvider<String, DateTimeFormatter>("LOCAL_DATE_WITH_MILLI", FormatterCreator.LOCAL_DATE_WITH_MILLI_FORMATTER_KEY);
    public static final FormatProvider<String, DateTimeFormatter> LOCAL_DATE_FORMAT_PROVIDER = new BaseFormatProvider<String, DateTimeFormatter>("LOCAL_DATE", FormatterCreator.LOCAL_DATE_FORMATTER_KEY);
    public static final FormatProvider<String, DateTimeFormatter> OFFSET_DATE_TIME_FORMAT_PROVIDER = new BaseFormatProvider<String, DateTimeFormatter>("OFFSET_DATE_TIME", FormatterCreator.OFFSET_DATE_TIME_FORMATTER_KEY);
    private static final Logger LOG = Logger.getInstance(FormatsCache.class);
    private static final NotNullLazyKey<FormatsCache, CoreGrid<?, ?>> FORMATS_CACHE_KEY = NotNullLazyKey.createLazyKey((String)"FORMATS_CACHE_KEY", FormatsCache::createCache);
    private final Map<Object, Object> myCache = new ConcurrentHashMap<Object, Object>();

    @NotNull
    private static FormatsCache createCache(CoreGrid<?, ?> grid) {
        FormatsCache cache = new FormatsCache();
        if (!Disposer.isDisposed(grid)) {
            ApplicationManager.getApplication().getMessageBus().connect(grid).subscribe(DataGridSettings.TOPIC, () -> cache.myCache.clear());
        }
        FormatsCache formatsCache = cache;
        if (formatsCache == null) {
            FormatsCache.$$$reportNull$$$0(0);
        }
        return formatsCache;
    }

    @NotNull
    public static FormatsCache get(@NotNull CoreGrid<?, ?> grid) {
        if (grid == null) {
            FormatsCache.$$$reportNull$$$0(1);
        }
        FormatsCache formatsCache = (FormatsCache)FORMATS_CACHE_KEY.getValue(grid);
        if (formatsCache == null) {
            FormatsCache.$$$reportNull$$$0(2);
        }
        return formatsCache;
    }

    @NotNull
    public <K, T> T get(@NotNull FormatProvider<K, T> provider, @NotNull FormatterCreator formatterCreator) {
        if (provider == null) {
            FormatsCache.$$$reportNull$$$0(3);
        }
        if (formatterCreator == null) {
            FormatsCache.$$$reportNull$$$0(4);
        }
        T t = this.get(provider, formatterCreator, true);
        if (t == null) {
            FormatsCache.$$$reportNull$$$0(5);
        }
        return t;
    }

    @NotNull
    public <K, T> T get(@NotNull FormatProvider<K, T> provider, @NotNull FormatterCreator formatterCreator, boolean cache) {
        int cacheSize;
        Object res;
        if (provider == null) {
            FormatsCache.$$$reportNull$$$0(6);
        }
        if (formatterCreator == null) {
            FormatsCache.$$$reportNull$$$0(7);
        }
        K key = provider.getCacheKey();
        if (cache && (res = this.myCache.get(key)) != null) {
            Object object = res;
            if (object == null) {
                FormatsCache.$$$reportNull$$$0(8);
            }
            return (T)object;
        }
        T r = provider.createFormatter(this, formatterCreator);
        if (cache) {
            this.myCache.put(key, r);
        }
        if ((cacheSize = this.myCache.size()) > 0 && (cacheSize % 10000 == 0 && cacheSize < 100000 || cacheSize % 100000 == 0)) {
            LOG.error("Formats cash size seems to be too big: " + cacheSize);
        }
        T t = r;
        if (t == null) {
            FormatsCache.$$$reportNull$$$0(9);
        }
        return t;
    }

    public static FormatProvider<Pair<String, ObjectFormatterConfig>, NumberFormatter> getIntFormatProvider(@Nullable ObjectFormatterConfig config) {
        return new BaseFormatProvider<Pair<String, ObjectFormatterConfig>, NumberFormatter>(new Pair((Object)"INT", (Object)config), (formatsCache, formatterCreator) -> formatterCreator.create(FormatterCreator.getIntKey(config)));
    }

    public static FormatProvider<Pair<String, ObjectFormatterConfig>, NumberFormatter> getLongFormatProvider(@Nullable ObjectFormatterConfig config) {
        return new BaseFormatProvider<Pair<String, ObjectFormatterConfig>, NumberFormatter>(new Pair((Object)"LONG", (Object)config), (formatsCache, formatterCreator) -> formatterCreator.create(FormatterCreator.getLongKey(config)));
    }

    public static FormatProvider<Pair<String, ObjectFormatterConfig>, NumberFormatter> getBigIntFormatProvider(@Nullable ObjectFormatterConfig config) {
        return new BaseFormatProvider<Pair<String, ObjectFormatterConfig>, NumberFormatter>(new Pair((Object)"BIG_INT", (Object)config), (formatsCache, formatterCreator) -> formatterCreator.create(FormatterCreator.getBigIntKey(config)));
    }

    public static FormatProvider<Pair<String, ObjectFormatterConfig>, NumberFormatter> getFloatFormatProvider(@Nullable ObjectFormatterConfig config) {
        return new BaseFormatProvider<Pair<String, ObjectFormatterConfig>, NumberFormatter>(new Pair((Object)"FLOAT", (Object)config), (formatsCache, formatterCreator) -> formatterCreator.create(FormatterCreator.getFloatKey(config)));
    }

    public static FormatProvider<Pair<String, ObjectFormatterConfig>, NumberFormatter> getDoubleFormatProvider(@Nullable ObjectFormatterConfig config) {
        return new BaseFormatProvider<Pair<String, ObjectFormatterConfig>, NumberFormatter>(new Pair((Object)"DOUBLE", (Object)config), (formatsCache, formatterCreator) -> formatterCreator.create(FormatterCreator.getDoubleKey(config)));
    }

    public static FormatProvider<Triple<String, GridColumn, ObjectFormatterConfig>, Formatter> getZonedTimeFormatProvider(@Nullable GridColumn column, @Nullable ObjectFormatterConfig config) {
        return new BaseFormatProvider<Triple<String, GridColumn, ObjectFormatterConfig>, Formatter>(new Triple((Object)"ZONED_TIME", (Object)column, (Object)config), (formatsCache, formatterCreator) -> formatterCreator.create(FormatterCreator.getZonedTimeKey(column, config, formatsCache)));
    }

    public static FormatProvider<Triple<String, GridColumn, ObjectFormatterConfig>, CompositeFormatter> getZonedTimestampFormatProvider(@Nullable GridColumn column, @Nullable ObjectFormatterConfig config) {
        return new BaseFormatProvider<Triple<String, GridColumn, ObjectFormatterConfig>, CompositeFormatter>(new Triple((Object)"ZONED_TIMESTAMP", (Object)column, (Object)config), (formatsCache, formatterCreator) -> formatterCreator.create(FormatterCreator.getZonedTimestampKey(column, config, formatsCache)));
    }

    public static FormatProvider<Triple<String, GridColumn, ObjectFormatterConfig>, Formatter> getShortEraZonedTimestampFormatProvider(@Nullable GridColumn column, @Nullable ObjectFormatterConfig config) {
        return new BaseFormatProvider<Triple<String, GridColumn, ObjectFormatterConfig>, Formatter>(new Triple((Object)"SHORT_ERA_ZONED_TIMESTAMP", (Object)column, (Object)config), (formatsCache, formatterCreator) -> formatterCreator.create(FormatterCreator.getShortEraZonedTimestampKey(column, config, formatsCache)));
    }

    public static FormatProvider<Triple<String, Integer, ObjectFormatterConfig>, NumberFormatter> getBigDecimalWithPriorityTypeFormatProvider(int type, @Nullable ObjectFormatterConfig config) {
        return new BaseFormatProvider<Triple<String, Integer, ObjectFormatterConfig>, NumberFormatter>(new Triple((Object)"DECIMAL_WITH_PRIORITY_TYPE", (Object)type, (Object)config), (formatsCache, formatterCreator) -> formatterCreator.create(FormatterCreator.getDecimalWithPriorityTypeKey(type, config)));
    }

    public static FormatProvider<Triple<String, GridColumn, ObjectFormatterConfig>, Formatter> getDateFormatProvider(@Nullable GridColumn column, @Nullable ObjectFormatterConfig config) {
        return new BaseFormatProvider<Triple<String, GridColumn, ObjectFormatterConfig>, Formatter>(new Triple((Object)"DATE", (Object)column, (Object)config), (formatsCache, formatterCreator) -> formatterCreator.create(FormatterCreator.getDateKey(column, config, formatsCache)));
    }

    public static FormatProvider<Triple<String, GridColumn, ObjectFormatterConfig>, NumberFormatter> getDecimalFormatProvider(@Nullable GridColumn column, @Nullable ObjectFormatterConfig config) {
        return new BaseFormatProvider<Triple<String, GridColumn, ObjectFormatterConfig>, NumberFormatter>(new Triple((Object)"DECIMAL", (Object)column, (Object)config), (formatsCache, formatterCreator) -> formatterCreator.create(FormatterCreator.getDecimalKey(column, config)));
    }

    public static FormatProvider<Triple<String, GridColumn, ObjectFormatterConfig>, Formatter> getTimeFormatProvider(@Nullable GridColumn column, @Nullable ObjectFormatterConfig config) {
        return new BaseFormatProvider<Triple<String, GridColumn, ObjectFormatterConfig>, Formatter>(new Triple((Object)"TIME", (Object)column, (Object)config), (formatsCache, formatterCreator) -> formatterCreator.create(FormatterCreator.getTimeKey(column, config, formatsCache)));
    }

    public static FormatProvider<Triple<String, GridColumn, ObjectFormatterConfig>, Formatter> getTimestampFormatProvider(@Nullable GridColumn column, @Nullable ObjectFormatterConfig config) {
        return new BaseFormatProvider<Triple<String, GridColumn, ObjectFormatterConfig>, Formatter>(new Triple((Object)"TIMESTAMP", (Object)column, (Object)config), (formatsCache, formatterCreator) -> formatterCreator.create(FormatterCreator.getTimestampKey(column, config, formatsCache)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3, 4, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/editors/FormatsCache";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatterCreator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createCache";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/editors/FormatsCache";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3, 4, 6, 7 -> new IllegalArgumentException(string);
        };
    }

    public static interface FormatProvider<K, T> {
        public K getCacheKey();

        public T createFormatter(@NotNull FormatsCache var1, @NotNull FormatterCreator var2);
    }

    public static class BaseFormatProvider<K, T>
    implements FormatProvider<K, T> {
        private final K myKey;
        private final BiFunction<FormatsCache, FormatterCreator, T> myCompute;

        BaseFormatProvider(@NotNull K key, @NotNull FormatterCreator.FormatterKey<T> formatterKey) {
            if (key == null) {
                BaseFormatProvider.$$$reportNull$$$0(0);
            }
            if (formatterKey == null) {
                BaseFormatProvider.$$$reportNull$$$0(1);
            }
            this.myKey = key;
            this.myCompute = (formatsCache, formatterCreator) -> formatterCreator.create(formatterKey);
        }

        public BaseFormatProvider(@NotNull K key, @NotNull BiFunction<FormatsCache, FormatterCreator, T> compute) {
            if (key == null) {
                BaseFormatProvider.$$$reportNull$$$0(2);
            }
            if (compute == null) {
                BaseFormatProvider.$$$reportNull$$$0(3);
            }
            this.myKey = key;
            this.myCompute = compute;
        }

        @Override
        public K getCacheKey() {
            return this.myKey;
        }

        @Override
        public T createFormatter(@NotNull FormatsCache formatsCache, @NotNull FormatterCreator formatterCreator) {
            if (formatsCache == null) {
                BaseFormatProvider.$$$reportNull$$$0(4);
            }
            if (formatterCreator == null) {
                BaseFormatProvider.$$$reportNull$$$0(5);
            }
            return this.myCompute.apply(formatsCache, formatterCreator);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "formatterKey";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "compute";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "formatsCache";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "formatterCreator";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/ui/grid/editors/FormatsCache$BaseFormatProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createFormatter";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

