/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.intellij.snapshot;

import com.intellij.jpa.jpb.model.orm.model.OrmEntity;
import com.intellij.jpa.jpb.model.orm.model.OrmFramework;
import com.intellij.liquibase.common.orm.OrmDiffModelProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.ext.intellij.database.IntellijDatabase;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.InvalidExampleException;
import liquibase.snapshot.SnapshotGenerator;
import liquibase.snapshot.SnapshotGeneratorChain;
import liquibase.structure.DatabaseObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IntellijSnapshotGenerator
implements SnapshotGenerator {
    public static final int PRIORITY_HIBERNATE_ADDITIONAL = 200;
    public static final int PRIORITY_HIBERNATE_DEFAULT = 100;
    protected Class<? extends DatabaseObject> defaultFor = null;
    protected Class<? extends DatabaseObject>[] addsTo = null;
    protected static final Logger LOG = Logger.getInstance(IntellijSnapshotGenerator.class);

    protected IntellijSnapshotGenerator(Class<? extends DatabaseObject> defaultFor) {
        this.defaultFor = defaultFor;
    }

    protected IntellijSnapshotGenerator(Class<? extends DatabaseObject> defaultFor, Class<? extends DatabaseObject>[] addsTo) {
        this.defaultFor = defaultFor;
        this.addsTo = addsTo;
    }

    public Class<? extends SnapshotGenerator>[] replaces() {
        return null;
    }

    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (database instanceof IntellijDatabase) {
            if (this.defaultFor != null && this.defaultFor.isAssignableFrom(objectType)) {
                return 100;
            }
            if (this.addsTo() != null) {
                for (Class<? extends DatabaseObject> type : this.addsTo()) {
                    if (!type.isAssignableFrom(objectType)) continue;
                    return 200;
                }
            }
        }
        return -1;
    }

    public final Class<? extends DatabaseObject>[] addsTo() {
        return this.addsTo;
    }

    public final DatabaseObject snapshot(DatabaseObject example, DatabaseSnapshot snapshot, SnapshotGeneratorChain chain) throws DatabaseException, InvalidExampleException {
        if (this.defaultFor != null && this.defaultFor.isAssignableFrom(example.getClass())) {
            return this.snapshotObject(example, snapshot);
        }
        DatabaseObject chainResponse = chain.snapshot(example, snapshot);
        if (chainResponse == null) {
            return null;
        }
        if (this.addsTo() != null) {
            for (Class<? extends DatabaseObject> addType : this.addsTo()) {
                if (!addType.isAssignableFrom(example.getClass())) continue;
                this.addTo(chainResponse, snapshot);
            }
        }
        return chainResponse;
    }

    protected abstract DatabaseObject snapshotObject(DatabaseObject var1, DatabaseSnapshot var2) throws DatabaseException, InvalidExampleException;

    protected abstract void addTo(DatabaseObject var1, DatabaseSnapshot var2) throws DatabaseException, InvalidExampleException;

    @Nullable
    protected OrmEntity findOrmEntity(DatabaseObject databaseObject, DatabaseSnapshot snapshot) {
        String tableName = databaseObject.getName();
        if (StringUtil.isEmpty((String)tableName)) {
            return null;
        }
        IntellijDatabase database = (IntellijDatabase)snapshot.getDatabase();
        return database.findOrmEntityByTableName(tableName);
    }

    @NotNull
    protected OrmDiffModelProvider getOrmDiffModelProvider(DatabaseSnapshot snapshot) {
        IntellijDatabase database = (IntellijDatabase)snapshot.getDatabase();
        OrmFramework ormFramework = database.getOrmFramework();
        OrmDiffModelProvider ormDiffModelProvider = OrmDiffModelProvider.Companion.getForFramework(ormFramework);
        if (ormDiffModelProvider == null) {
            IntellijSnapshotGenerator.$$$reportNull$$$0(0);
        }
        return ormDiffModelProvider;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "liquibase/ext/intellij/snapshot/IntellijSnapshotGenerator", "getOrmDiffModelProvider"));
    }
}

