/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.google.common.collect.Lists;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.codeInsight.CommentUtilCore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.kdoc.psi.api.KDocElement;
import org.jetbrains.kotlin.lang.BinaryOperationPrecedence;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtBlockStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtCollectionLiteralExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtContainerNodeForControlStructureBody;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtDelegatedSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtDoubleColonExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtFunctionType;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLabelReferenceExpression;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtPrefixExpression;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtStatementExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtTryExpression;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.StatementFilter;
import org.jetbrains.kotlin.resolve.StatementFilterKt;

public class KtPsiUtil {
    public static final int MAX_PRIORITY = CollectionsKt.count(BinaryOperationPrecedence.getEntries()) + 3;

    private KtPsiUtil() {
    }

    public static <D> void visitChildren(@NotNull KtElement element, @NotNull KtVisitor<Void, D> visitor2, D data) {
        if (element == null) {
            KtPsiUtil.$$$reportNull$$$0(0);
        }
        if (visitor2 == null) {
            KtPsiUtil.$$$reportNull$$$0(1);
        }
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof KtElement)) continue;
            ((KtElement)child).accept(visitor2, data);
        }
    }

    @NotNull
    public static KtExpression safeDeparenthesize(@NotNull KtExpression expression) {
        if (expression == null) {
            KtPsiUtil.$$$reportNull$$$0(2);
        }
        return KtPsiUtil.safeDeparenthesize(expression, false);
    }

    @NotNull
    public static KtExpression safeDeparenthesize(@NotNull KtExpression expression, boolean keepAnnotations) {
        KtExpression deparenthesized;
        if (expression == null) {
            KtPsiUtil.$$$reportNull$$$0(3);
        }
        KtExpression ktExpression = (deparenthesized = KtPsiUtil.deparenthesize(expression, keepAnnotations)) != null ? deparenthesized : expression;
        if (ktExpression == null) {
            KtPsiUtil.$$$reportNull$$$0(4);
        }
        return ktExpression;
    }

    @Nullable
    public static KtExpression deparenthesize(@Nullable KtExpression expression) {
        return KtPsiUtil.deparenthesize(expression, false);
    }

    @Nullable
    public static KtExpression deparenthesize(@Nullable KtExpression expression, boolean keepAnnotations) {
        KtExpression baseExpression;
        while ((baseExpression = KtPsiUtil.deparenthesizeOnce(expression, keepAnnotations)) != expression) {
            expression = baseExpression;
        }
        return baseExpression;
    }

    @Nullable
    public static KtExpression deparenthesizeOnce(@Nullable KtExpression expression) {
        return KtPsiUtil.deparenthesizeOnce(expression, false);
    }

    @Nullable
    public static KtExpression deparenthesizeOnce(@Nullable KtExpression expression, boolean keepAnnotations) {
        if (expression instanceof KtAnnotatedExpression && !keepAnnotations) {
            return ((KtAnnotatedExpression)expression).getBaseExpression();
        }
        if (expression instanceof KtLabeledExpression) {
            return ((KtLabeledExpression)expression).getBaseExpression();
        }
        if (expression instanceof KtExpressionWrapper) {
            return ((KtExpressionWrapper)((Object)expression)).getBaseExpression();
        }
        if (expression instanceof KtParenthesizedExpression) {
            return ((KtParenthesizedExpression)expression).getExpression();
        }
        return expression;
    }

    @NotNull
    public static Name safeName(@Nullable String name2) {
        Name name3 = name2 == null ? SpecialNames.NO_NAME_PROVIDED : Name.identifier(name2);
        if (name3 == null) {
            KtPsiUtil.$$$reportNull$$$0(5);
        }
        return name3;
    }

    @NotNull
    public static Set<KtElement> findRootExpressions(@NotNull Collection<KtElement> unreachableElements) {
        if (unreachableElements == null) {
            KtPsiUtil.$$$reportNull$$$0(6);
        }
        HashSet<KtElement> rootElements = new HashSet<KtElement>();
        final HashSet shadowedElements = new HashSet();
        KtVisitorVoid shadowAllChildren = new KtVisitorVoid(){

            @Override
            public void visitKtElement(@NotNull KtElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (shadowedElements.add(element)) {
                    element.acceptChildren(this);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/psi/KtPsiUtil$1", "visitKtElement"));
            }
        };
        for (KtElement element : unreachableElements) {
            if (shadowedElements.contains(element)) continue;
            element.acceptChildren(shadowAllChildren);
            rootElements.removeAll(shadowedElements);
            rootElements.add(element);
        }
        HashSet<KtElement> hashSet = rootElements;
        if (hashSet == null) {
            KtPsiUtil.$$$reportNull$$$0(7);
        }
        return hashSet;
    }

    @NotNull
    public static String unquoteIdentifier(@NotNull String quoted) {
        if (quoted == null) {
            KtPsiUtil.$$$reportNull$$$0(8);
        }
        if (quoted.indexOf(96) < 0) {
            String string = quoted;
            if (string == null) {
                KtPsiUtil.$$$reportNull$$$0(9);
            }
            return string;
        }
        if (quoted.startsWith("`") && quoted.endsWith("`") && quoted.length() >= 2) {
            String string = quoted.substring(1, quoted.length() - 1);
            if (string == null) {
                KtPsiUtil.$$$reportNull$$$0(10);
            }
            return string;
        }
        String string = quoted;
        if (string == null) {
            KtPsiUtil.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    public static String unquoteIdentifierOrFieldReference(@NotNull String quoted) {
        if (quoted == null) {
            KtPsiUtil.$$$reportNull$$$0(12);
        }
        if (quoted.indexOf(96) < 0) {
            String string = quoted;
            if (string == null) {
                KtPsiUtil.$$$reportNull$$$0(13);
            }
            return string;
        }
        if (quoted.startsWith("$")) {
            String string = "$" + KtPsiUtil.unquoteIdentifier(quoted.substring(1));
            if (string == null) {
                KtPsiUtil.$$$reportNull$$$0(14);
            }
            return string;
        }
        return KtPsiUtil.unquoteIdentifier(quoted);
    }

    public static boolean isDeprecated(@NotNull KtModifierListOwner owner) {
        KtModifierList modifierList2;
        if (owner == null) {
            KtPsiUtil.$$$reportNull$$$0(15);
        }
        if ((modifierList2 = owner.getModifierList()) != null) {
            List<KtAnnotationEntry> annotationEntries = modifierList2.getAnnotationEntries();
            for (KtAnnotationEntry annotation : annotationEntries) {
                Name shortName = annotation.getShortName();
                if (!StandardNames.FqNames.deprecated.shortName().equals(shortName)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static <T extends PsiElement> T getDirectParentOfTypeForBlock(@NotNull KtBlockExpression block, @NotNull Class<T> aClass) {
        KtFunctionLiteral functionLiteral;
        KtIfExpression ifExpression;
        PsiElement parent;
        if (block == null) {
            KtPsiUtil.$$$reportNull$$$0(16);
        }
        if (aClass == null) {
            KtPsiUtil.$$$reportNull$$$0(17);
        }
        if ((parent = PsiTreeUtil.getParentOfType((PsiElement)block, aClass)) instanceof KtIfExpression && ((ifExpression = (KtIfExpression)parent).getElse() == block || ifExpression.getThen() == block)) {
            return (T)parent;
        }
        if (parent instanceof KtWhenExpression) {
            KtWhenExpression whenExpression = (KtWhenExpression)parent;
            for (KtWhenEntry whenEntry : whenExpression.getEntries()) {
                if (whenEntry.getExpression() != block) continue;
                return (T)parent;
            }
        }
        if (parent instanceof KtFunctionLiteral && (functionLiteral = (KtFunctionLiteral)parent).getBodyExpression() == block) {
            return (T)parent;
        }
        if (parent instanceof KtTryExpression) {
            KtTryExpression tryExpression = (KtTryExpression)parent;
            if (tryExpression.getTryBlock() == block) {
                return (T)parent;
            }
            for (KtCatchClause clause : tryExpression.getCatchClauses()) {
                if (clause.getCatchBody() != block) continue;
                return (T)parent;
            }
        }
        return null;
    }

    @Nullable
    public static KtSimpleNameExpression getLastReference(@NotNull KtExpression importedReference) {
        KtElement selector;
        if (importedReference == null) {
            KtPsiUtil.$$$reportNull$$$0(18);
        }
        return (selector = KtPsiUtilKt.getQualifiedElementSelector(importedReference)) instanceof KtSimpleNameExpression ? (KtSimpleNameExpression)selector : null;
    }

    public static boolean isSelectorInQualified(@NotNull KtSimpleNameExpression nameExpression) {
        KtElement qualifiedElement;
        if (nameExpression == null) {
            KtPsiUtil.$$$reportNull$$$0(19);
        }
        return (qualifiedElement = KtPsiUtilKt.getQualifiedElement(nameExpression)) instanceof KtQualifiedExpression || qualifiedElement instanceof KtUserType && ((KtUserType)qualifiedElement).getQualifier() != null;
    }

    public static boolean isLHSOfDot(@NotNull KtExpression expression) {
        PsiElement parent;
        if (expression == null) {
            KtPsiUtil.$$$reportNull$$$0(20);
        }
        if (!((parent = expression.getParent()) instanceof KtQualifiedExpression)) {
            return false;
        }
        KtQualifiedExpression qualifiedParent = (KtQualifiedExpression)parent;
        return qualifiedParent.getReceiverExpression() == expression || KtPsiUtil.isLHSOfDot(qualifiedParent);
    }

    public static boolean isScriptDeclaration(@NotNull KtDeclaration namedDeclaration) {
        if (namedDeclaration == null) {
            KtPsiUtil.$$$reportNull$$$0(21);
        }
        return KtPsiUtil.getScript(namedDeclaration) != null;
    }

    @Nullable
    public static KtScript getScript(@NotNull KtDeclaration namedDeclaration) {
        PsiElement parent;
        if (namedDeclaration == null) {
            KtPsiUtil.$$$reportNull$$$0(22);
        }
        if ((parent = namedDeclaration.getParent()) != null && parent.getParent() instanceof KtScript) {
            return (KtScript)parent.getParent();
        }
        return null;
    }

    public static boolean isRemovableVariableDeclaration(@NotNull KtDeclaration declaration) {
        if (declaration == null) {
            KtPsiUtil.$$$reportNull$$$0(23);
        }
        if (!(declaration instanceof KtVariableDeclaration)) {
            return false;
        }
        if (declaration instanceof KtProperty) {
            return true;
        }
        assert (declaration instanceof KtDestructuringDeclarationEntry);
        return true;
    }

    @SafeVarargs
    @Nullable
    @Contract(value="null, _ -> null")
    public static PsiElement getTopmostParentOfTypes(@Nullable PsiElement element, Class<? extends PsiElement> ... parentTypes) {
        PsiElement next;
        if (parentTypes == null) {
            KtPsiUtil.$$$reportNull$$$0(24);
        }
        if (element instanceof PsiFile) {
            return null;
        }
        PsiElement answer = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])parentTypes);
        if (answer instanceof PsiFile) {
            return answer;
        }
        while ((next = PsiTreeUtil.getParentOfType((PsiElement)answer, (Class[])parentTypes)) != null) {
            answer = next;
        }
        return answer;
    }

    public static boolean isNullConstant(@NotNull KtExpression expression) {
        KtExpression deparenthesized;
        if (expression == null) {
            KtPsiUtil.$$$reportNull$$$0(25);
        }
        return (deparenthesized = KtPsiUtil.deparenthesize(expression)) instanceof KtConstantExpression && deparenthesized.getNode().getElementType() == KtNodeTypes.NULL;
    }

    public static boolean isTrueConstant(@Nullable KtExpression condition) {
        return KtPsiUtil.isBooleanConstant(condition) && condition.getNode().findChildByType((IElementType)KtTokens.TRUE_KEYWORD) != null;
    }

    public static boolean isFalseConstant(@Nullable KtExpression condition) {
        return KtPsiUtil.isBooleanConstant(condition) && condition.getNode().findChildByType((IElementType)KtTokens.FALSE_KEYWORD) != null;
    }

    public static boolean isBooleanConstant(@Nullable KtExpression condition) {
        return condition != null && condition.getNode().getElementType() == KtNodeTypes.BOOLEAN_CONSTANT;
    }

    public static boolean isAbstract(@NotNull KtDeclarationWithBody declaration) {
        if (declaration == null) {
            KtPsiUtil.$$$reportNull$$$0(26);
        }
        return declaration.getBodyExpression() == null;
    }

    @Nullable
    public static KtExpression getExpressionOrLastStatementInBlock(@Nullable KtExpression expression) {
        if (expression instanceof KtBlockExpression) {
            return KtPsiUtil.getLastStatementInABlock((KtBlockExpression)expression);
        }
        return expression;
    }

    @Nullable
    public static KtExpression getLastStatementInABlock(@Nullable KtBlockExpression blockExpression) {
        if (blockExpression == null) {
            return null;
        }
        List<KtExpression> statements = blockExpression.getStatements();
        return statements.isEmpty() ? null : statements.get(statements.size() - 1);
    }

    public static boolean isTrait(@NotNull KtClassOrObject classOrObject) {
        if (classOrObject == null) {
            KtPsiUtil.$$$reportNull$$$0(27);
        }
        return classOrObject instanceof KtClass && ((KtClass)classOrObject).isInterface();
    }

    @Nullable
    public static KtClassOrObject getOutermostClassOrObject(@NotNull KtClassOrObject classOrObject) {
        if (classOrObject == null) {
            KtPsiUtil.$$$reportNull$$$0(28);
        }
        KtClassOrObject current = classOrObject;
        while (true) {
            PsiElement parent = current.getParent();
            assert (parent != null) : "Class with no parent: " + current.getText();
            if (parent instanceof PsiFile) {
                return current;
            }
            if (!(parent instanceof KtClassBody)) {
                return current;
            }
            current = (KtClassOrObject)parent.getParent();
        }
    }

    @Nullable
    public static KtClassOrObject getClassIfParameterIsProperty(@NotNull KtParameter ktParameter) {
        PsiElement grandParent;
        if (ktParameter == null) {
            KtPsiUtil.$$$reportNull$$$0(29);
        }
        if (ktParameter.hasValOrVar() && (grandParent = ktParameter.getParent().getParent()) instanceof KtPrimaryConstructor) {
            return ((KtPrimaryConstructor)grandParent).getContainingClassOrObject();
        }
        return null;
    }

    @Nullable
    private static IElementType getOperation(@NotNull KtExpression expression) {
        if (expression == null) {
            KtPsiUtil.$$$reportNull$$$0(30);
        }
        if (expression instanceof KtQualifiedExpression) {
            return ((KtQualifiedExpression)expression).getOperationSign();
        }
        if (expression instanceof KtOperationExpression) {
            return ((KtOperationExpression)expression).getOperationReference().getReferencedNameElementType();
        }
        return null;
    }

    private static int getPriority(@NotNull KtExpression expression) {
        BinaryOperationPrecedence binaryPrecedence;
        if (expression == null) {
            KtPsiUtil.$$$reportNull$$$0(31);
        }
        if (expression instanceof KtSuperExpression) {
            return MAX_PRIORITY;
        }
        if (expression instanceof KtPostfixExpression || expression instanceof KtQualifiedExpression || expression instanceof KtCallExpression || expression instanceof KtArrayAccessExpression || expression instanceof KtDoubleColonExpression) {
            return MAX_PRIORITY - 1;
        }
        if (expression instanceof KtPrefixExpression || expression instanceof KtLabeledExpression || expression instanceof KtIfExpression) {
            return MAX_PRIORITY - 2;
        }
        IElementType operation = KtPsiUtil.getOperation(expression);
        if (operation instanceof KtToken && (binaryPrecedence = BinaryOperationPrecedence.TOKEN_TO_BINARY_PRECEDENCE_MAP.get((Object)((KtToken)operation))) != null) {
            return MAX_PRIORITY - 3 - binaryPrecedence.ordinal();
        }
        if (expression instanceof KtDeclaration || expression instanceof KtStatementExpression) {
            return 0;
        }
        return MAX_PRIORITY;
    }

    public static boolean areParenthesesUseless(@NotNull KtParenthesizedExpression expression) {
        KtExpression innerExpression;
        if (expression == null) {
            KtPsiUtil.$$$reportNull$$$0(32);
        }
        if ((innerExpression = expression.getExpression()) == null) {
            return true;
        }
        PsiElement parent = expression.getParent();
        if (!(parent instanceof KtElement)) {
            return true;
        }
        return !KtPsiUtil.areParenthesesNecessary(innerExpression, expression, (KtElement)parent);
    }

    public static boolean areParenthesesNecessary(@NotNull KtExpression innerExpression, @NotNull KtExpression currentInner, @NotNull KtElement parentElement) {
        int parentPriority;
        PsiElement prevSibling;
        if (innerExpression == null) {
            KtPsiUtil.$$$reportNull$$$0(33);
        }
        if (currentInner == null) {
            KtPsiUtil.$$$reportNull$$$0(34);
        }
        if (parentElement == null) {
            KtPsiUtil.$$$reportNull$$$0(35);
        }
        if (parentElement instanceof KtDelegatedSuperTypeEntry) {
            return true;
        }
        if (parentElement instanceof KtParenthesizedExpression || innerExpression instanceof KtParenthesizedExpression) {
            return false;
        }
        if (parentElement instanceof KtPackageDirective) {
            return false;
        }
        if (parentElement instanceof KtWhenExpression || innerExpression instanceof KtWhenExpression) {
            return false;
        }
        if (parentElement instanceof KtCollectionLiteralExpression) {
            return false;
        }
        if (innerExpression instanceof KtIfExpression) {
            if (parentElement instanceof KtQualifiedExpression) {
                return true;
            }
            KtElement current = parentElement;
            while (!(current instanceof KtBlockExpression || current instanceof KtDeclaration || current instanceof KtStatementExpression || current instanceof KtFile)) {
                if (current.getTextRange().getEndOffset() != currentInner.getTextRange().getEndOffset()) {
                    return !(current instanceof KtParenthesizedExpression) && !(current instanceof KtValueArgumentList);
                }
                current = current.getParent();
            }
        }
        if (innerExpression instanceof KtLambdaExpression && KtPsiUtil.endWithParenthesisOrCallExpression(prevSibling = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)currentInner))) {
            return true;
        }
        if (parentElement instanceof KtCallExpression && currentInner == ((KtCallExpression)parentElement).getCalleeExpression()) {
            KtExpression selector;
            KtCallExpression parentCall = (KtCallExpression)parentElement;
            KtExpression targetInnerExpression = innerExpression;
            if (targetInnerExpression instanceof KtDotQualifiedExpression && (selector = ((KtDotQualifiedExpression)targetInnerExpression).getSelectorExpression()) != null) {
                targetInnerExpression = selector;
            }
            if (targetInnerExpression instanceof KtSimpleNameExpression) {
                return false;
            }
            if (KtPsiUtilKt.getQualifiedExpressionForSelector(parentElement) != null) {
                return true;
            }
            if (targetInnerExpression instanceof KtCallExpression && parentCall.getValueArgumentList() == null) {
                return true;
            }
            return !(targetInnerExpression instanceof KtThisExpression) && !(targetInnerExpression instanceof KtArrayAccessExpression) && !(targetInnerExpression instanceof KtConstantExpression) && !(targetInnerExpression instanceof KtStringTemplateExpression) && !(targetInnerExpression instanceof KtCallExpression);
        }
        if (parentElement instanceof KtValueArgument) {
            KtExpression nextExpression;
            KtValueArgument nextArg = (KtValueArgument)PsiTreeUtil.getNextSiblingOfType((PsiElement)parentElement, KtValueArgument.class);
            KtExpression ktExpression = nextExpression = nextArg != null ? nextArg.getArgumentExpression() : null;
            if (innerExpression instanceof KtBinaryExpression && ((KtBinaryExpression)innerExpression).getOperationToken() == KtTokens.LT && nextExpression instanceof KtBinaryExpression && ((KtBinaryExpression)nextExpression).getOperationToken() == KtTokens.GT) {
                return true;
            }
        }
        IElementType innerOperation = KtPsiUtil.getOperation(innerExpression);
        if (innerExpression instanceof KtBinaryExpression) {
            KtBinaryExpression innerBinary;
            if (parentElement instanceof KtBinaryExpression && (innerBinary = (KtBinaryExpression)innerExpression).getRight() instanceof KtReturnExpression) {
                return true;
            }
            if (!(innerOperation == KtTokens.ELVIS || parentElement instanceof KtValueArgument || parentElement instanceof KtParameter || parentElement instanceof KtBlockStringTemplateEntry || parentElement instanceof KtContainerNode && !(parentElement instanceof KtContainerNodeForControlStructureBody) || !KtPsiUtil.isKeepBinaryExpressionParenthesized((KtBinaryExpression)innerExpression))) {
                return true;
            }
        }
        if (!(parentElement instanceof KtExpression)) {
            return false;
        }
        IElementType parentOperation = KtPsiUtil.getOperation((KtExpression)parentElement);
        if (parentElement instanceof KtReturnExpression && (innerExpression instanceof KtLabeledExpression || innerExpression instanceof KtAnnotatedExpression)) {
            return true;
        }
        if (innerExpression instanceof KtBinaryExpressionWithTypeRHS && parentOperation == KtTokens.LT) {
            return true;
        }
        if (parentElement instanceof KtLabeledExpression) {
            return false;
        }
        if (parentElement instanceof KtBinaryExpression && parentOperation == KtTokens.ELVIS && !(innerExpression instanceof KtBinaryExpression) && currentInner == ((KtBinaryExpression)parentElement).getRight()) {
            return false;
        }
        if (parentElement instanceof KtBinaryExpression && parentOperation == KtTokens.EQ && innerExpression instanceof KtNamedFunction && currentInner == ((KtBinaryExpression)parentElement).getRight()) {
            return false;
        }
        int innerPriority = KtPsiUtil.getPriority(innerExpression);
        if (innerPriority == (parentPriority = KtPsiUtil.getPriority((KtExpression)parentElement))) {
            if (parentElement instanceof KtBinaryExpression) {
                if (innerOperation == KtTokens.ANDAND || innerOperation == KtTokens.OROR) {
                    return false;
                }
                return ((KtBinaryExpression)parentElement).getRight() == currentInner;
            }
            if (parentElement instanceof KtPrefixExpression && innerExpression instanceof KtPrefixExpression) {
                if (parentOperation == KtTokens.PLUS) {
                    return innerOperation == KtTokens.PLUS || innerOperation == KtTokens.PLUSPLUS;
                }
                if (parentOperation == KtTokens.MINUS) {
                    return innerOperation == KtTokens.MINUS || innerOperation == KtTokens.MINUSMINUS;
                }
            }
            return false;
        }
        return innerPriority < parentPriority;
    }

    private static boolean endWithParenthesisOrCallExpression(PsiElement element) {
        if (element == null) {
            return false;
        }
        if (element.getText().endsWith(KtTokens.RPAR.getValue()) || element instanceof KtCallExpression) {
            return true;
        }
        PsiElement[] children = element.getChildren();
        int length = children.length;
        if (length == 0) {
            return false;
        }
        return KtPsiUtil.endWithParenthesisOrCallExpression(children[length - 1]);
    }

    private static boolean isKeepBinaryExpressionParenthesized(KtBinaryExpression expression) {
        for (PsiElement expr = expression.getFirstChild(); expr != null; expr = expr.getNextSibling()) {
            if (expr instanceof PsiWhiteSpace && expr.textContains('\n')) {
                return true;
            }
            if (expr instanceof KtOperationReferenceExpression) break;
        }
        return expression.getRight() instanceof KtBinaryExpression && KtPsiUtil.isKeepBinaryExpressionParenthesized((KtBinaryExpression)expression.getRight()) || expression.getLeft() instanceof KtBinaryExpression && KtPsiUtil.isKeepBinaryExpressionParenthesized((KtBinaryExpression)expression.getLeft());
    }

    public static boolean isAssignment(@NotNull PsiElement element) {
        if (element == null) {
            KtPsiUtil.$$$reportNull$$$0(36);
        }
        return element instanceof KtBinaryExpression && KtTokens.ALL_ASSIGNMENTS.contains(((KtBinaryExpression)element).getOperationToken());
    }

    public static boolean isOrdinaryAssignment(@NotNull PsiElement element) {
        if (element == null) {
            KtPsiUtil.$$$reportNull$$$0(37);
        }
        return element instanceof KtBinaryExpression && ((KtBinaryExpression)element).getOperationToken().equals((Object)KtTokens.EQ);
    }

    public static boolean isCast(@NotNull KtBinaryExpressionWithTypeRHS expression) {
        if (expression == null) {
            KtPsiUtil.$$$reportNull$$$0(38);
        }
        return KtPsiUtil.isSafeCast(expression) || KtPsiUtil.isUnsafeCast(expression);
    }

    public static boolean isSafeCast(@NotNull KtBinaryExpressionWithTypeRHS expression) {
        if (expression == null) {
            KtPsiUtil.$$$reportNull$$$0(39);
        }
        return expression.getOperationReference().getReferencedNameElementType() == KtTokens.AS_SAFE;
    }

    public static boolean isUnsafeCast(@NotNull KtBinaryExpressionWithTypeRHS expression) {
        if (expression == null) {
            KtPsiUtil.$$$reportNull$$$0(40);
        }
        return expression.getOperationReference().getReferencedNameElementType() == KtTokens.AS_KEYWORD;
    }

    public static boolean checkVariableDeclarationInBlock(@NotNull KtBlockExpression block, @NotNull String varName) {
        if (block == null) {
            KtPsiUtil.$$$reportNull$$$0(41);
        }
        if (varName == null) {
            KtPsiUtil.$$$reportNull$$$0(42);
        }
        for (KtExpression element : block.getStatements()) {
            if (!(element instanceof KtVariableDeclaration) || !((KtVariableDeclaration)element).getNameAsSafeName().asString().equals(varName)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkWhenExpressionHasSingleElse(@NotNull KtWhenExpression whenExpression) {
        if (whenExpression == null) {
            KtPsiUtil.$$$reportNull$$$0(43);
        }
        int elseCount = 0;
        for (KtWhenEntry entry : whenExpression.getEntries()) {
            if (!entry.isElse()) continue;
            ++elseCount;
        }
        return elseCount == 1;
    }

    @Nullable
    public static PsiElement skipTrailingWhitespacesAndComments(@Nullable PsiElement element) {
        return PsiTreeUtil.skipSiblingsForward((PsiElement)element, (Class[])new Class[]{PsiWhiteSpace.class, PsiComment.class});
    }

    @Nullable
    public static PsiElement prevLeafIgnoringWhitespaceAndComments(@NotNull PsiElement element) {
        if (element == null) {
            KtPsiUtil.$$$reportNull$$$0(44);
        }
        PsiElement prev = PsiTreeUtil.prevLeaf((PsiElement)element, (boolean)true);
        while (prev != null && KtTokens.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(prev.getNode().getElementType())) {
            prev = PsiTreeUtil.prevLeaf((PsiElement)prev, (boolean)true);
        }
        return prev;
    }

    @Nullable
    public static PsiElement getPreviousWord(@NotNull PsiElement element, @NotNull String word) {
        PsiElement prev;
        if (element == null) {
            KtPsiUtil.$$$reportNull$$$0(45);
        }
        if (word == null) {
            KtPsiUtil.$$$reportNull$$$0(46);
        }
        if ((prev = KtPsiUtil.prevLeafIgnoringWhitespaceAndComments(element)) != null && prev.getNode().getElementType() == KtTokens.IDENTIFIER && word.equals(prev.getText())) {
            return prev;
        }
        return null;
    }

    @NotNull
    public static String getText(@Nullable PsiElement element) {
        return element != null ? element.getText() : "";
    }

    @Nullable
    public static String getNullableText(@Nullable PsiElement element) {
        return element != null ? element.getText() : null;
    }

    public static boolean isInComment(PsiElement element) {
        return CommentUtilCore.isComment((PsiElement)element) || element instanceof KDocElement;
    }

    @Nullable
    public static PsiElement getOutermostParent(@NotNull PsiElement element, @NotNull PsiElement upperBound, boolean strict) {
        PsiElement parent;
        if (element == null) {
            KtPsiUtil.$$$reportNull$$$0(47);
        }
        if (upperBound == null) {
            KtPsiUtil.$$$reportNull$$$0(48);
        }
        PsiElement psiElement = parent = strict ? element.getParent() : element;
        while (parent != null && parent.getParent() != upperBound) {
            parent = parent.getParent();
        }
        return parent;
    }

    @SafeVarargs
    public static <T extends PsiElement> T getLastChildByType(@NotNull PsiElement root, Class<? extends T> ... elementTypes) {
        if (root == null) {
            KtPsiUtil.$$$reportNull$$$0(49);
        }
        if (elementTypes == null) {
            KtPsiUtil.$$$reportNull$$$0(50);
        }
        PsiElement[] children = root.getChildren();
        for (int i = children.length - 1; i >= 0; --i) {
            if (!PsiTreeUtil.instanceOf((Object)children[i], (Class[])elementTypes)) continue;
            return (T)children[i];
        }
        return null;
    }

    @Nullable
    public static KtElement getOutermostDescendantElement(@Nullable PsiElement root, boolean first, final @NotNull Predicate<KtElement> predicate) {
        if (predicate == null) {
            KtPsiUtil.$$$reportNull$$$0(51);
        }
        if (!(root instanceof KtElement)) {
            return null;
        }
        final ArrayList results = Lists.newArrayList();
        root.accept((PsiElementVisitor)new KtVisitorVoid(){

            @Override
            public void visitKtElement(@NotNull KtElement element) {
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (predicate.test(element)) {
                    results.add(element);
                } else {
                    element.acceptChildren(this);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/psi/KtPsiUtil$2", "visitKtElement"));
            }
        });
        if (results.isEmpty()) {
            return null;
        }
        return first ? (KtElement)results.get(0) : (KtElement)results.get(results.size() - 1);
    }

    @Nullable
    public static PsiElement findChildByType(@NotNull PsiElement element, @NotNull IElementType type) {
        ASTNode node;
        if (element == null) {
            KtPsiUtil.$$$reportNull$$$0(52);
        }
        if (type == null) {
            KtPsiUtil.$$$reportNull$$$0(53);
        }
        return (node = element.getNode().findChildByType(type)) == null ? null : node.getPsi();
    }

    @Nullable
    public static PsiElement skipSiblingsBackwardByPredicate(@Nullable PsiElement element, Predicate<PsiElement> elementsToSkip) {
        if (element == null) {
            return null;
        }
        for (PsiElement e = element.getPrevSibling(); e != null; e = e.getPrevSibling()) {
            if (elementsToSkip.test(e)) continue;
            return e;
        }
        return null;
    }

    public static PsiElement ascendIfPropertyAccessor(PsiElement element) {
        if (element instanceof KtPropertyAccessor) {
            return element.getParent();
        }
        return element;
    }

    @Nullable
    @Contract(value="_, !null -> !null")
    public static KtModifierList replaceModifierList(@NotNull KtModifierListOwner owner, @Nullable KtModifierList modifierList2) {
        if (owner == null) {
            KtPsiUtil.$$$reportNull$$$0(54);
        }
        KtModifierList oldModifierList = owner.getModifierList();
        if (modifierList2 == null) {
            if (oldModifierList != null) {
                oldModifierList.delete();
            }
            return null;
        }
        if (oldModifierList == null) {
            PsiElement firstChild = owner.getFirstChild();
            return (KtModifierList)owner.addBefore((PsiElement)modifierList2, firstChild);
        }
        return (KtModifierList)oldModifierList.replace((PsiElement)modifierList2);
    }

    @Nullable
    public static String getPackageName(@NotNull KtElement element) {
        KtFile file;
        KtPackageDirective header;
        if (element == null) {
            KtPsiUtil.$$$reportNull$$$0(55);
        }
        return (header = (KtPackageDirective)PsiTreeUtil.findChildOfType((PsiElement)(file = element.getContainingKtFile()), KtPackageDirective.class)) != null ? header.getQualifiedName() : null;
    }

    @Nullable
    public static KtElement getEnclosingElementForLocalDeclaration(@NotNull KtDeclaration declaration) {
        if (declaration == null) {
            KtPsiUtil.$$$reportNull$$$0(56);
        }
        return KtPsiUtil.getEnclosingElementForLocalDeclaration(declaration, true);
    }

    private static boolean isMemberOfObjectExpression(@NotNull KtCallableDeclaration propertyOrFunction) {
        PsiElement parent;
        if (propertyOrFunction == null) {
            KtPsiUtil.$$$reportNull$$$0(57);
        }
        if (!((parent = PsiTreeUtil.getStubOrPsiParent((PsiElement)propertyOrFunction)) instanceof KtClassBody)) {
            return false;
        }
        PsiElement grandparent = PsiTreeUtil.getStubOrPsiParent((PsiElement)parent);
        if (!(grandparent instanceof KtObjectDeclaration)) {
            return false;
        }
        return PsiTreeUtil.getStubOrPsiParent((PsiElement)grandparent) instanceof KtObjectLiteralExpression;
    }

    private static boolean isNonLocalCallable(@Nullable KtDeclaration declaration) {
        if (declaration instanceof KtProperty) {
            return !((KtProperty)declaration).isLocal();
        }
        if (declaration instanceof KtFunction) {
            return !((KtFunction)declaration).isLocal();
        }
        return false;
    }

    @Nullable
    public static KtElement getEnclosingElementForLocalDeclaration(@NotNull KtDeclaration declaration, boolean skipParameters) {
        if (declaration == null) {
            KtPsiUtil.$$$reportNull$$$0(58);
        }
        if (declaration instanceof KtTypeParameter && skipParameters) {
            declaration = (KtDeclaration)PsiTreeUtil.getParentOfType((PsiElement)declaration, KtNamedDeclaration.class);
        } else if (declaration instanceof KtParameter) {
            KtFunctionType functionType = (KtFunctionType)PsiTreeUtil.getParentOfType((PsiElement)declaration, KtFunctionType.class);
            if (functionType != null) {
                return functionType;
            }
            PsiElement parent = declaration.getParent();
            if (((KtParameter)declaration).hasValOrVar() && parent != null && parent.getParent() instanceof KtPrimaryConstructor) {
                return KtPsiUtil.getEnclosingElementForLocalDeclaration(((KtPrimaryConstructor)parent.getParent()).getContainingClassOrObject(), skipParameters);
            }
            if (skipParameters && parent != null && !(parent instanceof KtForExpression) && parent.getParent() instanceof KtNamedFunction) {
                declaration = (KtNamedFunction)parent.getParent();
            }
        }
        if (declaration instanceof PsiFile) {
            return declaration;
        }
        PsiElement current = PsiTreeUtil.getStubOrPsiParent((PsiElement)declaration);
        boolean isNonLocalCallable = KtPsiUtil.isNonLocalCallable(declaration);
        while (current != null) {
            PsiElement grandParent;
            if (current instanceof PsiFile) {
                return null;
            }
            PsiElement parent = PsiTreeUtil.getStubOrPsiParent((PsiElement)current);
            if (parent instanceof KtScript) {
                return null;
            }
            if (current instanceof KtAnonymousInitializer) {
                return ((KtAnonymousInitializer)current).getBody();
            }
            if (current instanceof KtProperty || current instanceof KtFunction) {
                if (parent instanceof KtFile) {
                    return (KtElement)current;
                }
                if (parent instanceof KtClassBody && !KtPsiUtil.isMemberOfObjectExpression((KtCallableDeclaration)current)) {
                    return (KtElement)parent;
                }
                if (parent instanceof KtBlockExpression && (grandParent = parent.getParent()) instanceof KtScript) {
                    return (KtElement)parent;
                }
            }
            if (current instanceof KtParameter) {
                return (KtElement)current;
            }
            if (current instanceof KtValueArgument && !isNonLocalCallable) {
                return (KtElement)current;
            }
            if (!(!(current instanceof KtBlockExpression) || isNonLocalCallable && current.getParent() instanceof KtFunctionLiteral)) {
                return (KtElement)current;
            }
            if ((current instanceof KtDelegatedSuperTypeEntry || current instanceof KtSuperTypeCallEntry) && (grandParent = current.getParent().getParent()) instanceof KtClassOrObject && !(grandParent.getParent() instanceof KtObjectLiteralExpression)) {
                return (KtElement)grandParent;
            }
            current = parent;
        }
        return null;
    }

    public static boolean isLocal(@NotNull KtDeclaration declaration) {
        if (declaration == null) {
            KtPsiUtil.$$$reportNull$$$0(59);
        }
        return KtPsiUtil.getEnclosingElementForLocalDeclaration(declaration) != null;
    }

    @Nullable
    public static KtToken getOperationToken(@NotNull KtOperationExpression expression) {
        if (expression == null) {
            KtPsiUtil.$$$reportNull$$$0(60);
        }
        KtSimpleNameExpression operationExpression = expression.getOperationReference();
        IElementType elementType = operationExpression.getReferencedNameElementType();
        assert (elementType == null || elementType instanceof KtToken) : "KtOperationExpression should have operation token of type KtToken: " + expression;
        return (KtToken)elementType;
    }

    public static boolean isLabelIdentifierExpression(PsiElement element) {
        return element instanceof KtLabelReferenceExpression;
    }

    @Nullable
    public static KtExpression getParentCallIfPresent(@NotNull KtExpression expression) {
        if (expression == null) {
            KtPsiUtil.$$$reportNull$$$0(61);
        }
        PsiElement parent = expression.getParent();
        while (parent != null) {
            if (parent instanceof KtBinaryExpression || parent instanceof KtUnaryExpression || parent instanceof KtLabeledExpression || parent instanceof KtDotQualifiedExpression || parent instanceof KtCallExpression || parent instanceof KtArrayAccessExpression || parent instanceof KtDestructuringDeclaration) {
                if (parent instanceof KtLabeledExpression) {
                    parent = parent.getParent();
                    continue;
                }
                return (KtExpression)parent;
            }
            if (parent instanceof KtParenthesizedExpression || parent instanceof KtBinaryExpressionWithTypeRHS) {
                parent = parent.getParent();
                continue;
            }
            if (parent instanceof KtValueArgument || parent instanceof KtValueArgumentList) {
                parent = parent.getParent();
                continue;
            }
            if (parent instanceof KtLambdaExpression || parent instanceof KtAnnotatedExpression) {
                parent = parent.getParent();
                continue;
            }
            return null;
        }
        return null;
    }

    public static boolean isLabeledFunctionLiteral(@NotNull KtFunctionLiteral functionLiteral) {
        if (functionLiteral == null) {
            KtPsiUtil.$$$reportNull$$$0(62);
        }
        return functionLiteral.getParent().getParent() instanceof KtLabeledExpression;
    }

    @Nullable
    public static KtExpression getLastElementDeparenthesized(@Nullable KtExpression expression, @NotNull StatementFilter statementFilter) {
        KtBlockExpression blockExpression;
        KtExpression lastStatementInABlock;
        KtExpression deparenthesizedExpression;
        if (statementFilter == null) {
            KtPsiUtil.$$$reportNull$$$0(63);
        }
        if ((deparenthesizedExpression = KtPsiUtil.deparenthesize(expression)) instanceof KtBlockExpression && (lastStatementInABlock = StatementFilterKt.getLastStatementInABlock(statementFilter, blockExpression = (KtBlockExpression)deparenthesizedExpression)) != null) {
            return KtPsiUtil.getLastElementDeparenthesized(lastStatementInABlock, statementFilter);
        }
        return deparenthesizedExpression;
    }

    public static boolean isStatementContainer(@Nullable PsiElement container) {
        return container instanceof KtBlockExpression || container instanceof KtContainerNodeForControlStructureBody || container instanceof KtWhenEntry;
    }

    public static boolean isStatement(@NotNull PsiElement element) {
        if (element == null) {
            KtPsiUtil.$$$reportNull$$$0(64);
        }
        return KtPsiUtil.isStatementContainer(element.getParent());
    }

    public static boolean isInOrNotInOperation(@NotNull KtBinaryExpression binaryExpression) {
        if (binaryExpression == null) {
            KtPsiUtil.$$$reportNull$$$0(65);
        }
        return KtPsiUtil.isInOperation(binaryExpression) || KtPsiUtil.isNotInOperation(binaryExpression);
    }

    public static boolean isNotInOperation(@NotNull KtBinaryExpression binaryExpression) {
        if (binaryExpression == null) {
            KtPsiUtil.$$$reportNull$$$0(66);
        }
        return binaryExpression.getOperationToken() == KtTokens.NOT_IN;
    }

    private static boolean isInOperation(@NotNull KtBinaryExpression binaryExpression) {
        if (binaryExpression == null) {
            KtPsiUtil.$$$reportNull$$$0(67);
        }
        return binaryExpression.getOperationToken() == KtTokens.IN_KEYWORD;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 2: 
            case 3: 
            case 20: 
            case 25: 
            case 30: 
            case 31: 
            case 32: 
            case 38: 
            case 39: 
            case 40: 
            case 60: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/psi/KtPsiUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unreachableElements";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quoted";
                break;
            }
            case 15: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 16: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importedReference";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameExpression";
                break;
            }
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedDeclaration";
                break;
            }
            case 23: 
            case 26: 
            case 56: 
            case 58: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentTypes";
                break;
            }
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classOrObject";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ktParameter";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "innerExpression";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentInner";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentElement";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "varName";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "whenExpression";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "word";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "upperBound";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementTypes";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyOrFunction";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionLiteral";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statementFilter";
                break;
            }
            case 65: 
            case 66: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/psi/KtPsiUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "safeDeparenthesize";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "safeName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findRootExpressions";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "unquoteIdentifier";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "unquoteIdentifierOrFieldReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "visitChildren";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "safeDeparenthesize";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findRootExpressions";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "unquoteIdentifier";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "unquoteIdentifierOrFieldReference";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isDeprecated";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getDirectParentOfTypeForBlock";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getLastReference";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isSelectorInQualified";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isLHSOfDot";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isScriptDeclaration";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getScript";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isRemovableVariableDeclaration";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getTopmostParentOfTypes";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isNullConstant";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isAbstract";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isTrait";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getOutermostClassOrObject";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getClassIfParameterIsProperty";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getOperation";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getPriority";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "areParenthesesUseless";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "areParenthesesNecessary";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isAssignment";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "isOrdinaryAssignment";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "isCast";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "isSafeCast";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "isUnsafeCast";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "checkVariableDeclarationInBlock";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "checkWhenExpressionHasSingleElse";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "prevLeafIgnoringWhitespaceAndComments";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getPreviousWord";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getOutermostParent";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getLastChildByType";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getOutermostDescendantElement";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "findChildByType";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "replaceModifierList";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getPackageName";
                break;
            }
            case 56: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getEnclosingElementForLocalDeclaration";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "isMemberOfObjectExpression";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "isLocal";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getOperationToken";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "getParentCallIfPresent";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "isLabeledFunctionLiteral";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "getLastElementDeparenthesized";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "isStatement";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "isInOrNotInOperation";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "isNotInOperation";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "isInOperation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface KtExpressionWrapper {
        public KtExpression getBaseExpression();
    }
}

